#! /usr/bin/env false

use v6.d;

unit module App::GTD::Config;

# This is a placeholder for documentation purposes

=begin pod

=NAME    App::GTD::Config
=AUTHOR  Patrick Spek <p.spek@tyil.work>
=VERSION 0.2.0

=head1 Configuration file location

C<App::GTD> is configured using a single C<TOML> file, which is stored at
C<$XDG_CONFIG_HOME/gtd/config.toml>. If you do not have C<$XDG_CONFIG_HOME> set
in your shell, it will default to C<$HOME/.config>.

=head1 Example configuration file with defaults

=begin code :name<config.toml> :lang<toml>
[data]
file = "/home/<user>/.local/share/todo.txt"

[colors]
enabled = true

contexts = "green"
projects = "red"
leftover-labels = "cyan"

labels.gtd = "yellow"
=end code

=head1 Available configuration options

=head2 Data storage

The file where your data is stored into is set in the C<data.file>. By default,
this is stored in C<$XDG_DATA_HOME/todo.txt>. If C<$XDG_DATA_HOME> is not set
in your shell, this defaults to C<$HOME/.local/share>.

The C<data.file> configuration option does B<not> expand variables or C<~>, so
you must use an absolute path if you wish to place it somewhere else.

=head2 Colorization

By default, C<App::GTD> has colors enabled. You can set C<colors.enabled> to
C<false> to turn off all colors.

If you like colors but want to alter them, you can set a number of options. The
first three, C<colors.contexts>, C<colors.projects>, and
C<colors.leftover-labels> respectively set the color of the contexts, projects
and labels which don't have their own specific color.

That last part is important, as C<App::GTD> allows you to set a specific color
to specific labels. You can do that through C<colors.labels.$label-name>. By
default, only the C<gtd> label is made yellow.

=end pod

# vim: ft=perl6 noet
