### sub merge-hashes

```perl6
sub merge-hashes(
    *@hashes
) returns Hash
```

Merge any number of Hashes together.

class *@hashes
--------------

Any number of Hashes to merge together.

### sub merge-hash

```perl6
sub merge-hash(
    %first,
    %second,
    Bool:D :$deep = Bool::True,
    Bool:D :$positional-append = Bool::True
) returns Hash
```

Merge two hashes together.

class %first
------------

The original Hash to merge the second Hash into.

class %second
-------------

The second hash, which will be merged into the first Hash.

class Bool:D :$deep = Bool::True
--------------------------------

Boolean to set whether Associative objects should be merged on their own. When set to False, Associative objects in %second will overwrite those from %first.

class Bool:D :$positional-append = Bool::True
---------------------------------------------

Boolean to set whether Positional objects should be appended. When set to False, Positional objects in %second will overwrite those from %first.

