package Config::From::Backend::File;
$Config::From::Backend::File::VERSION = '0.02';

use utf8;
use Moose;
extends 'Config::From::Backend';

use Config::Any;
use Carp qw/croak/;

has file => (
    is       => 'rw',
    required => 1,
    isa      => 'Str',
);


has datas => (
    is         => 'rw',
    isa        => 'HashRef',
    lazy_build => 1,
    builder => '_build_datas',
);

sub _build_datas {
    my $self = shift;

    my $file = $self->file;
    my $cfg = Config::Any->load_files({files => [$file], use_ext => 1 });
    croak "Can not open $file !" if ! $cfg->[0];
    my ($filename, $config) = %{$cfg->[0]};
    return $config;
}


1; # End of Config::From::Backend::File
