/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.ber;

import com.vizdom.ber.BerIdentifier;
import com.vizdom.ber.BerModule;
import com.vizdom.ber.BerObject;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BerInteger
extends BerObject {
    static final BerIdentifier gIDENTIFIER = new BerIdentifier(0, 2);
    private int mValue;

    protected BerInteger() {
    }

    public BerInteger(int aValue) {
        this.mValue = aValue;
    }

    @Override
    public BerIdentifier getIdentifier() {
        return gIDENTIFIER;
    }

    @Override
    protected final int mGetLength() {
        int count;
        if (this.mValue == 0 || this.mValue == -1) {
            count = 1;
        } else {
            int octet = 0;
            count = 0;
            for (int n = this.mValue; n != 0 && n != -1; n >>= 8) {
                octet = n & 0xFF;
                ++count;
            }
            if ((octet & 0x80) == 128 && this.mValue >= 0) {
                ++count;
            }
        }
        return count;
    }

    @Override
    protected final void mWriteContents(OutputStream anOut) throws IOException {
        if (this.mValue == 0 || this.mValue == -1) {
            anOut.write(this.mValue);
        } else {
            int r = 0;
            int count = 0;
            for (int n = this.mValue; n != 0 && n != -1; n >>= 8) {
                r <<= 8;
                r |= n & 0xFF;
                ++count;
            }
            if ((r & 0x80) == 128 && this.mValue >= 0) {
                r <<= 8;
                ++count;
            }
            for (int i = 0; i < count; ++i) {
                anOut.write(r & 0xFF);
                r >>= 8;
            }
        }
    }

    @Override
    protected void mReadContents(InputStream anIn, BerModule aModule, BerIdentifier anIdentifier, int aLength) throws IOException {
        int octet = anIn.read();
        if (octet == -1) {
            throw new EOFException();
        }
        int n = octet;
        for (int i = 1; i < aLength; ++i) {
            octet = anIn.read();
            if (octet == -1) {
                throw new EOFException();
            }
            n <<= 8;
            n |= octet;
        }
        this.mValue = n;
    }

    public int intValue() {
        return this.mValue;
    }

    @Override
    public String toString() {
        return String.valueOf(this.mValue);
    }
}

