#!perl

use Test::More tests => 18;
use HiPi qw( :rpi );
use HiPi::RaspberryPi;
use Time::HiRes;

my $sleepwait = 1000;

SKIP: {
        skip 'not in dist testing', 18 unless $ENV{HIPI_MODULES_DIST_TEST_RFSPI};

diag('SPI RF tests are running');
    
use_ok( HiPi::Energenie );

my $monitor_1 = '0004-0001-000A54';
my $adapter_1 = '0004-0002-000E08';
my $adapter_2 = '0004-0002-002BA0';

my $handler = HiPi::Energenie->new(
    backend      => 'RF69HW',
    devicename => '/dev/spidev0.1',
);

my $val = $handler->process_request(
    command         => 'query',
    sensor_key      => $monitor_1,
);

my $data = $val->{data};

my $record = $data->records->[0];
is( $record->name, 'Real Power', 'monitor Real Power name' );


$record = $data->records->[1];
is( $record->name, 'Reactive Power', 'monitor Reactive Power name' );


$record = $data->records->[2];
is( $record->name, 'Voltage', 'monitor Voltage name' );


$record = $data->records->[3];
is( $record->name, 'Frequency', 'monitor Frequency name' );

$val = $handler->process_request(
    command         => 'query',
    sensor_key      => $adapter_1,
);

$data = $val->{data};

$record = $data->records->[0];
is( $record->name, 'Real Power', 'adapter Real Power name' );


$record = $data->records->[1];
is( $record->name, 'Reactive Power', 'adapter Reactive Power name' );


$record = $data->records->[2];
is( $record->name, 'Voltage', 'adapter Voltage name' );


$record = $data->records->[3];
is( $record->name, 'Frequency', 'adapter Frequency name' );

$record = $data->records->[4];
is( $record->name, 'Switch State', 'adapter Switch State name' );

$val = $handler->process_request(
    command         => 'switch',
    sensor_key      => $adapter_2,
    switch_state    => 1
);

is( $val->{success}, 1, 'adapter switched on' );

$record = $val->{data}->records->[-1];
is( $record->name, 'Switch State', 'adapter switched on Switch State name' );
is( $record->value, 1, 'adapter switched on value' );

sleep 2;

$val = $handler->process_request(
    command         => 'switch',
    sensor_key      => $adapter_2,
    switch_state    => 0
);

is( $val->{success}, 1, 'adapter switched off' );

$record = $val->{data}->records->[-1];
is( $record->name, 'Switch State', 'adapter switched off Switch State name' );
is( $record->value, 0, 'adapter switched off value' );

is( $handler->switch_socket( 0x0C976E, 2, 1 ), undef ,'socket on');
sleep 2;
is( $handler->switch_socket( 0x0C976E, 2, 0 ), undef ,'socket off');

} # End SKIP

1;
