package DBIx::TextIndex::StopList::en;

use strict;
use warnings;

our @words = qw(
a
about
after
all
also
an
and
any
are
as
at
be
because
been
but
by
can
could
for
from
had
has
have
he
her
his
i
if
in
into
is
it
its
last
like
many
me
miss
more
most
much
mr
mrs
ms
my
no
not
of
on
one
only
or
other
out
over
s
says
she
should
so
some
such
than
that
the
their
them
there
these
they
this
those
thus
to
too
up
us
you
was
we
were
when
which
who
whose
will
with
would
);

1;
__END__

=head1 NAME

DBIx::TextIndex::StopList::en - English-language stop list


=head1 SYNOPSIS

 require DBIx::TextIndex::StopList::en;


=head1 DESCRIPTION

Contains a default list of English-language stop words

Used internally by L<DBIx::TextIndex>.


=head1 INTERFACE

None.


=head1 AUTHOR

Daniel Koch, dkoch@cpan.org.


=head1 COPYRIGHT

Copyright 1997-2007 by Daniel Koch.
All rights reserved.


=head1 LICENSE

This package is free software; you can redistribute it and/or modify it
under the same terms as Perl itself, i.e., under the terms of the "Artistic
License" or the "GNU General Public License".


=head1 DISCLAIMER

This package is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

See the "GNU General Public License" for more details.

=cut
