# Copyright 2020, Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

package Google::Ads::GoogleAds::V22::Enums::ContentLabelTypeEnum;

use strict;
use warnings;

use Const::Exporter enums => [
  UNSPECIFIED                            => "UNSPECIFIED",
  UNKNOWN                                => "UNKNOWN",
  SEXUALLY_SUGGESTIVE                    => "SEXUALLY_SUGGESTIVE",
  BELOW_THE_FOLD                         => "BELOW_THE_FOLD",
  PARKED_DOMAIN                          => "PARKED_DOMAIN",
  JUVENILE                               => "JUVENILE",
  PROFANITY                              => "PROFANITY",
  TRAGEDY                                => "TRAGEDY",
  VIDEO                                  => "VIDEO",
  VIDEO_RATING_DV_G                      => "VIDEO_RATING_DV_G",
  VIDEO_RATING_DV_PG                     => "VIDEO_RATING_DV_PG",
  VIDEO_RATING_DV_T                      => "VIDEO_RATING_DV_T",
  VIDEO_RATING_DV_MA                     => "VIDEO_RATING_DV_MA",
  VIDEO_NOT_YET_RATED                    => "VIDEO_NOT_YET_RATED",
  EMBEDDED_VIDEO                         => "EMBEDDED_VIDEO",
  LIVE_STREAMING_VIDEO                   => "LIVE_STREAMING_VIDEO",
  SOCIAL_ISSUES                          => "SOCIAL_ISSUES",
  BRAND_SUITABILITY_CONTENT_FOR_FAMILIES =>
    "BRAND_SUITABILITY_CONTENT_FOR_FAMILIES",
  BRAND_SUITABILITY_GAMES_FIGHTING   => "BRAND_SUITABILITY_GAMES_FIGHTING",
  BRAND_SUITABILITY_GAMES_MATURE     => "BRAND_SUITABILITY_GAMES_MATURE",
  BRAND_SUITABILITY_HEALTH_SENSITIVE => "BRAND_SUITABILITY_HEALTH_SENSITIVE",
  BRAND_SUITABILITY_HEALTH_SOURCE_UNDETERMINED =>
    "BRAND_SUITABILITY_HEALTH_SOURCE_UNDETERMINED",
  BRAND_SUITABILITY_NEWS_RECENT    => "BRAND_SUITABILITY_NEWS_RECENT",
  BRAND_SUITABILITY_NEWS_SENSITIVE => "BRAND_SUITABILITY_NEWS_SENSITIVE",
  BRAND_SUITABILITY_NEWS_SOURCE_NOT_FEATURED =>
    "BRAND_SUITABILITY_NEWS_SOURCE_NOT_FEATURED",
  BRAND_SUITABILITY_POLITICS => "BRAND_SUITABILITY_POLITICS",
  BRAND_SUITABILITY_RELIGION => "BRAND_SUITABILITY_RELIGION"
];

1;
