# Generated by default/object.tt
package Paws::IoTEvents::SSOIdentity;
  use Moose;
  has IdentityStoreId => (is => 'ro', isa => 'Str', request_name => 'identityStoreId', traits => ['NameInRequest'], required => 1);
  has UserId => (is => 'ro', isa => 'Str', request_name => 'userId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTEvents::SSOIdentity

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTEvents::SSOIdentity object:

  $service_obj->Method(Att1 => { IdentityStoreId => $value, ..., UserId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTEvents::SSOIdentity object:

  $result = $service_obj->Method(...);
  $result->Att1->IdentityStoreId

=head1 DESCRIPTION

Contains information about your identity source in AWS Single Sign-On.
For more information, see the AWS Single Sign-On User Guide
(https://docs.aws.amazon.com/singlesignon/latest/userguide/what-is.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> IdentityStoreId => Str

The ID of the AWS SSO identity store.


=head2 UserId => Str

The user ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

