use strict ;
use warnings ;

use Data::TreeDumper ;

my $master_category =
{
'System roll-out' => 
	{
	'_DEFINITION' => '',
	'Distribution' => 
		{
		'_DEFINITION' => ' to user'
		},
	'Migration' => 
		{
		'_DEFINITION' => ''
		},
	'Setup' => 
		{
		'_DEFINITION' => 'Installing the system on user computer'
		},
	'User feedback' => 
		{
		'_DEFINITION' => ''
		},
	'Versioning & compatibility' => 
		{
		'_DEFINITION' => '',
		}
	},

'Debugging' => 
	{
	'_DEFINITION' => 'Debugging of the system if problems occur',
	},

'Development & maintenance' => 
	{
	'_DEFINITION' => 'Development team project specific working practices and processes',
	'Documentation' => 
		{
		'_DEFINITION' => 'Project specific documentation, standards and guidelines, system design'
		},

	'Environment' => 
		{
		'_DEFINITION' => 'Installation & configuration of the software environment required to develop and test the system'
		},

	'Architecture' => 
		{
		'_DEFINITION' => 'Architectual awareness'
		},

	'Process' => 
		{
		'_DEFINITION' => 'Project specific processes to follow for continuous integration of the system development',
		'Quality and traceability' =>
			{
			'_DEFINITION' => 'Processes to follow to ensure quality is maintained within the project',
			},
				
		'Test' =>
			{
			'_DEFINITION' => 'Project test strategy',
			'Functional' =>
				{
				'_DEFINITION' => 'Functional testing',
				},
			'Integration' =>
				{
				'_DEFINITION' => 'Integration testing',
				},
			'Systems' =>
				{
				'_DEFINITION' => 'Systems testing',
				},
			'Acceptance' =>
				{
				'_DEFINITION' => 'Acceptance testing',
				},
			'Regression' =>
				{
				'_DEFINITION' => 'Regression testing',
				},
			'Stress' =>
				{
				'_DEFINITION' => 'Stress testing',
				},
			}
		}
	},

'Environment' => 
	{
	'_DEFINITION' => 'The tools used to implement the system and their configuration',

	'Network' => 
		{
		'_DEFINITION' => 'Interaction of the system within a network',
		},
		
	'Filesystem usage' => 
		{
		'_DEFINITION' => 'File systems resources used by the system'
		},
		
	'External tools' => 
		{
		'_DEFINITION' => 'External tools used from the system'
		},
		
	'Platform independence' => 
		{
		'_DEFINITION' => 'Multiple platforms and independent on platform-specific constraints'
		}
	},

'Interface' => 
	{
	'_DEFINITION' => 'Interfaces to the system',
	'Input' => 
		{
		'_DEFINITION' => 'Elements pertinent to the input to the system',
		
		'General' => 
			{
			'_DEFINITION' => 'Applicable to all the categories below the root category',
			},
			
		'Input channels' => 
			{
			'UI' => 
				{
				'_DEFINITION' => 'Interfaces to the system involving human interaction',
				},

			'Programmatic interface' =>
				{
				'_DEFINITION' => 'Interfaces to the system called by another program',
				},
			},
		},
			
	'Output' => 
		{
		'_DEFINITION' => 'Output information from the system',
		'General' => 
			{
			'_DEFINITION' => 'Applicable to all the categories below the root category',
			},
			
		'Logs' => 
			{
			'_DEFINITION' => 'Generated log files',
			'Contents' => 
				{
				'_DEFINITION' => 'Log file contents and structure'
				},
			'Searching' => 
				{
				'_DEFINITION' => 'Log file parsing and searching'
				}
			},
			
		'Visualization' => 
			{
			'_DEFINITION' => 'Visualization applications to present a user friendly view (i.e. DAG etc)'
			},
			
		'Report' => 
			{
			'_DEFINITION' => 'Reports generated by the system'
			}
		},
		
	'System interaction with user' => 
		{
		'_DEFINITION' => 'interaction involving a live user (no automation)',
		'Usability' => 
			{
			'_DEFINITION' => '',
			}
		}
	},

'Metrics' => 
	{
	'_DEFINITION' => 'A set of ways of quantitatively and periodically measuring, assessing, controlling or selecting build software along with the procedures to carry out measurements and the procedures for the interpretation of the assessment in the light of previous or comparable assessments.',
	},

'Security' => 
	{
	'_DEFINITION' => 'Insure only authorised persons have access to the system',
	'Access control' => 
		{
		'_DEFINITION' => 'Access rights to control access to and from the system',
		}
	},

'Support' => 
	{
	'_DEFINITION' => 'Tools and actions needed to support processes around platform builds',
	},

'User documentation' => 
	{
	'_DEFINITION' => 'System documentation and training',
	'System' => 
		{
		'_DEFINITION' => 'System user and administration documentation'
		},
	'Rollout' => 
		{
		'_DEFINITION' => 'System rollout documentation'
		},
	'Training' => 
		{
		'_DEFINITION' => 'System training and documentation'
		},
	},
};

my ($package) = caller() ;

unless(defined $package)
	{
	my ($missing_definitions, $number_of_categories) = (0, 0) ;

	my $display_filter = sub
		{
		my $tree = shift ;

		if('HASH' eq ref $tree )
			{
			$number_of_categories++ ;
			
			my $valid_definition = (exists $tree->{_DEFINITION} and $tree->{_DEFINITION} ne q{}) ;
			$missing_definitions += ! $valid_definition ;

			if($valid_definition)
				{
				return(Data::TreeDumper::DefaultNodesToDisplay($tree)) ;
				}
			else
				{
				return('HASH', $tree, sort grep {! /^_/} keys %$tree) ; 
				}
			}
		else
			{
			return('SCALAR', 1) ; # prune
			}	
		} ;
		
	print DumpTree $master_category, 'Category structure:', DISPLAY_ADDRESS => 0, USE_ASCII => 1 , NO_NO_ELEMENTS => 1, FILTER => $display_filter ;

	print <<EOT ;

number of categories = $number_of_categories
missing definitions = $missing_definitions
EOT

	}

$master_category = $master_category ; # leave this be, nkh
