package CPSC;

my %part_base_to_cpsc_map =
qw(
	9424 03.01.03
        9425 03.01.03
	9428 03.01.04
	9430 03.01.04
	9431 03.01.04
);

sub find_cpsc_for_part_base {
    my($base) = @_;
    $base = uc $base;
    $part_base_to_cpsc_map{$base};
}

sub tree { return [
{ -label => q{00 - Complete Vehicle System},
  -cpsc_obid => q{ihvlUpkpdcmp1z0admin-Dv4},
  -cpsc => q{00.00.00},
  -flags => 88,
  -children => [
    { -label => q{00.01 - Descriptive Plates and Instructions},
      -cpsc_obid => q{gcqnQ0faec---z0admin-ad2},
      -cpsc => q{00.01.00},
      -flags => 88,
      -children => [
        { -label => q{00.01.01 - Body},
          -cpsc_obid => q{gcqnQ1caec---z0admin-ad2},
          -cpsc => q{00.01.01},
          -flags => 80 },
        { -label => q{00.01.02 - Frame and Mounting},
          -cpsc_obid => q{gcqnQ1kaec---z0admin-ad2},
          -cpsc => q{00.01.02},
          -flags => 80 },
        { -label => q{00.01.03 - Engine},
          -cpsc_obid => q{gcqnQ2haec---z0admin-ad2},
          -cpsc => q{00.01.03},
          -flags => 80 },
        { -label => q{00.01.04 - Suspension},
          -cpsc_obid => q{gcqnQ3eaec---z0admin-ad2},
          -cpsc => q{00.01.04},
          -flags => 80 },
        { -label => q{00.01.05 - Driveline},
          -cpsc_obid => q{gcqnQ4baec---z0admin-ad2},
          -cpsc => q{00.01.05},
          -flags => 80 },
        { -label => q{00.01.06 - Brake},
          -cpsc_obid => q{gcqnQ4jaec---z0admin-ad2},
          -cpsc => q{00.01.06},
          -flags => 80 },
        { -label => q{00.01.07 - Transmission},
          -cpsc_obid => q{gcqnQ5gaec---z0admin-ad2},
          -cpsc => q{00.01.07},
          -flags => 80 },
        { -label => q{00.01.08 - Clutch},
          -cpsc_obid => q{gcqnQ6daec---z0admin-ad2},
          -cpsc => q{00.01.08},
          -flags => 80 },
        { -label => q{00.01.09 - Exhaust},
          -cpsc_obid => q{gcqnQ7aaec---z0admin-ad2},
          -cpsc => q{00.01.09},
          -flags => 80 },
        { -label => q{00.01.10 - Fuel},
          -cpsc_obid => q{gcqnQ7iaec---z0admin-ad2},
          -cpsc => q{00.01.10},
          -flags => 80 },
        { -label => q{00.01.11 - Steering},
          -cpsc_obid => q{gcqnRafaec---z0admin-ad2},
          -cpsc => q{00.01.11},
          -flags => 80 },
        { -label => q{00.01.12 - Climate Control},
          -cpsc_obid => q{gcqnRbcaec---z0admin-ad2},
          -cpsc => q{00.01.12},
          -flags => 80 },
        { -label => q{00.01.13 - Gauge and Warning Device},
          -cpsc_obid => q{gcqnRbkaec---z0admin-ad2},
          -cpsc => q{00.01.13},
          -flags => 80 },
        { -label => q{00.01.14 - Electrical Power Supply},
          -cpsc_obid => q{gcqnRchaec---z0admin-ad2},
          -cpsc => q{00.01.14},
          -flags => 80 },
        { -label => q{00.01.15 - Radio Tape and Communications},
          -cpsc_obid => q{gcqnRdeaec---z0admin-ad2},
          -cpsc => q{00.01.15},
          -flags => 80 },
        { -label => q{00.01.16 - Vacuum Distribution},
          -cpsc_obid => q{gcqnOzkaec---z0admin-ad1},
          -cpsc => q{00.01.16},
          -flags => 80 },
        { -label => q{00.01.17 - Lighting},
          -cpsc_obid => q{gcqnOAhaec---z0admin-ad1},
          -cpsc => q{00.01.17},
          -flags => 80 },
        { -label => q{00.01.18 - Electrical Distribution},
          -cpsc_obid => q{gcqnOBeaec---z0admin-ad1},
          -cpsc => q{00.01.18},
          -flags => 80 },
        { -label => q{00.01.XX - Information Attached to System XX},
          -cpsc_obid => q{gcqnOCbaec---z0admin-ad1},
          -cpsc => q{00.01.XX},
          -flags => 80 } ] },
    { -label => q{00.02 - Jack Tools and Emergency Equipment},
      -cpsc_obid => q{gcqnOCjaec---z0admin-ad1},
      -cpsc => q{00.02.00},
      -flags => 88,
      -children => [
        { -label => q{00.02.01 - Jack and Jack Handle},
          -cpsc_obid => q{gcqnODgaec---z0admin-ad1},
          -cpsc => q{00.02.01},
          -flags => 80 },
        { -label => q{00.02.02 - Tools},
          -cpsc_obid => q{gcqnRedaec---z0admin-ad2},
          -cpsc => q{00.02.02},
          -flags => 80 },
        { -label => q{00.02.03 - Warning Sign and Warning Lamp},
          -cpsc_obid => q{gcqnRfaaec---z0admin-ad2},
          -cpsc => q{00.02.03},
          -flags => 80 },
        { -label => q{00.02.04 - Fire Extinguisher},
          -cpsc_obid => q{gcqnOEcaec---z0admin-ad1},
          -cpsc => q{00.02.04},
          -flags => 80 },
        { -label => q{00.02.05 - First Aid Kits},
          -cpsc_obid => q{gcqnOEkaec---z0admin-ad1},
          -cpsc => q{00.02.05},
          -flags => 80 },
        { -label => q{00.02.06 - Tire Inflation Devices},
          -cpsc_obid => q{gcqnOFhaec---z0admin-ad1},
          -cpsc => q{00.02.06},
          -flags => 80 },
        { -label => q{00.02.07 - Wheel Chocks},
          -cpsc_obid => q{gcqnOGeaec---z0admin-ad1},
          -cpsc => q{00.02.07},
          -flags => 80 } ] },
    { -label => q{00.03 - Dealer-Owner-Operator Accessories},
      -cpsc_obid => q{gcqnOHbaec---z0admin-ad1},
      -cpsc => q{00.03.00},
      -flags => 88,
      -children => [
        { -label => q{00.03.01 - Accessories},
          -cpsc_obid => q{gcqnOHjaec---z0admin-ad1},
          -cpsc => q{00.03.01},
          -flags => 80 },
        { -label => q{00.03.02 - Appearance and Protection},
          -cpsc_obid => q{hbEmJ4apdcmp1z0admin-cyl},
          -cpsc => q{00.03.02},
          -flags => 80 },
        { -label => q{00.03.03 - Interior Styling},
          -cpsc_obid => q{hbEmJ4dpdcmp1z0admin-cyl},
          -cpsc => q{00.03.03},
          -flags => 80 },
        { -label => q{00.03.04 - Safety and Emergency},
          -cpsc_obid => q{hbEmJ4fpdcmp1z0admin-cyl},
          -cpsc => q{00.03.04},
          -flags => 80 },
        { -label => q{00.03.05 - Vision and Lighting},
          -cpsc_obid => q{hbEmJ4hpdcmp1z0admin-cyl},
          -cpsc => q{00.03.05},
          -flags => 80 } ] },
    { -label => q{00.04 - Vehicle Transportation Aids},
      -cpsc_obid => q{gcqnOIgaec---z0admin-ad1},
      -cpsc => q{00.04.00},
      -flags => 88,
      -children => [
        { -label => q{00.04.01 - Body-Mounted Transportation Aids and Shipping Tie-Downs},
          -cpsc_obid => q{gcqnOJdaec---z0admin-ad1},
          -cpsc => q{00.04.01},
          -flags => 80 },
        { -label => q{00.04.02 - Chassis-Mounted Transportation Aids and Shipping Tie-Downs},
          -cpsc_obid => q{gcqnOKaaec---z0admin-ad1},
          -cpsc => q{00.04.02},
          -flags => 80 } ] },
    { -label => q{00.05 - Dynamic Damper},
      -cpsc_obid => q{gcqnOKiaec---z0admin-ad1},
      -cpsc => q{00.05.00},
      -flags => 88,
      -children => [
        { -label => q{00.05.01 - Body-Mounted Dynamic Dampers},
          -cpsc_obid => q{gcqnOLfaec---z0admin-ad1},
          -cpsc => q{00.05.01},
          -flags => 80 },
        { -label => q{00.05.02 - Chassis-Mounted Dynamic Dampers},
          -cpsc_obid => q{gcqnOMcaec---z0admin-ad1},
          -cpsc => q{00.05.02},
          -flags => 80 },
        { -label => q{00.05.03 - Engine-Mounted Dynamic Dampers},
          -cpsc_obid => q{gcqnOMkaec---z0admin-ad1},
          -cpsc => q{00.05.03},
          -flags => 80 },
        { -label => q{00.05.04 - Reserved},
          -cpsc_obid => q{hbEmJ5fpdcmp1z0admin-cyl},
          -cpsc => q{00.05.04},
          -flags => 80 },
        { -label => q{00.05.05 - Axle/Driveshaft-Mounted Dynamic Dampers},
          -cpsc_obid => q{gcqnONhaec---z0admin-ad1},
          -cpsc => q{00.05.05},
          -flags => 80 },
        { -label => q{00.05.06 - Reserved},
          -cpsc_obid => q{hbEmJ5hpdcmp1z0admin-cyl},
          -cpsc => q{00.05.06},
          -flags => 80 },
        { -label => q{00.05.07 - Transmission-Mounted Dynamic Dampers-Absorbers},
          -cpsc_obid => q{gcqnOOeaec---z0admin-ad1},
          -cpsc => q{00.05.07},
          -flags => 80 },
        { -label => q{00.05.08 - Reserved 00.05.08 - 00.05.10},
          -cpsc_obid => q{hbEmn2cpdcmp1z0admin-cyi},
          -cpsc => q{00.05.08},
          -flags => 80 },
        { -label => q{00.05.11 - Steering-Mounted Dynamic Dampers},
          -cpsc_obid => q{gcqnOPbaec---z0admin-ad1},
          -cpsc => q{00.05.11},
          -flags => 80 },
        { -label => q{00.05.XX - System XX-Mounted Dynamic Dampers},
          -cpsc_obid => q{gcqnOPjaec---z0admin-ad1},
          -cpsc => q{00.05.XX},
          -flags => 80 } ] },
    { -label => q{00.06 - Electrical-Electronic},
      -cpsc_obid => q{gcqnOQgaec---z0admin-ad1},
      -cpsc => q{00.06.00},
      -flags => 88,
      -children => [
        { -label => q{00.06.01 - Communication Network},
          -cpsc_obid => q{gcqnORdaec---z0admin-ad1},
          -cpsc => q{00.06.01},
          -flags => 80 },
        { -label => q{00.06.02 - Communication Network Software},
          -cpsc_obid => q{gcqnRfiaec---z0admin-ad2},
          -cpsc => q{00.06.02},
          -flags => 80 },
        { -label => q{00.06.03 - Communication Network Hardware},
          -cpsc_obid => q{gcqnOSaaec---z0admin-ad1},
          -cpsc => q{00.06.03},
          -flags => 80 },
        { -label => q{00.06.04 - OBD-II Interface},
          -cpsc_obid => q{gcqnOSiaec---z0admin-ad1},
          -cpsc => q{00.06.04},
          -flags => 80 },
        { -label => q{00.06.05 - Reserved 00.06.05 - 00.06.13},
          -cpsc_obid => q{hbEmqRapdcmp1z0admin-cyj},
          -cpsc => q{00.06.05},
          -flags => 80 },
        { -label => q{00.06.14 - Electrical Energy Management},
          -cpsc_obid => q{gcqnOTfaec---z0admin-ad1},
          -cpsc => q{00.06.14},
          -flags => 80 },
        { -label => q{00.06.15 - Vehicle Electronics Diagnostics},
          -cpsc_obid => q{gcqnOUcaec---z0admin-ad1},
          -cpsc => q{00.06.15},
          -flags => 80 },
        { -label => q{00.06.16 - Reserved 00.06.16 - 00.06.24},
          -cpsc_obid => q{hbEmqRcpdcmp1z0admin-cyj},
          -cpsc => q{00.06.16},
          -flags => 80 },
        { -label => q{00.06.25 - Electromagnetic Compatibility EMC},
          -cpsc_obid => q{gcqnOUkaec---z0admin-ad1},
          -cpsc => q{00.06.25},
          -flags => 80 },
        { -label => q{00.06.26 - Entertainment System Suppression},
          -cpsc_obid => q{gcqnOVhaec---z0admin-ad1},
          -cpsc => q{00.06.26},
          -flags => 80 },
        { -label => q{00.06.27 - Reserved 00.06.27 - 00.06.49},
          -cpsc_obid => q{hbEmqRgpdcmp1z0admin-cyj},
          -cpsc => q{00.06.27},
          -flags => 80 },
        { -label => q{00.06.50 - E-E System Power Distribution-Grounding},
          -cpsc_obid => q{gcqnOWeaec---z0admin-ad1},
          -cpsc => q{00.06.50},
          -flags => 80 },
        { -label => q{00.06.51 - Generic Shared Circuits-Signals},
          -cpsc_obid => q{gcqnOXbaec---z0admin-ad1},
          -cpsc => q{00.06.51},
          -flags => 80 } ] },
    { -label => q{00.00.01 - Total Vehicle Requirements},
      -cpsc_obid => q{hbEmJSkpdcmp1z0admin-cyl},
      -cpsc => q{00.00.01},
      -flags => 80 },
    { -label => q{00.00.03 - Engine Compartment Installation-Package},
      -cpsc_obid => q{gcqnOrjaec---z0admin-ad1},
      -cpsc => q{00.00.03},
      -flags => 80 },
    { -label => q{00.00.04 - Reserved 00.00.04 - 00.00.49},
      -cpsc_obid => q{hbEmJTbpdcmp1z0admin-cyl},
      -cpsc => q{00.00.04},
      -flags => 80 },
    { -label => q{00.00.50 - Fuel Economy},
      -cpsc_obid => q{gcqnOsgaec---z0admin-ad1},
      -cpsc => q{00.00.50},
      -flags => 80 },
    { -label => q{00.00.51 - Noise - Exterior},
      -cpsc_obid => q{gcqnOtdaec---z0admin-ad1},
      -cpsc => q{00.00.51},
      -flags => 80 },
    { -label => q{00.00.52 - Noise - Interior},
      -cpsc_obid => q{gcqnOuaaec---z0admin-ad1},
      -cpsc => q{00.00.52},
      -flags => 80 },
    { -label => q{00.00.53 - Occupant Protection - Vehicle Behavior},
      -cpsc_obid => q{gcqnQLdaec---z0admin-ad2},
      -cpsc => q{00.00.53},
      -flags => 80 },
    { -label => q{00.00.54 - Occupant Protection - Interior Impact},
      -cpsc_obid => q{gcqnQMbaec---z0admin-ad2},
      -cpsc => q{00.00.54},
      -flags => 80 },
    { -label => q{00.00.55 - Reserved - see 00.06.25 for RFI},
      -cpsc_obid => q{gcqnQMjaec---z0admin-ad2},
      -cpsc => q{00.00.55},
      -flags => 80 },
    { -label => q{00.00.56 - Type Approval and Definitions/Classifications},
      -cpsc_obid => q{gcqnQNgaec---z0admin-ad2},
      -cpsc => q{00.00.56},
      -flags => 80 },
    { -label => q{00.00.57 - Materials and Restricted Substances},
      -cpsc_obid => q{gcqnQOdaec---z0admin-ad2},
      -cpsc => q{00.00.57},
      -flags => 80 },
    { -label => q{00.00.58 - Vehicle Weights and Dimensions},
      -cpsc_obid => q{gcqnQPaaec---z0admin-ad2},
      -cpsc => q{00.00.58},
      -flags => 80 },
    { -label => q{00.00.59 - Anti-Theft},
      -cpsc_obid => q{gcqnQPiaec---z0admin-ad2},
      -cpsc => q{00.00.59},
      -flags => 80 },
    { -label => q{00.00.60 - Vehicle Performance},
      -cpsc_obid => q{gcqnQQfaec---z0admin-ad2},
      -cpsc => q{00.00.60},
      -flags => 80 },
    { -label => q{00.00.61 - Technical Taxation},
      -cpsc_obid => q{gcqnQRcaec---z0admin-ad2},
      -cpsc => q{00.00.61},
      -flags => 80 },
    { -label => q{00.00.62 - Health and Safety},
      -cpsc_obid => q{gcqnQRkaec---z0admin-ad2},
      -cpsc => q{00.00.62},
      -flags => 80 },
    { -label => q{00.00.63 - Engine Power},
      -cpsc_obid => q{gcqnQShaec---z0admin-ad2},
      -cpsc => q{00.00.63},
      -flags => 80 },
    { -label => q{00.00.64 - Commercial Carriage of Passengers},
      -cpsc_obid => q{gcqnOukaec---z0admin-ad1},
      -cpsc => q{00.00.64},
      -flags => 80 },
    { -label => q{00.00.65 - Ground Clearance},
      -cpsc_obid => q{gcqnOvhaec---z0admin-ad1},
      -cpsc => q{00.00.65},
      -flags => 80 },
    { -label => q{00.00.66 - Tire Clearance},
      -cpsc_obid => q{gcqnOweaec---z0admin-ad1},
      -cpsc => q{00.00.66},
      -flags => 80 },
    { -label => q{00.00.67 - Tube Routing},
      -cpsc_obid => q{gcqnOxbaec---z0admin-ad1},
      -cpsc => q{00.00.67},
      -flags => 80 },
    { -label => q{00.00.68 - Interior Controls},
      -cpsc_obid => q{gcqnQTcaec---z0admin-ad2},
      -cpsc => q{00.00.68},
      -flags => 80 },
    { -label => q{00.00.69 - Driver's Reach Zones},
      -cpsc_obid => q{gcqnQTkaec---z0admin-ad2},
      -cpsc => q{00.00.69},
      -flags => 80 },
    { -label => q{00.00.70 - Fields of View},
      -cpsc_obid => q{gcqnQUhaec---z0admin-ad2},
      -cpsc => q{00.00.70},
      -flags => 80 },
    { -label => q{00.00.71 - Trailer Operation},
      -cpsc_obid => q{gcqnQVeaec---z0admin-ad2},
      -cpsc => q{00.00.71},
      -flags => 80 },
    { -label => q{00.00.72 - Reserved},
      -cpsc_obid => q{hbEmJTfpdcmp1z0admin-cyl},
      -cpsc => q{00.00.72},
      -flags => 80 },
    { -label => q{00.00.73 - Package Requirements},
      -cpsc_obid => q{gcqnOxjaec---z0admin-ad1},
      -cpsc => q{00.00.73},
      -flags => 80 },
    { -label => q{00.00.74 - Production Conformity},
      -cpsc_obid => q{gcqnOygaec---z0admin-ad1},
      -cpsc => q{00.00.74},
      -flags => 80 },
    { -label => q{00.00.75 - Carriage of Dangerous Goods},
      -cpsc_obid => q{gcqnQWbaec---z0admin-ad2},
      -cpsc => q{00.00.75},
      -flags => 80 },
    { -label => q{00.00.76 - Special Type Vehicles},
      -cpsc_obid => q{gcqnOzdaec---z0admin-ad1},
      -cpsc => q{00.00.76},
      -flags => 80 },
    { -label => q{00.00.77 - Restrictions on Vehicle Operation},
      -cpsc_obid => q{gcqnQWjaec---z0admin-ad2},
      -cpsc => q{00.00.77},
      -flags => 80 },
    { -label => q{00.00.78 - Driver and Operator Licensing},
      -cpsc_obid => q{gcqnQXgaec---z0admin-ad2},
      -cpsc => q{00.00.78},
      -flags => 80 },
    { -label => q{00.00.79 - In-Service Inspection-Roadworthiness},
      -cpsc_obid => q{gcqnQYdaec---z0admin-ad2},
      -cpsc => q{00.00.79},
      -flags => 80 },
    { -label => q{00.00.80 - Import-Sale and Local Content Controls},
      -cpsc_obid => q{gcqnQZaaec---z0admin-ad2},
      -cpsc => q{00.00.80},
      -flags => 80 },
    { -label => q{00.00.81 - Vehicle Stability and Handling},
      -cpsc_obid => q{gcqnQZiaec---z0admin-ad2},
      -cpsc => q{00.00.81},
      -flags => 80 } ] },

{ -label => q{01 - Body System},
  -cpsc_obid => q{gcqnOXjaec---z0admin-ad1},
  -cpsc => q{01.00.00},
  -flags => 88,
  -children => [
    { -label => q{01.01 - Body Structure},
      -cpsc_obid => q{gcqnOYaaec---z0admin-ad1},
      -cpsc => q{01.01.00},
      -flags => 88,
      -children => [
        { -label => q{01.01.01 - Underbody},
          -cpsc_obid => q{gcqnOYiaec---z0admin-ad1},
          -cpsc => q{01.01.01},
          -flags => 80 },
        { -label => q{01.01.02 - Body Dash and Cowl},
          -cpsc_obid => q{gcqnOZfaec---z0admin-ad1},
          -cpsc => q{01.01.02},
          -flags => 88,
          -children => [
            { -label => q{*** See 01.01.01 - Underbody},
              -flags => 80 } ] },
        { -label => q{01.01.03 - Roof},
          -cpsc_obid => q{gcqnO0caec---z0admin-ad1},
          -cpsc => q{01.01.03},
          -flags => 80 },
        { -label => q{01.01.04 - Body Side and Quarter},
          -cpsc_obid => q{gcqnO0kaec---z0admin-ad1},
          -cpsc => q{01.01.04},
          -flags => 80 },
        { -label => q{01.01.05 - Package Tray},
          -cpsc_obid => q{gcqnO1haec---z0admin-ad1},
          -cpsc => q{01.01.05},
          -flags => 80 },
        { -label => q{01.01.06 - Body Rear End},
          -cpsc_obid => q{gcqnRghaec---z0admin-ad2},
          -cpsc => q{01.01.06},
          -flags => 80 },
        { -label => q{01.01.07 - Deflector and Shields},
          -cpsc_obid => q{gcqnRheaec---z0admin-ad2},
          -cpsc => q{01.01.07},
          -flags => 80 } ] },
    { -label => q{01.02 - Front End},
      -cpsc_obid => q{gcqnRibaec---z0admin-ad2},
      -cpsc => q{01.02.00},
      -flags => 88,
      -children => [
        { -label => q{01.02.01 - Front Structure},
          -cpsc_obid => q{gcqnRijaec---z0admin-ad2},
          -cpsc => q{01.02.01},
          -flags => 80 },
        { -label => q{01.02.02 - Grille Opening Panel-Front Sheet Metal},
          -cpsc_obid => q{gcqnRjgaec---z0admin-ad2},
          -cpsc => q{01.02.02},
          -flags => 80 },
        { -label => q{01.02.03 - Front Fenders},
          -cpsc_obid => q{gcqnRkdaec---z0admin-ad2},
          -cpsc => q{01.02.03},
          -flags => 80 },
        { -label => q{01.02.04 - Deflectors and Shields},
          -cpsc_obid => q{gcqnRlaaec---z0admin-ad2},
          -cpsc => q{01.02.04},
          -flags => 80 },
        { -label => q{01.02.05 - Hood and Mounting},
          -cpsc_obid => q{gcqnRliaec---z0admin-ad2},
          -cpsc => q{01.02.05},
          -flags => 80 },
        { -label => q{01.02.06 - Headlamp Mounting Panel},
          -cpsc_obid => q{gcqnRmfaec---z0admin-ad2},
          -cpsc => q{01.02.06},
          -flags => 80 },
        { -label => q{01.02.07 - Aerodynamic Undershields and Air Foils},
          -cpsc_obid => q{gcqnRncaec---z0admin-ad2},
          -cpsc => q{01.02.07},
          -flags => 80 } ] },
    { -label => q{01.03 - Body Closures},
      -cpsc_obid => q{gcqnRnkaec---z0admin-ad2},
      -cpsc => q{01.03.00},
      -flags => 88,
      -children => [
        { -label => q{01.03.01 - Front Side Doors},
          -cpsc_obid => q{gcqnRohaec---z0admin-ad2},
          -cpsc => q{01.03.01},
          -chunk_obid => q{hgkoPfipdcmp1z0admin-fKL},
          -chunk => q{010301},
          -flags => 80 },
        { -label => q{01.03.02 - Rear Side Doors},
          -cpsc_obid => q{gcqnRpeaec---z0admin-ad2},
          -cpsc => q{01.03.02},
          -chunk_obid => q{hgkoFRdpdcmp1z0admin-fKI},
          -chunk => q{010302},
          -flags => 80 },
        { -label => q{01.03.03 - Rear Deck Lid Truck Back Doors Tailgate and Liftgate},
          -cpsc_obid => q{gcqnRqbaec---z0admin-ad2},
          -cpsc => q{01.03.03},
          -chunk_obid => q{hgkoQmipdcmp1z0admin-fKM},
          -chunk => q{010303},
          -flags => 80 },
        { -label => q{01.03.04 - Storage Access Doors},
          -cpsc_obid => q{gcqnRqjaec---z0admin-ad2},
          -cpsc => q{01.03.04},
          -chunk_obid => q{hgkoG5kpdcmp1z0admin-fKK},
          -chunk => q{010304},
          -flags => 80 } ] },
    { -label => q{01.04 - Second Unit Body},
      -cpsc_obid => q{gcqnO2caec---z0admin-ad1},
      -cpsc => q{01.04.00},
      -flags => 88,
      -children => [
        { -label => q{01.04.01 - Pick-up Box Body},
          -cpsc_obid => q{gcqnO2kaec---z0admin-ad1},
          -cpsc => q{01.04.01},
          -flags => 80 },
        { -label => q{01.04.02 - Platform Body},
          -cpsc_obid => q{gcqnO3haec---z0admin-ad1},
          -cpsc => q{01.04.02},
          -flags => 80 },
        { -label => q{01.04.03 - Special Truck Body},
          -cpsc_obid => q{gcqnO4eaec---z0admin-ad1},
          -cpsc => q{01.04.03},
          -flags => 80 },
        { -label => q{01.04.04 - Camper Body Shells},
          -cpsc_obid => q{gcqnO5baec---z0admin-ad1},
          -cpsc => q{01.04.04},
          -flags => 80 } ] },
    { -label => q{01.05 - Interior Trim and Ornamentation},
      -cpsc_obid => q{gcqnO5jaec---z0admin-ad1},
      -cpsc => q{01.05.00},
      -flags => 88,
      -children => [
        { -label => q{01.05.01 - Floor - Trim},
          -cpsc_obid => q{gcqnO6gaec---z0admin-ad1},
          -cpsc => q{01.05.01},
          -flags => 80 },
        { -label => q{01.05.02 - Cowl - Trim},
          -cpsc_obid => q{gcqnO7daec---z0admin-ad1},
          -cpsc => q{01.05.02},
          -flags => 80 },
        { -label => q{01.05.03 - Roof Trim and Ornamentation},
          -cpsc_obid => q{gcqnPaaaec---z0admin-ad1},
          -cpsc => q{01.05.03},
          -flags => 80 },
        { -label => q{01.05.04 - Sun Visors},
          -cpsc_obid => q{gcqnPaiaec---z0admin-ad1},
          -cpsc => q{01.05.04},
          -flags => 80 },
        { -label => q{01.05.05 - Front Side Door-Trim and Ornamentation},
          -cpsc_obid => q{gcqnPbfaec---z0admin-ad1},
          -cpsc => q{01.05.05},
          -chunk_obid => q{hglrGEjpdcmp1z0admin-fQ6},
          -chunk => q{010505},
          -flags => 88,
          -children => [
            { -label => q{FRBRKT - Front side Brackets},
              -chunk_obid => q{giEeavkpdcmp1z0admin-bab},
              -chunk => q{FRBRKT},
              -flags => 80 },
            { -label => q{FRFPNL - Front side Finished Panels},
              -chunk_obid => q{giEeaxjpdcmp1z0admin-bab},
              -chunk => q{FRFPNL},
              -flags => 80 },
            { -label => q{FRHNDL - Front Handle},
              -chunk_obid => q{giEkS4dpdcmp1z0admin-bae},
              -chunk => q{FRHNDL},
              -flags => 80 },
            { -label => q{FRMCMP - Front side Misc. Components},
              -chunk_obid => q{giEkgSbpdcmp1z0admin-bac},
              -chunk => q{FRMCMP},
              -flags => 80 },
            { -label => q{FRSBST - Front side Substrate},
              -chunk_obid => q{giEeawhpdcmp1z0admin-bab},
              -chunk => q{FRSBST},
              -flags => 80 },
            { -label => q{FSIDUM - Front Side Impact Dummies},
              -chunk_obid => q{giEkgRbpdcmp1z0admin-bac},
              -chunk => q{FSIDUM},
              -flags => 80 } ] },
        { -label => q{01.05.06 - Rear Side Door-Trim and Ornamentation},
          -cpsc_obid => q{gcqnPccaec---z0admin-ad1},
          -cpsc => q{01.05.06},
          -chunk_obid => q{hgzlBEgpdcmp1z0admin-gQj},
          -chunk => q{010506},
          -flags => 88,
          -children => [
            { -label => q{RRBRKT - Rear side Brackets},
              -chunk_obid => q{giEkgSipdcmp1z0admin-bac},
              -chunk => q{RRBRKT},
              -flags => 80 },
            { -label => q{RRFPNL - Rear side Finished Panels},
              -chunk_obid => q{giEeaAdpdcmp1z0admin-bab},
              -chunk => q{RRFPNL},
              -flags => 80 },
            { -label => q{RRHNDL - Rear side Handle},
              -chunk_obid => q{giEkS6kpdcmp1z0admin-bae},
              -chunk => q{RRHNDL},
              -flags => 80 },
            { -label => q{RRMCMP - Rear side Misc. Components},
              -chunk_obid => q{giEeaBcpdcmp1z0admin-bab},
              -chunk => q{RRMCMP},
              -flags => 80 },
            { -label => q{RRSBST - Rear side Substrate},
              -chunk_obid => q{giEeazbpdcmp1z0admin-bab},
              -chunk => q{RRSBST},
              -flags => 80 },
            { -label => q{RSIDUM - Rear Side Impact Dummies},
              -chunk_obid => q{giEkS7gpdcmp1z0admin-bae},
              -chunk => q{RSIDUM},
              -flags => 80 } ] },
        { -label => q{01.05.07 - Body Side-Quarter-Trim and Ornamentation},
          -cpsc_obid => q{gcqnPckaec---z0admin-ad1},
          -cpsc => q{01.05.07},
          -flags => 80 },
        { -label => q{01.05.08 - Body Rear End-Trim and Ornamentation},
          -cpsc_obid => q{gcqnPdhaec---z0admin-ad1},
          -cpsc => q{01.05.08},
          -flags => 80 },
        { -label => q{01.05.09 - Tailgate Liftgate and Back Door Trim and Ornamentation},
          -cpsc_obid => q{gcqnPeeaec---z0admin-ad1},
          -cpsc => q{01.05.09},
          -flags => 80 },
        { -label => q{01.05.10 - Sleeper Compartment Trim and Ornamentation},
          -cpsc_obid => q{gcqnPfbaec---z0admin-ad1},
          -cpsc => q{01.05.10},
          -flags => 80 },
        { -label => q{01.05.11 - Interior Accessory Bars},
          -cpsc_obid => q{gcqnPfjaec---z0admin-ad1},
          -cpsc => q{01.05.11},
          -flags => 80 } ] },
    { -label => q{01.06 - Sound and Heat Control Body},
      -cpsc_obid => q{gcqnPggaec---z0admin-ad1},
      -cpsc => q{01.06.00},
      -flags => 88,
      -children => [
        { -label => q{01.06.01 - Sound Control Less Back Door and Tailgate},
          -cpsc_obid => q{gcqnPhdaec---z0admin-ad1},
          -cpsc => q{01.06.01},
          -flags => 80 },
        { -label => q{01.06.02 - Sound Control Back Door and Tailgate},
          -cpsc_obid => q{gcqnPiaaec---z0admin-ad1},
          -cpsc => q{01.06.02},
          -flags => 80 },
        { -label => q{01.06.03 - Heat Control},
          -cpsc_obid => q{gcqnPiiaec---z0admin-ad1},
          -cpsc => q{01.06.03},
          -flags => 80 } ] },
    { -label => q{01.07 - Sealing},
      -cpsc_obid => q{gcqnPjdaec---z0admin-ad1},
      -cpsc => q{01.07.00},
      -flags => 88,
      -children => [
        { -label => q{01.07.01 - Static Weatherstrips},
          -cpsc_obid => q{gcqnPkaaec---z0admin-ad1},
          -cpsc => q{01.07.01},
          -flags => 80 },
        { -label => q{01.07.02 - Dynamic Weatherstrips},
          -cpsc_obid => q{gcqnPkiaec---z0admin-ad1},
          -cpsc => q{01.07.02},
          -flags => 80 },
        { -label => q{01.07.03 - Soft Sealing},
          -cpsc_obid => q{gcqnPlfaec---z0admin-ad1},
          -cpsc => q{01.07.03},
          -flags => 80 },
        { -label => q{01.07.04 - Structural Adhesive},
          -cpsc_obid => q{gcqnPmcaec---z0admin-ad1},
          -cpsc => q{01.07.04},
          -flags => 80 },
        { -label => q{01.07.05 - Joint Finishing},
          -cpsc_obid => q{gcqnPmkaec---z0admin-ad1},
          -cpsc => q{01.07.05},
          -flags => 80 },
        { -label => q{01.07.06 - Sealing Plugs and Functional Tapes},
          -cpsc_obid => q{gcqnPnhaec---z0admin-ad1},
          -cpsc => q{01.07.06},
          -flags => 80 },
        { -label => q{01.07.07 - Door and Quarter Panel Watershields},
          -cpsc_obid => q{gcqnPoeaec---z0admin-ad1},
          -cpsc => q{01.07.07},
          -flags => 80 } ] },
    { -label => q{01.08 - Exterior Trim and Ornamentation},
      -cpsc_obid => q{gcqnPpbaec---z0admin-ad1},
      -cpsc => q{01.08.00},
      -flags => 88,
      -children => [
        { -label => q{01.08.01 - Radiator Grille and Headlamp Bezels},
          -cpsc_obid => q{gcqnRrhaec---z0admin-ad2},
          -cpsc => q{01.08.01},
          -chunk_obid => q{giEkSSkpdcmp1z0admin-bae},
          -chunk => q{010801},
          -flags => 80 },
        { -label => q{01.08.02 - Front End-Trim and Ornamentation},
          -cpsc_obid => q{gcqnRseaec---z0admin-ad2},
          -cpsc => q{01.08.02},
          -flags => 80 },
        { -label => q{01.08.03 - Front End-Air Dam Extensions},
          -cpsc_obid => q{gcqnRtbaec---z0admin-ad2},
          -cpsc => q{01.08.03},
          -flags => 80 },
        { -label => q{01.08.04 - Roof-Trim and Ornamentation},
          -cpsc_obid => q{gcqnRtjaec---z0admin-ad2},
          -cpsc => q{01.08.04},
          -flags => 80 },
        { -label => q{01.08.05 - Body Side and Quarter Trim and Ornamentation},
          -cpsc_obid => q{gcqnRugaec---z0admin-ad2},
          -cpsc => q{01.08.05},
          -flags => 80 },
        { -label => q{01.08.06 - Body Rear End-Trim and Ornamentation},
          -cpsc_obid => q{gcqnRvdaec---z0admin-ad2},
          -cpsc => q{01.08.06},
          -flags => 80 },
        { -label => q{01.08.07 - Rear Deck Lid Truck Back Door Tailgate and Liftgate-Trim and Ornamentation},
          -cpsc_obid => q{gcqnRwaaec---z0admin-ad2},
          -cpsc => q{01.08.07},
          -flags => 80 },
        { -label => q{01.08.08 - Exterior Accessory Bar},
          -cpsc_obid => q{gcqnRwiaec---z0admin-ad2},
          -cpsc => q{01.08.08},
          -flags => 80 },
        { -label => q{01.08.09 - Exterior Steps and Grab Handles},
          -cpsc_obid => q{gcqnRxfaec---z0admin-ad2},
          -cpsc => q{01.08.09},
          -flags => 80 } ] },
    { -label => q{01.09 - Rear View Mirrors},
      -cpsc_obid => q{gcqnRycaec---z0admin-ad2},
      -cpsc => q{01.09.00},
      -flags => 88,
      -children => [
        { -label => q{01.09.01 - Inside Mirrors},
          -cpsc_obid => q{gcqnRykaec---z0admin-ad2},
          -cpsc => q{01.09.01},
          -flags => 80 },
        { -label => q{01.09.02 - Outside Mirrors},
          -cpsc_obid => q{gcqnRzhaec---z0admin-ad2},
          -cpsc => q{01.09.02},
          -flags => 80 },
        { -label => q{01.09.03 - Heated Outside Mirrors},
          -cpsc_obid => q{gcqnRAeaec---z0admin-ad2},
          -cpsc => q{01.09.03},
          -flags => 80 },
        { -label => q{01.09.04 - Electrically Positioned Outside Mirror},
          -cpsc_obid => q{gcqnRBbaec---z0admin-ad2},
          -cpsc => q{01.09.04},
          -flags => 80 },
        { -label => q{01.09.05 - Outside Mirror Position Controls and Memory Circuits},
          -cpsc_obid => q{gcqnRBjaec---z0admin-ad2},
          -cpsc => q{01.09.05},
          -flags => 80 },
        { -label => q{01.09.06 - Heated Mirror Controls},
          -cpsc_obid => q{gcqnRCgaec---z0admin-ad2},
          -cpsc => q{01.09.06},
          -flags => 80 },
        { -label => q{01.09.07 - Automatic Electric Day-Night Inside Mirror},
          -cpsc_obid => q{gcqnRDdaec---z0admin-ad2},
          -cpsc => q{01.09.07},
          -flags => 80 },
        { -label => q{01.09.08 - Automatic Multi-function Inside Mirror},
          -cpsc_obid => q{gcqnREaaec---z0admin-ad2},
          -cpsc => q{01.09.08},
          -flags => 80 } ] },
    { -label => q{01.10 - Seating},
      -cpsc_obid => q{gcqnREiaec---z0admin-ad2},
      -cpsc => q{01.10.00},
      -flags => 88,
      -children => [
        { -label => q{01.10.01 - Front Seat Trim and Ornamentation},
          -cpsc_obid => q{gcqnRFfaec---z0admin-ad2},
          -cpsc => q{01.10.01},
          -flags => 80 },
        { -label => q{01.10.02 - Front Seat Springs Frame Tracks and Mechanisms Manual},
          -cpsc_obid => q{gcqnRGcaec---z0admin-ad2},
          -cpsc => q{01.10.02},
          -flags => 80 },
        { -label => q{01.10.03 - Rear Seat Trim and Ornamentation},
          -cpsc_obid => q{gcqnRGkaec---z0admin-ad2},
          -cpsc => q{01.10.03},
          -flags => 80 },
        { -label => q{01.10.04 - Rear Seat Springs Frame Tracks and Mechanisms},
          -cpsc_obid => q{gcqnRHhaec---z0admin-ad2},
          -cpsc => q{01.10.04},
          -flags => 80 },
        { -label => q{01.10.05 - Seat Beds and Auxiliary/Utility Seat Trim and Ornamentation (If Unique From Fron},
          -cpsc_obid => q{gcuadXjaec---z0admin-aeU},
          -cpsc => q{01.10.05},
          -flags => 80 },
        { -label => q{01.10.06 - Seat Beds and Auxiliary-Utility Seat Springs Frame Tracks and Mechanisms},
          -cpsc_obid => q{gcqnYIfaec---z0admin-ad3},
          -cpsc => q{01.10.06},
          -flags => 80 },
        { -label => q{01.10.07 - Power Seat Mechanisms},
          -cpsc_obid => q{gcqnYJdaec---z0admin-ad3},
          -cpsc => q{01.10.07},
          -flags => 80 },
        { -label => q{01.10.08 - Power Seat Electric Motors},
          -cpsc_obid => q{gcqnRIeaec---z0admin-ad2},
          -cpsc => q{01.10.08},
          -flags => 80 },
        { -label => q{01.10.09 - Power Seat Controls},
          -cpsc_obid => q{gcqnRJbaec---z0admin-ad2},
          -cpsc => q{01.10.09},
          -flags => 80 },
        { -label => q{01.10.10 - Power Memory Seat Control Module},
          -cpsc_obid => q{gcqnRJjaec---z0admin-ad2},
          -cpsc => q{01.10.10},
          -flags => 80 },
        { -label => q{01.10.11 - Electrically Heated Seats},
          -cpsc_obid => q{gcqnRKgaec---z0admin-ad2},
          -cpsc => q{01.10.11},
          -flags => 80 },
        { -label => q{01.10.12 - Seat Occupant Sensing Switches},
          -cpsc_obid => q{gcqnRLdaec---z0admin-ad2},
          -cpsc => q{01.10.12},
          -flags => 80 } ] },
    { -label => q{01.11 - Glass Glazing Frames and Mechanism},
      -cpsc_obid => q{gcqnYKaaec---z0admin-ad3},
      -cpsc => q{01.11.00},
      -flags => 88,
      -children => [
        { -label => q{01.11.01 - Windshield Glass Glazing},
          -cpsc_obid => q{gcqnYKiaec---z0admin-ad3},
          -cpsc => q{01.11.01},
          -flags => 80 },
        { -label => q{01.11.02 - Heated Windshield},
          -cpsc_obid => q{gcqnYLfaec---z0admin-ad3},
          -cpsc => q{01.11.02},
          -flags => 80 },
        { -label => q{01.11.03 - Front and Rear Door Glass Glazing Frames and Mechanisms},
          -cpsc_obid => q{gcqnYMcaec---z0admin-ad3},
          -cpsc => q{01.11.03},
          -flags => 80 },
        { -label => q{01.11.04 - Body Side and Quarter Glass Glazing Frames and Mechanisms},
          -cpsc_obid => q{gcqnYMkaec---z0admin-ad3},
          -cpsc => q{01.11.04},
          -flags => 80 },
        { -label => q{01.11.05 - Body Rear End Glass Glazing Frames and Mechanisms},
          -cpsc_obid => q{gcqnYNhaec---z0admin-ad3},
          -cpsc => q{01.11.05},
          -flags => 80 },
        { -label => q{01.11.06 - Heated Backlights},
          -cpsc_obid => q{gcqnYOeaec---z0admin-ad3},
          -cpsc => q{01.11.06},
          -flags => 80 },
        { -label => q{01.11.07 - Heated Window Controls},
          -cpsc_obid => q{gcqnZudaec---z0admin-ad4},
          -cpsc => q{01.11.07},
          -flags => 80 },
        { -label => q{01.11.08 - Power Window Mechanisms},
          -cpsc_obid => q{gcqnZvbaec---z0admin-ad4},
          -cpsc => q{01.11.08},
          -flags => 80 },
        { -label => q{01.11.09 - Power Window Controls},
          -cpsc_obid => q{gcqnZvjaec---z0admin-ad4},
          -cpsc => q{01.11.09},
          -flags => 80 },
        { -label => q{01.11.10 - Power Window Motors},
          -cpsc_obid => q{gcqnZwgaec---z0admin-ad4},
          -cpsc => q{01.11.10},
          -flags => 80 } ] },
    { -label => q{01.12 - Instrument Panel and Console},
      -cpsc_obid => q{gcqnZxdaec---z0admin-ad4},
      -cpsc => q{01.12.00},
      -flags => 88,
      -children => [
        { -label => q{01.12.01 - Instrument Panel},
          -cpsc_obid => q{gcqnZyaaec---z0admin-ad4},
          -cpsc => q{01.12.01},
          -chunk_obid => q{giEkTbepdcmp1z0admin-bae},
          -chunk => q{011201},
          -flags => 88,
          -children => [
            { -label => q{*** See 13.01 - Instrument Cluster},
              -flags => 80 },
            { -label => q{*** See 15.01 - Receiver and Audio Media},
              -flags => 80 },
            { -label => q{ATRAY - Ash Tray},
              -chunk_obid => q{giEkTfdpdcmp1z0admin-bae},
              -chunk => q{ATRAY},
              -flags => 80 },
            { -label => q{CUPHLD - Cup Holder},
              -chunk_obid => q{giEeaKjpdcmp1z0admin-bab},
              -chunk => q{CUPHLD},
              -flags => 80 },
            { -label => q{GBOX - Glove Box},
              -chunk_obid => q{giEkgXbpdcmp1z0admin-bac},
              -chunk => q{GBOX},
              -flags => 88,
              -children => [
                { -label => q{IPBIN - IP Bin},
                  -chunk_obid => q{giEkTgdpdcmp1z0admin-bae},
                  -chunk => q{IPBIN},
                  -flags => 80 },
                { -label => q{IPDOOR - Door},
                  -chunk_obid => q{giEkgYdpdcmp1z0admin-bac},
                  -chunk => q{IPDOOR},
                  -flags => 80 },
                { -label => q{IPLTCH - Latch},
                  -chunk_obid => q{giEeaGepdcmp1z0admin-bab},
                  -chunk => q{IPLTCH},
                  -flags => 80 } ] },
            { -label => q{IPABAS - IP Air Bag Assembly},
              -chunk_obid => q{giEeaJjpdcmp1z0admin-bab},
              -chunk => q{IPABAS},
              -flags => 80 },
            { -label => q{IPCCSY - IP Climate Control System},
              -chunk_obid => q{giEkg3dpdcmp1z0admin-bac},
              -chunk => q{IPCCSY},
              -flags => 88,
              -children => [
                { -label => q{IPCCDT - IP Climate Control Ducts},
                  -chunk_obid => q{giEkg3kpdcmp1z0admin-bac},
                  -chunk => q{IPCCDT},
                  -flags => 80 },
                { -label => q{IPCCHD - IP Climate Control Head},
                  -chunk_obid => q{giEeaMhpdcmp1z0admin-bab},
                  -chunk => q{IPCCHD},
                  -flags => 80 },
                { -label => q{IPCCPL - IP Climate Control Plenum},
                  -chunk_obid => q{giEeaMapdcmp1z0admin-bab},
                  -chunk => q{IPCCPL},
                  -flags => 80 } ] },
            { -label => q{IPFPNL - IP Finished Panels},
              -chunk_obid => q{giEeaIjpdcmp1z0admin-bab},
              -chunk => q{IPFPNL},
              -flags => 80 },
            { -label => q{IPMCMP - IP Misc. Components},
              -chunk_obid => q{giEkTikpdcmp1z0admin-bae},
              -chunk => q{IPMCMP},
              -flags => 80 },
            { -label => q{IPSBST - IP Substrate},
              -chunk_obid => q{giEkTehpdcmp1z0admin-bae},
              -chunk => q{IPSBST},
              -flags => 80 },
            { -label => q{IPSCAS - IP Structure and Steering Coloumn Assembly},
              -chunk_obid => q{giEeaCepdcmp1z0admin-bab},
              -chunk => q{IPSCAS},
              -flags => 88,
              -children => [
                { -label => q{IPSTRC - IP Structure},
                  -chunk_obid => q{giEkTcgpdcmp1z0admin-bae},
                  -chunk => q{IPSTRC},
                  -flags => 88,
                  -children => [
                    { -label => q{CCBEAM - Cross Car Beam},
                      -chunk_obid => q{giEkgVhpdcmp1z0admin-bac},
                      -chunk => q{CCBEAM},
                      -flags => 80 },
                    { -label => q{KBLSTR - Knee Bolsters},
                      -chunk_obid => q{giEkTdipdcmp1z0admin-bae},
                      -chunk => q{KBLSTR},
                      -flags => 80 },
                    { -label => q{SCBRKT - Steering Column Brackets},
                      -chunk_obid => q{giEeaEfpdcmp1z0admin-bab},
                      -chunk => q{SCBRKT},
                      -flags => 80 } ] },
                { -label => q{SCASLY - Steering Column Assembly},
                  -chunk_obid => q{giEeaDdpdcmp1z0admin-bab},
                  -chunk => q{SCASLY},
                  -flags => 80 } ] },
            { -label => q{STDDUM - Standard Dummies},
              -chunk_obid => q{giEkg0epdcmp1z0admin-bac},
              -chunk => q{STDDUM},
              -flags => 80 },
            { -label => q{WHFPNL - Wire Harness/Fuse Panel},
              -chunk_obid => q{giEkg1ipdcmp1z0admin-bac},
              -chunk => q{WHFPNL},
              -flags => 80 } ] },
        { -label => q{01.12.02 - Console Unit},
          -cpsc_obid => q{gcqnZyiaec---z0admin-ad4},
          -cpsc => q{01.12.02},
          -chunk_obid => q{giEkg5dpdcmp1z0admin-bac},
          -chunk => q{011202},
          -flags => 88,
          -children => [
            { -label => q{CNBIN - Console Bin},
              -chunk_obid => q{giEeaPdpdcmp1z0admin-bab},
              -chunk => q{CNBIN},
              -flags => 80 },
            { -label => q{CNBRKT - Console Brackets},
              -chunk_obid => q{giEeaNipdcmp1z0admin-bab},
              -chunk => q{CNBRKT},
              -flags => 80 },
            { -label => q{CNDUCT - Console Ducts},
              -chunk_obid => q{giEeaRbpdcmp1z0admin-bab},
              -chunk => q{CNDUCT},
              -flags => 80 },
            { -label => q{CNFPNL - Console Finished Panels},
              -chunk_obid => q{giEkTnapdcmp1z0admin-bae},
              -chunk => q{CNFPNL},
              -flags => 80 },
            { -label => q{CNHLDR - Console Cup Holder},
              -chunk_obid => q{giEeaQcpdcmp1z0admin-bab},
              -chunk => q{CNHLDR},
              -flags => 80 },
            { -label => q{CNMCMP - Console Misc. Components},
              -chunk_obid => q{giEkTnhpdcmp1z0admin-bae},
              -chunk => q{CNMCMP},
              -flags => 80 },
            { -label => q{CNSBST - Console Substrate},
              -chunk_obid => q{giEeaOepdcmp1z0admin-bab},
              -chunk => q{CNSBST},
              -flags => 80 } ] } ] },
    { -label => q{01.13 - Reserved},
      -cpsc_obid => q{hbEmokdpdcmp1z0admin-cyi},
      -cpsc => q{01.13.00},
      -flags => 80 },
    { -label => q{01.14 - Handles Locks Latches and Mech},
      -cpsc_obid => q{gcqnYPbaec---z0admin-ad3},
      -cpsc => q{01.14.00},
      -flags => 88,
      -children => [
        { -label => q{01.14.01 - Lock Set and Keys},
          -cpsc_obid => q{gcqnYPjaec---z0admin-ad3},
          -cpsc => q{01.14.01},
          -flags => 80 },
        { -label => q{01.14.02 - Key Illumination Device},
          -cpsc_obid => q{gcqnYQgaec---z0admin-ad3},
          -cpsc => q{01.14.02},
          -flags => 80 },
        { -label => q{01.14.03 - Body Front End Latches Hood Latches and Mechanisms},
          -cpsc_obid => q{gcqnYRdaec---z0admin-ad3},
          -cpsc => q{01.14.03},
          -flags => 80 },
        { -label => q{01.14.04 - Body Side Door-Handles Latches and Mechanisms},
          -cpsc_obid => q{gcqnYSaaec---z0admin-ad3},
          -cpsc => q{01.14.04},
          -flags => 80 },
        { -label => q{01.14.05 - Rear Door Deck Lid Liftgate and Tailgate-Handles Latches and Mech},
          -cpsc_obid => q{gcqnYSiaec---z0admin-ad3},
          -cpsc => q{01.14.05},
          -flags => 80 },
        { -label => q{01.14.06 - Underbody - Floor Compartment Latches and Mechanisms},
          -cpsc_obid => q{gcqnYTfaec---z0admin-ad3},
          -cpsc => q{01.14.06},
          -flags => 80 },
        { -label => q{01.14.07 - Power Lock Solenoids-Motors},
          -cpsc_obid => q{gcqnYUcaec---z0admin-ad3},
          -cpsc => q{01.14.07},
          -flags => 80 },
        { -label => q{01.14.08 - Power Lock Controls},
          -cpsc_obid => q{gcqnYUkaec---z0admin-ad3},
          -cpsc => q{01.14.08},
          -flags => 80 },
        { -label => q{01.14.09 - Keyless Entry-Computer Operated Locks},
          -cpsc_obid => q{gcqnYVhaec---z0admin-ad3},
          -cpsc => q{01.14.09},
          -flags => 80 },
        { -label => q{01.14.10 - Fuel Filler Door Latches and Mechanisms},
          -cpsc_obid => q{gcqnYWeaec---z0admin-ad3},
          -cpsc => q{01.14.10},
          -flags => 80 },
        { -label => q{01.14.11 - Power Closure Mechanisms},
          -cpsc_obid => q{hbEmKlapdcmp1z0admin-cyl},
          -cpsc => q{01.14.11},
          -flags => 80 } ] },
    { -label => q{01.15 - Reserved},
      -cpsc_obid => q{hbEmKlcpdcmp1z0admin-cyl},
      -cpsc => q{01.15.00},
      -flags => 80 },
    { -label => q{01.16 - Wipers and Washers},
      -cpsc_obid => q{gcqnYXbaec---z0admin-ad3},
      -cpsc => q{01.16.00},
      -flags => 88,
      -children => [
        { -label => q{01.16.01 - Windshield Backlite Wipers},
          -cpsc_obid => q{gcqnYXjaec---z0admin-ad3},
          -cpsc => q{01.16.01},
          -flags => 80 },
        { -label => q{01.16.02 - Linkages},
          -cpsc_obid => q{gcqnZzeaec---z0admin-ad4},
          -cpsc => q{01.16.02},
          -flags => 80 },
        { -label => q{01.16.03 - Windshield-Backlite Washers},
          -cpsc_obid => q{gcqnZAbaec---z0admin-ad4},
          -cpsc => q{01.16.03},
          -flags => 80 },
        { -label => q{01.16.04 - Headlamp-Tail Lamp Washers},
          -cpsc_obid => q{gcqnYYiaec---z0admin-ad3},
          -cpsc => q{01.16.04},
          -flags => 80 },
        { -label => q{01.16.05 - Wiper Motors},
          -cpsc_obid => q{gcqnYZfaec---z0admin-ad3},
          -cpsc => q{01.16.05},
          -flags => 80 },
        { -label => q{01.16.06 - Wiper-Washer Controls},
          -cpsc_obid => q{gcqnY0caec---z0admin-ad3},
          -cpsc => q{01.16.06},
          -flags => 80 },
        { -label => q{01.16.07 - Washer Fluid},
          -cpsc_obid => q{gcqnY0kaec---z0admin-ad3},
          -cpsc => q{01.16.07},
          -flags => 80 } ] },
    { -label => q{01.17 - Convertible Top and Roof Opg Pnl},
      -cpsc_obid => q{gcqnY1haec---z0admin-ad3},
      -cpsc => q{01.17.00},
      -flags => 88,
      -children => [
        { -label => q{01.17.01 - Convertible Top and Roof Opening Panel},
          -cpsc_obid => q{gcqnY2eaec---z0admin-ad3},
          -cpsc => q{01.17.01},
          -flags => 80 },
        { -label => q{01.17.02 - Convertible Top Mechanisms},
          -cpsc_obid => q{gcqnY3baec---z0admin-ad3},
          -cpsc => q{01.17.02},
          -flags => 80 },
        { -label => q{01.17.03 - Roof Opening Panels},
          -cpsc_obid => q{gcqnY3jaec---z0admin-ad3},
          -cpsc => q{01.17.03},
          -flags => 80 },
        { -label => q{01.17.04 - Roof Opening Panel Hinging-Removal Mechanism},
          -cpsc_obid => q{gcqnY4gaec---z0admin-ad3},
          -cpsc => q{01.17.04},
          -flags => 80 },
        { -label => q{01.17.05 - Roof Opening Panel Sliding Mechanisms},
          -cpsc_obid => q{gcqnY5daec---z0admin-ad3},
          -cpsc => q{01.17.05},
          -flags => 80 },
        { -label => q{01.17.06 - Reserved},
          -cpsc_obid => q{gcqnY6aaec---z0admin-ad3},
          -cpsc => q{01.17.06},
          -flags => 80 },
        { -label => q{01.17.07 - Electric Motor},
          -cpsc_obid => q{gcqnZAkaec---z0admin-ad4},
          -cpsc => q{01.17.07},
          -flags => 80 } ] },
    { -label => q{01.18 - Body Paint},
      -cpsc_obid => q{gcqnZBhaec---z0admin-ad4},
      -cpsc => q{01.18.00},
      -flags => 88,
      -children => [
        { -label => q{01.18.01 - Body Paint},
          -cpsc_obid => q{gcqnZCeaec---z0admin-ad4},
          -cpsc => q{01.18.01},
          -flags => 80 },
        { -label => q{01.18.02 - Body Corrosion Protection},
          -cpsc_obid => q{hbEmKpapdcmp1z0admin-cyl},
          -cpsc => q{01.18.02},
          -flags => 80 },
        { -label => q{01.18.03 - Body Stripes Paint and Tape and Vinyl Films},
          -cpsc_obid => q{gcqnZDjaec---z0admin-ad4},
          -cpsc => q{01.18.03},
          -flags => 80 } ] },
    { -label => q{01.19 - Bumpers},
      -cpsc_obid => q{gcqnZEgaec---z0admin-ad4},
      -cpsc => q{01.19.00},
      -flags => 88,
      -children => [
        { -label => q{01.19.01 - Front Bumper},
          -cpsc_obid => q{gcqnZFdaec---z0admin-ad4},
          -cpsc => q{01.19.01},
          -chunk_obid => q{giEeanapdcmp1z0admin-bab},
          -chunk => q{011901},
          -flags => 88,
          -children => [
            { -label => q{*** See 01.08.01 - Radiator Grille and Headlamp Bezels},
              -flags => 80 },
            { -label => q{FRBPBM - Front Bumper Beam},
              -chunk_obid => q{giEkSSdpdcmp1z0admin-bae},
              -chunk => q{FRBPBM},
              -flags => 80 },
            { -label => q{FRCRCN - Front Crush Can},
              -chunk_obid => q{giEkgFfpdcmp1z0admin-bac},
              -chunk => q{FRCRCN},
              -flags => 80 },
            { -label => q{FRFASC - Front Fascia},
              -chunk_obid => q{giEkgEhpdcmp1z0admin-bac},
              -chunk => q{FRFASC},
              -flags => 80 },
            { -label => q{HDLMP - Head Lamp Assembly},
              -chunk_obid => q{giEkSTgpdcmp1z0admin-bae},
              -chunk => q{HDLMP},
              -flags => 88,
              -children => [
                { -label => q{HLBULB - Head Lamp Bulb},
                  -chunk_obid => q{giEkgHdpdcmp1z0admin-bac},
                  -chunk => q{HLBULB},
                  -flags => 80 },
                { -label => q{HLLENS - Head Lamp Lens},
                  -chunk_obid => q{giEkgGhpdcmp1z0admin-bac},
                  -chunk => q{HLLENS},
                  -flags => 80 },
                { -label => q{HLRFLC - Head lamp Reflector and Bezel},
                  -chunk_obid => q{giEkSUipdcmp1z0admin-bae},
                  -chunk => q{HLRFLC},
                  -flags => 88,
                  -children => [
                    { -label => q{HLCONN - Head lamp Connector},
                      -chunk_obid => q{giEeaqcpdcmp1z0admin-bab},
                      -chunk => q{HLCONN},
                      -flags => 80 },
                    { -label => q{HLHSNG - Head lamp Housing},
                      -chunk_obid => q{giEkgIfpdcmp1z0admin-bac},
                      -chunk => q{HLHSNG},
                      -flags => 80 } ] },
                { -label => q{HLSHLD - Head lamp Shield},
                  -chunk_obid => q{giEearcpdcmp1z0admin-bab},
                  -chunk => q{HLSHLD},
                  -flags => 80 } ] } ] },
        { -label => q{01.19.02 - Rear Bumper},
          -cpsc_obid => q{gcqnZGaaec---z0admin-ad4},
          -cpsc => q{01.19.02},
          -chunk_obid => q{giEkgJfpdcmp1z0admin-bac},
          -chunk => q{011902},
          -flags => 88,
          -children => [
            { -label => q{RRBPBM - Rear Bumper Beam},
              -chunk_obid => q{giEkgKgpdcmp1z0admin-bac},
              -chunk => q{RRBPBM},
              -flags => 80 },
            { -label => q{RRCRCN - Rear Crush Can},
              -chunk_obid => q{giEeascpdcmp1z0admin-bab},
              -chunk => q{RRCRCN},
              -flags => 80 },
            { -label => q{RRFASC - Rear Fascia},
              -chunk_obid => q{giEkSWhpdcmp1z0admin-bae},
              -chunk => q{RRFASC},
              -flags => 80 },
            { -label => q{TLLMP - Tail Lamp Assembly},
              -chunk_obid => q{giEkSXjpdcmp1z0admin-bae},
              -chunk => q{TLLMP},
              -flags => 88,
              -children => [
                { -label => q{TLBULB - Tail Lamp Bulb},
                  -chunk_obid => q{giEkgMhpdcmp1z0admin-bac},
                  -chunk => q{TLBULB},
                  -flags => 80 },
                { -label => q{TLLENS - Tail Lamp Lens},
                  -chunk_obid => q{giEkgLipdcmp1z0admin-bac},
                  -chunk => q{TLLENS},
                  -flags => 80 },
                { -label => q{TLRFLC - Tail Lamp Reflector and Bezel},
                  -chunk_obid => q{giEkSZapdcmp1z0admin-bae},
                  -chunk => q{TLRFLC},
                  -flags => 88,
                  -children => [
                    { -label => q{TLCTR - Tail Lamp Connector},
                      -chunk_obid => q{giEkSZhpdcmp1z0admin-bae},
                      -chunk => q{TLCTR},
                      -flags => 80 },
                    { -label => q{TLHSNG - Tail Lamp Housing},
                      -chunk_obid => q{giEeatjpdcmp1z0admin-bab},
                      -chunk => q{TLHSNG},
                      -flags => 80 } ] },
                { -label => q{TLSHLD - Tail Lamp Shield},
                  -chunk_obid => q{giEeaufpdcmp1z0admin-bab},
                  -chunk => q{TLSHLD},
                  -flags => 80 } ] } ] },
        { -label => q{01.19.03 - Energy Absorber-Bumper Isolation Units},
          -cpsc_obid => q{gcqnZGiaec---z0admin-ad4},
          -cpsc => q{01.19.03},
          -flags => 80 },
        { -label => q{01.19.04 - License Plate Brackets},
          -cpsc_obid => q{gcqnZHfaec---z0admin-ad4},
          -cpsc => q{01.19.04},
          -flags => 80 } ] },
    { -label => q{01.20 - Occupant Restraining Device Subsystem},
      -cpsc_obid => q{gcqnZIcaec---z0admin-ad4},
      -cpsc => q{01.20.00},
      -chunk_obid => q{giEeaSdpdcmp1z0admin-bab},
      -chunk => q{012000},
      -flags => 88,
      -children => [
        { -label => q{01.20.01 - Seat Belts-Shoulder Harness},
          -cpsc_obid => q{gcqnZIkaec---z0admin-ad4},
          -cpsc => q{01.20.01},
          -flags => 80 },
        { -label => q{01.20.02 - Seat Belt-Shoulder Harness Switches},
          -cpsc_obid => q{gcqnY6gaec---z0admin-ad3},
          -cpsc => q{01.20.02},
          -flags => 80 },
        { -label => q{01.20.03 - Passenger Restraint Bags},
          -cpsc_obid => q{gcqnY7daec---z0admin-ad3},
          -cpsc => q{01.20.03},
          -flags => 80 },
        { -label => q{01.20.04 - Miscellaneous Passive Restraint Systems},
          -cpsc_obid => q{gcqnZaaaec---z0admin-ad3},
          -cpsc => q{01.20.04},
          -flags => 80 },
        { -label => q{01.20.05 - Restraining Devices - Actuation Sensing},
          -cpsc_obid => q{gcqnZaiaec---z0admin-ad3},
          -cpsc => q{01.20.05},
          -flags => 80 },
        { -label => q{01.20.06 - Restraining Devices - Diagnostic},
          -cpsc_obid => q{gcqnZbfaec---z0admin-ad3},
          -cpsc => q{01.20.06},
          -flags => 80 },
        { -label => q{01.20.07 - Electric Motors},
          -cpsc_obid => q{gcqnZccaec---z0admin-ad3},
          -cpsc => q{01.20.07},
          -flags => 80 },
        { -label => q{ABASLY - Air Bag Module Assembly},
          -chunk_obid => q{giEeaXepdcmp1z0admin-bab},
          -chunk => q{ABASLY},
          -flags => 88,
          -children => [
            { -label => q{ABMBRK - Air Bag Module Bracket},
              -chunk_obid => q{giEkhchpdcmp1z0admin-bac},
              -chunk => q{ABMBRK},
              -flags => 80 },
            { -label => q{ABMOD - Air Bag Module},
              -chunk_obid => q{giEkhddpdcmp1z0admin-bac},
              -chunk => q{ABMOD},
              -flags => 88,
              -children => [
                { -label => q{ABCBHS - Air Bag Module Circuit Board and Heat Sink},
                  -chunk_obid => q{giEkTsapdcmp1z0admin-bae},
                  -chunk => q{ABCBHS},
                  -flags => 88,
                  -children => [
                    { -label => q{ABCBRD - Air Bag Module Circuit Board},
                      -chunk_obid => q{giEeaYfpdcmp1z0admin-bab},
                      -chunk => q{ABCBRD},
                      -flags => 88,
                      -children => [
                        { -label => q{ABECMP - Air Bag Module Electrical Components},
                          -chunk_obid => q{giEea0bpdcmp1z0admin-bab},
                          -chunk => q{ABECMP},
                          -flags => 80 },
                        { -label => q{ABMBRD - Air Bag Module Board},
                          -chunk_obid => q{giEeaZfpdcmp1z0admin-bab},
                          -chunk => q{ABMBRD},
                          -flags => 80 } ] },
                    { -label => q{ABHS - Air Bag Module Heat Sink},
                      -chunk_obid => q{giEkTtepdcmp1z0admin-bae},
                      -chunk => q{ABHS},
                      -flags => 80 } ] },
                { -label => q{ABCTR - Air Bag Module Connector},
                  -chunk_obid => q{giEkhfapdcmp1z0admin-bac},
                  -chunk => q{ABCTR},
                  -flags => 80 },
                { -label => q{ABHSG - Air Bag Module Housing},
                  -chunk_obid => q{giEea1dpdcmp1z0admin-bab},
                  -chunk => q{ABHSG},
                  -flags => 80 } ] } ] },
        { -label => q{SSABAG - Side Satellite Air Bag},
          -chunk_obid => q{giEkg7gpdcmp1z0admin-bac},
          -chunk => q{SSABAG},
          -flags => 88,
          -children => [
            { -label => q{SABCBH - Side Air Bag Circuit Board and Heat Sink},
              -chunk_obid => q{giEeaTfpdcmp1z0admin-bab},
              -chunk => q{SABCBH},
              -flags => 88,
              -children => [
                { -label => q{SABCBD - Side Air Bag Circuit Board},
                  -chunk_obid => q{giEeaUepdcmp1z0admin-bab},
                  -chunk => q{SABCBD},
                  -flags => 88,
                  -children => [
                    { -label => q{SABBRD - Side Air Bag Board},
                      -chunk_obid => q{giEkTqapdcmp1z0admin-bae},
                      -chunk => q{SABBRD},
                      -flags => 88,
                      -children => [
                        { -label => q{*** See ABCBHS - Air Bag Module Circuit Board and Heat Sink},
                          -flags => 80 } ] },
                    { -label => q{SABECM - Side Air Bag Electrical Components},
                      -chunk_obid => q{giEkhbapdcmp1z0admin-bac},
                      -chunk => q{SABECM},
                      -flags => 80 } ] },
                { -label => q{SABHS - Side Air Bag Heat Sink},
                  -chunk_obid => q{giEeaVgpdcmp1z0admin-bab},
                  -chunk => q{SABHS},
                  -flags => 80 } ] },
            { -label => q{SABCTR - Side Air Bag Connector},
              -chunk_obid => q{giEkTojpdcmp1z0admin-bae},
              -chunk => q{SABCTR},
              -flags => 80 },
            { -label => q{SABHSG - Side Air Bag Housing},
              -chunk_obid => q{giEeaWfpdcmp1z0admin-bab},
              -chunk => q{SABHSG},
              -flags => 80 } ] } ] },
    { -label => q{01.21 - Add-on Sleeper Compartment},
      -cpsc_obid => q{gcqnZckaec---z0admin-ad3},
      -cpsc => q{01.21.00},
      -flags => 88,
      -children => [
        { -label => q{01.21.01 - Sleeper Compartment},
          -cpsc_obid => q{gcqnZdhaec---z0admin-ad3},
          -cpsc => q{01.21.01},
          -flags => 80 } ] },
    { -label => q{01.22 - Spare Tire Mounting Body},
      -cpsc_obid => q{gcqnZeeaec---z0admin-ad3},
      -cpsc => q{01.22.00},
      -flags => 88,
      -children => [
        { -label => q{01.22.01 - Spare Wheel Retainer},
          -cpsc_obid => q{gcqnZJhaec---z0admin-ad4},
          -cpsc => q{01.22.01},
          -flags => 80 },
        { -label => q{01.22.02 - Spare Wheel Exterior Mounting},
          -cpsc_obid => q{gcqnZKeaec---z0admin-ad4},
          -cpsc => q{01.22.02},
          -flags => 80 } ] } ] },

{ -label => q{02 - Frame and Mounting System},
  -cpsc_obid => q{gcqnZLbaec---z0admin-ad4},
  -cpsc => q{02.00.00},
  -flags => 88,
  -children => [
    { -label => q{02.01 - Frame},
      -cpsc_obid => q{gcqnZLdaec---z0admin-ad4},
      -cpsc => q{02.01.00},
      -flags => 88,
      -children => [
        { -label => q{02.01.01 - Frame Assembly},
          -cpsc_obid => q{gcqnZMaaec---z0admin-ad4},
          -cpsc => q{02.01.01},
          -flags => 80 },
        { -label => q{02.01.02 - Special Protective Structures},
          -cpsc_obid => q{gcqnZMiaec---z0admin-ad4},
          -cpsc => q{02.01.02},
          -flags => 80 },
        { -label => q{02.01.03 - Frame Corrosion Protection},
          -cpsc_obid => q{gcqnZNfaec---z0admin-ad4},
          -cpsc => q{02.01.03},
          -flags => 80 } ] },
    { -label => q{02.02 - Body Mounting},
      -cpsc_obid => q{gcqnZOcaec---z0admin-ad4},
      -cpsc => q{02.02.00},
      -flags => 88,
      -children => [
        { -label => q{02.02.01 - Body Isolation},
          -cpsc_obid => q{gcqnZOkaec---z0admin-ad4},
          -cpsc => q{02.02.01},
          -flags => 80 },
        { -label => q{02.02.02 - Cab Tilting Mechanisms},
          -cpsc_obid => q{gcqnZPhaec---z0admin-ad4},
          -cpsc => q{02.02.02},
          -flags => 80 },
        { -label => q{02.02.03 - Second Unit Body Tilting Mechanisms},
          -cpsc_obid => q{gcqnZQeaec---z0admin-ad4},
          -cpsc => q{02.02.03},
          -flags => 80 },
        { -label => q{02.02.04 - Cab Suspension Leveling Mechanism},
          -cpsc_obid => q{gcqnZRbaec---z0admin-ad4},
          -cpsc => q{02.02.04},
          -flags => 80 } ] },
    { -label => q{02.03 - Engine/Transmission Mounting},
      -cpsc_obid => q{gcqnZRjaec---z0admin-ad4},
      -cpsc => q{02.03.00},
      -flags => 88,
      -children => [
        { -label => q{02.03.01 - Engine Mounts},
          -cpsc_obid => q{gcqnZSgaec---z0admin-ad4},
          -cpsc => q{02.03.01},
          -flags => 80 },
        { -label => q{02.03.02 - Transmission-Transaxle Mounts or Crossmembers},
          -cpsc_obid => q{gcuad3eaec---z0admin-aeU},
          -cpsc => q{02.03.02},
          -flags => 80 },
        { -label => q{02.03.03 - Roll Restrictors},
          -cpsc_obid => q{gcqnZTfaec---z0admin-ad4},
          -cpsc => q{02.03.03},
          -flags => 80 },
        { -label => q{02.03.04 - Engine Motion Dampers},
          -cpsc_obid => q{gcqnZUcaec---z0admin-ad4},
          -cpsc => q{02.03.04},
          -flags => 80 } ] },
    { -label => q{02.04 - Towing and Coupling Attachments Subsystem},
      -cpsc_obid => q{gcqnZUkaec---z0admin-ad4},
      -cpsc => q{02.04.00},
      -flags => 88,
      -children => [
        { -label => q{02.04.01 - Towing Provisions},
          -cpsc_obid => q{gcqnZVhaec---z0admin-ad4},
          -cpsc => q{02.04.01},
          -flags => 80 },
        { -label => q{02.04.02 - Trailer Coupling Attachments},
          -cpsc_obid => q{gcqnZWeaec---z0admin-ad4},
          -cpsc => q{02.04.02},
          -flags => 80 } ] },
    { -label => q{02.05 - Spare Tire Mounting Chassis},
      -cpsc_obid => q{gcqnZXbaec---z0admin-ad4},
      -cpsc => q{02.05.00},
      -flags => 88,
      -children => [
        { -label => q{02.05.01 - Spare Wheel Frame Mounting},
          -cpsc_obid => q{gcqnZXjaec---z0admin-ad4},
          -cpsc => q{02.05.01},
          -flags => 80 } ] },
    { -label => q{02.06 - Splash and Heat Shields},
      -cpsc_obid => q{gcqnZYgaec---z0admin-ad4},
      -cpsc => q{02.06.00},
      -flags => 88,
      -children => [
        { -label => q{02.06.01 - Splash Deflectors and Shields},
          -cpsc_obid => q{gcqnZZdaec---z0admin-ad4},
          -cpsc => q{02.06.01},
          -flags => 80 },
        { -label => q{02.06.02 - Heat Deflectors and Shields},
          -cpsc_obid => q{gcqnZ0aaec---z0admin-ad4},
          -cpsc => q{02.06.02},
          -flags => 80 } ] },
    { -label => q{02.07 - Sound Control},
      -cpsc_obid => q{gcqnZ0iaec---z0admin-ad4},
      -cpsc => q{02.07.00},
      -flags => 88,
      -children => [
        { -label => q{02.07.01 - Noise Shields},
          -cpsc_obid => q{gcqnZfbaec---z0admin-ad3},
          -cpsc => q{02.07.01},
          -flags => 80 } ] } ] },

{ -label => q{03 - Engine System},
  -cpsc_obid => q{gcqnZfjaec---z0admin-ad3},
  -cpsc => q{03.00.00},
  -chunk_obid => q{giElbIepdcmp1z0admin-baf},
  -chunk => q{030000},
  -flags => 88,
  -children => [
    { -label => q{03.01 - Basic Engine Structure},
      -cpsc_obid => q{gcqnZ4eaec---z0admin-ad4},
      -cpsc => q{03.01.00},
      -chunk_obid => q{giEkTFapdcmp1z0admin-bae},
      -chunk => q{030100},
      -flags => 88,
      -children => [
        { -label => q{03.01.01 - Cylinder Block},
          -cpsc_obid => q{gcqnZljaec---z0admin-ad3},
          -cpsc => q{03.01.01},
          -chunk_obid => q{giEkTFkpdcmp1z0admin-bae},
          -chunk => q{030101},
          -flags => 80 },
        { -label => q{03.01.02 - Cylinder Heads},
          -cpsc_obid => q{gcqnZ5daec---z0admin-ad4},
          -cpsc => q{03.01.02},
          -chunk_obid => q{giElbJgpdcmp1z0admin-baf},
          -chunk => q{030102},
          -flags => 80 },
        { -label => q{03.01.03 - Intake Manifold},
          -cpsc_obid => q{gcqnZ6aaec---z0admin-ad4},
          -cpsc => q{03.01.03},
          -chunk_obid => q{giEkhrapdcmp1z0admin-bac},
          -chunk => q{030103},
          -flags => 80 },
        { -label => q{03.01.04 - Exhaust Manifold},
          -cpsc_obid => q{gcqnZ6iaec---z0admin-ad4},
          -cpsc => q{03.01.04},
          -chunk_obid => q{giEkhrhpdcmp1z0admin-bac},
          -chunk => q{030104},
          -flags => 80 },
        { -label => q{03.01.05 - Flywheel Housing Adaptor},
          -cpsc_obid => q{gcqnZmeaec---z0admin-ad3},
          -cpsc => q{03.01.05},
          -chunk_obid => q{giEkTHgpdcmp1z0admin-bae},
          -chunk => q{030105},
          -flags => 80 },
        { -label => q{03.01.06 - Engine Lifting Eyes},
          -cpsc_obid => q{gcqnZnbaec---z0admin-ad3},
          -cpsc => q{03.01.06},
          -chunk_obid => q{giElbKkpdcmp1z0admin-baf},
          -chunk => q{030106},
          -flags => 80 } ] },
    { -label => q{03.02 - Engine Lubrication},
      -cpsc_obid => q{gcqnZnjaec---z0admin-ad3},
      -cpsc => q{03.02.00},
      -chunk_obid => q{giEkhsjpdcmp1z0admin-bac},
      -chunk => q{030200},
      -flags => 88,
      -children => [
        { -label => q{03.02.01 - Oil Pump and Screen},
          -cpsc_obid => q{gcqnZ7faec---z0admin-ad4},
          -cpsc => q{03.02.01},
          -chunk_obid => q{giEkTIipdcmp1z0admin-bae},
          -chunk => q{030201},
          -flags => 80 },
        { -label => q{03.02.02 - Oil Filter Dip Stick and Filler},
          -cpsc_obid => q{gcqnZogaec---z0admin-ad3},
          -cpsc => q{03.02.02},
          -chunk_obid => q{giElbMbpdcmp1z0admin-baf},
          -chunk => q{030202},
          -flags => 80 },
        { -label => q{03.02.03 - Oil Pan and Reservoirs},
          -cpsc_obid => q{gcqnZpdaec---z0admin-ad3},
          -cpsc => q{03.02.03},
          -chunk_obid => q{giEkTJipdcmp1z0admin-bae},
          -chunk => q{030203},
          -flags => 80 },
        { -label => q{03.02.04 - Engine Oil Cooler},
          -cpsc_obid => q{gcqnZqaaec---z0admin-ad3},
          -cpsc => q{03.02.04},
          -chunk_obid => q{giEkhucpdcmp1z0admin-bac},
          -chunk => q{030204},
          -flags => 80 },
        { -label => q{03.02.05 - Oil Distribution},
          -cpsc_obid => q{gcqn0acaec---z0admin-ad4},
          -cpsc => q{03.02.05},
          -chunk_obid => q{giEkhujpdcmp1z0admin-bac},
          -chunk => q{030205},
          -flags => 80 },
        { -label => q{03.02.06 - Engine Lubricant},
          -cpsc_obid => q{gcqn0akaec---z0admin-ad4},
          -cpsc => q{03.02.06},
          -chunk_obid => q{giEkhvfpdcmp1z0admin-bac},
          -chunk => q{030206},
          -flags => 80 } ] },
    { -label => q{03.03 - Engine Cooling},
      -cpsc_obid => q{gcqn0bhaec---z0admin-ad4},
      -cpsc => q{03.03.00},
      -chunk_obid => q{giElb3jpdcmp1z0admin-bag},
      -chunk => q{030300},
      -flags => 88,
      -children => [
        { -label => q{03.03.01 - Radiator and Cap},
          -cpsc_obid => q{gcqn0ceaec---z0admin-ad4},
          -cpsc => q{03.03.01},
          -flags => 80 },
        { -label => q{03.03.02 - Radiator Mounting-Retention},
          -cpsc_obid => q{gcqn0dbaec---z0admin-ad4},
          -cpsc => q{03.03.02},
          -flags => 88,
          -children => [
            { -label => q{*** See 03.03.01 - Radiator and Cap},
              -flags => 80 } ] },
        { -label => q{03.03.03 - Radiator Shutters},
          -cpsc_obid => q{gcqn0diaec---z0admin-ad4},
          -cpsc => q{03.03.03},
          -flags => 80 },
        { -label => q{03.03.04 - Hoses and Reservoirs},
          -cpsc_obid => q{gcqn0efaec---z0admin-ad4},
          -cpsc => q{03.03.04},
          -flags => 80 },
        { -label => q{03.03.05 - Coolant Pump and Flow Control},
          -cpsc_obid => q{gcqn0fcaec---z0admin-ad4},
          -cpsc => q{03.03.05},
          -flags => 80 },
        { -label => q{03.03.06 - Fan Fan Clutches and Shrouds},
          -cpsc_obid => q{gcqn0fkaec---z0admin-ad4},
          -cpsc => q{03.03.06},
          -flags => 80 },
        { -label => q{03.03.07 - Engine Coolant},
          -cpsc_obid => q{gcqn0ghaec---z0admin-ad4},
          -cpsc => q{03.03.07},
          -flags => 80 },
        { -label => q{03.03.08 - Fan Drive - Electric Motor},
          -cpsc_obid => q{gcqn0heaec---z0admin-ad4},
          -cpsc => q{03.03.08},
          -flags => 80 },
        { -label => q{03.03.09 - Fan Drive - Relay},
          -cpsc_obid => q{gcqn0ibaec---z0admin-ad4},
          -cpsc => q{03.03.09},
          -flags => 80 },
        { -label => q{03.03.10 - Fan Controls},
          -cpsc_obid => q{gcqn0ijaec---z0admin-ad4},
          -cpsc => q{03.03.10},
          -flags => 80 },
        { -label => q{03.03.11 - Engine Coolant Heating Element},
          -cpsc_obid => q{gcqn0jgaec---z0admin-ad4},
          -cpsc => q{03.03.11},
          -flags => 80 },
        { -label => q{03.03.12 - Fan Drive - Hydraulic},
          -cpsc_obid => q{gcqn0kdaec---z0admin-ad4},
          -cpsc => q{03.03.12},
          -flags => 80 },
        { -label => q{FSMTR - Fan/Shroud/Motor},
          -chunk_obid => q{giElcrgpdcmp1z0admin-baf},
          -chunk => q{FSMTR},
          -flags => 80 },
        { -label => q{INCOOL - Inter Coolers},
          -chunk_obid => q{giElb4ipdcmp1z0admin-bag},
          -chunk => q{INCOOL},
          -flags => 80 },
        { -label => q{RDTR - Radiator},
          -chunk_obid => q{giEnGybpdcmp1z0admin-bak},
          -chunk => q{RDTR},
          -flags => 88,
          -children => [
            { -label => q{TOCLR - Trans Oil Cooler},
              -chunk_obid => q{giElcsfpdcmp1z0admin-baf},
              -chunk => q{TOCLR},
              -flags => 80 } ] } ] },
    { -label => q{03.04 - Fuel Charging and Controls},
      -cpsc_obid => q{gcqn0laaec---z0admin-ad4},
      -cpsc => q{03.04.00},
      -chunk_obid => q{giEkhwbpdcmp1z0admin-bac},
      -chunk => q{030400},
      -flags => 88,
      -children => [
        { -label => q{03.04.01 - Carburetion},
          -cpsc_obid => q{gcqn0liaec---z0admin-ad4},
          -cpsc => q{03.04.01},
          -chunk_obid => q{giEkTLfpdcmp1z0admin-bae},
          -chunk => q{030401},
          -flags => 80 },
        { -label => q{03.04.02 - Fuel Injection-Mechanical Components},
          -cpsc_obid => q{gcqn0mfaec---z0admin-ad4},
          -cpsc => q{03.04.02},
          -chunk_obid => q{giElbOepdcmp1z0admin-baf},
          -chunk => q{030402},
          -flags => 80 },
        { -label => q{03.04.03 - Fuel Injection-Electrical Components},
          -cpsc_obid => q{gcqn0ncaec---z0admin-ad4},
          -cpsc => q{03.04.03},
          -chunk_obid => q{giEkTMbpdcmp1z0admin-bae},
          -chunk => q{030403},
          -flags => 80 },
        { -label => q{03.04.04 - Fuel Lines and Filters Engine},
          -cpsc_obid => q{gcqn0nkaec---z0admin-ad4},
          -cpsc => q{03.04.04},
          -chunk_obid => q{giEkhxjpdcmp1z0admin-bac},
          -chunk => q{030404},
          -flags => 80 },
        { -label => q{03.04.05 - Engine Governors-Mechanical},
          -cpsc_obid => q{gcqn0ohaec---z0admin-ad4},
          -cpsc => q{03.04.05},
          -chunk_obid => q{giEkTNbpdcmp1z0admin-bae},
          -chunk => q{030405},
          -flags => 80 },
        { -label => q{03.04.06 - Engine Governors-Electrical},
          -cpsc_obid => q{gcqn0peaec---z0admin-ad4},
          -cpsc => q{03.04.06},
          -chunk_obid => q{giEkhyfpdcmp1z0admin-bac},
          -chunk => q{030406},
          -flags => 80 },
        { -label => q{03.04.07 - Turbocharger-Supercharger},
          -cpsc_obid => q{gcqnZraaec---z0admin-ad3},
          -cpsc => q{03.04.07},
          -chunk_obid => q{giEkTOcpdcmp1z0admin-bae},
          -chunk => q{030407},
          -flags => 80 },
        { -label => q{03.04.08 - Mechanical Fuel Pumps},
          -cpsc_obid => q{gcqnZriaec---z0admin-ad3},
          -cpsc => q{03.04.08},
          -chunk_obid => q{giElbCapdcmp1z0admin-bag},
          -chunk => q{030408},
          -flags => 80 },
        { -label => q{03.04.09 - Vehicle Deceleration Fuel Shut-Off},
          -cpsc_obid => q{gcqnZsfaec---z0admin-ad3},
          -cpsc => q{03.04.09},
          -chunk_obid => q{giEkhzipdcmp1z0admin-bac},
          -chunk => q{030409},
          -flags => 80 },
        { -label => q{03.04.10 - Carburetor Cooling Fans},
          -cpsc_obid => q{gcqnZtcaec---z0admin-ad3},
          -cpsc => q{03.04.10},
          -chunk_obid => q{giElbQjpdcmp1z0admin-baf},
          -chunk => q{030410},
          -flags => 80 },
        { -label => q{03.04.11 - Automatic Choke},
          -cpsc_obid => q{hbEo6Bapdcmp1z0admin-cyn},
          -cpsc => q{03.04.11},
          -flags => 80 } ] },
    { -label => q{03.05 - Accessory Drive},
      -cpsc_obid => q{gcqnZtkaec---z0admin-ad3},
      -cpsc => q{03.05.00},
      -chunk_obid => q{giElbDcpdcmp1z0admin-bag},
      -chunk => q{030500},
      -flags => 88,
      -children => [
        { -label => q{03.05.01 - Air Conditioning Drive},
          -cpsc_obid => q{gcqnZuhaec---z0admin-ad3},
          -cpsc => q{03.05.01},
          -chunk_obid => q{giElbEbpdcmp1z0admin-bag},
          -chunk => q{030501},
          -flags => 80 },
        { -label => q{03.05.02 - Coolant Circulation Drive},
          -cpsc_obid => q{gcqnZveaec---z0admin-ad3},
          -cpsc => q{03.05.02},
          -chunk_obid => q{giElbSapdcmp1z0admin-baf},
          -chunk => q{030502},
          -flags => 80 },
        { -label => q{03.05.03 - Power Steering Drive},
          -cpsc_obid => q{gcqnZwbaec---z0admin-ad3},
          -cpsc => q{03.05.03},
          -chunk_obid => q{giEkhBcpdcmp1z0admin-bac},
          -chunk => q{030503},
          -flags => 80 },
        { -label => q{03.05.04 - Alternator-Generator Drive},
          -cpsc_obid => q{gcqnZwjaec---z0admin-ad3},
          -cpsc => q{03.05.04},
          -chunk_obid => q{giEkgGkpdcmp1z0admin-bad},
          -chunk => q{030504},
          -flags => 80 },
        { -label => q{03.05.05 - Air Pump-Compressor-Vacuum Generator Drive},
          -cpsc_obid => q{gcqnZxgaec---z0admin-ad3},
          -cpsc => q{03.05.05},
          -chunk_obid => q{giEmojepdcmp1z0admin-bai},
          -chunk => q{030505},
          -flags => 80 },
        { -label => q{03.05.06 - Accessory Drive Speed Control},
          -cpsc_obid => q{gcqnZydaec---z0admin-ad3},
          -cpsc => q{03.05.06},
          -chunk_obid => q{giEmn1dpdcmp1z0admin-bah},
          -chunk => q{030506},
          -flags => 80 },
        { -label => q{03.05.07 - Drive Belts},
          -cpsc_obid => q{gcqnZzaaec---z0admin-ad3},
          -cpsc => q{03.05.07},
          -chunk_obid => q{giEmn2dpdcmp1z0admin-bah},
          -chunk => q{030507},
          -flags => 80 },
        { -label => q{03.05.08 - Crankshaft Drive Pulleys},
          -cpsc_obid => q{gcqnZziaec---z0admin-ad3},
          -cpsc => q{03.05.08},
          -chunk_obid => q{giEmn2kpdcmp1z0admin-bah},
          -chunk => q{030508},
          -flags => 80 },
        { -label => q{03.05.09 - Other Accessory Drive Pulleys},
          -cpsc_obid => q{gcqnZAfaec---z0admin-ad3},
          -cpsc => q{03.05.09},
          -chunk_obid => q{giEkgIbpdcmp1z0admin-bad},
          -chunk => q{030509},
          -flags => 80 } ] },
    { -label => q{03.06 - Engine Cranking},
      -cpsc_obid => q{gcqn0pkaec---z0admin-ad4},
      -cpsc => q{03.06.00},
      -chunk_obid => q{giEkgJapdcmp1z0admin-bad},
      -chunk => q{030600},
      -flags => 88,
      -children => [
        { -label => q{03.06.01 - Starter Ring Gear Manual Trans.},
          -cpsc_obid => q{gcqn0qhaec---z0admin-ad4},
          -cpsc => q{03.06.01},
          -chunk_obid => q{giEmn4epdcmp1z0admin-bah},
          -chunk => q{030601},
          -flags => 80 },
        { -label => q{03.06.02 - Starter Ring Gear - Auto. Trans.},
          -cpsc_obid => q{gcqn0reaec---z0admin-ad4},
          -cpsc => q{03.06.02},
          -chunk_obid => q{giEkgKapdcmp1z0admin-bad},
          -chunk => q{030602},
          -flags => 80 },
        { -label => q{03.06.03 - Starter and Integral Solenoid},
          -cpsc_obid => q{gcqn0sbaec---z0admin-ad4},
          -cpsc => q{03.06.03},
          -chunk_obid => q{giEmn5cpdcmp1z0admin-bah},
          -chunk => q{030603},
          -flags => 80 },
        { -label => q{03.06.04 - Starter Relay and Switches},
          -cpsc_obid => q{gcqn0sjaec---z0admin-ad4},
          -cpsc => q{03.06.04},
          -chunk_obid => q{giEmoljpdcmp1z0admin-bai},
          -chunk => q{030604},
          -flags => 80 },
        { -label => q{03.06.05 - Starting Aids},
          -cpsc_obid => q{gcqn0tgaec---z0admin-ad4},
          -cpsc => q{03.06.05},
          -chunk_obid => q{giEkgLcpdcmp1z0admin-bad},
          -chunk => q{030605},
          -flags => 80 } ] },
    { -label => q{03.07 - Engine Ignition},
      -cpsc_obid => q{gcqn0udaec---z0admin-ad4},
      -cpsc => q{03.07.00},
      -chunk_obid => q{giEmn6epdcmp1z0admin-bah},
      -chunk => q{030700},
      -flags => 88,
      -children => [
        { -label => q{03.07.01 - Distributor-Synchronizer},
          -cpsc_obid => q{gcqnZBcaec---z0admin-ad3},
          -cpsc => q{03.07.01},
          -chunk_obid => q{giEkgMcpdcmp1z0admin-bad},
          -chunk => q{030701},
          -flags => 80 },
        { -label => q{03.07.02 - Ignition Coil},
          -cpsc_obid => q{gcqnZBkaec---z0admin-ad3},
          -cpsc => q{03.07.02},
          -chunk_obid => q{giEmn7apdcmp1z0admin-bah},
          -chunk => q{030702},
          -flags => 80 },
        { -label => q{03.07.03 - Sparks Plugs},
          -cpsc_obid => q{gcqnZChaec---z0admin-ad3},
          -cpsc => q{03.07.03},
          -chunk_obid => q{giEmonipdcmp1z0admin-bai},
          -chunk => q{030703},
          -flags => 80 },
        { -label => q{03.07.04 - Ignition Wiring},
          -cpsc_obid => q{gcqnZDeaec---z0admin-ad3},
          -cpsc => q{03.07.04},
          -chunk_obid => q{giEkgNepdcmp1z0admin-bad},
          -chunk => q{030704},
          -flags => 80 },
        { -label => q{03.07.05 - Electronic Ignition},
          -cpsc_obid => q{gcqnZEbaec---z0admin-ad3},
          -cpsc => q{03.07.05},
          -chunk_obid => q{giEmoacpdcmp1z0admin-bah},
          -chunk => q{030705},
          -flags => 80 },
        { -label => q{03.07.06 - Crankshaft Position Sensors},
          -cpsc_obid => q{gcqnZEjaec---z0admin-ad3},
          -cpsc => q{03.07.06},
          -chunk_obid => q{giEkgOgpdcmp1z0admin-bad},
          -chunk => q{030706},
          -flags => 80 },
        { -label => q{03.07.07 - Camshaft Position Sensors},
          -cpsc_obid => q{gcqnZFgaec---z0admin-ad3},
          -cpsc => q{03.07.07},
          -chunk_obid => q{giEmopapdcmp1z0admin-bai},
          -chunk => q{030707},
          -flags => 80 },
        { -label => q{03.07.08 - Misfire Detection Sensors},
          -cpsc_obid => q{gcqnZGdaec---z0admin-ad3},
          -cpsc => q{03.07.08},
          -chunk_obid => q{giEmobepdcmp1z0admin-bah},
          -chunk => q{030708},
          -flags => 80 },
        { -label => q{03.07.09 - Diesel Glow Plugs - Glow Plug Modules},
          -cpsc_obid => q{gcqnZHaaec---z0admin-ad3},
          -cpsc => q{03.07.09},
          -chunk_obid => q{giEkgPipdcmp1z0admin-bad},
          -chunk => q{030709},
          -flags => 80 } ] },
    { -label => q{03.08 - Engine Emission Control},
      -cpsc_obid => q{gcqnZHiaec---z0admin-ad3},
      -cpsc => q{03.08.00},
      -chunk_obid => q{giEmoqcpdcmp1z0admin-bai},
      -chunk => q{030800},
      -flags => 88,
      -children => [
        { -label => q{03.08.01 - Engine Ventilation},
          -cpsc_obid => q{gcqnZIfaec---z0admin-ad3},
          -cpsc => q{03.08.01},
          -chunk_obid => q{giEmocgpdcmp1z0admin-bah},
          -chunk => q{030801},
          -flags => 80 },
        { -label => q{03.08.02 - Secondary Air Emission Control},
          -cpsc_obid => q{gcqn7Bfaec---z0admin-ad5},
          -cpsc => q{03.08.02},
          -chunk_obid => q{giEkgQkpdcmp1z0admin-bad},
          -chunk => q{030802},
          -flags => 80 },
        { -label => q{03.08.03 - Emission Control-Distributor Mech.},
          -cpsc_obid => q{gcqn7Cdaec---z0admin-ad5},
          -cpsc => q{03.08.03},
          -chunk_obid => q{giEkgRjpdcmp1z0admin-bad},
          -chunk => q{030803},
          -flags => 80 },
        { -label => q{03.08.04 - Exhaust Gas Recirculation},
          -cpsc_obid => q{gcqn7Daaec---z0admin-ad5},
          -cpsc => q{03.08.04},
          -chunk_obid => q{giEkgSipdcmp1z0admin-bad},
          -chunk => q{030804},
          -flags => 80 },
        { -label => q{03.08.05 - Deceleration Valve},
          -cpsc_obid => q{gcqn7Diaec---z0admin-ad5},
          -cpsc => q{03.08.05},
          -chunk_obid => q{giEmorhpdcmp1z0admin-bai},
          -chunk => q{030805},
          -flags => 80 },
        { -label => q{03.08.06 - Catalytic Converter-Internal Components},
          -cpsc_obid => q{gcqn7Tdaec---z0admin-ad6},
          -cpsc => q{03.08.06},
          -chunk_obid => q{giEmoedpdcmp1z0admin-bah},
          -chunk => q{030806},
          -flags => 80 },
        { -label => q{03.08.07 - Particulate Trap-Internal Components},
          -cpsc_obid => q{gcqn7Ubaec---z0admin-ad6},
          -cpsc => q{03.08.07},
          -chunk_obid => q{giEkgTkpdcmp1z0admin-bad},
          -chunk => q{030807},
          -flags => 80 },
        { -label => q{03.08.08 - Reserved 03.08.08 - 03.08.49},
          -cpsc_obid => q{hbEo6Jkpdcmp1z0admin-cyo},
          -cpsc => q{03.08.08},
          -flags => 80 },
        { -label => q{03.08.50 - Engine Emission Control - Gasoline},
          -cpsc_obid => q{gcuaebcaec---z0admin-aeU},
          -cpsc => q{03.08.50},
          -chunk_obid => q{giEmosgpdcmp1z0admin-bai},
          -chunk => q{030850},
          -flags => 80 },
        { -label => q{03.08.51 - Engine Emission Control - Diesel},
          -cpsc_obid => q{gctxPXdaec---z0admin-aeT},
          -cpsc => q{03.08.51},
          -chunk_obid => q{giEkgUkpdcmp1z0admin-bad},
          -chunk => q{030851},
          -flags => 80 },
        { -label => q{03.08.52 - Engine Emission Control - Alternative Fuels},
          -cpsc_obid => q{gctxPYbaec---z0admin-aeT},
          -cpsc => q{03.08.52},
          -chunk_obid => q{giEmotfpdcmp1z0admin-bai},
          -chunk => q{030852},
          -flags => 80 },
        { -label => q{03.08.53 - Engine Emission Control - Fuel Specifications},
          -cpsc_obid => q{gctxPYkaec---z0admin-aeT},
          -cpsc => q{03.08.53},
          -chunk_obid => q{giEmouepdcmp1z0admin-bai},
          -chunk => q{030853},
          -flags => 80 } ] },
    { -label => q{03.09 - Valve Train},
      -cpsc_obid => q{gcqn7Vgaec---z0admin-ad6},
      -cpsc => q{03.09.00},
      -chunk_obid => q{giEmogepdcmp1z0admin-bah},
      -chunk => q{030900},
      -flags => 88,
      -children => [
        { -label => q{03.09.01 - Camshaft and Drive},
          -cpsc_obid => q{gcqn7Wdaec---z0admin-ad6},
          -cpsc => q{03.09.01},
          -chunk_obid => q{giEmohapdcmp1z0admin-bah},
          -chunk => q{030901},
          -flags => 80 },
        { -label => q{03.09.02 - Valve Actuation-Mech.},
          -cpsc_obid => q{gcqn7Xaaec---z0admin-ad6},
          -cpsc => q{03.09.02},
          -chunk_obid => q{giEmovgpdcmp1z0admin-bai},
          -chunk => q{030902},
          -flags => 80 },
        { -label => q{03.09.03 - Valve Actuation-Electrical},
          -cpsc_obid => q{gcqn7Xiaec---z0admin-ad6},
          -cpsc => q{03.09.03},
          -chunk_obid => q{giEkgWgpdcmp1z0admin-bad},
          -chunk => q{030903},
          -flags => 80 },
        { -label => q{03.09.04 - Valves},
          -cpsc_obid => q{gcqn7Yfaec---z0admin-ad6},
          -cpsc => q{03.09.04},
          -chunk_obid => q{giEmoicpdcmp1z0admin-bah},
          -chunk => q{030904},
          -flags => 80 },
        { -label => q{03.09.05 - Valve Train Accessory Drive},
          -cpsc_obid => q{gcqn7Zcaec---z0admin-ad6},
          -cpsc => q{03.09.05},
          -chunk_obid => q{giEmowipdcmp1z0admin-bai},
          -chunk => q{030905},
          -flags => 80 } ] },
    { -label => q{03.10 - Engine Sealing},
      -cpsc_obid => q{gcqn7Zkaec---z0admin-ad6},
      -cpsc => q{03.10.00},
      -chunk_obid => q{giEkgXipdcmp1z0admin-bad},
      -chunk => q{031000},
      -flags => 88,
      -children => [
        { -label => q{03.10.01 - Oil Control},
          -cpsc_obid => q{gcqn70haec---z0admin-ad6},
          -cpsc => q{03.10.01},
          -chunk_obid => q{giEmojepdcmp1z0admin-bah},
          -chunk => q{031001},
          -flags => 80 },
        { -label => q{03.10.02 - Coolant Control},
          -cpsc_obid => q{gcqn71eaec---z0admin-ad6},
          -cpsc => q{03.10.02},
          -chunk_obid => q{giEmoxkpdcmp1z0admin-bai},
          -chunk => q{031002},
          -flags => 80 },
        { -label => q{03.10.03 - Air and Contaminant Control},
          -cpsc_obid => q{gcqn72baec---z0admin-ad6},
          -cpsc => q{03.10.03},
          -chunk_obid => q{giEkgYkpdcmp1z0admin-bad},
          -chunk => q{031003},
          -flags => 80 },
        { -label => q{03.10.04 - Engine Covers},
          -cpsc_obid => q{gcqn72jaec---z0admin-ad6},
          -cpsc => q{03.10.04},
          -chunk_obid => q{giEmokgpdcmp1z0admin-bah},
          -chunk => q{031004},
          -flags => 80 } ] },
    { -label => q{03.11 - Engine Power Conversion},
      -cpsc_obid => q{gcqn73gaec---z0admin-ad6},
      -cpsc => q{03.11.00},
      -chunk_obid => q{giEmozbpdcmp1z0admin-bai},
      -chunk => q{031100},
      -flags => 88,
      -children => [
        { -label => q{03.11.01 - Crankshaft},
          -cpsc_obid => q{gcqn74daec---z0admin-ad6},
          -cpsc => q{03.11.01},
          -chunk_obid => q{giEmoAapdcmp1z0admin-bai},
          -chunk => q{031101},
          -flags => 80 },
        { -label => q{03.11.02 - Pistons Rings and Connecting Rods},
          -cpsc_obid => q{gcqn75aaec---z0admin-ad6},
          -cpsc => q{03.11.02},
          -chunk_obid => q{giEmolipdcmp1z0admin-bah},
          -chunk => q{031102},
          -flags => 80 },
        { -label => q{03.11.03 - Flywheel},
          -cpsc_obid => q{gcqn75iaec---z0admin-ad6},
          -cpsc => q{03.11.03},
          -chunk_obid => q{giEkg0epdcmp1z0admin-bad},
          -chunk => q{031103},
          -flags => 80 } ] },
    { -label => q{03.12 - Air Charging},
      -cpsc_obid => q{gcqn76faec---z0admin-ad6},
      -cpsc => q{03.12.00},
      -chunk_obid => q{giEmoBdpdcmp1z0admin-bai},
      -chunk => q{031200},
      -flags => 88,
      -children => [
        { -label => q{03.12.01 - Air Cleaner and Associated Components},
          -cpsc_obid => q{gcqn77caec---z0admin-ad6},
          -cpsc => q{03.12.01},
          -chunk_obid => q{giEmomkpdcmp1z0admin-bah},
          -chunk => q{031201},
          -flags => 80 },
        { -label => q{03.12.02 - Air Coolers},
          -cpsc_obid => q{gcqn77kaec---z0admin-ad6},
          -cpsc => q{03.12.02},
          -chunk_obid => q{giEmoCdpdcmp1z0admin-bai},
          -chunk => q{031202},
          -flags => 80 } ] },
    { -label => q{03.13 - Evaporative Emissions},
      -cpsc_obid => q{gcqoaahaec---z0admin-ad6},
      -cpsc => q{03.13.00},
      -chunk_obid => q{giEmonkpdcmp1z0admin-bah},
      -chunk => q{031300},
      -flags => 88,
      -children => [
        { -label => q{03.13.01 - Fuel Vapor Storage Canisters},
          -cpsc_obid => q{gcqobadaec---z0admin-ad7},
          -cpsc => q{03.13.01},
          -chunk_obid => q{giEmoDdpdcmp1z0admin-bai},
          -chunk => q{031301},
          -flags => 80 },
        { -label => q{03.13.02 - Lines},
          -cpsc_obid => q{gcqobbbaec---z0admin-ad7},
          -cpsc => q{03.13.02},
          -chunk_obid => q{giEmookpdcmp1z0admin-bah},
          -chunk => q{031302},
          -flags => 80 },
        { -label => q{03.13.03 - Control Modules and Solenoids},
          -cpsc_obid => q{gcqobbjaec---z0admin-ad7},
          -cpsc => q{03.13.03},
          -chunk_obid => q{giEkg2dpdcmp1z0admin-bad},
          -chunk => q{031303},
          -flags => 80 },
        { -label => q{03.13.04 - Venting Devices and Valves},
          -cpsc_obid => q{gcqobcgaec---z0admin-ad7},
          -cpsc => q{03.13.04},
          -chunk_obid => q{giEmoEfpdcmp1z0admin-bai},
          -chunk => q{031304},
          -flags => 80 },
        { -label => q{03.13.05 - Separator Tank and Fill Sensing},
          -cpsc_obid => q{gcqobddaec---z0admin-ad7},
          -cpsc => q{03.13.05},
          -chunk_obid => q{giEmoqbpdcmp1z0admin-bah},
          -chunk => q{031305},
          -flags => 80 } ] },
    { -label => q{03.14 - Electronic Engine Control},
      -cpsc_obid => q{gcqn7Egaec---z0admin-ad5},
      -cpsc => q{03.14.00},
      -chunk_obid => q{giEkg3fpdcmp1z0admin-bad},
      -chunk => q{031400},
      -flags => 88,
      -children => [
        { -label => q{03.14.01 - Computer Assembly},
          -cpsc_obid => q{gcqn7Fdaec---z0admin-ad5},
          -cpsc => q{03.14.01},
          -chunk_obid => q{giEmoFhpdcmp1z0admin-bai},
          -chunk => q{031401},
          -flags => 80 },
        { -label => q{03.14.02 - Mounting Hardware},
          -cpsc_obid => q{gcqn7Gaaec---z0admin-ad5},
          -cpsc => q{03.14.02},
          -chunk_obid => q{giEkg4bpdcmp1z0admin-bad},
          -chunk => q{031402},
          -flags => 80 },
        { -label => q{03.14.03 - Sensors-Signal Conditioning Devices},
          -cpsc_obid => q{gcqobeaaec---z0admin-ad7},
          -cpsc => q{03.14.03},
          -chunk_obid => q{giEmoGhpdcmp1z0admin-bai},
          -chunk => q{031403},
          -flags => 80 },
        { -label => q{03.14.04 - Electronic Actuator Devices},
          -cpsc_obid => q{gcqobeiaec---z0admin-ad7},
          -cpsc => q{03.14.04},
          -chunk_obid => q{giEmosapdcmp1z0admin-bah},
          -chunk => q{031404},
          -flags => 80 },
        { -label => q{03.14.05 - EEC Power Relay and Relay Controller},
          -cpsc_obid => q{gcuaebkaec---z0admin-aeU},
          -cpsc => q{03.14.05},
          -flags => 80 } ] },
    { -label => q{03.15 - Sound Control},
      -cpsc_obid => q{gcqobfhaec---z0admin-ad7},
      -cpsc => q{03.15.00},
      -chunk_obid => q{giEkg5dpdcmp1z0admin-bad},
      -chunk => q{031500},
      -flags => 88,
      -children => [
        { -label => q{03.15.01 - Sound Inhibitors},
          -cpsc_obid => q{gcqobgeaec---z0admin-ad7},
          -cpsc => q{03.15.01},
          -chunk_obid => q{giEmotcpdcmp1z0admin-bah},
          -chunk => q{031501},
          -flags => 80 } ] },
    { -label => q{03.16 - Electronic Throttle Control ELTHRCON},
      -cpsc_obid => q{hbEmJ7fpdcmp1z0admin-cyk},
      -cpsc => q{03.16.00},
      -flags => 88,
      -children => [
        { -label => q{03.16.01 - Throttle Control Unit},
          -cpsc_obid => q{hbEmKafpdcmp1z0admin-cyk},
          -cpsc => q{03.16.01},
          -flags => 80 },
        { -label => q{03.16.02 - Throttle Motor},
          -cpsc_obid => q{hbEmKahpdcmp1z0admin-cyk},
          -cpsc => q{03.16.02},
          -flags => 80 },
        { -label => q{03.16.03 - Monitor},
          -cpsc_obid => q{hbEmKajpdcmp1z0admin-cyk},
          -cpsc => q{03.16.03},
          -flags => 80 },
        { -label => q{03.16.04 - Accelerator Pedal Position Sensor},
          -cpsc_obid => q{hbEmKbbpdcmp1z0admin-cyk},
          -cpsc => q{03.16.04},
          -flags => 80 },
        { -label => q{03.16.05 - Throttle Position Sensor},
          -cpsc_obid => q{hbEo6Jkpdcmp1z0admin-cyn},
          -cpsc => q{03.16.05},
          -flags => 80 } ] },
    { -label => q{03.17 - EV Electronic Traction Motor Contr},
      -cpsc_obid => q{gcqobhbaec---z0admin-ad7},
      -cpsc => q{03.17.00},
      -chunk_obid => q{giEkg6apdcmp1z0admin-bad},
      -chunk => q{031700},
      -flags => 88,
      -children => [
        { -label => q{03.17.01 - Inverter Motor Controller IMC},
          -cpsc_obid => q{gcqobhjaec---z0admin-ad7},
          -cpsc => q{03.17.01},
          -chunk_obid => q{giEmoubpdcmp1z0admin-bah},
          -chunk => q{031701},
          -flags => 80 },
        { -label => q{03.17.02 - IMC Mounting Hardware},
          -cpsc_obid => q{gcqobigaec---z0admin-ad7},
          -cpsc => q{03.17.02},
          -chunk_obid => q{giEmoIkpdcmp1z0admin-bai},
          -chunk => q{031702},
          -flags => 80 } ] },
    { -label => q{03.18 - Foot-Operated Acceleration Control THRCON},
      -cpsc_obid => q{hbEo6Kipdcmp1z0admin-cyn},
      -cpsc => q{03.18.00},
      -flags => 88,
      -children => [
        { -label => q{03.18.01 - Foot-Operated Throttle Control},
          -cpsc_obid => q{hbEo6Kkpdcmp1z0admin-cyn},
          -cpsc => q{03.18.01},
          -flags => 80 } ] },
    { -label => q{03.19 - Automatic Vehicle Speed Control SPDCTL},
      -cpsc_obid => q{hbEo6Lbpdcmp1z0admin-cyn},
      -cpsc => q{03.19.00},
      -chunk_obid => q{giEkhvepdcmp1z0admin-bad},
      -chunk => q{031900},
      -flags => 88,
      -children => [
        { -label => q{03.19.01 - Speed Sensors},
          -cpsc_obid => q{hbEo6Ldpdcmp1z0admin-cyn},
          -cpsc => q{03.19.01},
          -flags => 80 },
        { -label => q{03.19.02 - Servo Actuators},
          -cpsc_obid => q{hbEo6Lfpdcmp1z0admin-cyn},
          -cpsc => q{03.19.02},
          -flags => 80 },
        { -label => q{03.19.03 - Electronic Module Amplifier},
          -cpsc_obid => q{hbEo6Lhpdcmp1z0admin-cyn},
          -cpsc => q{03.19.03},
          -flags => 80 },
        { -label => q{03.19.04 - Speed Control Switches Deactivating},
          -cpsc_obid => q{hbEo6Ljpdcmp1z0admin-cyn},
          -cpsc => q{03.19.04},
          -flags => 80 },
        { -label => q{SCAMD - Speed Control Actuator Module},
          -chunk_obid => q{giElbOjpdcmp1z0admin-bag},
          -chunk => q{SCAMD},
          -flags => 88,
          -children => [
            { -label => q{SCCTH - Speed Control Clutch},
              -chunk_obid => q{giEkhAbpdcmp1z0admin-bad},
              -chunk => q{SCCTH},
              -flags => 80 },
            { -label => q{SCGTRN - Speed Control Gear Train},
              -chunk_obid => q{giElcecpdcmp1z0admin-baf},
              -chunk => q{SCGTRN},
              -flags => 88,
              -children => [
                { -label => q{SCGRS - Speed Control Gears},
                  -chunk_obid => q{giElbRdpdcmp1z0admin-bag},
                  -chunk => q{SCGRS},
                  -flags => 80 },
                { -label => q{SCRTNS - Speed Control Retainers},
                  -chunk_obid => q{giElcfdpdcmp1z0admin-baf},
                  -chunk => q{SCRTNS},
                  -flags => 80 },
                { -label => q{SCSPND - Speed Control Spindles},
                  -chunk_obid => q{giElbSdpdcmp1z0admin-bag},
                  -chunk => q{SCSPND},
                  -flags => 80 } ] },
            { -label => q{SCHSNG - Speed Control Housing},
              -chunk_obid => q{giElbPfpdcmp1z0admin-bag},
              -chunk => q{SCHSNG},
              -flags => 80 },
            { -label => q{SCMTR - Speed Control Motor},
              -chunk_obid => q{giElbQbpdcmp1z0admin-bag},
              -chunk => q{SCMTR},
              -flags => 80 } ] },
        { -label => q{SCAMOD - Speed Control Amplifier Module},
          -chunk_obid => q{giElcagpdcmp1z0admin-baf},
          -chunk => q{SCAMOD},
          -flags => 88,
          -children => [
            { -label => q{SCCBHS - Speed Control Circuit Board and Heat Sink},
              -chunk_obid => q{giElbMhpdcmp1z0admin-bag},
              -chunk => q{SCCBHS},
              -flags => 88,
              -children => [
                { -label => q{SCCBRD - Speed Control Circuit Board},
                  -chunk_obid => q{giEkhxgpdcmp1z0admin-bad},
                  -chunk => q{SCCBRD},
                  -flags => 88,
                  -children => [
                    { -label => q{SCBRD - Speed Control Board},
                      -chunk_obid => q{giElbNhpdcmp1z0admin-bag},
                      -chunk => q{SCBRD},
                      -flags => 80 },
                    { -label => q{SCECOM - Speed Control Electrical Components},
                      -chunk_obid => q{giEkhycpdcmp1z0admin-bad},
                      -chunk => q{SCECOM},
                      -flags => 80 } ] },
                { -label => q{SCHSNK - Speed Control Heat Sink},
                  -chunk_obid => q{giElcchpdcmp1z0admin-baf},
                  -chunk => q{SCHSNK},
                  -flags => 80 } ] },
            { -label => q{SCCCTR - Speed Control Connector},
              -chunk_obid => q{giEkhwgpdcmp1z0admin-bad},
              -chunk => q{SCCCTR},
              -flags => 80 } ] },
        { -label => q{SCBKT - Speed Control Bracket},
          -chunk_obid => q{giElbLfpdcmp1z0admin-bag},
          -chunk => q{SCBKT},
          -flags => 80 } ] },
    { -label => q{03.20 - Hand-Operated Fuel and Choke Control HNDFUEL},
      -cpsc_obid => q{hbEo6Mapdcmp1z0admin-cyn},
      -cpsc => q{03.20.00},
      -flags => 88,
      -children => [
        { -label => q{03.20.01 - Hand-Operated Throttle Control},
          -cpsc_obid => q{hbEo6Mcpdcmp1z0admin-cyn},
          -cpsc => q{03.20.01},
          -flags => 80 },
        { -label => q{03.20.02 - Manual Choke Control},
          -cpsc_obid => q{hbEo6Mepdcmp1z0admin-cyn},
          -cpsc => q{03.20.02},
          -flags => 80 },
        { -label => q{03.20.03 - Fuel Shut-Off Control},
          -cpsc_obid => q{hbEo6Mgpdcmp1z0admin-cyn},
          -cpsc => q{03.20.03},
          -flags => 80 } ] },
    { -label => q{03.00.01 - Ford Produced Spark Ignition In-Line},
      -cpsc_obid => q{gcqnZgaaec---z0admin-ad3},
      -cpsc => q{03.00.01},
      -flags => 80 },
    { -label => q{03.00.02 - Ford Produced Spark Ignition Vee},
      -cpsc_obid => q{gcqnZgiaec---z0admin-ad3},
      -cpsc => q{03.00.02},
      -flags => 80 },
    { -label => q{03.00.03 - Ford Produced Diesel In-Line},
      -cpsc_obid => q{gcqnZhfaec---z0admin-ad3},
      -cpsc => q{03.00.03},
      -flags => 80 },
    { -label => q{03.00.04 - Ford Produced Diesel Vee},
      -cpsc_obid => q{gcqnZicaec---z0admin-ad3},
      -cpsc => q{03.00.04},
      -flags => 80 },
    { -label => q{03.00.05 - Vendor Produced Spark Ignition In-Line},
      -cpsc_obid => q{gcqnZikaec---z0admin-ad3},
      -cpsc => q{03.00.05},
      -flags => 80 },
    { -label => q{03.00.06 - Vendor Produced Spark Ignition Vee},
      -cpsc_obid => q{gcqnZjhaec---z0admin-ad3},
      -cpsc => q{03.00.06},
      -flags => 80 },
    { -label => q{03.00.07 - Vendor Produced Diesel In-Line},
      -cpsc_obid => q{gcqnZkeaec---z0admin-ad3},
      -cpsc => q{03.00.07},
      -flags => 80 },
    { -label => q{03.00.08 - Vendor Produced Diesel Vee},
      -cpsc_obid => q{gcqnZlbaec---z0admin-ad3},
      -cpsc => q{03.00.08},
      -flags => 80 },
    { -label => q{03.00.09 - Ford Produced Spark Ignition Rotary},
      -cpsc_obid => q{gcqnZ1faec---z0admin-ad4},
      -cpsc => q{03.00.09},
      -flags => 80 },
    { -label => q{03.00.10 - Vendor Produced Spark Ignition Rotary},
      -cpsc_obid => q{gcqnZ2caec---z0admin-ad4},
      -cpsc => q{03.00.10},
      -flags => 80 },
    { -label => q{03.00.11 - EV Ford Produced NA Electric},
      -cpsc_obid => q{gcqnZ2kaec---z0admin-ad4},
      -cpsc => q{03.00.11},
      -flags => 80 },
    { -label => q{03.00.12 - EV Vendor Produced NA Electric},
      -cpsc_obid => q{gcqnZ3haec---z0admin-ad4},
      -cpsc => q{03.00.12},
      -flags => 80 } ] },

{ -label => q{04 - Suspension System},
  -cpsc_obid => q{gcqobjdaec---z0admin-ad7},
  -cpsc => q{04.00.00},
  -flags => 88,
  -children => [
    { -label => q{04.01 - Front Suspension},
      -cpsc_obid => q{gcqobkkaec---z0admin-ad7},
      -cpsc => q{04.01.00},
      -flags => 88,
      -children => [
        { -label => q{04.01.01 - Front Springs},
          -cpsc_obid => q{gcqn7Giaec---z0admin-ad5},
          -cpsc => q{04.01.01},
          -flags => 80 },
        { -label => q{04.01.02 - Front Suspension Members},
          -cpsc_obid => q{gcqn7Hfaec---z0admin-ad5},
          -cpsc => q{04.01.02},
          -flags => 80 },
        { -label => q{04.01.03 - Front Non-Driven Axles},
          -cpsc_obid => q{gcqn7Icaec---z0admin-ad5},
          -cpsc => q{04.01.03},
          -flags => 80 },
        { -label => q{04.01.04 - Front Hubs and Spindles-Knuckles},
          -cpsc_obid => q{gcqn7Ikaec---z0admin-ad5},
          -cpsc => q{04.01.04},
          -flags => 80 },
        { -label => q{04.01.05 - Front Stabilizer Bar-Strut},
          -cpsc_obid => q{gcqn7Jhaec---z0admin-ad5},
          -cpsc => q{04.01.05},
          -flags => 80 } ] },
    { -label => q{04.02 - Rear Suspension},
      -cpsc_obid => q{gcqn7Keaec---z0admin-ad5},
      -cpsc => q{04.02.00},
      -flags => 88,
      -children => [
        { -label => q{04.02.01 - Rear Springs},
          -cpsc_obid => q{gcqn7Lbaec---z0admin-ad5},
          -cpsc => q{04.02.01},
          -flags => 80 },
        { -label => q{04.02.02 - Rear Suspension Members},
          -cpsc_obid => q{gcqn7Ljaec---z0admin-ad5},
          -cpsc => q{04.02.02},
          -flags => 80 },
        { -label => q{04.02.03 - Rear Hubs and Spindles},
          -cpsc_obid => q{gcqn7Mgaec---z0admin-ad5},
          -cpsc => q{04.02.03},
          -flags => 80 },
        { -label => q{04.02.04 - Rear Non-Driven Axles},
          -cpsc_obid => q{gcqn7Ndaec---z0admin-ad5},
          -cpsc => q{04.02.04},
          -flags => 80 },
        { -label => q{04.02.05 - Rear Stabilizer Bar},
          -cpsc_obid => q{gcqn7Oaaec---z0admin-ad5},
          -cpsc => q{04.02.05},
          -flags => 80 },
        { -label => q{04.02.06 - Lifting Mechanisms},
          -cpsc_obid => q{gcqn7Oiaec---z0admin-ad5},
          -cpsc => q{04.02.06},
          -flags => 80 } ] },
    { -label => q{04.03 - Shock Absorber},
      -cpsc_obid => q{gcqn7Pfaec---z0admin-ad5},
      -cpsc => q{04.03.00},
      -flags => 88,
      -children => [
        { -label => q{04.03.01 - Front Shock Absorbers},
          -cpsc_obid => q{gcqn7Qcaec---z0admin-ad5},
          -cpsc => q{04.03.01},
          -flags => 80 },
        { -label => q{04.03.02 - Rear Shock Absorbers},
          -cpsc_obid => q{gcqn7Qkaec---z0admin-ad5},
          -cpsc => q{04.03.02},
          -flags => 80 },
        { -label => q{04.03.03 - Shock Absorber Damping Actuators},
          -cpsc_obid => q{gcqn7Rhaec---z0admin-ad5},
          -cpsc => q{04.03.03},
          -flags => 80 },
        { -label => q{04.03.04 - Shock Absorber Damping Controls},
          -cpsc_obid => q{gcqn7Seaec---z0admin-ad5},
          -cpsc => q{04.03.04},
          -flags => 80 } ] },
    { -label => q{04.04 - Wheels and Tires},
      -cpsc_obid => q{gcqn7Tbaec---z0admin-ad5},
      -cpsc => q{04.04.00},
      -flags => 88,
      -children => [
        { -label => q{04.04.01 - Wheels},
          -cpsc_obid => q{gcqn7Tjaec---z0admin-ad5},
          -cpsc => q{04.04.01},
          -flags => 80 },
        { -label => q{04.04.02 - Tires},
          -cpsc_obid => q{gcqn7Ugaec---z0admin-ad5},
          -cpsc => q{04.04.02},
          -flags => 80 },
        { -label => q{04.04.03 - Wheel Ornamentation},
          -cpsc_obid => q{gcqn7Vdaec---z0admin-ad5},
          -cpsc => q{04.04.03},
          -flags => 80 } ] },
    { -label => q{04.05 - Suspension Load Leveling Control},
      -cpsc_obid => q{gcqn7Waaec---z0admin-ad5},
      -cpsc => q{04.05.00},
      -flags => 88,
      -children => [
        { -label => q{04.05.01 - Suspension Leveling Power Source},
          -cpsc_obid => q{gcqn7Wiaec---z0admin-ad5},
          -cpsc => q{04.05.01},
          -flags => 80 },
        { -label => q{04.05.02 - Load Leveling Controls},
          -cpsc_obid => q{gcqoblhaec---z0admin-ad7},
          -cpsc => q{04.05.02},
          -flags => 80 },
        { -label => q{04.05.03 - Load Leveling Distribution Equipment},
          -cpsc_obid => q{gcqobmeaec---z0admin-ad7},
          -cpsc => q{04.05.03},
          -flags => 80 },
        { -label => q{04.05.04 - Load Leveling Electric Motors},
          -cpsc_obid => q{gcqobnbaec---z0admin-ad7},
          -cpsc => q{04.05.04},
          -flags => 80 } ] },
    { -label => q{04.00.01 - Front Wheel Alignment Specifications},
      -cpsc_obid => q{gcqobjfaec---z0admin-ad7},
      -cpsc => q{04.00.01},
      -flags => 80 },
    { -label => q{04.00.02 - Rear Wheel Alignment Specifications},
      -cpsc_obid => q{gcqobkcaec---z0admin-ad7},
      -cpsc => q{04.00.02},
      -flags => 80 } ] },

{ -label => q{05 - Driveline System},
  -cpsc_obid => q{gcqn7Xfaec---z0admin-ad5},
  -cpsc => q{05.00.00},
  -chunk_obid => q{giEmSebpdcmp1z0admin-baj},
  -chunk => q{050000},
  -flags => 88,
  -children => [
    { -label => q{05.01 - Driveshaft},
      -cpsc_obid => q{gcqn7Xhaec---z0admin-ad5},
      -cpsc => q{05.01.00},
      -chunk_obid => q{giEmoRkpdcmp1z0admin-bah},
      -chunk => q{050100},
      -flags => 88,
      -children => [
        { -label => q{05.01.01 - End Couplings and Yokes},
          -cpsc_obid => q{gcqoboaaec---z0admin-ad7},
          -cpsc => q{05.01.01},
          -chunk_obid => q{giEmo7ipdcmp1z0admin-bai},
          -chunk => q{050101},
          -flags => 80 },
        { -label => q{05.01.02 - Joints},
          -cpsc_obid => q{gcqoboiaec---z0admin-ad7},
          -cpsc => q{05.01.02},
          -chunk_obid => q{giEmSfdpdcmp1z0admin-baj},
          -chunk => q{050102},
          -flags => 80 },
        { -label => q{05.01.03 - Tubes},
          -cpsc_obid => q{gcqobpfaec---z0admin-ad7},
          -cpsc => q{05.01.03},
          -chunk_obid => q{giEmoTbpdcmp1z0admin-bah},
          -chunk => q{050103},
          -flags => 80 },
        { -label => q{05.01.04 - Supports},
          -cpsc_obid => q{gcqobqcaec---z0admin-ad7},
          -cpsc => q{05.01.04},
          -chunk_obid => q{giEmpakpdcmp1z0admin-bai},
          -chunk => q{050104},
          -flags => 80 } ] },
    { -label => q{05.02 - Rear Drive Housed Axle},
      -cpsc_obid => q{gcqobqkaec---z0admin-ad7},
      -cpsc => q{05.02.00},
      -chunk_obid => q{giEmSgfpdcmp1z0admin-baj},
      -chunk => q{050200},
      -flags => 88,
      -children => [
        { -label => q{05.02.01 - Housing},
          -cpsc_obid => q{gcqn7Ycaec---z0admin-ad5},
          -cpsc => q{05.02.01},
          -chunk_obid => q{giEmoUdpdcmp1z0admin-bah},
          -chunk => q{050201},
          -flags => 80 },
        { -label => q{05.02.02 - Bearings and Seals},
          -cpsc_obid => q{gcqn7Ykaec---z0admin-ad5},
          -cpsc => q{05.02.02},
          -chunk_obid => q{giEmShfpdcmp1z0admin-baj},
          -chunk => q{050202},
          -flags => 80 },
        { -label => q{05.02.03 - Gear Set},
          -cpsc_obid => q{gcqn7Zhaec---z0admin-ad5},
          -cpsc => q{05.02.03},
          -chunk_obid => q{giEmSiapdcmp1z0admin-baj},
          -chunk => q{050203},
          -flags => 80 },
        { -label => q{05.02.04 - Differential Assembly},
          -cpsc_obid => q{gcqn70eaec---z0admin-ad5},
          -cpsc => q{05.02.04},
          -chunk_obid => q{giEmpcfpdcmp1z0admin-bai},
          -chunk => q{050204},
          -flags => 80 },
        { -label => q{05.02.05 - Axle Shafts},
          -cpsc_obid => q{gcqn71baec---z0admin-ad5},
          -cpsc => q{05.02.05},
          -chunk_obid => q{giEmoWapdcmp1z0admin-bah},
          -chunk => q{050205},
          -flags => 80 },
        { -label => q{05.02.06 - Multi-Speed Axle and Controls},
          -cpsc_obid => q{gcqn71jaec---z0admin-ad5},
          -cpsc => q{05.02.06},
          -chunk_obid => q{giEmSjcpdcmp1z0admin-baj},
          -chunk => q{050206},
          -flags => 88,
          -children => [
            { -label => q{*** See 05.02.05 - Axle Shafts},
              -flags => 80 } ] },
        { -label => q{05.02.07 - Double Reduction Mechanism},
          -cpsc_obid => q{gcqn72gaec---z0admin-ad5},
          -cpsc => q{05.02.07},
          -chunk_obid => q{giEmoXapdcmp1z0admin-bah},
          -chunk => q{050207},
          -flags => 80 },
        { -label => q{05.02.08 - Lubricants},
          -cpsc_obid => q{gcqn73daec---z0admin-ad5},
          -cpsc => q{05.02.08},
          -chunk_obid => q{giEmoXhpdcmp1z0admin-bah},
          -chunk => q{050208},
          -flags => 80 } ] },
    { -label => q{05.03 - Front Drive Housed Axle},
      -cpsc_obid => q{gcqn73jaec---z0admin-ad5},
      -cpsc => q{05.03.00},
      -chunk_obid => q{giEmpeepdcmp1z0admin-bai},
      -chunk => q{050300},
      -flags => 88,
      -children => [
        { -label => q{*** See 05.02.08 - Lubricants},
          -flags => 80 },
        { -label => q{05.03.01 - Housing},
          -cpsc_obid => q{gcqn74gaec---z0admin-ad5},
          -cpsc => q{05.03.01},
          -chunk_obid => q{giEmpfapdcmp1z0admin-bai},
          -chunk => q{050301},
          -flags => 80 },
        { -label => q{05.03.02 - Bearings and Seals},
          -cpsc_obid => q{gcqn75daec---z0admin-ad5},
          -cpsc => q{05.03.02},
          -chunk_obid => q{giEmoYjpdcmp1z0admin-bah},
          -chunk => q{050302},
          -flags => 80 },
        { -label => q{05.03.03 - Gear Set},
          -cpsc_obid => q{gcqn76aaec---z0admin-ad5},
          -cpsc => q{05.03.03},
          -chunk_obid => q{giEmoZipdcmp1z0admin-bah},
          -chunk => q{050303},
          -flags => 80 },
        { -label => q{05.03.04 - Differential Assembly},
          -cpsc_obid => q{gcqobsaaec---z0admin-ad7},
          -cpsc => q{05.03.04},
          -chunk_obid => q{giEmSlfpdcmp1z0admin-baj},
          -chunk => q{050304},
          -flags => 80 },
        { -label => q{05.03.05 - Axle Shafts and Joints},
          -cpsc_obid => q{gcqobsiaec---z0admin-ad7},
          -cpsc => q{05.03.05},
          -chunk_obid => q{giEmSmepdcmp1z0admin-baj},
          -chunk => q{050305},
          -flags => 80 },
        { -label => q{05.03.06 - Locking Hubs},
          -cpsc_obid => q{gcqobtfaec---z0admin-ad7},
          -cpsc => q{05.03.06},
          -chunk_obid => q{giEmo0kpdcmp1z0admin-bah},
          -chunk => q{050306},
          -flags => 80 },
        { -label => q{05.03.07 - Lubricants},
          -cpsc_obid => q{gcqobucaec---z0admin-ad7},
          -cpsc => q{05.03.07},
          -chunk_obid => q{giEmSnepdcmp1z0admin-baj},
          -chunk => q{050307},
          -flags => 80 } ] },
    { -label => q{05.04 - Front Drive Half-Shafts},
      -cpsc_obid => q{gcqobukaec---z0admin-ad7},
      -cpsc => q{05.04.00},
      -chunk_obid => q{giEmpgfpdcmp1z0admin-bai},
      -chunk => q{050400},
      -flags => 88,
      -children => [
        { -label => q{05.04.01 - End Couplings and Yokes},
          -cpsc_obid => q{gcqobvhaec---z0admin-ad7},
          -cpsc => q{05.04.01},
          -chunk_obid => q{giEmo2bpdcmp1z0admin-bah},
          -chunk => q{050401},
          -flags => 80 },
        { -label => q{05.04.02 - Joints},
          -cpsc_obid => q{gcqobweaec---z0admin-ad7},
          -cpsc => q{05.04.02},
          -chunk_obid => q{giEmSokpdcmp1z0admin-baj},
          -chunk => q{050402},
          -flags => 80 },
        { -label => q{05.04.03 - Tubes},
          -cpsc_obid => q{gcqobxbaec---z0admin-ad7},
          -cpsc => q{05.04.03},
          -chunk_obid => q{giEmo3jpdcmp1z0admin-bah},
          -chunk => q{050403},
          -flags => 80 },
        { -label => q{05.04.04 - Supports},
          -cpsc_obid => q{gcqobxjaec---z0admin-ad7},
          -cpsc => q{05.04.04},
          -chunk_obid => q{giEmphjpdcmp1z0admin-bai},
          -chunk => q{050404},
          -flags => 80 } ] },
    { -label => q{05.05 - Rear Drive Half-Shafts},
      -cpsc_obid => q{gcqobygaec---z0admin-ad7},
      -cpsc => q{05.05.00},
      -chunk_obid => q{giEmpiipdcmp1z0admin-bai},
      -chunk => q{050500},
      -flags => 88,
      -children => [
        { -label => q{05.05.01 - End Couplings and Yokes},
          -cpsc_obid => q{gcqobzdaec---z0admin-ad7},
          -cpsc => q{05.05.01},
          -chunk_obid => q{giEmo5gpdcmp1z0admin-bah},
          -chunk => q{050501},
          -flags => 80 },
        { -label => q{05.05.02 - Joints},
          -cpsc_obid => q{gcqobAaaec---z0admin-ad7},
          -cpsc => q{05.05.02},
          -chunk_obid => q{giEmpkbpdcmp1z0admin-bai},
          -chunk => q{050502},
          -flags => 80 },
        { -label => q{05.05.03 - Tubes},
          -cpsc_obid => q{gcqobAiaec---z0admin-ad7},
          -cpsc => q{05.05.03},
          -chunk_obid => q{giElbWdpdcmp1z0admin-baf},
          -chunk => q{050503},
          -flags => 80 } ] },
    { -label => q{05.06 - Multiple Drive},
      -cpsc_obid => q{gcqobBfaec---z0admin-ad7},
      -cpsc => q{05.06.00},
      -chunk_obid => q{giElbWkpdcmp1z0admin-baf},
      -chunk => q{050600},
      -flags => 88,
      -children => [
        { -label => q{05.06.01 - Multiple Drive Components},
          -cpsc_obid => q{gcqobCcaec---z0admin-ad7},
          -cpsc => q{05.06.01},
          -chunk_obid => q{giEmSrcpdcmp1z0admin-baj},
          -chunk => q{050601},
          -flags => 80 },
        { -label => q{05.06.02 - Power Divider},
          -cpsc_obid => q{gcqn76haec---z0admin-ad5},
          -cpsc => q{05.06.02},
          -chunk_obid => q{giEmplcpdcmp1z0admin-bai},
          -chunk => q{050602},
          -flags => 80 } ] } ] },

{ -label => q{06 - Brake System},
  -cpsc_obid => q{gcqn77eaec---z0admin-ad5},
  -cpsc => q{06.00.00},
  -chunk_obid => q{giEnGpbpdcmp1z0admin-bak},
  -chunk => q{060000},
  -flags => 88,
  -children => [
    { -label => q{06.01 - Front Drum Brake},
      -cpsc_obid => q{gcqn77gaec---z0admin-ad5},
      -cpsc => q{06.01.00},
      -flags => 88,
      -children => [
        { -label => q{06.01.01 - Front Drum},
          -cpsc_obid => q{gcqoaadaec---z0admin-ad5},
          -cpsc => q{06.01.01},
          -flags => 80 },
        { -label => q{06.01.02 - Front Drum Brake Assembly and Attaching Parts},
          -cpsc_obid => q{gcqoabaaec---z0admin-ad5},
          -cpsc => q{06.01.02},
          -flags => 80 } ] },
    { -label => q{06.02 - Rear Drum Brake},
      -cpsc_obid => q{gcqoabiaec---z0admin-ad5},
      -cpsc => q{06.02.00},
      -flags => 88,
      -children => [
        { -label => q{06.02.01 - Rear Drum},
          -cpsc_obid => q{gcqoacfaec---z0admin-ad5},
          -cpsc => q{06.02.01},
          -flags => 80 },
        { -label => q{06.02.02 - Rear Drum Brake Assembly and Attaching Parts},
          -cpsc_obid => q{gcqoadcaec---z0admin-ad5},
          -cpsc => q{06.02.02},
          -flags => 80 } ] },
    { -label => q{06.03 - Front Disc Brake},
      -cpsc_obid => q{gcqoadkaec---z0admin-ad5},
      -cpsc => q{06.03.00},
      -flags => 88,
      -children => [
        { -label => q{06.03.01 - Front Rotor Disc},
          -cpsc_obid => q{gcqobCjaec---z0admin-ad7},
          -cpsc => q{06.03.01},
          -flags => 80 },
        { -label => q{06.03.02 - Front Caliper and Attaching Parts},
          -cpsc_obid => q{gcqobDgaec---z0admin-ad7},
          -cpsc => q{06.03.02},
          -flags => 80 } ] },
    { -label => q{06.04 - Rear Disc Brake},
      -cpsc_obid => q{gcqoaejaec---z0admin-ad5},
      -cpsc => q{06.04.00},
      -flags => 88,
      -children => [
        { -label => q{06.04.01 - Rear Rotor Disc},
          -cpsc_obid => q{gcqoafgaec---z0admin-ad5},
          -cpsc => q{06.04.01},
          -flags => 80 },
        { -label => q{06.04.02 - Rear Caliper and Attaching Parts},
          -cpsc_obid => q{gcqoagdaec---z0admin-ad5},
          -cpsc => q{06.04.02},
          -flags => 80 } ] },
    { -label => q{06.05 - Parking Brake and Actuation},
      -cpsc_obid => q{gcqoahaaec---z0admin-ad5},
      -cpsc => q{06.05.00},
      -flags => 88,
      -children => [
        { -label => q{06.05.01 - Parking Brake Assembly},
          -cpsc_obid => q{gcqoahiaec---z0admin-ad5},
          -cpsc => q{06.05.01},
          -flags => 80 },
        { -label => q{06.05.02 - Parking Brake Controls Cable},
          -cpsc_obid => q{gcqoaifaec---z0admin-ad5},
          -cpsc => q{06.05.02},
          -flags => 80 },
        { -label => q{06.05.03 - Parking Brake Controls Hydraulic},
          -cpsc_obid => q{gcqoajcaec---z0admin-ad5},
          -cpsc => q{06.05.03},
          -flags => 80 } ] },
    { -label => q{06.06 - Hydraulic Brake Actuation},
      -cpsc_obid => q{gcqoajkaec---z0admin-ad5},
      -cpsc => q{06.06.00},
      -flags => 88,
      -children => [
        { -label => q{06.06.01 - Master Cylinder},
          -cpsc_obid => q{gcqoakhaec---z0admin-ad5},
          -cpsc => q{06.06.01},
          -flags => 80 },
        { -label => q{06.06.02 - Pedal and Support},
          -cpsc_obid => q{gcqoaleaec---z0admin-ad5},
          -cpsc => q{06.06.02},
          -flags => 80 },
        { -label => q{06.06.03 - Tubes and Hoses},
          -cpsc_obid => q{gcqoambaec---z0admin-ad5},
          -cpsc => q{06.06.03},
          -flags => 80 },
        { -label => q{06.06.04 - Stop Lamp Switch},
          -cpsc_obid => q{gcqoamjaec---z0admin-ad5},
          -cpsc => q{06.06.04},
          -flags => 80 },
        { -label => q{06.06.05 - Brake Control Valves},
          -cpsc_obid => q{gcqoangaec---z0admin-ad5},
          -cpsc => q{06.06.05},
          -flags => 80 },
        { -label => q{06.06.06 - Brake Fluid},
          -cpsc_obid => q{gcqoaodaec---z0admin-ad5},
          -cpsc => q{06.06.06},
          -flags => 80 } ] },
    { -label => q{06.07 - Power Brake},
      -cpsc_obid => q{gcqoapaaec---z0admin-ad5},
      -cpsc => q{06.07.00},
      -flags => 88,
      -children => [
        { -label => q{06.07.01 - Vacuum Booster},
          -cpsc_obid => q{gcqoapiaec---z0admin-ad5},
          -cpsc => q{06.07.01},
          -flags => 80 },
        { -label => q{06.07.02 - Vacuum Pump Power Brakes Only},
          -cpsc_obid => q{gcqoaqfaec---z0admin-ad5},
          -cpsc => q{06.07.02},
          -flags => 80 },
        { -label => q{06.07.03 - Air Assist Booster},
          -cpsc_obid => q{gcqoarcaec---z0admin-ad5},
          -cpsc => q{06.07.03},
          -flags => 80 },
        { -label => q{06.07.04 - Hydraulic Unique Hydro-Boost},
          -cpsc_obid => q{gcqoarkaec---z0admin-ad5},
          -cpsc => q{06.07.04},
          -flags => 80 } ] },
    { -label => q{06.08 - Air Brake},
      -cpsc_obid => q{gcqoashaec---z0admin-ad5},
      -cpsc => q{06.08.00},
      -flags => 88,
      -children => [
        { -label => q{06.08.01 - Air Brake Valves},
          -cpsc_obid => q{gcqobEcaec---z0admin-ad7},
          -cpsc => q{06.08.01},
          -flags => 80 },
        { -label => q{06.08.02 - Tubes and Hoses},
          -cpsc_obid => q{gcqobEkaec---z0admin-ad7},
          -cpsc => q{06.08.02},
          -flags => 80 },
        { -label => q{06.08.03 - Stop Lamp Switch},
          -cpsc_obid => q{gcqoatdaec---z0admin-ad5},
          -cpsc => q{06.08.03},
          -flags => 80 },
        { -label => q{06.08.04 - Air Compressor Pump},
          -cpsc_obid => q{gcqoauaaec---z0admin-ad5},
          -cpsc => q{06.08.04},
          -flags => 80 },
        { -label => q{06.08.05 - Air Reservoirs},
          -cpsc_obid => q{gcqoauiaec---z0admin-ad5},
          -cpsc => q{06.08.05},
          -flags => 80 } ] },
    { -label => q{06.09 - Anti-Lock Control and Anti-Whlspn Contr},
      -cpsc_obid => q{gcqoavfaec---z0admin-ad5},
      -cpsc => q{06.09.00},
      -flags => 88,
      -children => [
        { -label => q{06.09.01 - Sensors},
          -cpsc_obid => q{gcqoawcaec---z0admin-ad5},
          -cpsc => q{06.09.01},
          -flags => 80 },
        { -label => q{06.09.02 - Logic Module},
          -cpsc_obid => q{gcqoawkaec---z0admin-ad5},
          -cpsc => q{06.09.02},
          -flags => 80 },
        { -label => q{06.09.03 - Actuators and Other Anti-Lock Control Components},
          -cpsc_obid => q{gcqoaxhaec---z0admin-ad5},
          -cpsc => q{06.09.03},
          -flags => 80 },
        { -label => q{06.09.04 - Unique Anti-Wheelspin Components},
          -cpsc_obid => q{gcqoayeaec---z0admin-ad5},
          -cpsc => q{06.09.04},
          -flags => 80 } ] },
    { -label => q{06.10 - Auxiliary Brake},
      -cpsc_obid => q{gcqoazbaec---z0admin-ad5},
      -cpsc => q{06.10.00},
      -flags => 88,
      -children => [
        { -label => q{06.10.01 - Exhaust Brake},
          -cpsc_obid => q{gcqoazjaec---z0admin-ad5},
          -cpsc => q{06.10.01},
          -flags => 80 },
        { -label => q{06.10.02 - Hydraulic Retarder},
          -cpsc_obid => q{gcqoaAgaec---z0admin-ad5},
          -cpsc => q{06.10.02},
          -flags => 80 },
        { -label => q{06.10.03 - Electric Retarder},
          -cpsc_obid => q{gcqoaBdaec---z0admin-ad5},
          -cpsc => q{06.10.03},
          -flags => 80 },
        { -label => q{06.10.04 - Regenerative Brake},
          -cpsc_obid => q{gcqobFhaec---z0admin-ad7},
          -cpsc => q{06.10.04},
          -flags => 80 } ] },
    { -label => q{ABSASL - ABS Module Assembly},
      -chunk_obid => q{giElbWkpdcmp1z0admin-bag},
      -chunk => q{ABSASL},
      -flags => 88,
      -children => [
        { -label => q{ABHSNG - ABS Housing},
          -chunk_obid => q{giElbZkpdcmp1z0admin-bag},
          -chunk => q{ABHSNG},
          -flags => 80 },
        { -label => q{ABSBKT - ABS Bracket},
          -chunk_obid => q{giElclfpdcmp1z0admin-baf},
          -chunk => q{ABSBKT},
          -flags => 80 },
        { -label => q{ABSCTR - ABS Connector},
          -chunk_obid => q{giElbZdpdcmp1z0admin-bag},
          -chunk => q{ABSCTR},
          -flags => 80 },
        { -label => q{ABSMOD - ABS Module},
          -chunk_obid => q{giEnGqepdcmp1z0admin-bak},
          -chunk => q{ABSMOD},
          -flags => 88,
          -children => [
            { -label => q{ABSCBH - ABS Circuit Board and Heat Sink},
              -chunk_obid => q{giElbYbpdcmp1z0admin-bag},
              -chunk => q{ABSCBH},
              -flags => 88,
              -children => [
                { -label => q{ABSCBD - ABS Circuit Board},
                  -chunk_obid => q{giElcmhpdcmp1z0admin-baf},
                  -chunk => q{ABSCBD},
                  -flags => 80 },
                { -label => q{ABSHSN - ABS Heat Sink},
                  -chunk_obid => q{giElcngpdcmp1z0admin-baf},
                  -chunk => q{ABSHSN},
                  -flags => 80 } ] } ] } ] } ] },

{ -label => q{07 - Transmission System},
  -cpsc_obid => q{gcqobGeaec---z0admin-ad7},
  -cpsc => q{07.00.00},
  -chunk_obid => q{giEkg6kpdcmp1z0admin-bad},
  -chunk => q{070000},
  -flags => 88,
  -children => [
    { -label => q{07.01 - Automatic Transmission-Transaxle},
      -cpsc_obid => q{gcqobGgaec---z0admin-ad7},
      -cpsc => q{07.01.00},
      -chunk_obid => q{giEmovdpdcmp1z0admin-bah},
      -chunk => q{070100},
      -flags => 88,
      -children => [
        { -label => q{07.01.01 - Housing and Seals},
          -cpsc_obid => q{gcqobHdaec---z0admin-ad7},
          -cpsc => q{07.01.01},
          -chunk_obid => q{giEmowcpdcmp1z0admin-bah},
          -chunk => q{070101},
          -flags => 80 },
        { -label => q{07.01.02 - Internal Hydraulic or Mechanical Controls and Pumps},
          -cpsc_obid => q{gcqobIaaec---z0admin-ad7},
          -cpsc => q{07.01.02},
          -chunk_obid => q{giEkg7ipdcmp1z0admin-bad},
          -chunk => q{070102},
          -flags => 80 },
        { -label => q{07.01.03 - Gear Sets Shafts Bearings Chains and Sprockets},
          -cpsc_obid => q{gcqobIiaec---z0admin-ad7},
          -cpsc => q{07.01.03},
          -chunk_obid => q{giEkhahpdcmp1z0admin-bad},
          -chunk => q{070103},
          -flags => 80 },
        { -label => q{07.01.04 - Clutch Packs and Brake Bands},
          -cpsc_obid => q{gcqobJfaec---z0admin-ad7},
          -cpsc => q{07.01.04},
          -chunk_obid => q{giEmoKkpdcmp1z0admin-bai},
          -chunk => q{070104},
          -flags => 80 },
        { -label => q{07.01.05 - Torque Converter and Drive Plate},
          -cpsc_obid => q{gcqobKcaec---z0admin-ad7},
          -cpsc => q{07.01.05},
          -chunk_obid => q{giEkhbfpdcmp1z0admin-bad},
          -chunk => q{070105},
          -flags => 80 },
        { -label => q{07.01.06 - Internal Electrical-Electronic Controls},
          -cpsc_obid => q{gcqobKkaec---z0admin-ad7},
          -cpsc => q{07.01.06},
          -chunk_obid => q{giEmoxjpdcmp1z0admin-bah},
          -chunk => q{070106},
          -flags => 80 },
        { -label => q{07.01.07 - Fluid},
          -cpsc_obid => q{gcqobLhaec---z0admin-ad7},
          -cpsc => q{07.01.07},
          -chunk_obid => q{giEmoMbpdcmp1z0admin-bai},
          -chunk => q{070107},
          -flags => 80 },
        { -label => q{07.01.08 - Sheaves and Belt},
          -cpsc_obid => q{gcqobMeaec---z0admin-ad7},
          -cpsc => q{07.01.08},
          -chunk_obid => q{giEmoyjpdcmp1z0admin-bah},
          -chunk => q{070108},
          -flags => 80 },
        { -label => q{07.01.09 - Transaxle Differential},
          -cpsc_obid => q{gcqobNbaec---z0admin-ad7},
          -cpsc => q{07.01.09},
          -chunk_obid => q{giEmozipdcmp1z0admin-bah},
          -chunk => q{070109},
          -flags => 80 },
        { -label => q{07.01.10 - EV Transaxle and Motor Assembly},
          -cpsc_obid => q{gcqobNjaec---z0admin-ad7},
          -cpsc => q{07.01.10},
          -chunk_obid => q{giEmoAepdcmp1z0admin-bah},
          -chunk => q{070110},
          -flags => 80 } ] },
    { -label => q{07.02 - Transmission Cooling},
      -cpsc_obid => q{gcqobOgaec---z0admin-ad7},
      -cpsc => q{07.02.00},
      -chunk_obid => q{giEkhdepdcmp1z0admin-bad},
      -chunk => q{070200},
      -flags => 88,
      -children => [
        { -label => q{07.02.01 - Transmission Cooler},
          -cpsc_obid => q{gcqobPdaec---z0admin-ad7},
          -cpsc => q{07.02.01},
          -chunk_obid => q{giEmoNkpdcmp1z0admin-bai},
          -chunk => q{070201},
          -flags => 80 },
        { -label => q{07.02.02 - Hoses},
          -cpsc_obid => q{gcqobQaaec---z0admin-ad7},
          -cpsc => q{07.02.02},
          -chunk_obid => q{giEkheepdcmp1z0admin-bad},
          -chunk => q{070202},
          -flags => 80 },
        { -label => q{07.02.03 - Pump},
          -cpsc_obid => q{gcqobQiaec---z0admin-ad7},
          -cpsc => q{07.02.03},
          -chunk_obid => q{giEmoBfpdcmp1z0admin-bah},
          -chunk => q{070203},
          -flags => 80 } ] },
    { -label => q{07.03 - Manual Transmission-Transaxle Subsystem},
      -cpsc_obid => q{gcqobRfaec---z0admin-ad7},
      -cpsc => q{07.03.00},
      -chunk_obid => q{giEmoPbpdcmp1z0admin-bai},
      -chunk => q{070300},
      -flags => 88,
      -children => [
        { -label => q{07.03.01 - Housing and Seals},
          -cpsc_obid => q{gcqobScaec---z0admin-ad7},
          -cpsc => q{07.03.01},
          -chunk_obid => q{giEmoCfpdcmp1z0admin-bah},
          -chunk => q{070301},
          -flags => 80 },
        { -label => q{07.03.02 - Internal Controls},
          -cpsc_obid => q{gcqobSkaec---z0admin-ad7},
          -cpsc => q{07.03.02},
          -chunk_obid => q{giEkhfipdcmp1z0admin-bad},
          -chunk => q{070302},
          -flags => 80 },
        { -label => q{07.03.03 - Gear Sets, Shafts and Bearings},
          -cpsc_obid => q{gcqobThaec---z0admin-ad7},
          -cpsc => q{07.03.03},
          -chunk_obid => q{giEmoQdpdcmp1z0admin-bai},
          -chunk => q{070303},
          -flags => 80 },
        { -label => q{07.03.04 - Synchronizers},
          -cpsc_obid => q{gcqobUeaec---z0admin-ad7},
          -cpsc => q{07.03.04},
          -chunk_obid => q{giEmRYapdcmp1z0admin-baj},
          -chunk => q{070304},
          -flags => 80 },
        { -label => q{07.03.05 - Speedometer Drive and Driven Gears},
          -cpsc_obid => q{gcqobVbaec---z0admin-ad7},
          -cpsc => q{07.03.05},
          -chunk_obid => q{giEkhgkpdcmp1z0admin-bad},
          -chunk => q{070305},
          -flags => 80 },
        { -label => q{07.03.06 - Transaxle Differential},
          -cpsc_obid => q{gcqobVjaec---z0admin-ad7},
          -cpsc => q{07.03.06},
          -chunk_obid => q{giEkhhgpdcmp1z0admin-bad},
          -chunk => q{070306},
          -flags => 80 },
        { -label => q{07.03.07 - Lubricants},
          -cpsc_obid => q{gcqobWgaec---z0admin-ad7},
          -cpsc => q{07.03.07},
          -chunk_obid => q{giEmRZdpdcmp1z0admin-baj},
          -chunk => q{070307},
          -flags => 80 } ] },
    { -label => q{07.04 - Auxiliary Transmission Subsystem},
      -cpsc_obid => q{gcqobXdaec---z0admin-ad7},
      -cpsc => q{07.04.00},
      -chunk_obid => q{giEmoEfpdcmp1z0admin-bah},
      -chunk => q{070400},
      -flags => 88,
      -children => [
        { -label => q{07.04.01 - Non-Integrated Auxiliary Transmission or Overdrive},
          -cpsc_obid => q{gcqobYaaec---z0admin-ad7},
          -cpsc => q{07.04.01},
          -chunk_obid => q{giEmoRdpdcmp1z0admin-bai},
          -chunk => q{070401},
          -flags => 80 },
        { -label => q{07.04.02 - Non-Integrated Range Splitter},
          -cpsc_obid => q{gcqobYiaec---z0admin-ad7},
          -cpsc => q{07.04.02},
          -chunk_obid => q{giEmoFfpdcmp1z0admin-bah},
          -chunk => q{070402},
          -flags => 80 } ] },
    { -label => q{07.05 - Automatic Trans External Contrs},
      -cpsc_obid => q{gcqobZfaec---z0admin-ad7},
      -cpsc => q{07.05.00},
      -chunk_obid => q{giEmoSdpdcmp1z0admin-bai},
      -chunk => q{070500},
      -flags => 88,
      -children => [
        { -label => q{07.05.01 - Driver-Operated External Controls-Floor Shift},
          -cpsc_obid => q{gcqob0caec---z0admin-ad7},
          -cpsc => q{07.05.01},
          -chunk_obid => q{giEmR0jpdcmp1z0admin-baj},
          -chunk => q{070501},
          -flags => 80 },
        { -label => q{07.05.02 - External Controls- Electrical-Electronic},
          -cpsc_obid => q{gcqoabeaec---z0admin-ad6},
          -cpsc => q{07.05.02},
          -chunk_obid => q{giEmoGhpdcmp1z0admin-bah},
          -chunk => q{070502},
          -flags => 80 },
        { -label => q{07.05.03 - External Controls- Mechanical},
          -cpsc_obid => q{gcqoacbaec---z0admin-ad6},
          -cpsc => q{07.05.03},
          -chunk_obid => q{giEmoTfpdcmp1z0admin-bai},
          -chunk => q{070503},
          -flags => 80 },
        { -label => q{07.05.04 - External Controls- Vacuum},
          -cpsc_obid => q{gcqoacjaec---z0admin-ad6},
          -cpsc => q{07.05.04},
          -chunk_obid => q{giEmoUepdcmp1z0admin-bai},
          -chunk => q{070504},
          -flags => 80 },
        { -label => q{07.05.05 - Driver-Operated External COntrols-Column Shift},
          -cpsc_obid => q{gcqoadgaec---z0admin-ad6},
          -cpsc => q{07.05.05},
          -chunk_obid => q{giEmoHjpdcmp1z0admin-bah},
          -chunk => q{070505},
          -flags => 80 } ] },
    { -label => q{07.06 - Manual Trans External Contrs},
      -cpsc_obid => q{gcqoaedaec---z0admin-ad6},
      -cpsc => q{07.06.00},
      -chunk_obid => q{giEmR2dpdcmp1z0admin-baj},
      -chunk => q{070600},
      -flags => 88,
      -children => [
        { -label => q{07.06.01 - Driver-Operated External Controls},
          -cpsc_obid => q{gcqoafaaec---z0admin-ad6},
          -cpsc => q{07.06.01},
          -chunk_obid => q{giEmoVgpdcmp1z0admin-bai},
          -chunk => q{070601},
          -flags => 80 },
        { -label => q{07.06.02 - External Controls-Auxiliary Transmission-Range Splitter},
          -cpsc_obid => q{gcqoafiaec---z0admin-ad6},
          -cpsc => q{07.06.02},
          -chunk_obid => q{giEmoJapdcmp1z0admin-bah},
          -chunk => q{070602},
          -flags => 80 },
        { -label => q{07.06.03 - External Controls-Transfer Case},
          -cpsc_obid => q{gcqob1aaec---z0admin-ad7},
          -cpsc => q{07.06.03},
          -chunk_obid => q{giEmoWgpdcmp1z0admin-bai},
          -chunk => q{070603},
          -flags => 80 } ] },
    { -label => q{07.07 - Transfer Drive},
      -cpsc_obid => q{gcqob1iaec---z0admin-ad7},
      -cpsc => q{07.07.00},
      -chunk_obid => q{giEmoJhpdcmp1z0admin-bah},
      -chunk => q{070700},
      -flags => 88,
      -children => [
        { -label => q{07.07.01 - Housing and Seals},
          -cpsc_obid => q{gcqob2faec---z0admin-ad7},
          -cpsc => q{07.07.01},
          -chunk_obid => q{giEmR4cpdcmp1z0admin-baj},
          -chunk => q{070701},
          -flags => 80 },
        { -label => q{07.07.02 - Internal Controls},
          -cpsc_obid => q{gcqob3caec---z0admin-ad7},
          -cpsc => q{07.07.02},
          -chunk_obid => q{giEmoKjpdcmp1z0admin-bah},
          -chunk => q{070702},
          -flags => 80 },
        { -label => q{07.07.03 - Gear Sets Shafts and Bearings},
          -cpsc_obid => q{gcqob3kaec---z0admin-ad7},
          -cpsc => q{07.07.03},
          -chunk_obid => q{giEmoXjpdcmp1z0admin-bai},
          -chunk => q{070703},
          -flags => 80 } ] },
    { -label => q{07.08 - Power Take-Off},
      -cpsc_obid => q{gcqob4haec---z0admin-ad7},
      -cpsc => q{07.08.00},
      -chunk_obid => q{giEmoYipdcmp1z0admin-bai},
      -chunk => q{070800},
      -flags => 88,
      -children => [
        { -label => q{07.08.01 - Power Take-Off},
          -cpsc_obid => q{gcqob5eaec---z0admin-ad7},
          -cpsc => q{07.08.01},
          -chunk_obid => q{giEmoZhpdcmp1z0admin-bai},
          -chunk => q{070801},
          -flags => 80 } ] },
    { -label => q{07.09 - Reserved},
      -cpsc_obid => q{hbEpumdpdcmp1z0admin-cyp},
      -cpsc => q{07.09.00},
      -flags => 80 },
    { -label => q{07.10 - Reserved},
      -cpsc_obid => q{hbEpumgpdcmp1z0admin-cyp},
      -cpsc => q{07.10.00},
      -flags => 80 },
    { -label => q{07.11 - Reserved},
      -cpsc_obid => q{hbEpumipdcmp1z0admin-cyp},
      -cpsc => q{07.11.00},
      -flags => 80 },
    { -label => q{07.12 - Transmission Sound Control Subsystem},
      -cpsc_obid => q{gcqob6baec---z0admin-ad7},
      -cpsc => q{07.12.00},
      -chunk_obid => q{giEmR5hpdcmp1z0admin-baj},
      -chunk => q{071200},
      -flags => 88,
      -children => [
        { -label => q{07.12.01 - Sound Inhibitors},
          -cpsc_obid => q{gcqob6jaec---z0admin-ad7},
          -cpsc => q{07.12.01},
          -chunk_obid => q{giEmoMdpdcmp1z0admin-bah},
          -chunk => q{071201},
          -flags => 80 } ] },
    { -label => q{07.13 - Reserved},
      -cpsc_obid => q{hbEpumkpdcmp1z0admin-cyp},
      -cpsc => q{07.13.00},
      -flags => 80 },
    { -label => q{07.14 - Neutral Start Switch Subsystem},
      -cpsc_obid => q{gcqob7gaec---z0admin-ad7},
      -cpsc => q{07.14.00},
      -chunk_obid => q{giEmo0jpdcmp1z0admin-bai},
      -chunk => q{071400},
      -flags => 88,
      -children => [
        { -label => q{07.14.01 - Transmission Mounted Switches},
          -cpsc_obid => q{gcqocadaec---z0admin-ad7},
          -cpsc => q{07.14.01},
          -chunk_obid => q{giEmR6jpdcmp1z0admin-baj},
          -chunk => q{071401},
          -flags => 80 },
        { -label => q{07.14.02 - External Control Mounted Switches},
          -cpsc_obid => q{gcqocaiaec---z0admin-ad7},
          -cpsc => q{07.14.02},
          -chunk_obid => q{giEmR7ipdcmp1z0admin-baj},
          -chunk => q{071402},
          -flags => 80 } ] } ] },

{ -label => q{08 - Clutch System},
  -cpsc_obid => q{gcqoagjaec---z0admin-ad6},
  -cpsc => q{08.00.00},
  -chunk_obid => q{giEmo2apdcmp1z0admin-bai},
  -chunk => q{080000},
  -flags => 88,
  -children => [
    { -label => q{08.01 - Clutch and Housing},
      -cpsc_obid => q{gcqoahaaec---z0admin-ad6},
      -cpsc => q{08.01.00},
      -chunk_obid => q{giEmoNipdcmp1z0admin-bah},
      -chunk => q{080100},
      -flags => 88,
      -children => [
        { -label => q{08.01.01 - Flywheel Housing and Splash Protection},
          -cpsc_obid => q{gcqoahiaec---z0admin-ad6},
          -cpsc => q{08.01.01},
          -chunk_obid => q{giEmSakpdcmp1z0admin-baj},
          -chunk => q{080101},
          -flags => 80 },
        { -label => q{08.01.02 - Clutch Disc Assembly},
          -cpsc_obid => q{gcqoaifaec---z0admin-ad6},
          -cpsc => q{08.01.02},
          -chunk_obid => q{giEmo3cpdcmp1z0admin-bai},
          -chunk => q{080102},
          -flags => 80 },
        { -label => q{08.01.03 - Pressure Plate and Cover Assembly},
          -cpsc_obid => q{gcqoajcaec---z0admin-ad6},
          -cpsc => q{08.01.03},
          -chunk_obid => q{giEmSbgpdcmp1z0admin-baj},
          -chunk => q{080103},
          -flags => 80 } ] },
    { -label => q{08.02 - Clutch Controls},
      -cpsc_obid => q{gcqoajkaec---z0admin-ad6},
      -cpsc => q{08.02.00},
      -chunk_obid => q{giEmo4epdcmp1z0admin-bai},
      -chunk => q{080200},
      -flags => 88,
      -children => [
        { -label => q{08.02.01 - Internal Controls},
          -cpsc_obid => q{gcqoakhaec---z0admin-ad6},
          -cpsc => q{08.02.01},
          -chunk_obid => q{giEmoPgpdcmp1z0admin-bah},
          -chunk => q{080201},
          -flags => 80 },
        { -label => q{08.02.02 - External Controls - Mechanical},
          -cpsc_obid => q{gcqoaleaec---z0admin-ad6},
          -cpsc => q{08.02.02},
          -chunk_obid => q{giEmo5epdcmp1z0admin-bai},
          -chunk => q{080202},
          -flags => 80 },
        { -label => q{08.02.03 - External Controls - Hydraulic},
          -cpsc_obid => q{gcqoambaec---z0admin-ad6},
          -cpsc => q{08.02.03},
          -chunk_obid => q{giEmo6apdcmp1z0admin-bai},
          -chunk => q{080203},
          -flags => 80 },
        { -label => q{08.02.04 - Automatic Clutch},
          -cpsc_obid => q{gcqoamjaec---z0admin-ad6},
          -cpsc => q{08.02.04},
          -chunk_obid => q{giEmoQipdcmp1z0admin-bah},
          -chunk => q{080204},
          -flags => 80 },
        { -label => q{08.02.05 - External Controls - Electrical},
          -cpsc_obid => q{gcqoangaec---z0admin-ad6},
          -cpsc => q{08.02.05},
          -chunk_obid => q{giEmSdfpdcmp1z0admin-baj},
          -chunk => q{080205},
          -flags => 80 } ] } ] },

{ -label => q{09 - Exhaust System},
  -cpsc_obid => q{gcqokKfaec---z0admin-aea},
  -cpsc => q{09.00.00},
  -chunk_obid => q{giEmpmbpdcmp1z0admin-bai},
  -chunk => q{090000},
  -flags => 88,
  -children => [
    { -label => q{09.01 - Acoustical Control Components},
      -cpsc_obid => q{gcqokKhaec---z0admin-aea},
      -cpsc => q{09.01.00},
      -chunk_obid => q{giEmSsipdcmp1z0admin-baj},
      -chunk => q{090100},
      -flags => 88,
      -children => [
        { -label => q{09.01.01 - Mufflers},
          -cpsc_obid => q{gcqoaobaec---z0admin-ad6},
          -cpsc => q{09.01.01},
          -chunk_obid => q{giElbYdpdcmp1z0admin-baf},
          -chunk => q{090101},
          -flags => 80 },
        { -label => q{09.01.02 - Resonators},
          -cpsc_obid => q{gcqoaojaec---z0admin-ad6},
          -cpsc => q{09.01.02},
          -chunk_obid => q{giEmpnapdcmp1z0admin-bai},
          -chunk => q{090102},
          -flags => 80 },
        { -label => q{09.01.03 - Diffusers},
          -cpsc_obid => q{gcqoapgaec---z0admin-ad6},
          -cpsc => q{09.01.03},
          -chunk_obid => q{giEmpnhpdcmp1z0admin-bai},
          -chunk => q{090103},
          -flags => 80 } ] },
    { -label => q{09.02 - Exhaust Gas Treatment Components},
      -cpsc_obid => q{gcqoaqdaec---z0admin-ad6},
      -cpsc => q{09.02.00},
      -chunk_obid => q{giElbZfpdcmp1z0admin-baf},
      -chunk => q{090200},
      -flags => 88,
      -children => [
        { -label => q{09.02.01 - Catalytic Converter Assembly},
          -cpsc_obid => q{gcqoaraaec---z0admin-ad6},
          -cpsc => q{09.02.01},
          -chunk_obid => q{giEkhnkpdcmp1z0admin-bad},
          -chunk => q{090201},
          -flags => 80 },
        { -label => q{09.02.02 - Particulate Trap Assembly},
          -cpsc_obid => q{gcqoariaec---z0admin-ad6},
          -cpsc => q{09.02.02},
          -chunk_obid => q{giEmSvapdcmp1z0admin-baj},
          -chunk => q{090202},
          -flags => 80 } ] },
    { -label => q{09.03 - Exhaust Pipes and Supports},
      -cpsc_obid => q{gcqoasfaec---z0admin-ad6},
      -cpsc => q{09.03.00},
      -chunk_obid => q{giElb0dpdcmp1z0admin-baf},
      -chunk => q{090300},
      -flags => 88,
      -children => [
        { -label => q{09.03.01 - Exhaust Pipes},
          -cpsc_obid => q{gcqoatcaec---z0admin-ad6},
          -cpsc => q{09.03.01},
          -flags => 80 },
        { -label => q{09.03.02 - Exhaust System Seals},
          -cpsc_obid => q{gcqoatkaec---z0admin-ad6},
          -cpsc => q{09.03.02},
          -chunk_obid => q{giEkhpbpdcmp1z0admin-bad},
          -chunk => q{090302},
          -flags => 80 },
        { -label => q{09.03.03 - Exhaust System Supports},
          -cpsc_obid => q{gcqoauhaec---z0admin-ad6},
          -cpsc => q{09.03.03},
          -chunk_obid => q{giElb1fpdcmp1z0admin-baf},
          -chunk => q{090303},
          -flags => 80 } ] },
    { -label => q{09.04 - Shields and Attachments},
      -cpsc_obid => q{gcqoaveaec---z0admin-ad6},
      -cpsc => q{09.04.00},
      -chunk_obid => q{giEmSxbpdcmp1z0admin-baj},
      -chunk => q{090400},
      -flags => 88,
      -children => [
        { -label => q{09.04.01 - Protective Devices},
          -cpsc_obid => q{gcqoawbaec---z0admin-ad6},
          -cpsc => q{09.04.01},
          -chunk_obid => q{giEkhqdpdcmp1z0admin-bad},
          -chunk => q{090401},
          -flags => 80 } ] } ] },

{ -label => q{10 - Fuel System},
  -cpsc_obid => q{gcqoawjaec---z0admin-ad6},
  -cpsc => q{10.00.00},
  -chunk_obid => q{giEkhEapdcmp1z0admin-bad},
  -chunk => q{100000},
  -flags => 88,
  -children => [
    { -label => q{10.01 - Fuel Tank and Lines},
      -cpsc_obid => q{hhbnRXapdcmp1z0admin-g56},
      -cpsc => q{10.01.00},
      -flags => 88,
      -children => [
        { -label => q{10.01.01 - Fuel Tanks and Reservoirs},
          -cpsc_obid => q{gcqoaxiaec---z0admin-ad6},
          -cpsc => q{10.01.01},
          -flags => 80 },
        { -label => q{10.01.02 - Fuel Tank Supports},
          -cpsc_obid => q{gcqoayfaec---z0admin-ad6},
          -cpsc => q{10.01.02},
          -flags => 80 },
        { -label => q{10.01.03 - Fuel Lines and Filters Chassis},
          -cpsc_obid => q{gcqoazcaec---z0admin-ad6},
          -cpsc => q{10.01.03},
          -flags => 80 },
        { -label => q{10.01.04 - Filler Cap and Pipe},
          -cpsc_obid => q{gcqokLhaec---z0admin-aea},
          -cpsc => q{10.01.04},
          -flags => 80 },
        { -label => q{10.01.05 - Fuel Valves},
          -cpsc_obid => q{gcqokMeaec---z0admin-aea},
          -cpsc => q{10.01.05},
          -flags => 80 },
        { -label => q{10.01.06 - Electric Fuel Pumps},
          -cpsc_obid => q{gcqokNbaec---z0admin-aea},
          -cpsc => q{10.01.06},
          -flags => 80 },
        { -label => q{10.01.07 - Fuel},
          -cpsc_obid => q{gcqokNjaec---z0admin-aea},
          -cpsc => q{10.01.07},
          -flags => 80 } ] },
    { -label => q{10.02 - Reserved (see 03.18.00 for Foot-Operated Acceleration Control)},
      -cpsc_obid => q{gcqokOgaec---z0admin-aea},
      -cpsc => q{10.02.00},
      -flags => 88,
      -children => [
        { -label => q{10.02.01 - Reserved},
          -cpsc_obid => q{gcqokPdaec---z0admin-aea},
          -cpsc => q{10.02.01},
          -flags => 80 } ] },
    { -label => q{10.03 - Reserved (see 03.19.00 for Automatic Vehicle Speed Control)},
      -cpsc_obid => q{gcqokQaaec---z0admin-aea},
      -cpsc => q{10.03.00},
      -flags => 88,
      -children => [
        { -label => q{10.03.01 - Reserved},
          -cpsc_obid => q{gcqoazkaec---z0admin-ad6},
          -cpsc => q{10.03.01},
          -flags => 80 },
        { -label => q{10.03.02 - Reserved},
          -cpsc_obid => q{gcqoaAhaec---z0admin-ad6},
          -cpsc => q{10.03.02},
          -flags => 80 },
        { -label => q{10.03.03 - Reserved},
          -cpsc_obid => q{gcqokQiaec---z0admin-aea},
          -cpsc => q{10.03.03},
          -flags => 80 },
        { -label => q{10.03.04 - Reserved},
          -cpsc_obid => q{gcqokRfaec---z0admin-aea},
          -cpsc => q{10.03.04},
          -flags => 80 } ] },
    { -label => q{10.04 - Resrved (see 03.20.00 for Hand-Operated Fuel and Choke Control)},
      -cpsc_obid => q{gcqokScaec---z0admin-aea},
      -cpsc => q{10.04.00},
      -flags => 88,
      -children => [
        { -label => q{10.04.01 - Reserved},
          -cpsc_obid => q{gcqokSkaec---z0admin-aea},
          -cpsc => q{10.04.01},
          -flags => 80 },
        { -label => q{10.04.02 - Reserved},
          -cpsc_obid => q{gcqokThaec---z0admin-aea},
          -cpsc => q{10.04.02},
          -flags => 80 },
        { -label => q{10.04.03 - Reserved},
          -cpsc_obid => q{gcqokUeaec---z0admin-aea},
          -cpsc => q{10.04.03},
          -flags => 80 } ] },
    { -label => q{FTANK - Fuel Tank},
      -chunk_obid => q{giElcihpdcmp1z0admin-baf},
      -chunk => q{FTANK},
      -flags => 80 },
    { -label => q{FTSTRP - Fuel Tank Straps},
      -chunk_obid => q{giEkhFcpdcmp1z0admin-bad},
      -chunk => q{FTSTRP},
      -flags => 80 },
    { -label => q{HSHLD - Heat Shield},
      -chunk_obid => q{giElckdpdcmp1z0admin-baf},
      -chunk => q{HSHLD},
      -flags => 80 },
    { -label => q{SPLATE - Skid Plate},
      -chunk_obid => q{giElcjepdcmp1z0admin-baf},
      -chunk => q{SPLATE},
      -flags => 80 } ] },

{ -label => q{11 - Steering System},
  -cpsc_obid => q{gcqokVbaec---z0admin-aea},
  -cpsc => q{11.00.00},
  -flags => 88,
  -children => [
    { -label => q{11.01 - Manual Steering Gear},
      -cpsc_obid => q{gcqokVdaec---z0admin-aea},
      -cpsc => q{11.01.00},
      -flags => 88,
      -children => [
        { -label => q{11.01.01 - Manual Steering Gear},
          -cpsc_obid => q{gcqokWaaec---z0admin-aea},
          -cpsc => q{11.01.01},
          -flags => 80 } ] },
    { -label => q{11.02 - Power Steering},
      -cpsc_obid => q{gcqokWiaec---z0admin-aea},
      -cpsc => q{11.02.00},
      -flags => 88,
      -children => [
        { -label => q{11.02.01 - Integral Power Steering},
          -cpsc_obid => q{gcqokXfaec---z0admin-aea},
          -cpsc => q{11.02.01},
          -flags => 80 },
        { -label => q{11.02.02 - Linkage Boost Power Steering},
          -cpsc_obid => q{gcqokYcaec---z0admin-aea},
          -cpsc => q{11.02.02},
          -flags => 80 },
        { -label => q{11.02.03 - Hydraulic Distribution},
          -cpsc_obid => q{gcqokYkaec---z0admin-aea},
          -cpsc => q{11.02.03},
          -flags => 80 },
        { -label => q{11.02.04 - Power Steering Pump},
          -cpsc_obid => q{gcqokZhaec---z0admin-aea},
          -cpsc => q{11.02.04},
          -flags => 80 },
        { -label => q{11.02.05 - Power Steering Fluid},
          -cpsc_obid => q{gcqok0eaec---z0admin-aea},
          -cpsc => q{11.02.05},
          -flags => 80 },
        { -label => q{11.02.06 - Power Steering Electronic Controls},
          -cpsc_obid => q{gcqok1baec---z0admin-aea},
          -cpsc => q{11.02.06},
          -flags => 80 },
        { -label => q{11.02.07 - Power Steering Sensors any Actuators},
          -cpsc_obid => q{gcqok1jaec---z0admin-aea},
          -cpsc => q{11.02.07},
          -flags => 80 } ] },
    { -label => q{11.03 - Steering Linkage},
      -cpsc_obid => q{gcqok2gaec---z0admin-aea},
      -cpsc => q{11.03.00},
      -flags => 88,
      -children => [
        { -label => q{11.03.01 - Steering Linkage Components - Front},
          -cpsc_obid => q{gcqok3daec---z0admin-aea},
          -cpsc => q{11.03.01},
          -flags => 80 },
        { -label => q{11.03.02 - Steering Linkage Components - Rear},
          -cpsc_obid => q{gcqok4aaec---z0admin-aea},
          -cpsc => q{11.03.02},
          -flags => 80 } ] },
    { -label => q{11.04 - Steering Column},
      -cpsc_obid => q{gcqok4iaec---z0admin-aea},
      -cpsc => q{11.04.00},
      -flags => 88,
      -children => [
        { -label => q{*** See 11.05 - Steering Column Switches},
          -flags => 80 },
        { -label => q{11.04.01 - Steering Column and Shaft},
          -cpsc_obid => q{gcqok5faec---z0admin-aea},
          -cpsc => q{11.04.01},
          -flags => 80 },
        { -label => q{11.04.02 - Transmission Shift Mechanism},
          -cpsc_obid => q{gcqok6caec---z0admin-aea},
          -cpsc => q{11.04.02},
          -flags => 80 } ] },
    { -label => q{11.05 - Steering Column Switches},
      -cpsc_obid => q{gcqok6kaec---z0admin-aea},
      -cpsc => q{11.05.00},
      -flags => 88,
      -children => [
        { -label => q{11.05.01 - Steering Column-Turn Signal Switch},
          -cpsc_obid => q{gcqok7haec---z0admin-aea},
          -cpsc => q{11.05.01},
          -flags => 80 },
        { -label => q{11.05.02 - Steering Column-Ignition Switch},
          -cpsc_obid => q{gcqolaeaec---z0admin-aea},
          -cpsc => q{11.05.02},
          -flags => 80 },
        { -label => q{11.05.03 - Steering Column-Wiper/Washer Switch},
          -cpsc_obid => q{gcqolbbaec---z0admin-aea},
          -cpsc => q{11.05.03},
          -flags => 80 },
        { -label => q{11.05.04 - Steering Column-Headlamp Switch},
          -cpsc_obid => q{gcqolbjaec---z0admin-aea},
          -cpsc => q{11.05.04},
          -flags => 80 },
        { -label => q{11.05.05 - Steering Column-Stalk Speed Controls},
          -cpsc_obid => q{gcqolcgaec---z0admin-aea},
          -cpsc => q{11.05.05},
          -flags => 80 },
        { -label => q{11.05.06 - Steering Rotation Sensor},
          -cpsc_obid => q{gcqolddaec---z0admin-aea},
          -cpsc => q{11.05.06},
          -flags => 80 },
        { -label => q{11.05.07 - Steering Column-Remote Entertainment Controls},
          -cpsc_obid => q{gcqoleaaec---z0admin-aea},
          -cpsc => q{11.05.07},
          -flags => 80 } ] },
    { -label => q{11.06 - Steering Wheel},
      -cpsc_obid => q{gcqoleiaec---z0admin-aea},
      -cpsc => q{11.06.00},
      -flags => 88,
      -children => [
        { -label => q{11.06.01 - Steering Wheel},
          -cpsc_obid => q{gcqolffaec---z0admin-aea},
          -cpsc => q{11.06.01},
          -flags => 80 },
        { -label => q{11.06.02 - Steering Wheel - Electrical},
          -cpsc_obid => q{gcqolgcaec---z0admin-aea},
          -cpsc => q{11.06.02},
          -flags => 80 },
        { -label => q{11.06.03 - Steering Wheel Passive Restraints},
          -cpsc_obid => q{gcqolgkaec---z0admin-aea},
          -cpsc => q{11.06.03},
          -flags => 80 } ] },
    { -label => q{11.07 - 4WS Actuator and Actuator Control},
      -cpsc_obid => q{gcqolhhaec---z0admin-aea},
      -cpsc => q{11.07.00},
      -flags => 88,
      -children => [
        { -label => q{11.07.01 - Electromechanical Steering Actuator},
          -cpsc_obid => q{gcqolieaec---z0admin-aea},
          -cpsc => q{11.07.01},
          -flags => 80 },
        { -label => q{11.07.02 - Sensors},
          -cpsc_obid => q{gcqoljbaec---z0admin-aea},
          -cpsc => q{11.07.02},
          -flags => 80 },
        { -label => q{11.07.03 - Logic Module},
          -cpsc_obid => q{gcqoljjaec---z0admin-aea},
          -cpsc => q{11.07.03},
          -flags => 80 },
        { -label => q{11.07.04 - Motor Drive Module},
          -cpsc_obid => q{gcqolkgaec---z0admin-aea},
          -cpsc => q{11.07.04},
          -flags => 80 } ] } ] },

{ -label => q{12 - Climate Control System},
  -cpsc_obid => q{gcqolldaec---z0admin-aea},
  -cpsc => q{12.00.00},
  -flags => 88,
  -children => [
    { -label => q{12.01 - Air Handling/Body Ventilation},
      -cpsc_obid => q{gcqollfaec---z0admin-aea},
      -cpsc => q{12.01.00},
      -flags => 88,
      -children => [
        { -label => q{12.01.01 - Air Intake Components},
          -cpsc_obid => q{gcqolmcaec---z0admin-aea},
          -cpsc => q{12.01.01},
          -flags => 80 },
        { -label => q{12.01.02 - Air Distribution Components},
          -cpsc_obid => q{gcqolmkaec---z0admin-aea},
          -cpsc => q{12.01.02},
          -flags => 80 },
        { -label => q{12.01.03 - Air Extraction Components},
          -cpsc_obid => q{gcqolnhaec---z0admin-aea},
          -cpsc => q{12.01.03},
          -flags => 80 } ] },
    { -label => q{12.02 - Heating-Defrosting Subsystem},
      -cpsc_obid => q{gcqoloeaec---z0admin-aea},
      -cpsc => q{12.02.00},
      -flags => 88,
      -children => [
        { -label => q{12.02.01 - Heater Blower Less Electric Motor},
          -cpsc_obid => q{gcqolpbaec---z0admin-aea},
          -cpsc => q{12.02.01},
          -flags => 80 },
        { -label => q{12.02.02 - Heater Assembly},
          -cpsc_obid => q{gcqolpjaec---z0admin-aea},
          -cpsc => q{12.02.02},
          -flags => 80 },
        { -label => q{12.02.03 - Distribution},
          -cpsc_obid => q{gcqolqgaec---z0admin-aea},
          -cpsc => q{12.02.03},
          -flags => 80 },
        { -label => q{12.02.04 - Heater Hoses},
          -cpsc_obid => q{gcqolrdaec---z0admin-aea},
          -cpsc => q{12.02.04},
          -flags => 80 },
        { -label => q{12.02.05 - Backlight Defogging},
          -cpsc_obid => q{gcqolsaaec---z0admin-aea},
          -cpsc => q{12.02.05},
          -flags => 80 },
        { -label => q{12.02.06 - EV Electrical Heating Components},
          -cpsc_obid => q{gcqolsiaec---z0admin-aea},
          -cpsc => q{12.02.06},
          -flags => 80 },
        { -label => q{12.02.07 - EV Fuel-Fired Heater},
          -cpsc_obid => q{gcqoltfaec---z0admin-aea},
          -cpsc => q{12.02.07},
          -flags => 80 } ] },
    { -label => q{12.03 - Refrigeration-Air Conditioning Subsystem},
      -cpsc_obid => q{gcqolucaec---z0admin-aea},
      -cpsc => q{12.03.00},
      -flags => 88,
      -children => [
        { -label => q{12.03.01 - Compressor},
          -cpsc_obid => q{gcqolukaec---z0admin-aea},
          -cpsc => q{12.03.01},
          -flags => 80 },
        { -label => q{12.03.02 - Condenser-Receiver},
          -cpsc_obid => q{gcqolvhaec---z0admin-aea},
          -cpsc => q{12.03.02},
          -flags => 80 },
        { -label => q{12.03.03 - Evaporator-Heater Assembly},
          -cpsc_obid => q{gcqolweaec---z0admin-aea},
          -cpsc => q{12.03.03},
          -flags => 80 },
        { -label => q{12.03.04 - Distribution},
          -cpsc_obid => q{gcqolxbaec---z0admin-aea},
          -cpsc => q{12.03.04},
          -flags => 80 },
        { -label => q{12.03.05 - Air Conditioning Lines and Fittings},
          -cpsc_obid => q{gcqolxjaec---z0admin-aea},
          -cpsc => q{12.03.05},
          -flags => 80 } ] },
    { -label => q{12.04 - Control},
      -cpsc_obid => q{gcqolygaec---z0admin-aea},
      -cpsc => q{12.04.00},
      -flags => 88,
      -children => [
        { -label => q{12.04.01 - Fan Speed Control},
          -cpsc_obid => q{gcqolzdaec---z0admin-aea},
          -cpsc => q{12.04.01},
          -flags => 80 },
        { -label => q{12.04.02 - Manual Control Unit},
          -cpsc_obid => q{gcqolAaaec---z0admin-aea},
          -cpsc => q{12.04.02},
          -flags => 80 },
        { -label => q{12.04.03 - Automatic Control Unit},
          -cpsc_obid => q{gcqolAiaec---z0admin-aea},
          -cpsc => q{12.04.03},
          -flags => 80 } ] } ] },

{ -label => q{13 - Information, Gauge, and Warning Device System},
  -cpsc_obid => q{gcqolBfaec---z0admin-aea},
  -cpsc => q{13.00.00},
  -flags => 88,
  -children => [
    { -label => q{13.01 - Instrument Cluster},
      -cpsc_obid => q{gcqolBhaec---z0admin-aea},
      -cpsc => q{13.01.00},
      -chunk_obid => q{giEkTkdpdcmp1z0admin-bae},
      -chunk => q{130100},
      -flags => 88,
      -children => [
        { -label => q{13.01.01 - Instrument Cluster-Console Modules},
          -cpsc_obid => q{gcqolCeaec---z0admin-aea},
          -cpsc => q{13.01.01},
          -flags => 80 },
        { -label => q{13.01.02 - Printed Circuit},
          -cpsc_obid => q{gcqolDbaec---z0admin-aea},
          -cpsc => q{13.01.02},
          -flags => 80 },
        { -label => q{13.01.03 - Reserved},
          -cpsc_obid => q{hbEpuFcpdcmp1z0admin-cyp},
          -cpsc => q{13.01.03},
          -flags => 80 },
        { -label => q{13.01.04 - Instrument Panel Voltage Regulator},
          -cpsc_obid => q{gcqolDjaec---z0admin-aea},
          -cpsc => q{13.01.04},
          -flags => 80 } ] },
    { -label => q{13.02 - Speedometer-Odometer},
      -cpsc_obid => q{gcqolEgaec---z0admin-aea},
      -cpsc => q{13.02.00},
      -flags => 88,
      -children => [
        { -label => q{13.02.01 - Indicators and Cables},
          -cpsc_obid => q{gcqolFdaec---z0admin-aea},
          -cpsc => q{13.02.01},
          -flags => 80 } ] },
    { -label => q{13.03 - Fuel Level Indication},
      -cpsc_obid => q{gcqolGaaec---z0admin-aea},
      -cpsc => q{13.03.00},
      -flags => 88,
      -children => [
        { -label => q{13.03.01 - Fuel Senders and Gauges},
          -cpsc_obid => q{gcqolGiaec---z0admin-aea},
          -cpsc => q{13.03.01},
          -flags => 80 },
        { -label => q{13.03.02 - Low Fuel Warning Devices},
          -cpsc_obid => q{gcqolHfaec---z0admin-aea},
          -cpsc => q{13.03.02},
          -flags => 80 } ] },
    { -label => q{13.04 - Electrical Power Supply Indication},
      -cpsc_obid => q{gcqolIcaec---z0admin-aea},
      -cpsc => q{13.04.00},
      -flags => 88,
      -children => [
        { -label => q{13.04.01 - Electrical Power Supply Gauge-Warning Light},
          -cpsc_obid => q{gcqolIkaec---z0admin-aea},
          -cpsc => q{13.04.01},
          -flags => 80 } ] },
    { -label => q{13.05 - Misc. Pwrtrn Indication and Warning},
      -cpsc_obid => q{gcqolJhaec---z0admin-aea},
      -cpsc => q{13.05.00},
      -flags => 88,
      -children => [
        { -label => q{13.05.01 - Engine Operation Gauges},
          -cpsc_obid => q{gcqolKeaec---z0admin-aea},
          -cpsc => q{13.05.01},
          -flags => 80 },
        { -label => q{13.05.02 - Transmission Operation Gauges},
          -cpsc_obid => q{gcqoaBcaec---z0admin-ad6},
          -cpsc => q{13.05.02},
          -flags => 80 },
        { -label => q{13.05.03 - Axle Operation Gauges-Warning Lights},
          -cpsc_obid => q{gcqoaBkaec---z0admin-ad6},
          -cpsc => q{13.05.03},
          -flags => 80 } ] },
    { -label => q{13.06 - Horn},
      -cpsc_obid => q{gcqoaChaec---z0admin-ad6},
      -cpsc => q{13.06.00},
      -flags => 88,
      -children => [
        { -label => q{13.06.01 - Electric Horns},
          -cpsc_obid => q{gcqoaDeaec---z0admin-ad6},
          -cpsc => q{13.06.01},
          -flags => 80 },
        { -label => q{13.06.02 - Electric Horn Relay},
          -cpsc_obid => q{gcqoaEbaec---z0admin-ad6},
          -cpsc => q{13.06.02},
          -flags => 80 },
        { -label => q{13.06.03 - Air Horns},
          -cpsc_obid => q{gcqoaEjaec---z0admin-ad6},
          -cpsc => q{13.06.03},
          -flags => 80 } ] },
    { -label => q{13.07 - Clock-Timekeeping},
      -cpsc_obid => q{gcqoaFgaec---z0admin-ad6},
      -cpsc => q{13.07.00},
      -flags => 88,
      -children => [
        { -label => q{13.07.01 - Clock},
          -cpsc_obid => q{gcqoaGdaec---z0admin-ad6},
          -cpsc => q{13.07.01},
          -flags => 80 } ] },
    { -label => q{13.08 - Driver Information-Message Center},
      -cpsc_obid => q{gcqoaHaaec---z0admin-ad6},
      -cpsc => q{13.08.00},
      -flags => 88,
      -children => [
        { -label => q{13.08.01 - Information Processing},
          -cpsc_obid => q{gcqoaHiaec---z0admin-ad6},
          -cpsc => q{13.08.01},
          -flags => 80 },
        { -label => q{13.08.02 - Information Display},
          -cpsc_obid => q{gcqoaIfaec---z0admin-ad6},
          -cpsc => q{13.08.02},
          -flags => 80 },
        { -label => q{13.08.03 - Message Center Controls},
          -cpsc_obid => q{gcqoaJcaec---z0admin-ad6},
          -cpsc => q{13.08.03},
          -flags => 80 },
        { -label => q{13.08.04 - Information Sensing},
          -cpsc_obid => q{gcqoqAfaec---z0admin-aeb},
          -cpsc => q{13.08.04},
          -flags => 80 } ] },
    { -label => q{13.09 - Misc. Indication and Warning},
      -cpsc_obid => q{gcqoqBdaec---z0admin-aeb},
      -cpsc => q{13.09.00},
      -flags => 88,
      -children => [
        { -label => q{13.09.01 - Gauges-Warning Lights},
          -cpsc_obid => q{gcqoqCaaec---z0admin-aeb},
          -cpsc => q{13.09.01},
          -flags => 80 },
        { -label => q{13.09.02 - Warning Buzzers},
          -cpsc_obid => q{gcqoqCiaec---z0admin-aeb},
          -cpsc => q{13.09.02},
          -flags => 80 },
        { -label => q{13.09.03 - Vehicle Attitude -Headlamp Level Indicator},
          -cpsc_obid => q{gcqoaJkaec---z0admin-ad6},
          -cpsc => q{13.09.03},
          -flags => 80 } ] },
    { -label => q{13.10 - Brake Operation Indication},
      -cpsc_obid => q{gcqoaKhaec---z0admin-ad6},
      -cpsc => q{13.10.00},
      -flags => 88,
      -children => [
        { -label => q{13.10.01 - Warning Devices},
          -cpsc_obid => q{gcqoaLeaec---z0admin-ad6},
          -cpsc => q{13.10.01},
          -flags => 80 } ] },
    { -label => q{13.11 - Engine Oil Pressure Indication},
      -cpsc_obid => q{gcqoaMbaec---z0admin-ad6},
      -cpsc => q{13.11.00},
      -flags => 80 },
    { -label => q{13.12 - Engine Oil Level Indication},
      -cpsc_obid => q{gcqoqDdaec---z0admin-aeb},
      -cpsc => q{13.12.00},
      -flags => 80 },
    { -label => q{13.13 - Parking-Reversing Aid},
      -cpsc_obid => q{gcqoqEaaec---z0admin-aeb},
      -cpsc => q{13.13.00},
      -flags => 88,
      -children => [
        { -label => q{13.13.01 - Parking - Reversing Aid Control Module},
          -cpsc_obid => q{gcqoqEiaec---z0admin-aeb},
          -cpsc => q{13.13.01},
          -flags => 80 },
        { -label => q{13.13.02 - Parking - Reversing Aid Proximity Sensors},
          -cpsc_obid => q{gcqoqFfaec---z0admin-aeb},
          -cpsc => q{13.13.02},
          -flags => 80 },
        { -label => q{13.13.03 - Parking - Reversing Aid Visual Display},
          -cpsc_obid => q{gcqoqGcaec---z0admin-aeb},
          -cpsc => q{13.13.03},
          -flags => 80 },
        { -label => q{13.13.04 - Parking - Reversing Aid Driver Controls},
          -cpsc_obid => q{gcqoaMiaec---z0admin-ad6},
          -cpsc => q{13.13.04},
          -flags => 80 } ] },
    { -label => q{13.14 - Engine Oil Life Indication},
      -cpsc_obid => q{gcqoaNfaec---z0admin-ad6},
      -cpsc => q{13.14.00},
      -flags => 80 },
    { -label => q{13.15 - Engine Coolant Temperature Indication},
      -cpsc_obid => q{gcqoqHaaec---z0admin-aeb},
      -cpsc => q{13.15.00},
      -flags => 88,
      -children => [
        { -label => q{13.15.01 - Water Temperature Sender},
          -cpsc_obid => q{hbEpuOapdcmp1z0admin-cyp},
          -cpsc => q{13.15.01},
          -flags => 80 } ] },
    { -label => q{13.16 - Engine Coolant Level Indication},
      -cpsc_obid => q{gcqoqHiaec---z0admin-aeb},
      -cpsc => q{13.16.00},
      -flags => 80 },
    { -label => q{13.17 - Engine Speed/Tachometer},
      -cpsc_obid => q{gcqoqIfaec---z0admin-aeb},
      -cpsc => q{13.17.00},
      -flags => 80 },
    { -label => q{13.18 - Engine Intake Manf Pressure Indication},
      -cpsc_obid => q{gcqoqJcaec---z0admin-aeb},
      -cpsc => q{13.18.00},
      -flags => 80 },
    { -label => q{13.19 - Air Temperature Indication Subsystem},
      -cpsc_obid => q{gcqoqJkaec---z0admin-aeb},
      -cpsc => q{13.19.00},
      -flags => 80 },
    { -label => q{13.20 - Washer Fluid Level Indication Subsystem},
      -cpsc_obid => q{gcqoqKhaec---z0admin-aeb},
      -cpsc => q{13.20.00},
      -flags => 80 } ] },

{ -label => q{14 - Electrical Power Supply System},
  -cpsc_obid => q{gcqoqLeaec---z0admin-aeb},
  -cpsc => q{14.00.00},
  -flags => 88,
  -children => [
    { -label => q{14.01 - Service Battery},
      -cpsc_obid => q{gcqoqLgaec---z0admin-aeb},
      -cpsc => q{14.01.00},
      -flags => 88,
      -children => [
        { -label => q{14.01.01 - Battery},
          -cpsc_obid => q{gcqoqMdaec---z0admin-aeb},
          -cpsc => q{14.01.01},
          -flags => 80 },
        { -label => q{14.01.02 - Battery Hold-Down and Supports},
          -cpsc_obid => q{gcqoqNaaec---z0admin-aeb},
          -cpsc => q{14.01.02},
          -flags => 80 },
        { -label => q{14.01.03 - Battery Cables},
          -cpsc_obid => q{gcqoqNiaec---z0admin-aeb},
          -cpsc => q{14.01.03},
          -flags => 80 } ] },
    { -label => q{14.02 - Generator Alternator and Regulator},
      -cpsc_obid => q{gcqoqOfaec---z0admin-aeb},
      -cpsc => q{14.02.00},
      -flags => 88,
      -children => [
        { -label => q{14.02.01 - Generator-Alternator},
          -cpsc_obid => q{gcqoqPcaec---z0admin-aeb},
          -cpsc => q{14.02.01},
          -flags => 80 },
        { -label => q{14.02.02 - Regulator},
          -cpsc_obid => q{gcqoqPkaec---z0admin-aeb},
          -cpsc => q{14.02.02},
          -flags => 80 } ] },
    { -label => q{14.03 - EV High Voltage Traction Battery},
      -cpsc_obid => q{gcqoqQhaec---z0admin-aeb},
      -cpsc => q{14.03.00},
      -flags => 88,
      -children => [
        { -label => q{14.03.01 - Traction Battery},
          -cpsc_obid => q{gcqoqReaec---z0admin-aeb},
          -cpsc => q{14.03.01},
          -flags => 80 },
        { -label => q{14.03.02 - Traction Battery Holdown and Supports},
          -cpsc_obid => q{gcqoqSbaec---z0admin-aeb},
          -cpsc => q{14.03.02},
          -flags => 80 },
        { -label => q{14.03.03 - Traction Battery Cables},
          -cpsc_obid => q{gcqoqSjaec---z0admin-aeb},
          -cpsc => q{14.03.03},
          -flags => 80 },
        { -label => q{14.03.04 - Traction Battery Charger},
          -cpsc_obid => q{gcqoqTgaec---z0admin-aeb},
          -cpsc => q{14.03.04},
          -flags => 80 },
        { -label => q{14.03.05 - Traction Battery Controller},
          -cpsc_obid => q{gcqoqUdaec---z0admin-aeb},
          -cpsc => q{14.03.05},
          -flags => 80 },
        { -label => q{14.03.06 - Traction Battery Cooling},
          -cpsc_obid => q{gcqoqVaaec---z0admin-aeb},
          -cpsc => q{14.03.06},
          -flags => 80 } ] },
    { -label => q{14.05 - Voltage Converter-Inverter},
      -cpsc_obid => q{gcqoqViaec---z0admin-aeb},
      -cpsc => q{14.05.00},
      -flags => 88,
      -children => [
        { -label => q{14.05.01 - Converter},
          -cpsc_obid => q{gcqoqWfaec---z0admin-aeb},
          -cpsc => q{14.05.01},
          -flags => 80 },
        { -label => q{14.05.02 - Inverter},
          -cpsc_obid => q{gcqoqXcaec---z0admin-aeb},
          -cpsc => q{14.05.02},
          -flags => 80 },
        { -label => q{14.05.03 - Converter-Inverter Cooling},
          -cpsc_obid => q{gcqoqXkaec---z0admin-aeb},
          -cpsc => q{14.05.03},
          -flags => 80 } ] } ] },

{ -label => q{15 - In-Vehicle Entertainment System},
  -cpsc_obid => q{gcqoqYhaec---z0admin-aeb},
  -cpsc => q{15.00.00},
  -chunk_obid => q{giEkTwkpdcmp1z0admin-bae},
  -chunk => q{150000},
  -flags => 88,
  -children => [
    { -label => q{15.01 - Receiver and Audio Media},
      -cpsc_obid => q{gcqoqYjaec---z0admin-aeb},
      -cpsc => q{15.01.00},
      -chunk_obid => q{giEkThfpdcmp1z0admin-bae},
      -chunk => q{150100},
      -flags => 88,
      -children => [
        { -label => q{15.01.01 - Receiver},
          -cpsc_obid => q{gcqoqZgaec---z0admin-aeb},
          -cpsc => q{15.01.01},
          -flags => 80 },
        { -label => q{15.01.02 - Receiver and Intergrated Media},
          -cpsc_obid => q{gcqoq0caec---z0admin-aeb},
          -cpsc => q{15.01.02},
          -flags => 80 },
        { -label => q{15.01.03 - Power Amplifier},
          -cpsc_obid => q{gcqoq0kaec---z0admin-aeb},
          -cpsc => q{15.01.03},
          -flags => 80 },
        { -label => q{15.01.04 - Primary Radio Controls and Display w-o receiver},
          -cpsc_obid => q{gcqoq1haec---z0admin-aeb},
          -cpsc => q{15.01.04},
          -flags => 80 },
        { -label => q{15.01.05 - Primary Radio Controls and Integral Media w-o reciever},
          -cpsc_obid => q{gcqosTdaec---z0admin-aec},
          -cpsc => q{15.01.05},
          -flags => 80 },
        { -label => q{15.01.06 - Remote Receivers},
          -cpsc_obid => q{gcqosUbaec---z0admin-aec},
          -cpsc => q{15.01.06},
          -flags => 80 },
        { -label => q{15.01.07 - Secondary Radio Controller and Equalization},
          -cpsc_obid => q{gcqoaOeaec---z0admin-ad6},
          -cpsc => q{15.01.07},
          -flags => 80 },
        { -label => q{15.01.08 - Separate Entertainment Media Players},
          -cpsc_obid => q{gcqoaPbaec---z0admin-ad6},
          -cpsc => q{15.01.08},
          -flags => 80 },
        { -label => q{CDJCKY - CD Disc Jockey},
          -chunk_obid => q{giEkgZfpdcmp1z0admin-bac},
          -chunk => q{CDJCKY},
          -flags => 80 },
        { -label => q{IRADIO - IP Radio},
          -chunk_obid => q{giEeaHhpdcmp1z0admin-bab},
          -chunk => q{IRADIO},
          -flags => 80 } ] },
    { -label => q{15.02 - Antenna},
      -cpsc_obid => q{gcqoaPjaec---z0admin-ad6},
      -cpsc => q{15.02.00},
      -flags => 88,
      -children => [
        { -label => q{15.02.01 - Fixed-Manual Antenna},
          -cpsc_obid => q{gcqoaQgaec---z0admin-ad6},
          -cpsc => q{15.02.01},
          -flags => 80 },
        { -label => q{15.02.02 - Power Operated Antenna},
          -cpsc_obid => q{gcqoaRdaec---z0admin-ad6},
          -cpsc => q{15.02.02},
          -flags => 80 },
        { -label => q{15.02.03 - Power Antenna Switch},
          -cpsc_obid => q{gcqoaSaaec---z0admin-ad6},
          -cpsc => q{15.02.03},
          -flags => 80 },
        { -label => q{15.02.04 - Electronic Antenna},
          -cpsc_obid => q{gcqoaSiaec---z0admin-ad6},
          -cpsc => q{15.02.04},
          -flags => 80 } ] },
    { -label => q{15.03 - Speaker},
      -cpsc_obid => q{gcqoaTfaec---z0admin-ad6},
      -cpsc => q{15.03.00},
      -flags => 88,
      -children => [
        { -label => q{15.03.01 - Speakers},
          -cpsc_obid => q{gcqosVbaec---z0admin-aec},
          -cpsc => q{15.03.01},
          -flags => 80 },
        { -label => q{15.03.02 - Speakers with Integral Amplifiers},
          -cpsc_obid => q{gcqosVjaec---z0admin-aec},
          -cpsc => q{15.03.02},
          -flags => 80 } ] },
    { -label => q{15.04 - Reserved},
      -cpsc_obid => q{hbEpuVhpdcmp1z0admin-cyp},
      -cpsc => q{15.04.00},
      -flags => 80 },
    { -label => q{15.05 - Radio Noise Suppression},
      -cpsc_obid => q{gcqosWgaec---z0admin-aec},
      -cpsc => q{15.05.00},
      -flags => 88,
      -children => [
        { -label => q{15.05.01 - Radio Frequency Interference RFI Suppression},
          -cpsc_obid => q{gcqosXdaec---z0admin-aec},
          -cpsc => q{15.05.01},
          -flags => 80 },
        { -label => q{15.05.02 - In Car Entertainment-Communication Interference Suppression},
          -cpsc_obid => q{gcqosYaaec---z0admin-aec},
          -cpsc => q{15.05.02},
          -flags => 80 } ] },
    { -label => q{RADIO - Radio},
      -chunk_obid => q{giEea5cpdcmp1z0admin-bab},
      -chunk => q{RADIO},
      -flags => 88,
      -children => [
        { -label => q{RADCBH - Radio Circuit Board and Heat Sink},
          -chunk_obid => q{giEea7apdcmp1z0admin-bab},
          -chunk => q{RADCBH},
          -flags => 88,
          -children => [
            { -label => q{RADCBR - Radio Circuit Board},
              -chunk_obid => q{giElbBcpdcmp1z0admin-baf},
              -chunk => q{RADCBR},
              -flags => 88,
              -children => [
                { -label => q{RADBRD - Radio Board},
                  -chunk_obid => q{giEkhkjpdcmp1z0admin-bac},
                  -chunk => q{RADBRD},
                  -flags => 80 },
                { -label => q{RADECM - Radio Electrical Components},
                  -chunk_obid => q{giElbCepdcmp1z0admin-baf},
                  -chunk => q{RADECM},
                  -flags => 80 },
                { -label => q{RADTUN - Radio Tuner},
                  -chunk_obid => q{giEkhjkpdcmp1z0admin-bac},
                  -chunk => q{RADTUN},
                  -flags => 80 } ] },
            { -label => q{RADHS - Radio Heat Sink},
              -chunk_obid => q{giEkTzbpdcmp1z0admin-bae},
              -chunk => q{RADHS},
              -flags => 80 } ] },
        { -label => q{RADCTR - Radio Connector},
          -chunk_obid => q{giEea6bpdcmp1z0admin-bab},
          -chunk => q{RADCTR},
          -flags => 80 },
        { -label => q{RADHSG - Radio Housing},
          -chunk_obid => q{giEkTAapdcmp1z0admin-bae},
          -chunk => q{RADHSG},
          -flags => 80 } ] } ] },

{ -label => q{16 - Vacuum Distribution System},
  -cpsc_obid => q{gcqosYiaec---z0admin-aec},
  -cpsc => q{16.00.00},
  -flags => 88,
  -children => [
    { -label => q{16.01 - Body Vacuum},
      -cpsc_obid => q{gcqosYkaec---z0admin-aec},
      -cpsc => q{16.01.00},
      -flags => 88,
      -children => [
        { -label => q{16.01.01 - Body Vacuum Components},
          -cpsc_obid => q{gcqoq2daec---z0admin-aeb},
          -cpsc => q{16.01.01},
          -flags => 80 } ] },
    { -label => q{16.02 - Chassis Vacuum},
      -cpsc_obid => q{gcqoq3aaec---z0admin-aeb},
      -cpsc => q{16.02.00},
      -flags => 88,
      -children => [
        { -label => q{16.02.01 - Chassis Vacuum Components},
          -cpsc_obid => q{gcqoq3iaec---z0admin-aeb},
          -cpsc => q{16.02.01},
          -flags => 80 } ] },
    { -label => q{16.03 - Transmission Vacuum},
      -cpsc_obid => q{gcqoq4faec---z0admin-aeb},
      -cpsc => q{16.03.00},
      -flags => 88,
      -children => [
        { -label => q{16.03.01 - Transmission Vacuum Components},
          -cpsc_obid => q{gcqoq5caec---z0admin-aeb},
          -cpsc => q{16.03.01},
          -flags => 80 } ] },
    { -label => q{16.04 - Vacuum Generator},
      -cpsc_obid => q{gcqoq5kaec---z0admin-aeb},
      -cpsc => q{16.04.00},
      -flags => 88,
      -children => [
        { -label => q{16.04.01 - Vacuum Generator Components},
          -cpsc_obid => q{gcqoq6haec---z0admin-aeb},
          -cpsc => q{16.04.01},
          -flags => 80 },
        { -label => q{16.04.02 - Vacuum Motor Electrical},
          -cpsc_obid => q{gcqoq7eaec---z0admin-aeb},
          -cpsc => q{16.04.02},
          -flags => 80 } ] } ] },

{ -label => q{17 - Lighting System},
  -cpsc_obid => q{gcqorabaec---z0admin-aeb},
  -cpsc => q{17.00.00},
  -flags => 88,
  -children => [
    { -label => q{17.01 - Front Lighting},
      -cpsc_obid => q{gcqoradaec---z0admin-aeb},
      -cpsc => q{17.01.00},
      -flags => 88,
      -children => [
        { -label => q{17.01.01 - Headlamps High and Low Beam and Headlamp Adjusting Components},
          -cpsc_obid => q{gcqorbaaec---z0admin-aeb},
          -cpsc => q{17.01.01},
          -flags => 80 },
        { -label => q{17.01.02 - Turn Indicating Lamps},
          -cpsc_obid => q{gcqosZhaec---z0admin-aec},
          -cpsc => q{17.01.02},
          -flags => 80 },
        { -label => q{17.01.03 - Position and Parking Lamps Unique Components Only},
          -cpsc_obid => q{gcqos0eaec---z0admin-aec},
          -cpsc => q{17.01.03},
          -flags => 80 },
        { -label => q{17.01.04 - Auxiliary Lamps Fog Lamps Spot Lamps etc.},
          -cpsc_obid => q{gcqos1baec---z0admin-aec},
          -cpsc => q{17.01.04},
          -flags => 80 },
        { -label => q{17.01.05 - Front Side Markers - Reflex Reflectors},
          -cpsc_obid => q{gcqos1jaec---z0admin-aec},
          -cpsc => q{17.01.05},
          -flags => 80 },
        { -label => q{17.01.06 - Roof Marker Lamps - Reflectors},
          -cpsc_obid => q{gcqos2gaec---z0admin-aec},
          -cpsc => q{17.01.06},
          -flags => 80 },
        { -label => q{17.01.07 - Cornering Lamps},
          -cpsc_obid => q{gcqos3daec---z0admin-aec},
          -cpsc => q{17.01.07},
          -flags => 80 } ] },
    { -label => q{17.02 - Interior Lighting},
      -cpsc_obid => q{gcqos4aaec---z0admin-aec},
      -cpsc => q{17.02.00},
      -flags => 88,
      -children => [
        { -label => q{17.02.01 - Engine Compartment Lighting},
          -cpsc_obid => q{gcqos4iaec---z0admin-aec},
          -cpsc => q{17.02.01},
          -flags => 80 },
        { -label => q{17.02.02 - Courtesy Lighting-Identification},
          -cpsc_obid => q{gcqos5faec---z0admin-aec},
          -cpsc => q{17.02.02},
          -flags => 80 },
        { -label => q{17.02.03 - Luggage Compartment Lighting},
          -cpsc_obid => q{gcqos6caec---z0admin-aec},
          -cpsc => q{17.02.03},
          -flags => 80 },
        { -label => q{17.02.04 - Lock Cylinder Lamp},
          -cpsc_obid => q{gcqos6kaec---z0admin-aec},
          -cpsc => q{17.02.04},
          -flags => 80 } ] },
    { -label => q{17.03 - Rear Lighting},
      -cpsc_obid => q{gcqos7haec---z0admin-aec},
      -cpsc => q{17.03.00},
      -flags => 88,
      -children => [
        { -label => q{17.03.01 - Rear Stop-Taillamps},
          -cpsc_obid => q{gcqotaeaec---z0admin-aec},
          -cpsc => q{17.03.01},
          -flags => 80 },
        { -label => q{17.03.02 - Back-Up Lamps},
          -cpsc_obid => q{gcqotbbaec---z0admin-aec},
          -cpsc => q{17.03.02},
          -flags => 80 },
        { -label => q{17.03.03 - Turn Indicating Lamps},
          -cpsc_obid => q{gcqotbjaec---z0admin-aec},
          -cpsc => q{17.03.03},
          -flags => 80 },
        { -label => q{17.03.04 - Auxiliary Lamps Flood Lamp},
          -cpsc_obid => q{gcqorbiaec---z0admin-aeb},
          -cpsc => q{17.03.04},
          -flags => 80 },
        { -label => q{17.03.05 - Rear Side Markers-Reflex Reflectors},
          -cpsc_obid => q{gcqorcfaec---z0admin-aeb},
          -cpsc => q{17.03.05},
          -flags => 80 },
        { -label => q{17.03.06 - Rear Reflex Reflectors},
          -cpsc_obid => q{gcqordcaec---z0admin-aeb},
          -cpsc => q{17.03.06},
          -flags => 80 },
        { -label => q{17.03.07 - Coach Lamps},
          -cpsc_obid => q{gcqordkaec---z0admin-aeb},
          -cpsc => q{17.03.07},
          -flags => 80 },
        { -label => q{17.03.08 - License Plate Illumination},
          -cpsc_obid => q{gcqorehaec---z0admin-aeb},
          -cpsc => q{17.03.08},
          -flags => 80 } ] },
    { -label => q{17.04 - Lighting-Special Mechanisms},
      -cpsc_obid => q{gcqorfeaec---z0admin-aeb},
      -cpsc => q{17.04.00},
      -flags => 88,
      -children => [
        { -label => q{17.04.01 - Headlamp Leveling},
          -cpsc_obid => q{gcqorgbaec---z0admin-aeb},
          -cpsc => q{17.04.01},
          -flags => 80 },
        { -label => q{17.04.02 - Headlamp Automatic On-Off-Delay Autolamp},
          -cpsc_obid => q{gcqorgjaec---z0admin-aeb},
          -cpsc => q{17.04.02},
          -flags => 80 },
        { -label => q{17.04.03 - Headlamp Automatic Dimmer Autodimmer},
          -cpsc_obid => q{gcqorhgaec---z0admin-aeb},
          -cpsc => q{17.04.03},
          -flags => 80 },
        { -label => q{17.04.04 - Headlamp Hiding},
          -cpsc_obid => q{gcqoridaec---z0admin-aeb},
          -cpsc => q{17.04.04},
          -flags => 80 },
        { -label => q{17.04.05 - Electric Motors},
          -cpsc_obid => q{gcqorjaaec---z0admin-aeb},
          -cpsc => q{17.04.05},
          -flags => 80 },
        { -label => q{17.04.06 - Daytime Running Light Control Module},
          -cpsc_obid => q{gcqorjiaec---z0admin-aeb},
          -cpsc => q{17.04.06},
          -flags => 80 } ] },
    { -label => q{17.05 - Lighting Switches},
      -cpsc_obid => q{gcqorkfaec---z0admin-aeb},
      -cpsc => q{17.05.00},
      -flags => 88,
      -children => [
        { -label => q{17.05.01 - Headlamp Switches},
          -cpsc_obid => q{gcqorlcaec---z0admin-aeb},
          -cpsc => q{17.05.01},
          -flags => 80 },
        { -label => q{17.05.02 - Auxiliary Lamp Switches},
          -cpsc_obid => q{gcqorlkaec---z0admin-aeb},
          -cpsc => q{17.05.02},
          -flags => 80 },
        { -label => q{17.05.03 - Interior Lamp Switches},
          -cpsc_obid => q{gcqormhaec---z0admin-aeb},
          -cpsc => q{17.05.03},
          -flags => 80 },
        { -label => q{17.05.04 - Hazard Warning Switches},
          -cpsc_obid => q{gcqorneaec---z0admin-aeb},
          -cpsc => q{17.05.04},
          -flags => 80 },
        { -label => q{17.05.05 - Headlamp Dimmer Switches},
          -cpsc_obid => q{gcqorobaec---z0admin-aeb},
          -cpsc => q{17.05.05},
          -flags => 80 } ] },
    { -label => q{17.06 - Interior Illumination},
      -cpsc_obid => q{gcqorojaec---z0admin-aeb},
      -cpsc => q{17.06.00},
      -flags => 80 } ] },

{ -label => q{18 - Electrical Distribution and Electronic Control System},
  -cpsc_obid => q{gcqorpgaec---z0admin-aeb},
  -cpsc => q{18.00.00},
  -flags => 88,
  -children => [
    { -label => q{18.01 - Electrical Wiring and Circuit Prot},
      -cpsc_obid => q{gcqorpiaec---z0admin-aeb},
      -cpsc => q{18.01.00},
      -flags => 88,
      -children => [
        { -label => q{18.01.01 - Front End and Engine Compartment Wiring},
          -cpsc_obid => q{gcqorqfaec---z0admin-aeb},
          -cpsc => q{18.01.01},
          -flags => 80 },
        { -label => q{18.01.02 - Instrument Panel and Cowl Wiring},
          -cpsc_obid => q{gcqorrcaec---z0admin-aeb},
          -cpsc => q{18.01.02},
          -flags => 80 },
        { -label => q{18.01.03 - Body and Rear End Wiring},
          -cpsc_obid => q{gcqorrkaec---z0admin-aeb},
          -cpsc => q{18.01.03},
          -flags => 80 },
        { -label => q{18.01.04 - Trailer Wiring-Relays},
          -cpsc_obid => q{gcqorshaec---z0admin-aeb},
          -cpsc => q{18.01.04},
          -flags => 80 },
        { -label => q{18.01.05 - Single Wires},
          -cpsc_obid => q{gcqorteaec---z0admin-aeb},
          -cpsc => q{18.01.05},
          -flags => 80 },
        { -label => q{18.01.06 - Fuse Panels, Fuses, and Circuit Breakers},
          -cpsc_obid => q{gcqorubaec---z0admin-aeb},
          -cpsc => q{18.01.06},
          -flags => 80 },
        { -label => q{18.01.07 - Wiring Connector Terminal Socket Relay and Module Fasteners},
          -cpsc_obid => q{gcqorujaec---z0admin-aeb},
          -cpsc => q{18.01.07},
          -flags => 80 },
        { -label => q{18.01.08 - Diagnostic Connector-Wiring},
          -cpsc_obid => q{gcqorvgaec---z0admin-aeb},
          -cpsc => q{18.01.08},
          -flags => 80 },
        { -label => q{18.01.09 - Multiplex Junction Blocks and Connectors},
          -cpsc_obid => q{gcqotcgaec---z0admin-aec},
          -cpsc => q{18.01.09},
          -flags => 80 } ] },
    { -label => q{18.02 - Flashers},
      -cpsc_obid => q{gcqotddaec---z0admin-aec},
      -cpsc => q{18.02.00},
      -flags => 88,
      -children => [
        { -label => q{18.02.01 - Turn Signal Flashers},
          -cpsc_obid => q{gcqoteaaec---z0admin-aec},
          -cpsc => q{18.02.01},
          -flags => 80 },
        { -label => q{18.02.02 - Hazard Warning-Heavy Duty Flashers},
          -cpsc_obid => q{gcqoteiaec---z0admin-aec},
          -cpsc => q{18.02.02},
          -flags => 80 },
        { -label => q{18.02.03 - Driver Warning Indicator Flashers},
          -cpsc_obid => q{gcqotffaec---z0admin-aec},
          -cpsc => q{18.02.03},
          -flags => 80 },
        { -label => q{18.02.04 - Headlamp Flashers},
          -cpsc_obid => q{gcqotgcaec---z0admin-aec},
          -cpsc => q{18.02.04},
          -flags => 80 } ] },
    { -label => q{18.03 - Electrical Distribution Switches Subsystem},
      -cpsc_obid => q{gcqotgkaec---z0admin-aec},
      -cpsc => q{18.03.00},
      -flags => 88,
      -children => [
        { -label => q{18.03.01 - Ignition Switches},
          -cpsc_obid => q{gcqothhaec---z0admin-aec},
          -cpsc => q{18.03.01},
          -flags => 80 } ] },
    { -label => q{18.04 - Miscellaneous Electrical Devices},
      -cpsc_obid => q{gcqotieaec---z0admin-aec},
      -cpsc => q{18.04.00},
      -flags => 88,
      -children => [
        { -label => q{18.04.01 - Cigar Lighters},
          -cpsc_obid => q{gcqotjbaec---z0admin-aec},
          -cpsc => q{18.04.01},
          -flags => 80 } ] },
    { -label => q{18.05 - Reserved},
      -cpsc_obid => q{hbEqEYhpdcmp1z0admin-cyy},
      -cpsc => q{18.05.00},
      -flags => 80 },
    { -label => q{18.06 - EV Traction and High Voltage Pwr Dstr},
      -cpsc_obid => q{gcqotjjaec---z0admin-aec},
      -cpsc => q{18.06.00},
      -flags => 88,
      -children => [
        { -label => q{18.06.01 - Contactor Box},
          -cpsc_obid => q{gcqotkgaec---z0admin-aec},
          -cpsc => q{18.06.01},
          -flags => 80 } ] },
    { -label => q{18.07 - EV Power Electric Center (PEC)},
      -cpsc_obid => q{gcqotldaec---z0admin-aec},
      -cpsc => q{18.07.00},
      -flags => 80 },
    { -label => q{18.08 - EV System Controller},
      -cpsc_obid => q{gcqotmaaec---z0admin-aec},
      -cpsc => q{18.08.00},
      -flags => 80 } ] },

{ -label => q{19 - Electronic Features Group},
  -cpsc_obid => q{gcqotmiaec---z0admin-aec},
  -cpsc => q{19.00.00},
  -flags => 88,
  -children => [
    { -label => q{19.01 - Anti-Theft Warning},
      -cpsc_obid => q{gcqotmkaec---z0admin-aec},
      -cpsc => q{19.01.00},
      -flags => 88,
      -children => [
        { -label => q{19.01.01 - Control Module},
          -cpsc_obid => q{gcqotnhaec---z0admin-aec},
          -cpsc => q{19.01.01},
          -flags => 80 },
        { -label => q{19.01.02 - Sensors and Switches},
          -cpsc_obid => q{gcqotoeaec---z0admin-aec},
          -cpsc => q{19.01.02},
          -flags => 80 },
        { -label => q{19.01.03 - Horns and Buzzers},
          -cpsc_obid => q{gcqotpbaec---z0admin-aec},
          -cpsc => q{19.01.03},
          -flags => 80 } ] },
    { -label => q{19.02 - Remote Convenience},
      -cpsc_obid => q{gcqotpjaec---z0admin-aec},
      -cpsc => q{19.02.00},
      -flags => 88,
      -children => [
        { -label => q{19.02.01 - Radio Command Signal Transmitters},
          -cpsc_obid => q{gcqotqgaec---z0admin-aec},
          -cpsc => q{19.02.01},
          -flags => 80 },
        { -label => q{19.02.02 - Radio Command Signal Receivers},
          -cpsc_obid => q{gcqotrdaec---z0admin-aec},
          -cpsc => q{19.02.02},
          -flags => 80 },
        { -label => q{19.02.03 - Electronic Control Logic Module},
          -cpsc_obid => q{gcqotsaaec---z0admin-aec},
          -cpsc => q{19.02.03},
          -flags => 80 },
        { -label => q{19.02.04 - Pager},
          -cpsc_obid => q{gcqotsiaec---z0admin-aec},
          -cpsc => q{19.02.04},
          -flags => 80 } ] },
    { -label => q{19.03 - Intelligent Cruise Control},
      -cpsc_obid => q{gcqorweaec---z0admin-aeb},
      -cpsc => q{19.03.00},
      -flags => 88,
      -children => [
        { -label => q{19.03.01 - Headway Sensor Module},
          -cpsc_obid => q{gcqorxbaec---z0admin-aeb},
          -cpsc => q{19.03.01},
          -flags => 80 } ] },
    { -label => q{19.04 - Side Vision},
      -cpsc_obid => q{gcqorxjaec---z0admin-aeb},
      -cpsc => q{19.04.00},
      -flags => 80 },
    { -label => q{19.05 - Vehicle Emergency Message (VEMS)},
      -cpsc_obid => q{gcqorygaec---z0admin-aeb},
      -cpsc => q{19.05.00},
      -flags => 88,
      -children => [
        { -label => q{19.05.01 - VEMS Control Module},
          -cpsc_obid => q{hbEqfkhpdcmp1z0admin-cyx},
          -cpsc => q{19.05.01},
          -flags => 80 } ] },
    { -label => q{19.06 - Voice Control Subsystem},
      -cpsc_obid => q{gcqorzdaec---z0admin-aeb},
      -cpsc => q{19.06.00},
      -flags => 88,
      -children => [
        { -label => q{19.06.01 - Voice Control Electronic Module},
          -cpsc_obid => q{gcqorAaaec---z0admin-aeb},
          -cpsc => q{19.06.01},
          -flags => 80 },
        { -label => q{19.06.02 - Voice Control Switches},
          -cpsc_obid => q{gcqorAiaec---z0admin-aeb},
          -cpsc => q{19.06.02},
          -flags => 80 },
        { -label => q{19.06.03 - Microphone},
          -cpsc_obid => q{gcqoycdaec---z0admin-aed},
          -cpsc => q{19.06.03},
          -flags => 80 } ] },
    { -label => q{19.07 - Vehicle Route Guidance-Navigation},
      -cpsc_obid => q{gcqoydbaec---z0admin-aed},
      -cpsc => q{19.07.00},
      -flags => 88,
      -children => [
        { -label => q{19.07.01 - Navigation Computer},
          -cpsc_obid => q{gcqoydjaec---z0admin-aed},
          -cpsc => q{19.07.01},
          -flags => 80 },
        { -label => q{19.07.02 - Navigation Data Base},
          -cpsc_obid => q{gcqoyegaec---z0admin-aed},
          -cpsc => q{19.07.02},
          -flags => 80 },
        { -label => q{19.07.03 - Navigation Display Controls},
          -cpsc_obid => q{gcqoyfdaec---z0admin-aed},
          -cpsc => q{19.07.03},
          -flags => 80 },
        { -label => q{19.07.04 - Navigation Controls},
          -cpsc_obid => q{gcqoygaaec---z0admin-aed},
          -cpsc => q{19.07.04},
          -flags => 80 },
        { -label => q{19.07.05 - Global Positioning System GPS Receiver},
          -cpsc_obid => q{gcqoygiaec---z0admin-aed},
          -cpsc => q{19.07.05},
          -flags => 80 },
        { -label => q{19.07.06 - Global Positioning System GPS Antenna},
          -cpsc_obid => q{gcqoyhfaec---z0admin-aed},
          -cpsc => q{19.07.06},
          -flags => 80 } ] },
    { -label => q{19.08 - Cellular Phone},
      -cpsc_obid => q{gcqoyicaec---z0admin-aed},
      -cpsc => q{19.08.00},
      -flags => 80 },
    { -label => q{19.09 - Citizens Band Radio},
      -cpsc_obid => q{gcqottfaec---z0admin-aec},
      -cpsc => q{19.09.00},
      -flags => 80 },
    { -label => q{19.10 - Multiple Function Electronic Control},
      -cpsc_obid => q{gcqotucaec---z0admin-aec},
      -cpsc => q{19.10.00},
      -flags => 88,
      -children => [
        { -label => q{19.10.01 - Multiple Function Electronic Control Module},
          -cpsc_obid => q{gcqotukaec---z0admin-aec},
          -cpsc => q{19.10.01},
          -flags => 80 },
        { -label => q{19.10.02 - Sensors},
          -cpsc_obid => q{gcqoyjbaec---z0admin-aed},
          -cpsc => q{19.10.02},
          -flags => 80 },
        { -label => q{19.10.03 - Actuators},
          -cpsc_obid => q{gcqoyjjaec---z0admin-aed},
          -cpsc => q{19.10.03},
          -flags => 80 } ] },
    { -label => q{19.11 - Electronic Compass},
      -cpsc_obid => q{gcqoykgaec---z0admin-aed},
      -cpsc => q{19.11.00},
      -flags => 80 },
    { -label => q{19.12 - Keyless Vehicle KEYLESS},
      -cpsc_obid => q{hbEqE4kpdcmp1z0admin-cyy},
      -cpsc => q{19.12.00},
      -flags => 88,
      -children => [
        { -label => q{19.12.01 - Hands-Free Locking and Unlocking},
          -cpsc_obid => q{hbEqE5bpdcmp1z0admin-cyy},
          -cpsc => q{19.12.01},
          -flags => 80 },
        { -label => q{19.12.02 - Keyless Ignition and Engine Immobilization},
          -cpsc_obid => q{hbEqE5dpdcmp1z0admin-cyy},
          -cpsc => q{19.12.02},
          -flags => 80 },
        { -label => q{19.12.03 - Customer Identification Device CID},
          -cpsc_obid => q{hbEqE5fpdcmp1z0admin-cyy},
          -cpsc => q{19.12.03},
          -flags => 80 },
        { -label => q{19.12.04 - Control Module},
          -cpsc_obid => q{hbEqE5hpdcmp1z0admin-cyy},
          -cpsc => q{19.12.04},
          -flags => 80 },
        { -label => q{19.12.05 - In-Vehicle Radio Communications},
          -cpsc_obid => q{hbEqE5jpdcmp1z0admin-cyy},
          -cpsc => q{19.12.05},
          -flags => 80 },
        { -label => q{19.12.06 - CID Radio Communications},
          -cpsc_obid => q{hbEqE6apdcmp1z0admin-cyy},
          -cpsc => q{19.12.06},
          -flags => 80 } ] },
    { -label => q{*** See XX.60 - Non-Automotive Application},
      -flags => 80 } ] },

{ -label => q{80 - Stamping Die Engineering},
  -cpsc_obid => q{hfCmxndpdcmp1z0admin-e5i},
  -cpsc => q{80.00.00},
  -flags => 88,
  -children => [
    { -label => q{80.01 - Stamping Die Engineering Loc},
      -cpsc_obid => q{hfCmxnfpdcmp1z0admin-e5i},
      -cpsc => q{80.01.00},
      -flags => 88,
      -children => [
        { -label => q{80.01.01 - Automation},
          -cpsc_obid => q{hfCmTgfpdcmp1z0admin-e5l},
          -cpsc => q{80.01.01},
          -flags => 80 },
        { -label => q{80.01.02 - Blank Layout},
          -cpsc_obid => q{hfCmTghpdcmp1z0admin-e5l},
          -cpsc => q{80.01.02},
          -flags => 80 },
        { -label => q{80.01.03 - Process Engrg},
          -cpsc_obid => q{hfCmTekpdcmp1z0admin-e5k},
          -cpsc => q{80.01.03},
          -flags => 80 },
        { -label => q{80.01.04 - Binder Development},
          -cpsc_obid => q{hfCmTfbpdcmp1z0admin-e5k},
          -cpsc => q{80.01.04},
          -flags => 80 },
        { -label => q{80.01.05 - Formability},
          -cpsc_obid => q{hfCmTfdpdcmp1z0admin-e5k},
          -cpsc => q{80.01.05},
          -flags => 80 },
        { -label => q{80.01.06 - Die Design},
          -cpsc_obid => q{hfCmTffpdcmp1z0admin-e5k},
          -cpsc => q{80.01.06},
          -flags => 80 },
        { -label => q{80.01.07 - Toolshop},
          -cpsc_obid => q{hfCmTfhpdcmp1z0admin-e5k},
          -cpsc => q{80.01.07},
          -flags => 80 } ] } ] },

{ -label => q{81 - Stamping DX Components},
  -cpsc_obid => q{hfCmTfjpdcmp1z0admin-e5k},
  -cpsc => q{81.00.00},
  -flags => 88,
  -children => [
    { -label => q{81.01 - Stamping DX Components Loc},
      -cpsc_obid => q{hfCmTgapdcmp1z0admin-e5k},
      -cpsc => q{81.01.00},
      -flags => 88,
      -children => [
        { -label => q{81.01.03 - WDX03},
          -cpsc_obid => q{hfCmTgcpdcmp1z0admin-e5k},
          -cpsc => q{81.01.03},
          -flags => 80 },
        { -label => q{81.01.04 - WDX04},
          -cpsc_obid => q{hfCmTgepdcmp1z0admin-e5k},
          -cpsc => q{81.01.04},
          -flags => 80 },
        { -label => q{81.01.05 - WDX05},
          -cpsc_obid => q{hfCmTggpdcmp1z0admin-e5k},
          -cpsc => q{81.01.05},
          -flags => 80 },
        { -label => q{81.01.06 - WDX06},
          -cpsc_obid => q{hfCmTgipdcmp1z0admin-e5k},
          -cpsc => q{81.01.06},
          -flags => 80 },
        { -label => q{81.01.07 - WDX07},
          -cpsc_obid => q{hfCmTgkpdcmp1z0admin-e5k},
          -cpsc => q{81.01.07},
          -flags => 80 },
        { -label => q{81.01.08 - WDX08},
          -cpsc_obid => q{hfCmThbpdcmp1z0admin-e5k},
          -cpsc => q{81.01.08},
          -flags => 80 },
        { -label => q{81.01.09 - WDX09},
          -cpsc_obid => q{hfCmThdpdcmp1z0admin-e5k},
          -cpsc => q{81.01.09},
          -flags => 80 },
        { -label => q{81.01.10 - WDX10},
          -cpsc_obid => q{hfCmThfpdcmp1z0admin-e5k},
          -cpsc => q{81.01.10},
          -flags => 80 },
        { -label => q{81.01.11 - WDX11},
          -cpsc_obid => q{hfCmThhpdcmp1z0admin-e5k},
          -cpsc => q{81.01.11},
          -flags => 80 },
        { -label => q{81.01.12 - WDX12},
          -cpsc_obid => q{hfCmThjpdcmp1z0admin-e5k},
          -cpsc => q{81.01.12},
          -flags => 80 },
        { -label => q{81.01.13 - WDX13},
          -cpsc_obid => q{hfCmTiapdcmp1z0admin-e5k},
          -cpsc => q{81.01.13},
          -flags => 80 },
        { -label => q{81.01.14 - WDX14},
          -cpsc_obid => q{hfCmTicpdcmp1z0admin-e5k},
          -cpsc => q{81.01.14},
          -flags => 80 },
        { -label => q{81.01.15 - WDX15},
          -cpsc_obid => q{hfCmTiepdcmp1z0admin-e5k},
          -cpsc => q{81.01.15},
          -flags => 80 },
        { -label => q{81.01.16 - WDX16},
          -cpsc_obid => q{hfCmTigpdcmp1z0admin-e5k},
          -cpsc => q{81.01.16},
          -flags => 80 },
        { -label => q{81.01.17 - WDX17},
          -cpsc_obid => q{hfCmTiipdcmp1z0admin-e5k},
          -cpsc => q{81.01.17},
          -flags => 80 },
        { -label => q{81.01.18 - WDX18},
          -cpsc_obid => q{hfCmTikpdcmp1z0admin-e5k},
          -cpsc => q{81.01.18},
          -flags => 80 },
        { -label => q{81.01.19 - WDX19},
          -cpsc_obid => q{hfCmTjbpdcmp1z0admin-e5k},
          -cpsc => q{81.01.19},
          -flags => 80 },
        { -label => q{81.01.20 - WDX20},
          -cpsc_obid => q{hfCmTjdpdcmp1z0admin-e5k},
          -cpsc => q{81.01.20},
          -flags => 80 },
        { -label => q{81.01.22 - WDX22},
          -cpsc_obid => q{hfCmTjfpdcmp1z0admin-e5k},
          -cpsc => q{81.01.22},
          -flags => 80 },
        { -label => q{81.01.30 - WDX30},
          -cpsc_obid => q{hfCmTjhpdcmp1z0admin-e5k},
          -cpsc => q{81.01.30},
          -flags => 80 },
        { -label => q{81.01.35 - WDX35},
          -cpsc_obid => q{hfCmTjjpdcmp1z0admin-e5k},
          -cpsc => q{81.01.35},
          -flags => 80 },
        { -label => q{81.01.97 - WDX97 Press Curves},
          -cpsc_obid => q{hfCmTkapdcmp1z0admin-e5k},
          -cpsc => q{81.01.97},
          -flags => 80 },
        { -label => q{81.01.98 - WDX98 Pressbook},
          -cpsc_obid => q{hfCmTkcpdcmp1z0admin-e5k},
          -cpsc => q{81.01.98},
          -flags => 80 },
        { -label => q{81.01.99 - WDX99},
          -cpsc_obid => q{hmpoOsipdcmp1z0admin-p6Q},
          -cpsc => q{81.01.99},
          -flags => 80 } ] } ] },

{ -label => q{82 - Customer Life Cycle},
  -cpsc_obid => q{hfCmTkipdcmp1z0admin-e5k},
  -cpsc => q{82.00.00},
  -flags => 88,
  -children => [
    { -label => q{82.01 - Customer Life Cycle Loc},
      -cpsc_obid => q{hfCmTkkpdcmp1z0admin-e5k},
      -cpsc => q{82.01.00},
      -flags => 88,
      -children => [
        { -label => q{82.01.01 - Body System},
          -cpsc_obid => q{hfCmTlbpdcmp1z0admin-e5k},
          -cpsc => q{82.01.01},
          -flags => 80 },
        { -label => q{82.01.02 - Chassis System},
          -cpsc_obid => q{hfCmTldpdcmp1z0admin-e5k},
          -cpsc => q{82.01.02},
          -flags => 80 },
        { -label => q{82.01.03 - Climate Control System},
          -cpsc_obid => q{hfCmTlfpdcmp1z0admin-e5k},
          -cpsc => q{82.01.03},
          -flags => 80 },
        { -label => q{82.01.04 - Powertrain System},
          -cpsc_obid => q{hfCmTlhpdcmp1z0admin-e5k},
          -cpsc => q{82.01.04},
          -flags => 80 },
        { -label => q{82.01.05 - Electrical System},
          -cpsc_obid => q{hfCmTljpdcmp1z0admin-e5k},
          -cpsc => q{82.01.05},
          -flags => 80 } ] } ] },

{ -label => q{83 - Durability},
  -cpsc_obid => q{hfCmTmapdcmp1z0admin-e5k},
  -cpsc => q{83.00.00},
  -flags => 88,
  -children => [
    { -label => q{83.01 - Durability Loc},
      -cpsc_obid => q{hfCmTmcpdcmp1z0admin-e5k},
      -cpsc => q{83.01.00},
      -flags => 88,
      -children => [
        { -label => q{83.01.01 - Body System},
          -cpsc_obid => q{hfCmTmepdcmp1z0admin-e5k},
          -cpsc => q{83.01.01},
          -flags => 80 },
        { -label => q{83.01.02 - Chassis System},
          -cpsc_obid => q{hfCmTmgpdcmp1z0admin-e5k},
          -cpsc => q{83.01.02},
          -flags => 80 },
        { -label => q{83.01.03 - Climate Control System},
          -cpsc_obid => q{hfCmTmipdcmp1z0admin-e5k},
          -cpsc => q{83.01.03},
          -flags => 80 },
        { -label => q{83.01.04 - Powertrain System},
          -cpsc_obid => q{hfCmTmkpdcmp1z0admin-e5k},
          -cpsc => q{83.01.04},
          -flags => 80 },
        { -label => q{83.01.05 - Electrical System},
          -cpsc_obid => q{hfCmTnbpdcmp1z0admin-e5k},
          -cpsc => q{83.01.05},
          -flags => 80 } ] } ] },

{ -label => q{84 - Electrical-Electronic},
  -cpsc_obid => q{hfCmTndpdcmp1z0admin-e5k},
  -cpsc => q{84.00.00},
  -flags => 88,
  -children => [
    { -label => q{84.01 - Electrical-Electronic Loc},
      -cpsc_obid => q{hfCmTnfpdcmp1z0admin-e5k},
      -cpsc => q{84.01.00},
      -flags => 88,
      -children => [
        { -label => q{84.01.01 - Body System},
          -cpsc_obid => q{hfCmTnhpdcmp1z0admin-e5k},
          -cpsc => q{84.01.01},
          -flags => 80 },
        { -label => q{84.01.02 - Chassis System},
          -cpsc_obid => q{hfCmTnjpdcmp1z0admin-e5k},
          -cpsc => q{84.01.02},
          -flags => 80 },
        { -label => q{84.01.03 - Climate Control System},
          -cpsc_obid => q{hfCmToapdcmp1z0admin-e5k},
          -cpsc => q{84.01.03},
          -flags => 80 },
        { -label => q{84.01.04 - Powertrain System},
          -cpsc_obid => q{hfCmTocpdcmp1z0admin-e5k},
          -cpsc => q{84.01.04},
          -flags => 80 },
        { -label => q{84.01.05 - Electrical System},
          -cpsc_obid => q{hfCmToepdcmp1z0admin-e5k},
          -cpsc => q{84.01.05},
          -flags => 80 } ] } ] },

{ -label => q{85 - Emissions},
  -cpsc_obid => q{hfCmTogpdcmp1z0admin-e5k},
  -cpsc => q{85.00.00},
  -flags => 88,
  -children => [
    { -label => q{85.01 - Emissions Loc},
      -cpsc_obid => q{hfCmToipdcmp1z0admin-e5k},
      -cpsc => q{85.01.00},
      -flags => 88,
      -children => [
        { -label => q{85.01.01 - Body System},
          -cpsc_obid => q{hfCmTokpdcmp1z0admin-e5k},
          -cpsc => q{85.01.01},
          -flags => 80 },
        { -label => q{85.01.02 - Chassis System},
          -cpsc_obid => q{hfCmTpbpdcmp1z0admin-e5k},
          -cpsc => q{85.01.02},
          -flags => 80 },
        { -label => q{85.01.03 - Climate Control System},
          -cpsc_obid => q{hfCmTpdpdcmp1z0admin-e5k},
          -cpsc => q{85.01.03},
          -flags => 80 },
        { -label => q{85.01.04 - Powertrain System},
          -cpsc_obid => q{hfCmTpfpdcmp1z0admin-e5k},
          -cpsc => q{85.01.04},
          -flags => 80 },
        { -label => q{85.01.05 - Electrical System},
          -cpsc_obid => q{hfCmTphpdcmp1z0admin-e5k},
          -cpsc => q{85.01.05},
          -flags => 80 } ] } ] },

{ -label => q{86 - Interior Comfort Environment},
  -cpsc_obid => q{hfCmXSkpdcmp1z0admin-e5m},
  -cpsc => q{86.00.00},
  -flags => 88,
  -children => [
    { -label => q{86.01 - Interior Comfort Environment Loc},
      -cpsc_obid => q{hfCmXTbpdcmp1z0admin-e5m},
      -cpsc => q{86.01.00},
      -flags => 88,
      -children => [
        { -label => q{86.01.01 - Body System},
          -cpsc_obid => q{hfCmXTdpdcmp1z0admin-e5m},
          -cpsc => q{86.01.01},
          -flags => 80 },
        { -label => q{86.01.02 - Chassis System},
          -cpsc_obid => q{hfCmJVcpdcmp1z0admin-e5j},
          -cpsc => q{86.01.02},
          -flags => 80 },
        { -label => q{86.01.03 - Climate Control System},
          -cpsc_obid => q{hfCmJVepdcmp1z0admin-e5j},
          -cpsc => q{86.01.03},
          -flags => 80 },
        { -label => q{86.01.04 - Powertrain System},
          -cpsc_obid => q{hfCmJVgpdcmp1z0admin-e5j},
          -cpsc => q{86.01.04},
          -flags => 80 },
        { -label => q{86.01.05 - Electrical System},
          -cpsc_obid => q{hfCmJVipdcmp1z0admin-e5j},
          -cpsc => q{86.01.05},
          -flags => 80 } ] } ] },

{ -label => q{87 - NVH},
  -cpsc_obid => q{hfCmJVkpdcmp1z0admin-e5j},
  -cpsc => q{87.00.00},
  -flags => 88,
  -children => [
    { -label => q{87.01 - NVH Loc},
      -cpsc_obid => q{hfCmJWbpdcmp1z0admin-e5j},
      -cpsc => q{87.01.00},
      -flags => 88,
      -children => [
        { -label => q{87.01.01 - Body System},
          -cpsc_obid => q{hfCmJWdpdcmp1z0admin-e5j},
          -cpsc => q{87.01.01},
          -flags => 80 },
        { -label => q{87.01.02 - Chassis System},
          -cpsc_obid => q{hfCmJWfpdcmp1z0admin-e5j},
          -cpsc => q{87.01.02},
          -flags => 80 },
        { -label => q{87.01.03 - Climate Control System},
          -cpsc_obid => q{hfCmJXapdcmp1z0admin-e5j},
          -cpsc => q{87.01.03},
          -flags => 80 },
        { -label => q{87.01.04 - Powertrain System},
          -cpsc_obid => q{hfCmXWdpdcmp1z0admin-e5m},
          -cpsc => q{87.01.04},
          -flags => 80 },
        { -label => q{87.01.05 - Electrical System},
          -cpsc_obid => q{hfCmXWfpdcmp1z0admin-e5m},
          -cpsc => q{87.01.05},
          -flags => 80 } ] } ] },

{ -label => q{88 - Package-Ergonomics},
  -cpsc_obid => q{hfCmXWipdcmp1z0admin-e5m},
  -cpsc => q{88.00.00},
  -flags => 88,
  -children => [
    { -label => q{88.01 - Package-Ergonomics Loc},
      -cpsc_obid => q{hfCm7Tjpdcmp1z0admin-e5n},
      -cpsc => q{88.01.00},
      -flags => 88,
      -children => [
        { -label => q{88.01.01 - Body System},
          -cpsc_obid => q{hfCm7Uapdcmp1z0admin-e5n},
          -cpsc => q{88.01.01},
          -flags => 80 },
        { -label => q{88.01.02 - Chassis System},
          -cpsc_obid => q{hfCm7Ucpdcmp1z0admin-e5n},
          -cpsc => q{88.01.02},
          -flags => 80 },
        { -label => q{88.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm7Uepdcmp1z0admin-e5n},
          -cpsc => q{88.01.03},
          -flags => 80 },
        { -label => q{88.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm7Ugpdcmp1z0admin-e5n},
          -cpsc => q{88.01.04},
          -flags => 80 },
        { -label => q{88.01.05 - Electrical System},
          -cpsc_obid => q{hfCm7Uipdcmp1z0admin-e5n},
          -cpsc => q{88.01.05},
          -flags => 80 },
        { -label => q{88.01.06 - Package Compliance},
          -cpsc_obid => q{ifooAjcpdcmp1z0admin-Ag7},
          -cpsc => q{88.01.06},
          -flags => 80 } ] },
    { -label => q{*** See 88.01.06 - Package Compliance},
      -flags => 80 } ] },

{ -label => q{89 - Performance-FE},
  -cpsc_obid => q{hfCm7Ukpdcmp1z0admin-e5n},
  -cpsc => q{89.00.00},
  -flags => 88,
  -children => [
    { -label => q{89.01 - Performance-FE Loc},
      -cpsc_obid => q{hfCm7Vbpdcmp1z0admin-e5n},
      -cpsc => q{89.01.00},
      -flags => 88,
      -children => [
        { -label => q{89.01.01 - Body System},
          -cpsc_obid => q{hfCm7Vdpdcmp1z0admin-e5n},
          -cpsc => q{89.01.01},
          -flags => 80 },
        { -label => q{89.01.02 - Chassis System},
          -cpsc_obid => q{hfCm7Vfpdcmp1z0admin-e5n},
          -cpsc => q{89.01.02},
          -flags => 80 },
        { -label => q{89.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm7Vhpdcmp1z0admin-e5n},
          -cpsc => q{89.01.03},
          -flags => 80 },
        { -label => q{89.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm7Vjpdcmp1z0admin-e5n},
          -cpsc => q{89.01.04},
          -flags => 80 },
        { -label => q{89.01.05 - Electrical System},
          -cpsc_obid => q{hfCm7Wapdcmp1z0admin-e5n},
          -cpsc => q{89.01.05},
          -flags => 80 } ] } ] },

{ -label => q{90 - Powertrain},
  -cpsc_obid => q{hfCm7Wcpdcmp1z0admin-e5n},
  -cpsc => q{90.00.00},
  -flags => 88,
  -children => [
    { -label => q{90.01 - Powertrain Loc},
      -cpsc_obid => q{hfCm7Wepdcmp1z0admin-e5n},
      -cpsc => q{90.01.00},
      -flags => 88,
      -children => [
        { -label => q{90.01.01 - Body System},
          -cpsc_obid => q{hfCm7Wgpdcmp1z0admin-e5n},
          -cpsc => q{90.01.01},
          -flags => 80 },
        { -label => q{90.01.02 - Chassis System},
          -cpsc_obid => q{hfCm7Wipdcmp1z0admin-e5n},
          -cpsc => q{90.01.02},
          -flags => 80 },
        { -label => q{90.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm7Wkpdcmp1z0admin-e5n},
          -cpsc => q{90.01.03},
          -flags => 80 },
        { -label => q{90.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm7Xbpdcmp1z0admin-e5n},
          -cpsc => q{90.01.04},
          -flags => 80 },
        { -label => q{90.01.05 - Electrical System},
          -cpsc_obid => q{hfCm7Xdpdcmp1z0admin-e5n},
          -cpsc => q{90.01.05},
          -flags => 80 } ] } ] },

{ -label => q{91 - Production Life Cycle},
  -cpsc_obid => q{hfCm7Xfpdcmp1z0admin-e5n},
  -cpsc => q{91.00.00},
  -flags => 88,
  -children => [
    { -label => q{91.01 - Production Life Cycle Loc},
      -cpsc_obid => q{hfCm7Xhpdcmp1z0admin-e5n},
      -cpsc => q{91.01.00},
      -flags => 88,
      -children => [
        { -label => q{91.01.01 - Body System},
          -cpsc_obid => q{hfCm7Xjpdcmp1z0admin-e5n},
          -cpsc => q{91.01.01},
          -flags => 80 },
        { -label => q{91.01.02 - Chassis System},
          -cpsc_obid => q{hfCm7Yapdcmp1z0admin-e5n},
          -cpsc => q{91.01.02},
          -flags => 80 },
        { -label => q{91.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm7Ycpdcmp1z0admin-e5n},
          -cpsc => q{91.01.03},
          -flags => 80 },
        { -label => q{91.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm7Yepdcmp1z0admin-e5n},
          -cpsc => q{91.01.04},
          -flags => 80 },
        { -label => q{91.01.05 - Electrical System},
          -cpsc_obid => q{hfCm7Ygpdcmp1z0admin-e5n},
          -cpsc => q{91.01.05},
          -flags => 80 } ] } ] },

{ -label => q{92 - Safety},
  -cpsc_obid => q{hfCm7Yipdcmp1z0admin-e5n},
  -cpsc => q{92.00.00},
  -flags => 88,
  -children => [
    { -label => q{92.01 - Safety Loc},
      -cpsc_obid => q{hfCm7Ykpdcmp1z0admin-e5n},
      -cpsc => q{92.01.00},
      -flags => 88,
      -children => [
        { -label => q{92.01.01 - Body System},
          -cpsc_obid => q{hfCm7Zbpdcmp1z0admin-e5n},
          -cpsc => q{92.01.01},
          -flags => 80 },
        { -label => q{92.01.02 - Chassis System},
          -cpsc_obid => q{hfCm7Zdpdcmp1z0admin-e5n},
          -cpsc => q{92.01.02},
          -flags => 80 },
        { -label => q{92.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm7Zfpdcmp1z0admin-e5n},
          -cpsc => q{92.01.03},
          -flags => 80 },
        { -label => q{92.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm7Zhpdcmp1z0admin-e5n},
          -cpsc => q{92.01.04},
          -flags => 80 },
        { -label => q{92.01.05 - Electrical System},
          -cpsc_obid => q{hfCm7Zjpdcmp1z0admin-e5n},
          -cpsc => q{92.01.05},
          -flags => 80 } ] } ] },

{ -label => q{93 - Styling-Appearance},
  -cpsc_obid => q{hfCm70apdcmp1z0admin-e5n},
  -cpsc => q{93.00.00},
  -flags => 88,
  -children => [
    { -label => q{93.01 - Styling-Appearance Loc},
      -cpsc_obid => q{hfCm70cpdcmp1z0admin-e5n},
      -cpsc => q{93.01.00},
      -flags => 88,
      -children => [
        { -label => q{93.01.01 - Body System},
          -cpsc_obid => q{hfCm70epdcmp1z0admin-e5n},
          -cpsc => q{93.01.01},
          -flags => 80 },
        { -label => q{93.01.02 - Chassis System},
          -cpsc_obid => q{hfCm70gpdcmp1z0admin-e5n},
          -cpsc => q{93.01.02},
          -flags => 80 },
        { -label => q{93.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm70ipdcmp1z0admin-e5n},
          -cpsc => q{93.01.03},
          -flags => 80 },
        { -label => q{93.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm70kpdcmp1z0admin-e5n},
          -cpsc => q{93.01.04},
          -flags => 80 },
        { -label => q{93.01.05 - Electrical System},
          -cpsc_obid => q{hfCm71bpdcmp1z0admin-e5n},
          -cpsc => q{93.01.05},
          -flags => 80 } ] } ] },

{ -label => q{94 - Thermal-Aero},
  -cpsc_obid => q{hfCm71dpdcmp1z0admin-e5n},
  -cpsc => q{94.00.00},
  -flags => 88,
  -children => [
    { -label => q{94.01 - Thermal-Aero Loc},
      -cpsc_obid => q{hfCm71fpdcmp1z0admin-e5n},
      -cpsc => q{94.01.00},
      -flags => 88,
      -children => [
        { -label => q{94.01.01 - Body System},
          -cpsc_obid => q{hfCm71hpdcmp1z0admin-e5n},
          -cpsc => q{94.01.01},
          -flags => 80 },
        { -label => q{94.01.02 - Chassis System},
          -cpsc_obid => q{hfCm71jpdcmp1z0admin-e5n},
          -cpsc => q{94.01.02},
          -flags => 80 },
        { -label => q{94.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm72apdcmp1z0admin-e5n},
          -cpsc => q{94.01.03},
          -flags => 80 },
        { -label => q{94.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm72cpdcmp1z0admin-e5n},
          -cpsc => q{94.01.04},
          -flags => 80 },
        { -label => q{94.01.05 - Electrical System},
          -cpsc_obid => q{hfCm72epdcmp1z0admin-e5n},
          -cpsc => q{94.01.05},
          -flags => 80 } ] } ] },

{ -label => q{95 - Vehicle Integration},
  -cpsc_obid => q{hfCm72gpdcmp1z0admin-e5n},
  -cpsc => q{95.00.00},
  -flags => 88,
  -children => [
    { -label => q{95.01 - Vehicle Integration Loc},
      -cpsc_obid => q{hfCm72ipdcmp1z0admin-e5n},
      -cpsc => q{95.01.00},
      -flags => 88,
      -children => [
        { -label => q{95.01.01 - Body System},
          -cpsc_obid => q{hfCm72kpdcmp1z0admin-e5n},
          -cpsc => q{95.01.01},
          -flags => 80 },
        { -label => q{95.01.02 - Chassis System},
          -cpsc_obid => q{hfCm73bpdcmp1z0admin-e5n},
          -cpsc => q{95.01.02},
          -flags => 80 },
        { -label => q{95.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm73dpdcmp1z0admin-e5n},
          -cpsc => q{95.01.03},
          -flags => 80 },
        { -label => q{95.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm73fpdcmp1z0admin-e5n},
          -cpsc => q{95.01.04},
          -flags => 80 },
        { -label => q{95.01.05 - Electrical System},
          -cpsc_obid => q{hfCm73hpdcmp1z0admin-e5n},
          -cpsc => q{95.01.05},
          -flags => 80 } ] } ] },

{ -label => q{96 - Vehicle Dynamics},
  -cpsc_obid => q{hfCm73jpdcmp1z0admin-e5n},
  -cpsc => q{96.00.00},
  -flags => 88,
  -children => [
    { -label => q{96.01 - Vehicle Dynamics Loc},
      -cpsc_obid => q{hfCm74apdcmp1z0admin-e5n},
      -cpsc => q{96.01.00},
      -flags => 88,
      -children => [
        { -label => q{96.01.01 - Body System},
          -cpsc_obid => q{hfCm74cpdcmp1z0admin-e5n},
          -cpsc => q{96.01.01},
          -flags => 80 },
        { -label => q{96.01.02 - Chassis System},
          -cpsc_obid => q{hfCm74epdcmp1z0admin-e5n},
          -cpsc => q{96.01.02},
          -flags => 80 },
        { -label => q{96.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm74gpdcmp1z0admin-e5n},
          -cpsc => q{96.01.03},
          -flags => 80 },
        { -label => q{96.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm74ipdcmp1z0admin-e5n},
          -cpsc => q{96.01.04},
          -flags => 80 },
        { -label => q{96.01.05 - Electrical System},
          -cpsc_obid => q{hfCm74kpdcmp1z0admin-e5n},
          -cpsc => q{96.01.05},
          -flags => 80 } ] } ] },

{ -label => q{97 - Weight},
  -cpsc_obid => q{hfCm75bpdcmp1z0admin-e5n},
  -cpsc => q{97.00.00},
  -flags => 88,
  -children => [
    { -label => q{97.01 - Weight Loc},
      -cpsc_obid => q{hfCm75dpdcmp1z0admin-e5n},
      -cpsc => q{97.01.00},
      -flags => 88,
      -children => [
        { -label => q{97.01.01 - Body System},
          -cpsc_obid => q{hfCm75fpdcmp1z0admin-e5n},
          -cpsc => q{97.01.01},
          -flags => 80 },
        { -label => q{97.01.02 - Chassis System},
          -cpsc_obid => q{hfCm75hpdcmp1z0admin-e5n},
          -cpsc => q{97.01.02},
          -flags => 80 },
        { -label => q{97.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm75jpdcmp1z0admin-e5n},
          -cpsc => q{97.01.03},
          -flags => 80 },
        { -label => q{97.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm76apdcmp1z0admin-e5n},
          -cpsc => q{97.01.04},
          -flags => 80 },
        { -label => q{97.01.05 - Electrical System},
          -cpsc_obid => q{hfCm76cpdcmp1z0admin-e5n},
          -cpsc => q{97.01.05},
          -flags => 80 } ] } ] },

{ -label => q{98 - Matl HDLG Rack Assemblies},
  -cpsc_obid => q{hfCm76epdcmp1z0admin-e5n},
  -cpsc => q{98.00.00},
  -flags => 88,
  -children => [
    { -label => q{98.01 - MATL HDLG RACK ASSEMBLIES Loc},
      -cpsc_obid => q{hfCm76gpdcmp1z0admin-e5n},
      -cpsc => q{98.01.00},
      -flags => 88,
      -children => [
        { -label => q{98.01.01 - Body System},
          -cpsc_obid => q{hfCm76ipdcmp1z0admin-e5n},
          -cpsc => q{98.01.01},
          -flags => 80 },
        { -label => q{98.01.02 - Chassis System},
          -cpsc_obid => q{hfCm76kpdcmp1z0admin-e5n},
          -cpsc => q{98.01.02},
          -flags => 80 },
        { -label => q{98.01.03 - Climate Control System},
          -cpsc_obid => q{hfCm77bpdcmp1z0admin-e5n},
          -cpsc => q{98.01.03},
          -flags => 80 },
        { -label => q{98.01.04 - Powertrain System},
          -cpsc_obid => q{hfCm77dpdcmp1z0admin-e5n},
          -cpsc => q{98.01.04},
          -flags => 80 },
        { -label => q{98.01.05 - Electrical System},
          -cpsc_obid => q{hfCm77fpdcmp1z0admin-e5n},
          -cpsc => q{98.01.05},
          -flags => 80 },
        { -label => q{98.01.06 - Standard Components},
          -cpsc_obid => q{ictqVdgpdcmp1z0admin-xEi},
          -cpsc => q{98.01.06},
          -flags => 80 } ] } ] },

{ -label => q{99 - Standard Fasteners},
  -cpsc_obid => q{hbEqE6gpdcmp1z0admin-cyy},
  -cpsc => q{99.00.00},
  -flags => 88,
  -children => [
    { -label => q{99.01 - WSF Bolts},
      -cpsc_obid => q{hbClR1apdcmp1z0admin-cxi},
      -cpsc => q{99.01.00},
      -flags => 88,
      -children => [
        { -label => q{99.01.01 - Bolt-Hex FLNG Pil-PC 10.9},
          -cpsc_obid => q{hbCl4Ncpdcmp1z0admin-cxl},
          -cpsc => q{99.01.01},
          -flags => 80 },
        { -label => q{99.01.02 - Bolt-Hex FLNG Pil-PC 8.8},
          -cpsc_obid => q{hbCl4Nepdcmp1z0admin-cxl},
          -cpsc => q{99.01.02},
          -flags => 80 },
        { -label => q{99.01.03 - Bolt-Hex FLNG-PC 10.9},
          -cpsc_obid => q{hbCl4Ngpdcmp1z0admin-cxl},
          -cpsc => q{99.01.03},
          -flags => 80 },
        { -label => q{99.01.04 - Bolt-Hex FLNG-PC 8.8},
          -cpsc_obid => q{hbCl4Nipdcmp1z0admin-cxl},
          -cpsc => q{99.01.04},
          -flags => 80 },
        { -label => q{99.01.05 - Bolt-Hex Pil-PC 10.9},
          -cpsc_obid => q{hbCl4Nkpdcmp1z0admin-cxl},
          -cpsc => q{99.01.05},
          -flags => 80 },
        { -label => q{99.01.06 - Bolt-Hex Pil-PC 8.8},
          -cpsc_obid => q{hbCl4Obpdcmp1z0admin-cxl},
          -cpsc => q{99.01.06},
          -flags => 80 },
        { -label => q{99.01.07 - Bolt-Hex-PC 10.9},
          -cpsc_obid => q{hbCl4Odpdcmp1z0admin-cxl},
          -cpsc => q{99.01.07},
          -flags => 80 },
        { -label => q{99.01.08 - Bolt-Hex-PC 8.8},
          -cpsc_obid => q{hbCl4Ofpdcmp1z0admin-cxl},
          -cpsc => q{99.01.08},
          -flags => 80 } ] },
    { -label => q{99.02 - WSF Hoseclamps},
      -cpsc_obid => q{hbCl4Ohpdcmp1z0admin-cxl},
      -cpsc => q{99.02.00},
      -flags => 88,
      -children => [
        { -label => q{99.02.01 - Hoseclamp-Spring Band},
          -cpsc_obid => q{hbCl4Ojpdcmp1z0admin-cxl},
          -cpsc => q{99.02.01},
          -flags => 80 },
        { -label => q{99.02.02 - Hoseclamp-Spring Band 12MM Heavy Duty},
          -cpsc_obid => q{hbCl4Papdcmp1z0admin-cxl},
          -cpsc => q{99.02.02},
          -flags => 80 },
        { -label => q{99.02.03 - Hoseclamp-Worm Drive},
          -cpsc_obid => q{hbCl4Pcpdcmp1z0admin-cxl},
          -cpsc => q{99.02.03},
          -flags => 80 },
        { -label => q{99.02.04 - Hoseclamp-Spring Band 15MM Heavy Duty},
          -cpsc_obid => q{hbCl4Pepdcmp1z0admin-cxl},
          -cpsc => q{99.02.04},
          -flags => 80 },
        { -label => q{99.02.05 - Hoseclamp-Spring Band 12MM Heavy Duty Pre-Open},
          -cpsc_obid => q{hbCl4Pgpdcmp1z0admin-cxl},
          -cpsc => q{99.02.05},
          -flags => 80 },
        { -label => q{99.02.06 - Hoseclamp-Spring Band 15MM Heavy Duty Pre-Open},
          -cpsc_obid => q{hbClR1fpdcmp1z0admin-cxi},
          -cpsc => q{99.02.06},
          -flags => 80 } ] },
    { -label => q{99.03 - WSF Machine Screws},
      -cpsc_obid => q{hbClR2bpdcmp1z0admin-cxi},
      -cpsc => q{99.03.00},
      -flags => 88,
      -children => [
        { -label => q{99.03.01 - Mach Screw WSHR-Flat CSK TTH Cross-PC 4.8},
          -cpsc_obid => q{hbClR2dpdcmp1z0admin-cxi},
          -cpsc => q{99.03.01},
          -flags => 80 },
        { -label => q{99.03.02 - Mach Screw WSHR-Pan TTH Cross-PC 4.8},
          -cpsc_obid => q{hbClR2fpdcmp1z0admin-cxi},
          -cpsc => q{99.03.02},
          -flags => 88,
          -children => [
            { -label => q{*** See 99.03.01 - Mach Screw WSHR-Flat CSK TTH Cross-PC 4.8},
              -flags => 80 } ] },
        { -label => q{99.03.03 - Mach Screw WSHR-Raised Oval TTH Cross-PC 4.8},
          -cpsc_obid => q{hbClR2hpdcmp1z0admin-cxi},
          -cpsc => q{99.03.03},
          -flags => 80 },
        { -label => q{99.03.04 - Mach Screw-Flat CSK 6 Lobe Pil-PC 8.8},
          -cpsc_obid => q{hbClR2kpdcmp1z0admin-cxi},
          -cpsc => q{99.03.04},
          -flags => 80 },
        { -label => q{99.03.05 - Mach Screw-Flat CSK 6 Lobe-PC 8.8},
          -cpsc_obid => q{hbCl4Rcpdcmp1z0admin-cxl},
          -cpsc => q{99.03.05},
          -flags => 80 },
        { -label => q{99.03.06 - Mach Screw-Flat CSK Cross-PC 4.8},
          -cpsc_obid => q{hbCl4Repdcmp1z0admin-cxl},
          -cpsc => q{99.03.06},
          -flags => 80 },
        { -label => q{99.03.07 - Mach Screw-Pan 6 Lobe Pil-PC 8.8},
          -cpsc_obid => q{hbClR3dpdcmp1z0admin-cxi},
          -cpsc => q{99.03.07},
          -flags => 80 },
        { -label => q{99.03.08 - Mach Screw-Pan 6 Lobe-PC 8.8},
          -cpsc_obid => q{hbClR3fpdcmp1z0admin-cxi},
          -cpsc => q{99.03.08},
          -flags => 80 },
        { -label => q{99.03.09 - Mach Screw-Pan Cross-PC 4.8},
          -cpsc_obid => q{hbClR3hpdcmp1z0admin-cxi},
          -cpsc => q{99.03.09},
          -flags => 80 },
        { -label => q{99.03.10 - Mach Screw-Raised Oval 6 Lobe Pil-PC 8.8},
          -cpsc_obid => q{hbClR3jpdcmp1z0admin-cxi},
          -cpsc => q{99.03.10},
          -flags => 80 },
        { -label => q{99.03.11 - Mach Screw-Raised Oval 6 Lobe-PC 8.8},
          -cpsc_obid => q{hbClR4apdcmp1z0admin-cxi},
          -cpsc => q{99.03.11},
          -flags => 80 },
        { -label => q{99.03.12 - Mach Screw-Raised Oval Cross-PC 4.8},
          -cpsc_obid => q{hbClR4cpdcmp1z0admin-cxi},
          -cpsc => q{99.03.12},
          -flags => 80 } ] },
    { -label => q{99.04 - WSF Nuts},
      -cpsc_obid => q{hbClR4epdcmp1z0admin-cxi},
      -cpsc => q{99.04.00},
      -flags => 88,
      -children => [
        { -label => q{99.04.01 - Nut-Hex FLNG Prevail Torque MTL},
          -cpsc_obid => q{hbClR4hpdcmp1z0admin-cxi},
          -cpsc => q{99.04.01},
          -flags => 80 },
        { -label => q{99.04.02 - Nut-Hex FLNG Prevail Torque Nonmtl Insert},
          -cpsc_obid => q{hbClR4jpdcmp1z0admin-cxi},
          -cpsc => q{99.04.02},
          -flags => 80 },
        { -label => q{99.04.03 - Nut-Hex FLNG-PC 08},
          -cpsc_obid => q{hbClR5apdcmp1z0admin-cxi},
          -cpsc => q{99.04.03},
          -flags => 80 },
        { -label => q{99.04.04 - Nut-Hex FLNG-PC 10},
          -cpsc_obid => q{hbClR5cpdcmp1z0admin-cxi},
          -cpsc => q{99.04.04},
          -flags => 80 },
        { -label => q{99.04.05 - Nut-Hex Prevail Torque MTL},
          -cpsc_obid => q{hbClR5epdcmp1z0admin-cxi},
          -cpsc => q{99.04.05},
          -flags => 80 },
        { -label => q{99.04.06 - Nut-Hex Prevail Torque Nonmtl Insert},
          -cpsc_obid => q{hbClR5gpdcmp1z0admin-cxi},
          -cpsc => q{99.04.06},
          -flags => 80 },
        { -label => q{99.04.07 - Nut-Hex Thin-PC 04},
          -cpsc_obid => q{hbClR5ipdcmp1z0admin-cxi},
          -cpsc => q{99.04.07},
          -flags => 80 },
        { -label => q{99.04.08 - Nut-Hex-PC 08},
          -cpsc_obid => q{hbClR5kpdcmp1z0admin-cxi},
          -cpsc => q{99.04.08},
          -flags => 80 },
        { -label => q{99.04.09 - Nut-Hex-PC 10},
          -cpsc_obid => q{hbClR6bpdcmp1z0admin-cxi},
          -cpsc => q{99.04.09},
          -flags => 80 },
        { -label => q{99.04.10 - Nut-Pierce-PC 08},
          -cpsc_obid => q{hbClR6dpdcmp1z0admin-cxi},
          -cpsc => q{99.04.10},
          -flags => 88,
          -children => [
            { -label => q{*** See 99.04.11 - Nut-RND Weld Pil-PC 08},
              -flags => 80 } ] },
        { -label => q{99.04.11 - Nut-RND Weld Pil-PC 08},
          -cpsc_obid => q{hbClR6kpdcmp1z0admin-cxi},
          -cpsc => q{99.04.11},
          -flags => 80 },
        { -label => q{99.04.12 - Nut-Spring U-Type},
          -cpsc_obid => q{hbClR7bpdcmp1z0admin-cxi},
          -cpsc => q{99.04.12},
          -flags => 80 },
        { -label => q{99.04.13 - Nut-Spring U-Type Prevail Torque},
          -cpsc_obid => q{hbClR7dpdcmp1z0admin-cxi},
          -cpsc => q{99.04.13},
          -flags => 80 } ] },
    { -label => q{99.05 - WSF Pins},
      -cpsc_obid => q{hbClR7fpdcmp1z0admin-cxi},
      -cpsc => q{99.05.00},
      -flags => 88,
      -children => [
        { -label => q{99.05.01 - Pin-Split Cotter},
          -cpsc_obid => q{hbClR7hpdcmp1z0admin-cxi},
          -cpsc => q{99.05.01},
          -flags => 80 },
        { -label => q{99.05.02 - Pin-Spring Coiled},
          -cpsc_obid => q{hbClR7jpdcmp1z0admin-cxi},
          -cpsc => q{99.05.02},
          -flags => 80 },
        { -label => q{99.05.03 - Pin-Spring Slot Heavy},
          -cpsc_obid => q{hbClSaapdcmp1z0admin-cxi},
          -cpsc => q{99.05.03},
          -flags => 80 } ] },
    { -label => q{99.06 - WSF Plug Expansion Cup},
      -cpsc_obid => q{hbClSacpdcmp1z0admin-cxi},
      -cpsc => q{99.06.00},
      -flags => 88,
      -children => [
        { -label => q{99.06.01 - Plug-Expansion Cup},
          -cpsc_obid => q{hbClSaepdcmp1z0admin-cxi},
          -cpsc => q{99.06.01},
          -flags => 80 },
        { -label => q{99.06.02 - Plug-Short Taper},
          -cpsc_obid => q{hbClSagpdcmp1z0admin-cxi},
          -cpsc => q{99.06.02},
          -flags => 80 } ] },
    { -label => q{99.07 - WSF Retainer Ring},
      -cpsc_obid => q{hbClSaipdcmp1z0admin-cxi},
      -cpsc => q{99.07.00},
      -flags => 88,
      -children => [
        { -label => q{99.07.01 - Ring-Retainer External},
          -cpsc_obid => q{hbClSakpdcmp1z0admin-cxi},
          -cpsc => q{99.07.01},
          -flags => 80 },
        { -label => q{99.07.02 - Ring-Retainer Type-E},
          -cpsc_obid => q{hbClSbbpdcmp1z0admin-cxi},
          -cpsc => q{99.07.02},
          -flags => 80 } ] },
    { -label => q{99.08 - WSF Rivets},
      -cpsc_obid => q{hbClSbdpdcmp1z0admin-cxi},
      -cpsc => q{99.08.00},
      -flags => 88,
      -children => [
        { -label => q{99.08.01 - Rivet-Domed Head Blind Alum},
          -cpsc_obid => q{hbClSbfpdcmp1z0admin-cxi},
          -cpsc => q{99.08.01},
          -flags => 80 },
        { -label => q{99.08.02 - Rivet-Domed Head Blind Steel},
          -cpsc_obid => q{hbClSbhpdcmp1z0admin-cxi},
          -cpsc => q{99.08.02},
          -flags => 80 },
        { -label => q{99.08.03 - Rivet-Multi-Grip Split},
          -cpsc_obid => q{hbClSbjpdcmp1z0admin-cxi},
          -cpsc => q{99.08.03},
          -flags => 80 },
        { -label => q{99.08.04 - Rivet-Solid Domed Head},
          -cpsc_obid => q{hbClScapdcmp1z0admin-cxi},
          -cpsc => q{99.08.04},
          -flags => 80 },
        { -label => q{99.08.05 - Rivet-Semi-Tubular Oval HD},
          -cpsc_obid => q{hbClSccpdcmp1z0admin-cxi},
          -cpsc => q{99.08.05},
          -flags => 80 } ] },
    { -label => q{99.09 - WSF Screws With Washers},
      -cpsc_obid => q{hbClScepdcmp1z0admin-cxi},
      -cpsc => q{99.09.00},
      -flags => 88,
      -children => [
        { -label => q{99.09.01 - Screw With WSHR-Hex Conl Pil-PC 8.8},
          -cpsc_obid => q{hbClScgpdcmp1z0admin-cxi},
          -cpsc => q{99.09.01},
          -flags => 80 },
        { -label => q{99.09.02 - Screw With WSHR-Hex Conl-PC 8.8},
          -cpsc_obid => q{hbClScipdcmp1z0admin-cxi},
          -cpsc => q{99.09.02},
          -flags => 80 } ] },
    { -label => q{99.10 - WSF Screws},
      -cpsc_obid => q{hbClSdapdcmp1z0admin-cxi},
      -cpsc => q{99.10.00},
      -flags => 88,
      -children => [
        { -label => q{99.10.01 - Screw-Hex FLNG Pil-PC 10.9},
          -cpsc_obid => q{hbClSdcpdcmp1z0admin-cxi},
          -cpsc => q{99.10.01},
          -flags => 80 },
        { -label => q{99.10.02 - Screw-Hex FLNG Pil-PC 8.8},
          -cpsc_obid => q{hbClSdepdcmp1z0admin-cxi},
          -cpsc => q{99.10.02},
          -flags => 80 },
        { -label => q{99.10.03 - Screw-Hex FLNG-PC 10.9},
          -cpsc_obid => q{hbClSdgpdcmp1z0admin-cxi},
          -cpsc => q{99.10.03},
          -flags => 80 },
        { -label => q{99.10.04 - Screw-Hex FLNG-PC 8.8},
          -cpsc_obid => q{hbClSdipdcmp1z0admin-cxi},
          -cpsc => q{99.10.04},
          -flags => 80 },
        { -label => q{99.10.05 - Screw-Hex Pil-PC 10.9},
          -cpsc_obid => q{hbClSdkpdcmp1z0admin-cxi},
          -cpsc => q{99.10.05},
          -flags => 80 },
        { -label => q{99.10.06 - Screw-Hex Pil-PC 8.8},
          -cpsc_obid => q{hbClSebpdcmp1z0admin-cxi},
          -cpsc => q{99.10.06},
          -flags => 80 },
        { -label => q{99.10.07 - Screw-Hex-PC 10.9},
          -cpsc_obid => q{hbClSedpdcmp1z0admin-cxi},
          -cpsc => q{99.10.07},
          -flags => 80 },
        { -label => q{99.10.08 - Screw-Hex-PC 8.8},
          -cpsc_obid => q{hbClSefpdcmp1z0admin-cxi},
          -cpsc => q{99.10.08},
          -flags => 80 } ] },
    { -label => q{99.11 - WSF Studs},
      -cpsc_obid => q{hbClSehpdcmp1z0admin-cxi},
      -cpsc => q{99.11.00},
      -flags => 88,
      -children => [
        { -label => q{99.11.01 - Stud-Self Piercing Pil-PC 8.8},
          -cpsc_obid => q{hbClSejpdcmp1z0admin-cxi},
          -cpsc => q{99.11.01},
          -flags => 80 } ] },
    { -label => q{99.12 - WSF Tapping Screws},
      -cpsc_obid => q{hbClSfapdcmp1z0admin-cxi},
      -cpsc => q{99.12.00},
      -flags => 88,
      -children => [
        { -label => q{99.12.01 - Tap Screw-Flat CSK Cross-Ab},
          -cpsc_obid => q{hbClSfcpdcmp1z0admin-cxi},
          -cpsc => q{99.12.01},
          -flags => 80 },
        { -label => q{99.12.02 - },
          -cpsc_obid => q{hcfvRObpdcmp1z0admin-cLd},
          -cpsc => q{99.12.02},
          -flags => 80 },
        { -label => q{99.12.03 - Tap Screw-Pan 6 Lobe THD Roll},
          -cpsc_obid => q{hbClSffpdcmp1z0admin-cxi},
          -cpsc => q{99.12.03},
          -flags => 80 },
        { -label => q{99.12.04 - Tap Screw-Hex FLNG Pil},
          -cpsc_obid => q{hbClSfhpdcmp1z0admin-cxi},
          -cpsc => q{99.12.04},
          -flags => 80 },
        { -label => q{99.12.05 - Tap Screw-Hex FLNG THD Roll Pil-PC 010},
          -cpsc_obid => q{hbClSfjpdcmp1z0admin-cxi},
          -cpsc => q{99.12.05},
          -flags => 80 },
        { -label => q{99.12.06 - Tap Screw-Hex FLNG THD Roll},
          -cpsc_obid => q{hbClSgapdcmp1z0admin-cxi},
          -cpsc => q{99.12.06},
          -flags => 80 },
        { -label => q{99.12.07 - Tap Screw-Hex FLNG-Ab},
          -cpsc_obid => q{hbClSgcpdcmp1z0admin-cxi},
          -cpsc => q{99.12.07},
          -flags => 80 },
        { -label => q{99.12.08 - Tap Screw-Hex FLNG-B},
          -cpsc_obid => q{hbClSgepdcmp1z0admin-cxi},
          -cpsc => q{99.12.08},
          -flags => 80 },
        { -label => q{99.12.09 - Tap Screw-Pan Cross CSTL-Ab},
          -cpsc_obid => q{hbClSggpdcmp1z0admin-cxi},
          -cpsc => q{99.12.09},
          -flags => 80 },
        { -label => q{99.12.10 - Tap Screw-Pan Cross CSTL-B},
          -cpsc_obid => q{hbClSgipdcmp1z0admin-cxi},
          -cpsc => q{99.12.10},
          -flags => 80 },
        { -label => q{99.12.11 - Tap Screw-Pan Cross STNLSSTL-Ab},
          -cpsc_obid => q{hbClSgkpdcmp1z0admin-cxi},
          -cpsc => q{99.12.11},
          -flags => 80 },
        { -label => q{99.12.12 - Tap Screw-Pan Cross STNLSSTL-B},
          -cpsc_obid => q{hbClShbpdcmp1z0admin-cxi},
          -cpsc => q{99.12.12},
          -flags => 80 },
        { -label => q{99.12.13 - Tap Screw-Raised Oval Cross CSTL-Ab},
          -cpsc_obid => q{hbClShdpdcmp1z0admin-cxi},
          -cpsc => q{99.12.13},
          -flags => 80 },
        { -label => q{99.12.14 - Tap Screw-Raised Oval Cross STNLSSTL-Ab},
          -cpsc_obid => q{hbClShfpdcmp1z0admin-cxi},
          -cpsc => q{99.12.14},
          -flags => 80 },
        { -label => q{99.12.15 - Tap Screw-Round WSHR Cross-Ab},
          -cpsc_obid => q{hbClShhpdcmp1z0admin-cxi},
          -cpsc => q{99.12.15},
          -flags => 80 },
        { -label => q{99.12.16 - Tap Screw-Round WSHR Cross-B},
          -cpsc_obid => q{hbClShjpdcmp1z0admin-cxi},
          -cpsc => q{99.12.16},
          -flags => 80 } ] },
    { -label => q{99.13 - WSF Washers},
      -cpsc_obid => q{hbClSiapdcmp1z0admin-cxi},
      -cpsc => q{99.13.00},
      -flags => 88,
      -children => [
        { -label => q{99.13.01 - Washer-Flat},
          -cpsc_obid => q{hbClSicpdcmp1z0admin-cxi},
          -cpsc => q{99.13.01},
          -flags => 80 },
        { -label => q{99.13.02 - Washer-Plain Bowed Type H},
          -cpsc_obid => q{hbClSiepdcmp1z0admin-cxi},
          -cpsc => q{99.13.02},
          -flags => 80 },
        { -label => q{99.13.03 - Washer-Plain Conical Type G},
          -cpsc_obid => q{hbClSigpdcmp1z0admin-cxi},
          -cpsc => q{99.13.03},
          -flags => 80 },
        { -label => q{99.13.04 - Washer-Toothed Type B},
          -cpsc_obid => q{hbClSiipdcmp1z0admin-cxi},
          -cpsc => q{99.13.04},
          -flags => 80 },
        { -label => q{99.13.05 - Washer-Toothed Type D},
          -cpsc_obid => q{hbClSikpdcmp1z0admin-cxi},
          -cpsc => q{99.13.05},
          -flags => 80 },
        { -label => q{99.13.06 - Washer-Toothed Type F},
          -cpsc_obid => q{hbClSjcpdcmp1z0admin-cxi},
          -cpsc => q{99.13.06},
          -flags => 80 },
        { -label => q{99.13.07 - Washer-Toothed Type E},
          -cpsc_obid => q{hbClSjepdcmp1z0admin-cxi},
          -cpsc => q{99.13.07},
          -flags => 80 } ] },
    { -label => q{99.20 - Power Tools},
      -cpsc_obid => q{hbClSjgpdcmp1z0admin-cxi},
      -cpsc => q{99.20.00},
      -flags => 88,
      -children => [
        { -label => q{99.20.01 - Drivers},
          -cpsc_obid => q{hbClSjipdcmp1z0admin-cxi},
          -cpsc => q{99.20.01},
          -flags => 80 },
        { -label => q{99.20.02 - Extensions},
          -cpsc_obid => q{hbClSjkpdcmp1z0admin-cxi},
          -cpsc => q{99.20.02},
          -flags => 80 },
        { -label => q{99.20.03 - Tool Box},
          -cpsc_obid => q{hbClSkbpdcmp1z0admin-cxi},
          -cpsc => q{99.20.03},
          -flags => 80 } ] } ] },

{ -label => q{XX - Non-Automotive Application System},
  -cpsc_obid => q{hmpoOtipdcmp1z0admin-p6Q},
  -cpsc => q{XX.00.00},
  -flags => 88,
  -children => [
    { -label => q{XX.60 - Non-Automotive Application},
      -cpsc_obid => q{hbClSkdpdcmp1z0admin-cxi},
      -cpsc => q{XX.60.00},
      -flags => 88,
      -children => [
        { -label => q{XX.60.01 - Unique Non-Automotive Assemblies},
          -cpsc_obid => q{hbClSkfpdcmp1z0admin-cxi},
          -cpsc => q{XX.60.01},
          -flags => 80 },
        { -label => q{XX.60.02 - Unique Non-Automotive Components},
          -cpsc_obid => q{hbClSkhpdcmp1z0admin-cxi},
          -cpsc => q{XX.60.02},
          -flags => 80 } ] } ] },

{ -label => q{APIL - Hinges A-Piller},
  -chunk_obid => q{hhvov6apdcmp1z0admin-hAM},
  -chunk => q{APIL},
  -flags => 80 },

{ -label => q{BDYSYS - Body System},
  -chunk_obid => q{giEeahgpdcmp1z0admin-bab},
  -chunk => q{BDYSYS},
  -flags => 80 },

{ -label => q{BPIL - Hinges B-Piller},
  -chunk_obid => q{hhvoixepdcmp1z0admin-hAJ},
  -chunk => q{BPIL},
  -flags => 80 },

{ -label => q{BSTSHM - Body Structure/Sheet Metal},
  -chunk_obid => q{giEkSLfpdcmp1z0admin-bae},
  -chunk => q{BSTSHM},
  -flags => 88,
  -children => [
    { -label => q{BIW - Body In White},
      -chunk_obid => q{giEkSMbpdcmp1z0admin-bae},
      -chunk => q{BIW},
      -flags => 88,
      -children => [
        { -label => q{APILAR - Hinges A-Pillar},
          -chunk_obid => q{hmjqtxkpdcmp1z0admin-phs},
          -chunk => q{APILAR},
          -flags => 80 },
        { -label => q{BATTRY - Battery Tray},
          -chunk_obid => q{hmjqfIjpdcmp1z0admin-phn},
          -chunk => q{BATTRY},
          -flags => 80 },
        { -label => q{BPILAR - Hinges B-Pillar},
          -chunk_obid => q{hmjqfLgpdcmp1z0admin-phn},
          -chunk => q{BPILAR},
          -flags => 80 },
        { -label => q{CPILAR - Gas Strut C-Pillar},
          -chunk_obid => q{hmjqtyfpdcmp1z0admin-phs},
          -chunk => q{CPILAR},
          -flags => 80 },
        { -label => q{DASH - Dash},
          -chunk_obid => q{hmjqfMipdcmp1z0admin-phn},
          -chunk => q{DASH},
          -flags => 80 },
        { -label => q{DPILAR - Gas Strut D-Pillar},
          -chunk_obid => q{hmjqfMbpdcmp1z0admin-phn},
          -chunk => q{DPILAR},
          -flags => 80 },
        { -label => q{FENDER - Fender},
          -chunk_obid => q{hmjqfLapdcmp1z0admin-phn},
          -chunk => q{FENDER},
          -flags => 80 },
        { -label => q{FLRPAN - Floor Panel Fatigue},
          -chunk_obid => q{hhvoABgpdcmp1z0admin-hAO},
          -chunk => q{FLRPAN},
          -flags => 80 },
        { -label => q{FRSHIP - Front Shipping Tie Down},
          -chunk_obid => q{hmjqfKfpdcmp1z0admin-phn},
          -chunk => q{FRSHIP},
          -flags => 80 },
        { -label => q{FSTRUT - Front Strut},
          -chunk_obid => q{hmjqtEfpdcmp1z0admin-pht},
          -chunk => q{FSTRUT},
          -flags => 80 },
        { -label => q{GRABHD - Grab/Strap Handle},
          -chunk_obid => q{hmjqtzapdcmp1z0admin-phs},
          -chunk => q{GRABHD},
          -flags => 80 },
        { -label => q{JOINTS - Joints},
          -chunk_obid => q{hmjqNshpdcmp1z0admin-phv},
          -chunk => q{JOINTS},
          -flags => 80 },
        { -label => q{LUGCAR - Luggage Carrier},
          -chunk_obid => q{hmjqtwjpdcmp1z0admin-phs},
          -chunk => q{LUGCAR},
          -flags => 80 },
        { -label => q{RRSHIP - Rear Shipping Tie Down},
          -chunk_obid => q{hmjqtxepdcmp1z0admin-phs},
          -chunk => q{RRSHIP},
          -flags => 80 },
        { -label => q{RSTRUT - Rear Strut},
          -chunk_obid => q{hmjqfJipdcmp1z0admin-phn},
          -chunk => q{RSTRUT},
          -flags => 80 },
        { -label => q{TRAILR - Trailer},
          -chunk_obid => q{hmjqtFcpdcmp1z0admin-pht},
          -chunk => q{TRAILR},
          -flags => 80 } ] },
    { -label => q{TOWHK - Towing Hook},
      -chunk_obid => q{hhvn34hpdcmp1z0admin-hAF},
      -chunk => q{TOWHK},
      -flags => 88,
      -children => [
        { -label => q{FTOWHK - Front Towing Hook},
          -chunk_obid => q{hhvopygpdcmp1z0admin-hAL},
          -chunk => q{FTOWHK},
          -flags => 80 },
        { -label => q{RTOWHK - Rear Towing Hook},
          -chunk_obid => q{hhvofSapdcmp1z0admin-hAJ},
          -chunk => q{RTOWHK},
          -flags => 80 } ] },
    { -label => q{TRLCPL - Trailer Coupling},
      -chunk_obid => q{hhvofSgpdcmp1z0admin-hAJ},
      -chunk => q{TRLCPL},
      -flags => 80 },
    { -label => q{TRMBDY - Trimmed Body},
      -chunk_obid => q{hhvn34apdcmp1z0admin-hAF},
      -chunk => q{TRMBDY},
      -flags => 88,
      -children => [
        { -label => q{BIP - Body in Prime},
          -chunk_obid => q{hmjqgDjpdcmp1z0admin-php},
          -chunk => q{BIP},
          -flags => 88,
          -children => [
            { -label => q{*** See BIW - Body In White},
              -flags => 80 } ] },
        { -label => q{CLSURE - Closures},
          -chunk_obid => q{giEkgyepdcmp1z0admin-bac},
          -chunk => q{CLSURE},
          -flags => 88,
          -children => [
            { -label => q{*** See 01.03.01 - Front Side Doors},
              -flags => 80 },
            { -label => q{*** See 01.03.02 - Rear Side Doors},
              -flags => 80 },
            { -label => q{*** See 01.03.03 - Rear Deck Lid Truck Back Doors Tailgate and Liftgate},
              -flags => 80 },
            { -label => q{*** See 01.03.04 - Storage Access Doors},
              -flags => 80 },
            { -label => q{FRDOOR - },
              -chunk_obid => q{hhkuBKepdcmp1z0admin-hiC},
              -chunk => q{FRDOOR},
              -flags => 80 },
            { -label => q{HOOD - Hood},
              -chunk_obid => q{hglpKXipdcmp1z0admin-fQf},
              -chunk => q{HOOD},
              -flags => 80 },
            { -label => q{LFTGTE - Liftgate},
              -chunk_obid => q{hmkot7kpdcmp1z0admin-pkY},
              -chunk => q{LFTGTE},
              -flags => 80 },
            { -label => q{RRDOOR - },
              -chunk_obid => q{hhkuBKkpdcmp1z0admin-hiC},
              -chunk => q{RRDOOR},
              -flags => 80 } ] },
        { -label => q{EXTR - Exterior},
          -chunk_obid => q{giEeajcpdcmp1z0admin-bab},
          -chunk => q{EXTR},
          -flags => 88,
          -children => [
            { -label => q{*** See 01.19.01 - Front Bumper},
              -flags => 80 },
            { -label => q{*** See 01.19.02 - Rear Bumper},
              -flags => 80 },
            { -label => q{AISYS - Air Induction Systems},
              -chunk_obid => q{giEkS0jpdcmp1z0admin-bae},
              -chunk => q{AISYS},
              -flags => 80 },
            { -label => q{BDYMEC - Body Mechanisms},
              -chunk_obid => q{giEkgAcpdcmp1z0admin-bac},
              -chunk => q{BDYMEC},
              -flags => 80 },
            { -label => q{EXTRTR - Exterior Trim},
              -chunk_obid => q{giEkSMkpdcmp1z0admin-bae},
              -chunk => q{EXTRTR},
              -flags => 80 },
            { -label => q{GLASS - Glass},
              -chunk_obid => q{giEkgzgpdcmp1z0admin-bac},
              -chunk => q{GLASS},
              -flags => 80 },
            { -label => q{WWMODA - Wipers/Washers Module Assembly},
              -chunk_obid => q{giEkSObpdcmp1z0admin-bae},
              -chunk => q{WWMODA},
              -flags => 88,
              -children => [
                { -label => q{WPBRKT - Wiper Module Bracket},
                  -chunk_obid => q{giEkgBcpdcmp1z0admin-bac},
                  -chunk => q{WPBRKT},
                  -flags => 80 },
                { -label => q{WPCMOD - Wiper Control Module},
                  -chunk_obid => q{giEkgBjpdcmp1z0admin-bac},
                  -chunk => q{WPCMOD},
                  -flags => 88,
                  -children => [
                    { -label => q{WMDHSG - Wiper Module Housing},
                      -chunk_obid => q{giEkSRbpdcmp1z0admin-bae},
                      -chunk => q{WMDHSG},
                      -flags => 80 },
                    { -label => q{WPCBRD - Wiper Module Circuit Board},
                      -chunk_obid => q{giEealhpdcmp1z0admin-bab},
                      -chunk => q{WPCBRD},
                      -flags => 88,
                      -children => [
                        { -label => q{WMDBRD - Wiper Module Board},
                          -chunk_obid => q{giEkgDapdcmp1z0admin-bac},
                          -chunk => q{WMDBRD},
                          -flags => 80 },
                        { -label => q{WMELEC - Wiper Module Electrical Components},
                          -chunk_obid => q{giEkSQfpdcmp1z0admin-bae},
                          -chunk => q{WMELEC},
                          -flags => 80 } ] },
                    { -label => q{WPCTR - Wiper Module Connector},
                      -chunk_obid => q{giEkSPdpdcmp1z0admin-bae},
                      -chunk => q{WPCTR},
                      -flags => 80 } ] } ] } ] },
        { -label => q{INTR - Interior},
          -chunk_obid => q{giEkgOipdcmp1z0admin-bac},
          -chunk => q{INTR},
          -flags => 88,
          -children => [
            { -label => q{*** See 01.20 - Occupant Restraining Device Subsystem},
              -flags => 80 },
            { -label => q{*** See 01.05.05 - Front Side Door-Trim and Ornamentation},
              -flags => 80 },
            { -label => q{*** See 01.05.06 - Rear Side Door-Trim and Ornamentation},
              -flags => 80 },
            { -label => q{*** See 01.12.01 - Instrument Panel},
              -flags => 80 },
            { -label => q{*** See 01.12.02 - Console Unit},
              -flags => 80 },
            { -label => q{INTRTR - Interior Trim},
              -chunk_obid => q{giEkgPhpdcmp1z0admin-bac},
              -chunk => q{INTRTR},
              -flags => 80 },
            { -label => q{STRSTN - Seating and Restraints},
              -chunk_obid => q{giEkTaipdcmp1z0admin-bae},
              -chunk => q{STRSTN},
              -flags => 80 } ] } ] } ] },

{ -label => q{CHDRST - Child Restraint System},
  -chunk_obid => q{hhvoewkpdcmp1z0admin-hAH},
  -chunk => q{CHDRST},
  -flags => 80 },

{ -label => q{CPIL - Cas Strut C-Piller},
  -chunk_obid => q{hhvov6ipdcmp1z0admin-hAM},
  -chunk => q{CPIL},
  -flags => 80 },

{ -label => q{DPIL - Cas Strut D-Piller},
  -chunk_obid => q{hhvoizbpdcmp1z0admin-hAJ},
  -chunk => q{DPIL},
  -flags => 80 },

{ -label => q{FPDSVE - FPDS Vehicle},
  -chunk_obid => q{gjulXEjpdcmp1z0admin-bky},
  -chunk => q{FPDSVE},
  -flags => 88,
  -children => [
    { -label => q{CCSYST - Climate Control System},
      -chunk_obid => q{giEnGvipdcmp1z0admin-bak},
      -chunk => q{CCSYST},
      -flags => 88,
      -children => [
        { -label => q{AHSICU - Air Handling System and Interior Comfort},
          -chunk_obid => q{giElcujpdcmp1z0admin-baf},
          -chunk => q{AHSICU},
          -flags => 88,
          -children => [
            { -label => q{AEXTR - Air Extractors},
              -chunk_obid => q{giElcgapdcmp1z0admin-bag},
              -chunk => q{AEXTR},
              -flags => 80 },
            { -label => q{COWL - Cowl},
              -chunk_obid => q{giElb7fpdcmp1z0admin-bag},
              -chunk => q{COWL},
              -flags => 80 },
            { -label => q{DFDUCT - Defroster Ducts},
              -chunk_obid => q{giEnWOdpdcmp1z0admin-bal},
              -chunk => q{DFDUCT},
              -flags => 88,
              -children => [
                { -label => q{DDUCTS - Dimister Ducts},
                  -chunk_obid => q{giEnGNbpdcmp1z0admin-bak},
                  -chunk => q{DDUCTS},
                  -flags => 88,
                  -children => [
                    { -label => q{DMSTRS - Dimisters},
                      -chunk_obid => q{giElchdpdcmp1z0admin-bag},
                      -chunk => q{DMSTRS},
                      -flags => 80 } ] },
                { -label => q{WDFRST - Windshield Defrosting},
                  -chunk_obid => q{giElcicpdcmp1z0admin-bag},
                  -chunk => q{WDFRST},
                  -flags => 80 } ] },
            { -label => q{FDUCTS - Floor Ducts},
              -chunk_obid => q{giEnGOdpdcmp1z0admin-bak},
              -chunk => q{FDUCTS},
              -flags => 80 },
            { -label => q{HVACUT - HVAC Unit},
              -chunk_obid => q{giEnGCgpdcmp1z0admin-bak},
              -chunk => q{HVACUT},
              -flags => 88,
              -children => [
                { -label => q{BFNSCR - Blower Fan and Scroll},
                  -chunk_obid => q{giElcwcpdcmp1z0admin-baf},
                  -chunk => q{BFNSCR},
                  -flags => 80 },
                { -label => q{EASLY - Evaporator Assembly Unit},
                  -chunk_obid => q{giElcdgpdcmp1z0admin-bag},
                  -chunk => q{EASLY},
                  -flags => 88,
                  -children => [
                    { -label => q{DSECT - Diffuser Section},
                      -chunk_obid => q{giEnGHhpdcmp1z0admin-bak},
                      -chunk => q{DSECT},
                      -flags => 80 },
                    { -label => q{ECRASL - Evaporator Core Assembly},
                      -chunk_obid => q{giEnGIgpdcmp1z0admin-bak},
                      -chunk => q{ECRASL},
                      -flags => 88,
                      -children => [
                        { -label => q{ECORE - Evaporator Core},
                          -chunk_obid => q{giElcAfpdcmp1z0admin-baf},
                          -chunk => q{ECORE},
                          -flags => 80 },
                        { -label => q{EFINS - Evaporator Fins},
                          -chunk_obid => q{giEnGJgpdcmp1z0admin-bak},
                          -chunk => q{EFINS},
                          -flags => 80 } ] } ] },
                { -label => q{FLTR - Filter},
                  -chunk_obid => q{giEnGDfpdcmp1z0admin-bak},
                  -chunk => q{FLTR},
                  -flags => 80 },
                { -label => q{PASLY - Plenum Assembly},
                  -chunk_obid => q{giEnGEfpdcmp1z0admin-bak},
                  -chunk => q{PASLY},
                  -flags => 88,
                  -children => [
                    { -label => q{HCRASL - Heater Core Assembly},
                      -chunk_obid => q{giElcxcpdcmp1z0admin-baf},
                      -chunk => q{HCRASL},
                      -flags => 88,
                      -children => [
                        { -label => q{HCORE - Heater Core},
                          -chunk_obid => q{giElcxjpdcmp1z0admin-baf},
                          -chunk => q{HCORE},
                          -flags => 80 },
                        { -label => q{HFINS - Heater Fins},
                          -chunk_obid => q{giElcbfpdcmp1z0admin-bag},
                          -chunk => q{HFINS},
                          -flags => 80 } ] },
                    { -label => q{PLENUM - Plenum},
                      -chunk_obid => q{giEnGFjpdcmp1z0admin-bak},
                      -chunk => q{PLENUM},
                      -flags => 88,
                      -children => [
                        { -label => q{BDOORS - Blend Doors},
                          -chunk_obid => q{giElccgpdcmp1z0admin-bag},
                          -chunk => q{BDOORS},
                          -flags => 80 },
                        { -label => q{MDOORS - Mold Doors},
                          -chunk_obid => q{giElczcpdcmp1z0admin-baf},
                          -chunk => q{MDOORS},
                          -flags => 80 } ] } ] } ] },
            { -label => q{IAFLOW - Interior Air Flow},
              -chunk_obid => q{giEnWNepdcmp1z0admin-bal},
              -chunk => q{IAFLOW},
              -flags => 80 },
            { -label => q{PDUCTS - Panel Ducts},
              -chunk_obid => q{giEnGKfpdcmp1z0admin-bak},
              -chunk => q{PDUCTS},
              -flags => 88,
              -children => [
                { -label => q{PRGSTR - Panel Registers},
                  -chunk_obid => q{giElcejpdcmp1z0admin-bag},
                  -chunk => q{PRGSTR},
                  -flags => 80 } ] },
            { -label => q{RDUCT - Rear Ducts},
              -chunk_obid => q{giEnWMbpdcmp1z0admin-bal},
              -chunk => q{RDUCT},
              -flags => 88,
              -children => [
                { -label => q{RRGSTR - Rear Registers},
                  -chunk_obid => q{giEnGLhpdcmp1z0admin-bak},
                  -chunk => q{RRGSTR},
                  -flags => 80 } ] } ] },
        { -label => q{ECMPT - Engine Compartment},
          -chunk_obid => q{giEnGwepdcmp1z0admin-bak},
          -chunk => q{ECMPT},
          -flags => 88,
          -children => [
            { -label => q{*** See 03.03 - Engine Cooling},
              -flags => 80 },
            { -label => q{ACRFG - A/C Refrigerant System},
              -chunk_obid => q{giEnGzdpdcmp1z0admin-bak},
              -chunk => q{ACRFG},
              -flags => 88,
              -children => [
                { -label => q{ACLTR - Accumulator},
                  -chunk_obid => q{giEnGBepdcmp1z0admin-bak},
                  -chunk => q{ACLTR},
                  -flags => 80 },
                { -label => q{CMPRCL - Compressor/Clutch},
                  -chunk_obid => q{giElcthpdcmp1z0admin-baf},
                  -chunk => q{CMPRCL},
                  -flags => 80 },
                { -label => q{CNDSR - Condenser},
                  -chunk_obid => q{giElb6dpdcmp1z0admin-bag},
                  -chunk => q{CNDSR},
                  -flags => 80 },
                { -label => q{HSTUBE - Hoses/Tubes},
                  -chunk_obid => q{giEnGAcpdcmp1z0admin-bak},
                  -chunk => q{HSTUBE},
                  -flags => 80 } ] } ] } ] },
    { -label => q{CHASYS - Chassis System},
      -chunk_obid => q{giEkhBhpdcmp1z0admin-bad},
      -chunk => q{CHASYS},
      -flags => 88,
      -children => [
        { -label => q{*** See 06 - Brake System},
          -flags => 80 },
        { -label => q{*** See 10 - Fuel System},
          -flags => 80 },
        { -label => q{FRMTNG - Frame/Mounting},
          -chunk_obid => q{giEnGsdpdcmp1z0admin-bak},
          -chunk => q{FRMTNG},
          -flags => 88,
          -children => [
            { -label => q{PWTNMT - Powertrain mounts},
              -chunk_obid => q{giElb1bpdcmp1z0admin-bag},
              -chunk => q{PWTNMT},
              -flags => 88,
              -children => [
                { -label => q{ENGDMP - Engine Motion Dampers},
                  -chunk_obid => q{giEnGvbpdcmp1z0admin-bak},
                  -chunk => q{ENGDMP},
                  -flags => 80 },
                { -label => q{ENGMTS - Engine Mounts},
                  -chunk_obid => q{giEnGtkpdcmp1z0admin-bak},
                  -chunk => q{ENGMTS},
                  -flags => 80 },
                { -label => q{RLRSTC - Roll Restrictors},
                  -chunk_obid => q{giElb2dpdcmp1z0admin-bag},
                  -chunk => q{RLRSTC},
                  -flags => 80 },
                { -label => q{TRNSMT - Transmission/ Transaxle Mounts or Crossmembers},
                  -chunk_obid => q{giElcphpdcmp1z0admin-baf},
                  -chunk => q{TRNSMT},
                  -flags => 80 } ] } ] },
        { -label => q{STNG - Steering},
          -chunk_obid => q{giElbUjpdcmp1z0admin-bag},
          -chunk => q{STNG},
          -flags => 80 },
        { -label => q{SUSP - Suspension},
          -chunk_obid => q{giElcgdpdcmp1z0admin-baf},
          -chunk => q{SUSP},
          -flags => 88,
          -children => [
            { -label => q{FRAME - },
              -chunk_obid => q{hhkuP5jpdcmp1z0admin-hiF},
              -chunk => q{FRAME},
              -flags => 80 },
            { -label => q{FRSUSP - Front Suspension},
              -chunk_obid => q{giElbThpdcmp1z0admin-bag},
              -chunk => q{FRSUSP},
              -flags => 88,
              -children => [
                { -label => q{FRSBFR - Front Sub-Frame},
                  -chunk_obid => q{hfipaVjpdcmp1z0admin-epN},
                  -chunk => q{FRSBFR},
                  -flags => 80 },
                { -label => q{L-ARM - L-Arm},
                  -chunk_obid => q{hfimXLbpdcmp1z0admin-eoh},
                  -chunk => q{L-ARM},
                  -flags => 80 } ] },
            { -label => q{RRSUSP - Rear Suspension},
              -chunk_obid => q{giEkhCjpdcmp1z0admin-bad},
              -chunk => q{RRSUSP},
              -flags => 88,
              -children => [
                { -label => q{*** See L-ARM - L-Arm},
                  -flags => 80 },
                { -label => q{RRKNLE - Rear Knuckle},
                  -chunk_obid => q{hggsWfhpdcmp1z0admin-fCe},
                  -chunk => q{RRKNLE},
                  -flags => 80 },
                { -label => q{RRSBFR - Rear Subframe},
                  -chunk_obid => q{hfimO0bpdcmp1z0admin-en6},
                  -chunk => q{RRSBFR},
                  -flags => 80 },
                { -label => q{TRLARM - Trailing Arm},
                  -chunk_obid => q{hggpURbpdcmp1z0admin-fA6},
                  -chunk => q{TRLARM},
                  -flags => 80 } ] },
            { -label => q{WHLTIR - Wheels/Tires},
              -chunk_obid => q{giElchfpdcmp1z0admin-baf},
              -chunk => q{WHLTIR},
              -flags => 80 } ] } ] },
    { -label => q{ELESYS - Electrical System},
      -chunk_obid => q{giEkTugpdcmp1z0admin-bae},
      -chunk => q{ELESYS},
      -flags => 88,
      -children => [
        { -label => q{*** See 15 - In-Vehicle Entertainment System},
          -flags => 80 },
        { -label => q{BDYCNT - Body Control},
          -chunk_obid => q{giEkhidpdcmp1z0admin-bac},
          -chunk => q{BDYCNT},
          -flags => 80 },
        { -label => q{ELDSTR - Electrical Distribution},
          -chunk_obid => q{giEkhgepdcmp1z0admin-bac},
          -chunk => q{ELDSTR},
          -flags => 80 },
        { -label => q{ELECTL - Electric/Electronic Controls},
          -chunk_obid => q{giElbDgpdcmp1z0admin-baf},
          -chunk => q{ELECTL},
          -flags => 88,
          -children => [
            { -label => q{ELTCMP - Electric Temperature Control Module},
              -chunk_obid => q{giEkTBcpdcmp1z0admin-bae},
              -chunk => q{ELTCMP},
              -flags => 88,
              -children => [
                { -label => q{ELCBHS - Electronic Climate Control Circuit Board and Heat Sink},
                  -chunk_obid => q{giEkhmjpdcmp1z0admin-bac},
                  -chunk => q{ELCBHS},
                  -flags => 88,
                  -children => [
                    { -label => q{ELCBRD - Electronic Climate Control Circuit Board},
                      -chunk_obid => q{giEkTCepdcmp1z0admin-bae},
                      -chunk => q{ELCBRD},
                      -flags => 88,
                      -children => [
                        { -label => q{ELCCBD - Electronic Climate Control Board},
                          -chunk_obid => q{giElbFfpdcmp1z0admin-baf},
                          -chunk => q{ELCCBD},
                          -flags => 80 },
                        { -label => q{ELCCEC - Electronic Climate Control Electrical Components},
                          -chunk_obid => q{giElbGbpdcmp1z0admin-baf},
                          -chunk => q{ELCCEC},
                          -flags => 80 } ] },
                    { -label => q{ELCCHS - Electronic Climate Control Heat Sink},
                      -chunk_obid => q{giEkTDgpdcmp1z0admin-bae},
                      -chunk => q{ELCCHS},
                      -flags => 80 } ] },
                { -label => q{ELCCCT - Electronic Climate Control Connector},
                  -chunk_obid => q{giElbEdpdcmp1z0admin-baf},
                  -chunk => q{ELCCCT},
                  -flags => 80 },
                { -label => q{ELCHSG - Electronic Climate Control Housing},
                  -chunk_obid => q{giEkhogpdcmp1z0admin-bac},
                  -chunk => q{ELCHSG},
                  -flags => 80 } ] } ] },
        { -label => q{ELEPGS - Electrical Power Generation/Storage},
          -chunk_obid => q{giEkTvcpdcmp1z0admin-bae},
          -chunk => q{ELEPGS},
          -flags => 80 },
        { -label => q{ELTRFR - Electronic Features},
          -chunk_obid => q{giEea2jpdcmp1z0admin-bab},
          -chunk => q{ELTRFR},
          -flags => 88,
          -children => [
            { -label => q{CNTGID - Controls & Guidance},
              -chunk_obid => q{giEea4apdcmp1z0admin-bab},
              -chunk => q{CNTGID},
              -flags => 80 },
            { -label => q{IND - Indicators},
              -chunk_obid => q{giEea3epdcmp1z0admin-bab},
              -chunk => q{IND},
              -flags => 80 } ] } ] },
    { -label => q{PTOSYS - Powertrain System},
      -chunk_obid => q{giEkhpfpdcmp1z0admin-bac},
      -chunk => q{PTOSYS},
      -flags => 88,
      -children => [
        { -label => q{*** See 05 - Driveline System},
          -flags => 80 },
        { -label => q{*** See 09 - Exhaust System},
          -flags => 80 },
        { -label => q{PLTSYS - Powerplant System},
          -chunk_obid => q{giElbHfpdcmp1z0admin-baf},
          -chunk => q{PLTSYS},
          -flags => 88,
          -children => [
            { -label => q{*** See 03 - Engine System},
              -flags => 80 },
            { -label => q{*** See 07 - Transmission System},
              -flags => 80 },
            { -label => q{*** See 08 - Clutch System},
              -flags => 80 } ] },
        { -label => q{PTCTRL - Power Train Electronic Controls},
          -chunk_obid => q{giElb2fpdcmp1z0admin-baf},
          -chunk => q{PTCTRL},
          -flags => 88,
          -children => [
            { -label => q{*** See 03.19 - Automatic Vehicle Speed Control SPDCTL},
              -flags => 80 },
            { -label => q{EECTRL - Electronic Engine Control},
              -chunk_obid => q{giEmSydpdcmp1z0admin-baj},
              -chunk => q{EECTRL},
              -flags => 88,
              -children => [
                { -label => q{ECBRKT - EEC Combined Bracket},
                  -chunk_obid => q{giElb3gpdcmp1z0admin-baf},
                  -chunk => q{ECBRKT},
                  -flags => 88,
                  -children => [
                    { -label => q{EBRKT1 - EEC Bracket 1},
                      -chunk_obid => q{giEkhrhpdcmp1z0admin-bad},
                      -chunk => q{EBRKT1},
                      -flags => 80 },
                    { -label => q{EBRKT2 - EEC Bracket 2},
                      -chunk_obid => q{giEmSzfpdcmp1z0admin-baj},
                      -chunk => q{EBRKT2},
                      -flags => 80 } ] },
                { -label => q{EECMOD - EEC Module},
                  -chunk_obid => q{giElb5hpdcmp1z0admin-baf},
                  -chunk => q{EECMOD},
                  -flags => 88,
                  -children => [
                    { -label => q{EECBRD - EEC Board},
                      -chunk_obid => q{giEkhucpdcmp1z0admin-bad},
                      -chunk => q{EECBRD},
                      -flags => 80 },
                    { -label => q{EECCTR - EEC Connector},
                      -chunk_obid => q{giEkhtgpdcmp1z0admin-bad},
                      -chunk => q{EECCTR},
                      -flags => 80 },
                    { -label => q{EECECM - EEC Electrical Components},
                      -chunk_obid => q{giElbKepdcmp1z0admin-bag},
                      -chunk => q{EECECM},
                      -flags => 80 },
                    { -label => q{EECHSR - EEC Heat Sink / Rail},
                      -chunk_obid => q{giElb7cpdcmp1z0admin-baf},
                      -chunk => q{EECHSR},
                      -flags => 80 },
                    { -label => q{EECSCL - EEC Spring Clips},
                      -chunk_obid => q{giElbJcpdcmp1z0admin-bag},
                      -chunk => q{EECSCL},
                      -flags => 80 } ] },
                { -label => q{EECSEL - EEC Cover / Seal},
                  -chunk_obid => q{giElb4ipdcmp1z0admin-baf},
                  -chunk => q{EECSEL},
                  -flags => 80 } ] } ] },
        { -label => q{*** See WHLTIR - Wheels/Tires},
          -flags => 80 } ] },
    { -label => q{*** See TRMBDY - Trimmed Body},
      -flags => 80 } ] },

{ -label => q{FRSDDR - Front Side Door},
  -chunk_obid => q{hmkot6hpdcmp1z0admin-pkY},
  -chunk => q{FRSDDR},
  -flags => 80 },

{ -label => q{FRSEAT - Front Seat Anchorage},
  -chunk_obid => q{hmjqNTepdcmp1z0admin-phx},
  -chunk => q{FRSEAT},
  -flags => 80 },

{ -label => q{LARM - },
  -chunk_obid => q{hhpsHfepdcmp1z0admin-hqT},
  -chunk => q{LARM},
  -flags => 80 },

{ -label => q{LIFTGA - },
  -chunk_obid => q{hhkuP6gpdcmp1z0admin-hiF},
  -chunk => q{LIFTGA},
  -flags => 80 },

{ -label => q{LUGRET - Luggage Retention},
  -chunk_obid => q{hhvoAwjpdcmp1z0admin-hAO},
  -chunk => q{LUGRET},
  -flags => 80 },

{ -label => q{PARKBR - Hand/Parking Brake},
  -chunk_obid => q{hhvovOdpdcmp1z0admin-hAM},
  -chunk => q{PARKBR},
  -flags => 80 },

{ -label => q{PEDAL - Brake Pedal Support},
  -chunk_obid => q{hhvofUapdcmp1z0admin-hAJ},
  -chunk => q{PEDAL},
  -flags => 80 },

{ -label => q{RRSDDR - Rear Side Door},
  -chunk_obid => q{hmkovjcpdcmp1z0admin-pk1},
  -chunk => q{RRSDDR},
  -flags => 80 },

{ -label => q{RRSEAT - Rear Seat Anchorage},
  -chunk_obid => q{hmjqtzgpdcmp1z0admin-phs},
  -chunk => q{RRSEAT},
  -flags => 80 },

{ -label => q{SBELT - Seat Belt Anchorage},
  -chunk_obid => q{hhvovPapdcmp1z0admin-hAM},
  -chunk => q{SBELT},
  -flags => 88,
  -children => [
    { -label => q{FSBELT - Front Seat Belt Anchorage},
      -chunk_obid => q{hhvofUgpdcmp1z0admin-hAJ},
      -chunk => q{FSBELT},
      -flags => 80 },
    { -label => q{MSBELT - Mid Seat Belt Anchorage RR},
      -chunk_obid => q{hhvoexjpdcmp1z0admin-hAI},
      -chunk => q{MSBELT},
      -flags => 80 },
    { -label => q{RSBELT - Rear Seat Belt Anchorage},
      -chunk_obid => q{hhvovPgpdcmp1z0admin-hAM},
      -chunk => q{RSBELT},
      -flags => 80 } ] },

{ -label => q{SEAT - Seat Anchorage},
  -chunk_obid => q{hhvn4dipdcmp1z0admin-hAF},
  -chunk => q{SEAT},
  -flags => 88,
  -children => [
    { -label => q{FSEAT - Front Seat Anchorage},
      -chunk_obid => q{hhvn4ffpdcmp1z0admin-hAF},
      -chunk => q{FSEAT},
      -flags => 80 },
    { -label => q{RSEAT - Rear Seat Anchorage},
      -chunk_obid => q{hhvoewbpdcmp1z0admin-hAH},
      -chunk => q{RSEAT},
      -flags => 80 } ] },

{ -label => q{SHIP - Shipping Tie Rod},
  -chunk_obid => q{hhvoesfpdcmp1z0admin-hAH},
  -chunk => q{SHIP},
  -flags => 88,
  -children => [
    { -label => q{FSHIP - Front Shipping Tie Rod},
      -chunk_obid => q{hhvofTepdcmp1z0admin-hAJ},
      -chunk => q{FSHIP},
      -flags => 80 },
    { -label => q{RSHIP - Rear Shipping Tie Rod},
      -chunk_obid => q{hhvoetbpdcmp1z0admin-hAH},
      -chunk => q{RSHIP},
      -flags => 80 } ] },

{ -label => q{SLDBAR - Slide Bar Strength},
  -chunk_obid => q{hhvopCkpdcmp1z0admin-hAL},
  -chunk => q{SLDBAR},
  -flags => 80 },

{ -label => q{TETHER - Child Tether Anchorage},
  -chunk_obid => q{hhvof0dpdcmp1z0admin-hAJ},
  -chunk => q{TETHER},
  -flags => 80 } ];
}

1;
