; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

declare void @use.i8(i8)
define i1 @sdiv_exact_eq_0(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_eq_0(
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %d = sdiv exact i8 %x, %y
  %r = icmp eq i8 %d, 0
  ret i1 %r
}

define i1 @udiv_exact_ne_0(i8 %x, i8 %y) {
; CHECK-LABEL: @udiv_exact_ne_0(
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %d = udiv exact i8 %x, %y
  %r = icmp ne i8 %d, 0
  ret i1 %r
}

define i1 @sdiv_exact_ne_1(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_ne_1(
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[X:%.*]], 0
; CHECK-NEXT:    ret i1 [[R]]
;
  %d = sdiv exact i8 %x, %y
  %r = icmp eq i8 %d, 0
  ret i1 %r
}

define i1 @udiv_exact_eq_1(i8 %x, i8 %y) {
; CHECK-LABEL: @udiv_exact_eq_1(
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %d = udiv exact i8 %x, %y
  %r = icmp ne i8 %d, 1
  ret i1 %r
}

define i1 @sdiv_exact_eq_9_no_of(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_eq_9_no_of(
; CHECK-NEXT:    [[YY:%.*]] = and i8 [[Y:%.*]], 7
; CHECK-NEXT:    [[TMP1:%.*]] = mul nuw nsw i8 [[YY]], 9
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = and i8 %y, 7
  %d = sdiv exact i8 %x, %yy
  %r = icmp eq i8 %d, 9
  ret i1 %r
}

define i1 @sdiv_exact_eq_9_may_of(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_eq_9_may_of(
; CHECK-NEXT:    [[D:%.*]] = sdiv exact i8 [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[D]], 9
; CHECK-NEXT:    ret i1 [[R]]
;
  %d = sdiv exact i8 %x, %y
  %r = icmp eq i8 %d, 9
  ret i1 %r
}

define i1 @sdiv_exact_eq_9_no_of_fail_multiuse(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_eq_9_no_of_fail_multiuse(
; CHECK-NEXT:    [[YY:%.*]] = and i8 [[Y:%.*]], 7
; CHECK-NEXT:    [[D:%.*]] = sdiv exact i8 [[X:%.*]], [[YY]]
; CHECK-NEXT:    call void @use.i8(i8 [[D]])
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[D]], 9
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = and i8 %y, 7
  %d = sdiv exact i8 %x, %yy
  call void @use.i8(i8 %d)
  %r = icmp eq i8 %d, 9
  ret i1 %r
}

define i1 @sdiv_exact_eq_9_must_of_todo_is_false(i8 %x, i8 %y) {
; CHECK-LABEL: @sdiv_exact_eq_9_must_of_todo_is_false(
; CHECK-NEXT:    [[YY:%.*]] = or i8 [[Y:%.*]], 55
; CHECK-NEXT:    [[D:%.*]] = sdiv exact i8 [[X:%.*]], [[YY]]
; CHECK-NEXT:    [[R:%.*]] = icmp eq i8 [[D]], 9
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = or i8 %y, 55
  %d = sdiv exact i8 %x, %yy
  %r = icmp eq i8 %d, 9
  ret i1 %r
}

define i1 @udiv_exact_ne_30_no_of(i8 %x, i8 %y) {
; CHECK-LABEL: @udiv_exact_ne_30_no_of(
; CHECK-NEXT:    [[YY:%.*]] = and i8 [[Y:%.*]], 7
; CHECK-NEXT:    [[TMP1:%.*]] = mul nuw i8 [[YY]], 30
; CHECK-NEXT:    [[R:%.*]] = icmp ne i8 [[TMP1]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[R]]
;
  %yy = and i8 %y, 7
  %d = udiv exact i8 %x, %yy
  %r = icmp ne i8 %d, 30
  ret i1 %r
}
