; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --filter-out "\b(sp)\b" --filter "^\s*(ld[^r]|st[^r]|swp|cas|bl|add|and|eor|orn|orr|sub|mvn|sxt|cmp|ccmp|csel|dmb)"
; The base test file was generated by ./llvm/test/CodeGen/AArch64/Atomics/generate-tests.py
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64 -mattr=+v8.1a -O0 | FileCheck %s --check-prefixes=CHECK,-O0
; RUN: llc %s -o - -verify-machineinstrs -mtriple=aarch64 -mattr=+v8.1a -O1 | FileCheck %s --check-prefixes=CHECK,-O1

define dso_local i8 @atomicrmw_xchg_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_aligned_monotonic:
; CHECK:    swpb w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_aligned_acquire:
; CHECK:    swpab w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_aligned_release:
; CHECK:    swplb w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_aligned_acq_rel:
; CHECK:    swpalb w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_aligned_seq_cst:
; CHECK:    swpalb w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_aligned_monotonic:
; CHECK:    swph w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_aligned_acquire:
; CHECK:    swpah w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_aligned_release:
; CHECK:    swplh w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_aligned_acq_rel:
; CHECK:    swpalh w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_aligned_seq_cst:
; CHECK:    swpalh w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_aligned_monotonic:
; CHECK:    swp w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_aligned_acquire:
; CHECK:    swpa w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_aligned_release:
; CHECK:    swpl w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_aligned_acq_rel:
; CHECK:    swpal w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_aligned_seq_cst:
; CHECK:    swpal w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_aligned_monotonic:
; CHECK:    swp x1, x0, [x0]
    %r = atomicrmw xchg ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_aligned_acquire:
; CHECK:    swpa x1, x0, [x0]
    %r = atomicrmw xchg ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_aligned_release:
; CHECK:    swpl x1, x0, [x0]
    %r = atomicrmw xchg ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_aligned_acq_rel:
; CHECK:    swpal x1, x0, [x0]
    %r = atomicrmw xchg ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_aligned_seq_cst:
; CHECK:    swpal x1, x0, [x0]
    %r = atomicrmw xchg ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_monotonic:
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    casp x4, x5, x2, x3, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xchg ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_acquire:
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    caspa x4, x5, x2, x3, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xchg ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_release:
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    caspl x4, x5, x2, x3, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xchg ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_acq_rel:
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    caspal x4, x5, x2, x3, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xchg ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xchg_i128_aligned_seq_cst:
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xchg_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    caspal x4, x5, x2, x3, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xchg ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_unaligned_monotonic:
; CHECK:    swpb w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_unaligned_acquire:
; CHECK:    swpab w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_unaligned_release:
; CHECK:    swplb w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_unaligned_acq_rel:
; CHECK:    swpalb w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xchg_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xchg_i8_unaligned_seq_cst:
; CHECK:    swpalb w1, w0, [x0]
    %r = atomicrmw xchg ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_monotonic:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_acquire:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_release:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_acq_rel:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xchg_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xchg_i16_unaligned_seq_cst:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_monotonic:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_acquire:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_release:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_acq_rel:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xchg_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xchg_i32_unaligned_seq_cst:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_monotonic:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_acquire:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_release:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_acq_rel:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xchg_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xchg_i64_unaligned_seq_cst:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_monotonic:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_acquire:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_release(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_release:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_acq_rel:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xchg_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; CHECK-LABEL: atomicrmw_xchg_i128_unaligned_seq_cst:
; CHECK:    bl __atomic_exchange
    %r = atomicrmw xchg ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_aligned_monotonic:
; CHECK:    ldaddb w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_aligned_acquire:
; CHECK:    ldaddab w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_aligned_release:
; CHECK:    ldaddlb w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_aligned_acq_rel:
; CHECK:    ldaddalb w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_aligned_seq_cst:
; CHECK:    ldaddalb w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_add_i16_aligned_monotonic:
; CHECK:    ldaddh w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_add_i16_aligned_acquire:
; CHECK:    ldaddah w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_add_i16_aligned_release:
; CHECK:    ldaddlh w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_add_i16_aligned_acq_rel:
; CHECK:    ldaddalh w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_add_i16_aligned_seq_cst:
; CHECK:    ldaddalh w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_add_i32_aligned_monotonic:
; CHECK:    ldadd w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_add_i32_aligned_acquire:
; CHECK:    ldadda w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_add_i32_aligned_release:
; CHECK:    ldaddl w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_add_i32_aligned_acq_rel:
; CHECK:    ldaddal w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_add_i32_aligned_seq_cst:
; CHECK:    ldaddal w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_add_i64_aligned_monotonic:
; CHECK:    ldadd x1, x0, [x0]
    %r = atomicrmw add ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_add_i64_aligned_acquire:
; CHECK:    ldadda x1, x0, [x0]
    %r = atomicrmw add ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_add_i64_aligned_release:
; CHECK:    ldaddl x1, x0, [x0]
    %r = atomicrmw add ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_add_i64_aligned_acq_rel:
; CHECK:    ldaddal x1, x0, [x0]
    %r = atomicrmw add ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_add_i64_aligned_seq_cst:
; CHECK:    ldaddal x1, x0, [x0]
    %r = atomicrmw add ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_monotonic:
; -O0:    adds x2, x9, x11
; -O0:    subs w11, w11, #1
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    adds x8, x4, x2
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw add ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_acquire:
; -O0:    adds x2, x9, x11
; -O0:    subs w11, w11, #1
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    adds x8, x4, x2
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw add ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_release:
; -O0:    adds x2, x9, x11
; -O0:    subs w11, w11, #1
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    adds x8, x4, x2
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw add ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_acq_rel:
; -O0:    adds x2, x9, x11
; -O0:    subs w11, w11, #1
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    adds x8, x4, x2
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw add ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_aligned_seq_cst:
; -O0:    adds x2, x9, x11
; -O0:    subs w11, w11, #1
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_add_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    adds x8, x4, x2
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw add ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_unaligned_monotonic:
; CHECK:    ldaddb w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_unaligned_acquire:
; CHECK:    ldaddab w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_unaligned_release:
; CHECK:    ldaddlb w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_unaligned_acq_rel:
; CHECK:    ldaddalb w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_add_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_add_i8_unaligned_seq_cst:
; CHECK:    ldaddalb w1, w0, [x0]
    %r = atomicrmw add ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_monotonic:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_monotonic:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_acquire:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_acquire:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_release:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_release:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_acq_rel:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_acq_rel:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_add_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_add_i16_unaligned_seq_cst:
; -O0:    add w8, w8, w9, uxth
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i16_unaligned_seq_cst:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_monotonic:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_monotonic:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_acquire:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_acquire:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_release:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_release:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_acq_rel:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_acq_rel:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_add_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_add_i32_unaligned_seq_cst:
; -O0:    add w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i32_unaligned_seq_cst:
; -O1:    add w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_monotonic:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_monotonic:
; -O1:    add x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_acquire:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_acquire:
; -O1:    add x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_release:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_release:
; -O1:    add x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_acq_rel:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_acq_rel:
; -O1:    add x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_add_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_add_i64_unaligned_seq_cst:
; -O0:    add x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i64_unaligned_seq_cst:
; -O1:    add x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_monotonic:
; -O0:    adds x9, x8, x9
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_acquire:
; -O0:    adds x9, x8, x9
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_release:
; -O0:    adds x9, x8, x9
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_acq_rel:
; -O0:    adds x9, x8, x9
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_add_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_add_i128_unaligned_seq_cst:
; -O0:    adds x9, x8, x9
; -O0:    subs w11, w11, #1
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_add_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    adds x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw add ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_aligned_monotonic:
; CHECK:    ldaddb w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_aligned_acquire:
; CHECK:    ldaddab w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_aligned_release:
; CHECK:    ldaddlb w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_aligned_acq_rel:
; CHECK:    ldaddalb w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_aligned_seq_cst:
; CHECK:    ldaddalb w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_sub_i16_aligned_monotonic:
; CHECK:    ldaddh w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_sub_i16_aligned_acquire:
; CHECK:    ldaddah w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_sub_i16_aligned_release:
; CHECK:    ldaddlh w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_sub_i16_aligned_acq_rel:
; CHECK:    ldaddalh w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_sub_i16_aligned_seq_cst:
; CHECK:    ldaddalh w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_sub_i32_aligned_monotonic:
; CHECK:    ldadd w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_sub_i32_aligned_acquire:
; CHECK:    ldadda w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_sub_i32_aligned_release:
; CHECK:    ldaddl w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_sub_i32_aligned_acq_rel:
; CHECK:    ldaddal w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_sub_i32_aligned_seq_cst:
; CHECK:    ldaddal w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_sub_i64_aligned_monotonic:
; CHECK:    ldadd x8, x0, [x0]
    %r = atomicrmw sub ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_sub_i64_aligned_acquire:
; CHECK:    ldadda x8, x0, [x0]
    %r = atomicrmw sub ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_sub_i64_aligned_release:
; CHECK:    ldaddl x8, x0, [x0]
    %r = atomicrmw sub ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_sub_i64_aligned_acq_rel:
; CHECK:    ldaddal x8, x0, [x0]
    %r = atomicrmw sub ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_sub_i64_aligned_seq_cst:
; CHECK:    ldaddal x8, x0, [x0]
    %r = atomicrmw sub ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_monotonic:
; -O0:    subs x2, x9, x11
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    subs x8, x4, x2
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw sub ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_acquire:
; -O0:    subs x2, x9, x11
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    subs x8, x4, x2
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw sub ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_release:
; -O0:    subs x2, x9, x11
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    subs x8, x4, x2
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw sub ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_acq_rel:
; -O0:    subs x2, x9, x11
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    subs x8, x4, x2
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw sub ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_aligned_seq_cst:
; -O0:    subs x2, x9, x11
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_sub_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    subs x8, x4, x2
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw sub ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_unaligned_monotonic:
; CHECK:    ldaddb w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_unaligned_acquire:
; CHECK:    ldaddab w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_unaligned_release:
; CHECK:    ldaddlb w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_unaligned_acq_rel:
; CHECK:    ldaddalb w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_sub_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_sub_i8_unaligned_seq_cst:
; CHECK:    ldaddalb w8, w0, [x0]
    %r = atomicrmw sub ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_monotonic:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_monotonic:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_acquire:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_acquire:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_release:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_release:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_acq_rel:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_acq_rel:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_sub_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_sub_i16_unaligned_seq_cst:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i16_unaligned_seq_cst:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_monotonic:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_monotonic:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_acquire:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_acquire:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_release:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_release:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_acq_rel:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_acq_rel:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_sub_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_sub_i32_unaligned_seq_cst:
; -O0:    subs w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i32_unaligned_seq_cst:
; -O1:    sub w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_monotonic:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_monotonic:
; -O1:    sub x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_acquire:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_acquire:
; -O1:    sub x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_release:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_release:
; -O1:    sub x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_acq_rel:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_acq_rel:
; -O1:    sub x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_sub_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_sub_i64_unaligned_seq_cst:
; -O0:    subs x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i64_unaligned_seq_cst:
; -O1:    sub x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_monotonic:
; -O0:    subs x9, x8, x9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_acquire:
; -O0:    subs x9, x8, x9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_release:
; -O0:    subs x9, x8, x9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_acq_rel:
; -O0:    subs x9, x8, x9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_sub_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_sub_i128_unaligned_seq_cst:
; -O0:    subs x9, x8, x9
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_sub_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    subs x8, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw sub ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_aligned_monotonic:
; CHECK:    mvn w8, w1
; CHECK:    ldclrb w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_aligned_acquire:
; CHECK:    mvn w8, w1
; CHECK:    ldclrab w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_aligned_release:
; CHECK:    mvn w8, w1
; CHECK:    ldclrlb w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_aligned_acq_rel:
; CHECK:    mvn w8, w1
; CHECK:    ldclralb w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_aligned_seq_cst:
; CHECK:    mvn w8, w1
; CHECK:    ldclralb w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_and_i16_aligned_monotonic:
; CHECK:    mvn w8, w1
; CHECK:    ldclrh w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_and_i16_aligned_acquire:
; CHECK:    mvn w8, w1
; CHECK:    ldclrah w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_and_i16_aligned_release:
; CHECK:    mvn w8, w1
; CHECK:    ldclrlh w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_and_i16_aligned_acq_rel:
; CHECK:    mvn w8, w1
; CHECK:    ldclralh w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_and_i16_aligned_seq_cst:
; CHECK:    mvn w8, w1
; CHECK:    ldclralh w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_and_i32_aligned_monotonic:
; CHECK:    mvn w8, w1
; CHECK:    ldclr w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_and_i32_aligned_acquire:
; CHECK:    mvn w8, w1
; CHECK:    ldclra w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_and_i32_aligned_release:
; CHECK:    mvn w8, w1
; CHECK:    ldclrl w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_and_i32_aligned_acq_rel:
; CHECK:    mvn w8, w1
; CHECK:    ldclral w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_and_i32_aligned_seq_cst:
; CHECK:    mvn w8, w1
; CHECK:    ldclral w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_and_i64_aligned_monotonic:
; CHECK:    mvn x8, x1
; CHECK:    ldclr x8, x0, [x0]
    %r = atomicrmw and ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_and_i64_aligned_acquire:
; CHECK:    mvn x8, x1
; CHECK:    ldclra x8, x0, [x0]
    %r = atomicrmw and ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_and_i64_aligned_release:
; CHECK:    mvn x8, x1
; CHECK:    ldclrl x8, x0, [x0]
    %r = atomicrmw and ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_and_i64_aligned_acq_rel:
; CHECK:    mvn x8, x1
; CHECK:    ldclral x8, x0, [x0]
    %r = atomicrmw and ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_and_i64_aligned_seq_cst:
; CHECK:    mvn x8, x1
; CHECK:    ldclral x8, x0, [x0]
    %r = atomicrmw and ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_monotonic:
; -O0:    and x2, x9, x11
; -O0:    and x9, x9, x10
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw and ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_acquire:
; -O0:    and x2, x9, x11
; -O0:    and x9, x9, x10
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw and ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_release:
; -O0:    and x2, x9, x11
; -O0:    and x9, x9, x10
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw and ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_acq_rel:
; -O0:    and x2, x9, x11
; -O0:    and x9, x9, x10
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw and ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_aligned_seq_cst:
; -O0:    and x2, x9, x11
; -O0:    and x9, x9, x10
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_and_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw and ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_unaligned_monotonic:
; CHECK:    mvn w8, w1
; CHECK:    ldclrb w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_unaligned_acquire:
; CHECK:    mvn w8, w1
; CHECK:    ldclrab w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_unaligned_release:
; CHECK:    mvn w8, w1
; CHECK:    ldclrlb w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_unaligned_acq_rel:
; CHECK:    mvn w8, w1
; CHECK:    ldclralb w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_and_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_and_i8_unaligned_seq_cst:
; CHECK:    mvn w8, w1
; CHECK:    ldclralb w8, w0, [x0]
    %r = atomicrmw and ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_monotonic:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_monotonic:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_acquire:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_acquire:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_release:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_release:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_acq_rel:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_acq_rel:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_and_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_and_i16_unaligned_seq_cst:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i16_unaligned_seq_cst:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_monotonic:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_monotonic:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_acquire:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_acquire:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_release:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_release:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_acq_rel:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_acq_rel:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_and_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_and_i32_unaligned_seq_cst:
; -O0:    and w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i32_unaligned_seq_cst:
; -O1:    and w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_monotonic:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_monotonic:
; -O1:    and x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_acquire:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_acquire:
; -O1:    and x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_release:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_release:
; -O1:    and x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_acq_rel:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_acq_rel:
; -O1:    and x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_and_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_and_i64_unaligned_seq_cst:
; -O0:    and x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i64_unaligned_seq_cst:
; -O1:    and x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_monotonic:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_acquire:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_release:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_acq_rel:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_and_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_and_i128_unaligned_seq_cst:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_and_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw and ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_monotonic:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    casb w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_monotonic:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casb w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_acquire:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    casab w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_acquire:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casab w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_release:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    caslb w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_release:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    caslb w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_acq_rel:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    casalb w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_acq_rel:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casalb w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_aligned_seq_cst:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    casalb w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_aligned_seq_cst:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casalb w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_monotonic:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    cash w9, w10, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_monotonic:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    cash w9, w10, [x0]
; -O1:    cmp w9, w8, uxth
    %r = atomicrmw nand ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_acquire:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    casah w9, w10, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_acquire:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casah w9, w10, [x0]
; -O1:    cmp w9, w8, uxth
    %r = atomicrmw nand ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_release:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    caslh w9, w10, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_release:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    caslh w9, w10, [x0]
; -O1:    cmp w9, w8, uxth
    %r = atomicrmw nand ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_acq_rel:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    casalh w9, w10, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_acq_rel:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casalh w9, w10, [x0]
; -O1:    cmp w9, w8, uxth
    %r = atomicrmw nand ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_aligned_seq_cst:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    casalh w9, w10, [x11]
; -O0:    subs w8, w8, w9, uxth
;
; -O1-LABEL: atomicrmw_nand_i16_aligned_seq_cst:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casalh w9, w10, [x0]
; -O1:    cmp w9, w8, uxth
    %r = atomicrmw nand ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_monotonic:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    cas w9, w10, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_monotonic:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    cas w9, w10, [x0]
; -O1:    cmp w9, w8
    %r = atomicrmw nand ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_acquire:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    casa w9, w10, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_acquire:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casa w9, w10, [x0]
; -O1:    cmp w9, w8
    %r = atomicrmw nand ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_release:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    casl w9, w10, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_release:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casl w9, w10, [x0]
; -O1:    cmp w9, w8
    %r = atomicrmw nand ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_acq_rel:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    casal w9, w10, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_acq_rel:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casal w9, w10, [x0]
; -O1:    cmp w9, w8
    %r = atomicrmw nand ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_aligned_seq_cst:
; -O0:    and w9, w8, w9
; -O0:    mvn w10, w9
; -O0:    casal w9, w10, [x11]
; -O0:    subs w8, w9, w8
;
; -O1-LABEL: atomicrmw_nand_i32_aligned_seq_cst:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casal w9, w10, [x0]
; -O1:    cmp w9, w8
    %r = atomicrmw nand ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_monotonic:
; -O0:    and x9, x8, x9
; -O0:    mvn x10, x9
; -O0:    cas x9, x10, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_monotonic:
; -O1:    and x10, x8, x1
; -O1:    mvn x10, x10
; -O1:    cas x9, x10, [x0]
; -O1:    cmp x9, x8
    %r = atomicrmw nand ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_acquire:
; -O0:    and x9, x8, x9
; -O0:    mvn x10, x9
; -O0:    casa x9, x10, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_acquire:
; -O1:    and x10, x8, x1
; -O1:    mvn x10, x10
; -O1:    casa x9, x10, [x0]
; -O1:    cmp x9, x8
    %r = atomicrmw nand ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_release:
; -O0:    and x9, x8, x9
; -O0:    mvn x10, x9
; -O0:    casl x9, x10, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_release:
; -O1:    and x10, x8, x1
; -O1:    mvn x10, x10
; -O1:    casl x9, x10, [x0]
; -O1:    cmp x9, x8
    %r = atomicrmw nand ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_acq_rel:
; -O0:    and x9, x8, x9
; -O0:    mvn x10, x9
; -O0:    casal x9, x10, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_acq_rel:
; -O1:    and x10, x8, x1
; -O1:    mvn x10, x10
; -O1:    casal x9, x10, [x0]
; -O1:    cmp x9, x8
    %r = atomicrmw nand ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_aligned_seq_cst:
; -O0:    and x9, x8, x9
; -O0:    mvn x10, x9
; -O0:    casal x9, x10, [x11]
; -O0:    subs x8, x9, x8
;
; -O1-LABEL: atomicrmw_nand_i64_aligned_seq_cst:
; -O1:    and x10, x8, x1
; -O1:    mvn x10, x10
; -O1:    casal x9, x10, [x0]
; -O1:    cmp x9, x8
    %r = atomicrmw nand ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_monotonic:
; -O0:    and x10, x9, x10
; -O0:    and x9, x9, x11
; -O0:    mvn x2, x10
; -O0:    mvn x9, x9
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    mvn x10, x8
; -O1:    mvn x11, x9
; -O1:    casp x4, x5, x10, x11, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw nand ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_acquire:
; -O0:    and x10, x9, x10
; -O0:    and x9, x9, x11
; -O0:    mvn x2, x10
; -O0:    mvn x9, x9
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    mvn x10, x8
; -O1:    mvn x11, x9
; -O1:    caspa x4, x5, x10, x11, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw nand ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_release:
; -O0:    and x10, x9, x10
; -O0:    and x9, x9, x11
; -O0:    mvn x2, x10
; -O0:    mvn x9, x9
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    mvn x10, x8
; -O1:    mvn x11, x9
; -O1:    caspl x4, x5, x10, x11, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw nand ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_acq_rel:
; -O0:    and x10, x9, x10
; -O0:    and x9, x9, x11
; -O0:    mvn x2, x10
; -O0:    mvn x9, x9
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    mvn x10, x8
; -O1:    mvn x11, x9
; -O1:    caspal x4, x5, x10, x11, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw nand ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_aligned_seq_cst:
; -O0:    and x10, x9, x10
; -O0:    and x9, x9, x11
; -O0:    mvn x2, x10
; -O0:    mvn x9, x9
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_nand_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    and x8, x4, x2
; -O1:    and x9, x7, x3
; -O1:    mvn x10, x8
; -O1:    mvn x11, x9
; -O1:    caspal x4, x5, x10, x11, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw nand ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_monotonic:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    casb w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_monotonic:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casb w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_acquire:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    casab w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_acquire:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casab w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_release(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_release:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    caslb w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_release:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    caslb w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_acq_rel:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    casalb w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_acq_rel:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casalb w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_nand_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; -O0-LABEL: atomicrmw_nand_i8_unaligned_seq_cst:
; -O0:    and w8, w10, w8
; -O0:    mvn w8, w8
; -O0:    casalb w9, w8, [x11]
; -O0:    and w8, w9, #0xff
; -O0:    subs w8, w8, w10, uxtb
;
; -O1-LABEL: atomicrmw_nand_i8_unaligned_seq_cst:
; -O1:    and w10, w8, w1
; -O1:    mvn w10, w10
; -O1:    casalb w9, w10, [x0]
; -O1:    cmp w9, w8, uxtb
    %r = atomicrmw nand ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_monotonic:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_monotonic:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_acquire:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_acquire:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_release:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_release:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_acq_rel:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_acq_rel:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_nand_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_nand_i16_unaligned_seq_cst:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i16_unaligned_seq_cst:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_monotonic:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_monotonic:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_acquire:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_acquire:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_release:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_release:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_acq_rel:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_acq_rel:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_nand_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_nand_i32_unaligned_seq_cst:
; -O0:    and w8, w9, w8
; -O0:    mvn w8, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i32_unaligned_seq_cst:
; -O1:    and w8, w0, w20
; -O1:    mvn w8, w8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_monotonic:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_monotonic:
; -O1:    and x8, x0, x20
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_acquire:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_acquire:
; -O1:    and x8, x0, x20
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_release:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_release:
; -O1:    and x8, x0, x20
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_acq_rel:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_acq_rel:
; -O1:    and x8, x0, x20
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_nand_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_nand_i64_unaligned_seq_cst:
; -O0:    and x8, x9, x8
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i64_unaligned_seq_cst:
; -O1:    and x8, x0, x20
; -O1:    mvn x8, x8
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_monotonic:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_acquire:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_release:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_acq_rel:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_nand_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_nand_i128_unaligned_seq_cst:
; -O0:    and x9, x8, x9
; -O0:    and x8, x8, x10
; -O0:    mvn x9, x9
; -O0:    mvn x8, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_nand_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    and x8, x1, x19
; -O1:    and x9, x0, x21
; -O1:    mvn x8, x8
; -O1:    mvn x9, x9
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw nand ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_aligned_monotonic:
; CHECK:    ldsetb w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_aligned_acquire:
; CHECK:    ldsetab w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_aligned_release:
; CHECK:    ldsetlb w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_aligned_acq_rel:
; CHECK:    ldsetalb w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_aligned_seq_cst:
; CHECK:    ldsetalb w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_or_i16_aligned_monotonic:
; CHECK:    ldseth w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_or_i16_aligned_acquire:
; CHECK:    ldsetah w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_or_i16_aligned_release:
; CHECK:    ldsetlh w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_or_i16_aligned_acq_rel:
; CHECK:    ldsetalh w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_or_i16_aligned_seq_cst:
; CHECK:    ldsetalh w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_or_i32_aligned_monotonic:
; CHECK:    ldset w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_or_i32_aligned_acquire:
; CHECK:    ldseta w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_or_i32_aligned_release:
; CHECK:    ldsetl w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_or_i32_aligned_acq_rel:
; CHECK:    ldsetal w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_or_i32_aligned_seq_cst:
; CHECK:    ldsetal w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_or_i64_aligned_monotonic:
; CHECK:    ldset x1, x0, [x0]
    %r = atomicrmw or ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_or_i64_aligned_acquire:
; CHECK:    ldseta x1, x0, [x0]
    %r = atomicrmw or ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_or_i64_aligned_release:
; CHECK:    ldsetl x1, x0, [x0]
    %r = atomicrmw or ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_or_i64_aligned_acq_rel:
; CHECK:    ldsetal x1, x0, [x0]
    %r = atomicrmw or ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_or_i64_aligned_seq_cst:
; CHECK:    ldsetal x1, x0, [x0]
    %r = atomicrmw or ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_monotonic:
; -O0:    orr x2, x9, x11
; -O0:    orr x9, x9, x10
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    orr x8, x4, x2
; -O1:    orr x9, x7, x3
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw or ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_acquire:
; -O0:    orr x2, x9, x11
; -O0:    orr x9, x9, x10
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    orr x8, x4, x2
; -O1:    orr x9, x7, x3
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw or ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_release:
; -O0:    orr x2, x9, x11
; -O0:    orr x9, x9, x10
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    orr x8, x4, x2
; -O1:    orr x9, x7, x3
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw or ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_acq_rel:
; -O0:    orr x2, x9, x11
; -O0:    orr x9, x9, x10
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    orr x8, x4, x2
; -O1:    orr x9, x7, x3
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw or ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_aligned_seq_cst:
; -O0:    orr x2, x9, x11
; -O0:    orr x9, x9, x10
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_or_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    orr x8, x4, x2
; -O1:    orr x9, x7, x3
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw or ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_unaligned_monotonic:
; CHECK:    ldsetb w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_unaligned_acquire:
; CHECK:    ldsetab w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_unaligned_release:
; CHECK:    ldsetlb w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_unaligned_acq_rel:
; CHECK:    ldsetalb w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_or_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_or_i8_unaligned_seq_cst:
; CHECK:    ldsetalb w1, w0, [x0]
    %r = atomicrmw or ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_monotonic:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_monotonic:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_acquire:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_acquire:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_release:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_release:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_acq_rel:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_acq_rel:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_or_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_or_i16_unaligned_seq_cst:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i16_unaligned_seq_cst:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_monotonic:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_monotonic:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_acquire:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_acquire:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_release:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_release:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_acq_rel:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_acq_rel:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_or_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_or_i32_unaligned_seq_cst:
; -O0:    orr w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i32_unaligned_seq_cst:
; -O1:    orr w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_monotonic:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_monotonic:
; -O1:    orr x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_acquire:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_acquire:
; -O1:    orr x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_release:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_release:
; -O1:    orr x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_acq_rel:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_acq_rel:
; -O1:    orr x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_or_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_or_i64_unaligned_seq_cst:
; -O0:    orr x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i64_unaligned_seq_cst:
; -O1:    orr x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_monotonic:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_acquire:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_release:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_acq_rel:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_or_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_or_i128_unaligned_seq_cst:
; -O0:    orr x9, x8, x9
; -O0:    orr x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_or_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    orr x8, x1, x19
; -O1:    orr x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw or ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_aligned_monotonic:
; CHECK:    ldeorb w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_aligned_acquire:
; CHECK:    ldeorab w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_aligned_release:
; CHECK:    ldeorlb w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_aligned_acq_rel:
; CHECK:    ldeoralb w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_aligned_seq_cst:
; CHECK:    ldeoralb w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xor_i16_aligned_monotonic:
; CHECK:    ldeorh w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xor_i16_aligned_acquire:
; CHECK:    ldeorah w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xor_i16_aligned_release:
; CHECK:    ldeorlh w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xor_i16_aligned_acq_rel:
; CHECK:    ldeoralh w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_xor_i16_aligned_seq_cst:
; CHECK:    ldeoralh w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xor_i32_aligned_monotonic:
; CHECK:    ldeor w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xor_i32_aligned_acquire:
; CHECK:    ldeora w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xor_i32_aligned_release:
; CHECK:    ldeorl w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xor_i32_aligned_acq_rel:
; CHECK:    ldeoral w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_xor_i32_aligned_seq_cst:
; CHECK:    ldeoral w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xor_i64_aligned_monotonic:
; CHECK:    ldeor x1, x0, [x0]
    %r = atomicrmw xor ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xor_i64_aligned_acquire:
; CHECK:    ldeora x1, x0, [x0]
    %r = atomicrmw xor ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xor_i64_aligned_release:
; CHECK:    ldeorl x1, x0, [x0]
    %r = atomicrmw xor ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xor_i64_aligned_acq_rel:
; CHECK:    ldeoral x1, x0, [x0]
    %r = atomicrmw xor ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_xor_i64_aligned_seq_cst:
; CHECK:    ldeoral x1, x0, [x0]
    %r = atomicrmw xor ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_monotonic:
; -O0:    eor x2, x9, x11
; -O0:    eor x9, x9, x10
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    eor x8, x4, x2
; -O1:    eor x9, x7, x3
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xor ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_acquire:
; -O0:    eor x2, x9, x11
; -O0:    eor x9, x9, x10
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    eor x8, x4, x2
; -O1:    eor x9, x7, x3
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xor ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_release:
; -O0:    eor x2, x9, x11
; -O0:    eor x9, x9, x10
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    eor x8, x4, x2
; -O1:    eor x9, x7, x3
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xor ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_acq_rel:
; -O0:    eor x2, x9, x11
; -O0:    eor x9, x9, x10
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    eor x8, x4, x2
; -O1:    eor x9, x7, x3
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xor ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_aligned_seq_cst:
; -O0:    eor x2, x9, x11
; -O0:    eor x9, x9, x10
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_xor_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    eor x8, x4, x2
; -O1:    eor x9, x7, x3
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw xor ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_unaligned_monotonic:
; CHECK:    ldeorb w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_unaligned_acquire:
; CHECK:    ldeorab w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_unaligned_release:
; CHECK:    ldeorlb w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_unaligned_acq_rel:
; CHECK:    ldeoralb w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_xor_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_xor_i8_unaligned_seq_cst:
; CHECK:    ldeoralb w1, w0, [x0]
    %r = atomicrmw xor ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_monotonic:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_monotonic:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_acquire:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_acquire:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_release:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_release:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_acq_rel:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_acq_rel:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_xor_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_xor_i16_unaligned_seq_cst:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i16_unaligned_seq_cst:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_monotonic:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_monotonic:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_acquire:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_acquire:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_release:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_release:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_acq_rel:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_acq_rel:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_xor_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_xor_i32_unaligned_seq_cst:
; -O0:    eor w8, w9, w8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i32_unaligned_seq_cst:
; -O1:    eor w8, w0, w20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_monotonic:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_monotonic:
; -O1:    eor x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_acquire:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_acquire:
; -O1:    eor x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_release:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_release:
; -O1:    eor x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_acq_rel:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_acq_rel:
; -O1:    eor x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_xor_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_xor_i64_unaligned_seq_cst:
; -O0:    eor x8, x9, x8
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i64_unaligned_seq_cst:
; -O1:    eor x8, x0, x20
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_monotonic:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_acquire:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_release:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_acq_rel:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_xor_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_xor_i128_unaligned_seq_cst:
; -O0:    eor x9, x8, x9
; -O0:    eor x8, x8, x10
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_xor_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    eor x8, x1, x19
; -O1:    eor x9, x0, x21
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw xor ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_aligned_monotonic:
; CHECK:    ldsmaxb w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_aligned_acquire:
; CHECK:    ldsmaxab w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_aligned_release:
; CHECK:    ldsmaxlb w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_aligned_acq_rel:
; CHECK:    ldsmaxalb w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_aligned_seq_cst:
; CHECK:    ldsmaxalb w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_max_i16_aligned_monotonic:
; CHECK:    ldsmaxh w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_max_i16_aligned_acquire:
; CHECK:    ldsmaxah w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_max_i16_aligned_release:
; CHECK:    ldsmaxlh w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_max_i16_aligned_acq_rel:
; CHECK:    ldsmaxalh w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_max_i16_aligned_seq_cst:
; CHECK:    ldsmaxalh w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_max_i32_aligned_monotonic:
; CHECK:    ldsmax w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_max_i32_aligned_acquire:
; CHECK:    ldsmaxa w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_max_i32_aligned_release:
; CHECK:    ldsmaxl w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_max_i32_aligned_acq_rel:
; CHECK:    ldsmaxal w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_max_i32_aligned_seq_cst:
; CHECK:    ldsmaxal w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_max_i64_aligned_monotonic:
; CHECK:    ldsmax x1, x0, [x0]
    %r = atomicrmw max ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_max_i64_aligned_acquire:
; CHECK:    ldsmaxa x1, x0, [x0]
    %r = atomicrmw max ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_max_i64_aligned_release:
; CHECK:    ldsmaxl x1, x0, [x0]
    %r = atomicrmw max ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_max_i64_aligned_acq_rel:
; CHECK:    ldsmaxal x1, x0, [x0]
    %r = atomicrmw max ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_max_i64_aligned_seq_cst:
; CHECK:    ldsmaxal x1, x0, [x0]
    %r = atomicrmw max ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_monotonic:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lt
; -O1:    csel x8, x4, x2, lt
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw max ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_acquire:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lt
; -O1:    csel x8, x4, x2, lt
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw max ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_release:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lt
; -O1:    csel x8, x4, x2, lt
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw max ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_acq_rel:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lt
; -O1:    csel x8, x4, x2, lt
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw max ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_aligned_seq_cst:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_max_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lt
; -O1:    csel x8, x4, x2, lt
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw max ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_unaligned_monotonic:
; CHECK:    ldsmaxb w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_unaligned_acquire:
; CHECK:    ldsmaxab w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_unaligned_release:
; CHECK:    ldsmaxlb w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_unaligned_acq_rel:
; CHECK:    ldsmaxalb w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_max_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_max_i8_unaligned_seq_cst:
; CHECK:    ldsmaxalb w1, w0, [x0]
    %r = atomicrmw max ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_monotonic:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_monotonic:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_acquire:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_acquire:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_release:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_release:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_acq_rel:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_acq_rel:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_max_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_max_i16_unaligned_seq_cst:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i16_unaligned_seq_cst:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_monotonic:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_monotonic:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_acquire:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_acquire:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_release:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_release:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_acq_rel:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_acq_rel:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_max_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_max_i32_unaligned_seq_cst:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i32_unaligned_seq_cst:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_monotonic:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_monotonic:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_acquire:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_acquire:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_release:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_release:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_acq_rel:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_acq_rel:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_max_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_max_i64_unaligned_seq_cst:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, gt
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i64_unaligned_seq_cst:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, gt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_monotonic:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x21, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_acquire:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x21, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_release:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x21, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_acq_rel:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x21, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_max_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_max_i128_unaligned_seq_cst:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_max_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lt
; -O1:    csel x9, x0, x21, lt
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw max ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_aligned_monotonic:
; CHECK:    ldsminb w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_aligned_acquire:
; CHECK:    ldsminab w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_aligned_release:
; CHECK:    ldsminlb w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_aligned_acq_rel:
; CHECK:    ldsminalb w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_aligned_seq_cst:
; CHECK:    ldsminalb w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_min_i16_aligned_monotonic:
; CHECK:    ldsminh w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_min_i16_aligned_acquire:
; CHECK:    ldsminah w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_min_i16_aligned_release:
; CHECK:    ldsminlh w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_min_i16_aligned_acq_rel:
; CHECK:    ldsminalh w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_min_i16_aligned_seq_cst:
; CHECK:    ldsminalh w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_min_i32_aligned_monotonic:
; CHECK:    ldsmin w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_min_i32_aligned_acquire:
; CHECK:    ldsmina w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_min_i32_aligned_release:
; CHECK:    ldsminl w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_min_i32_aligned_acq_rel:
; CHECK:    ldsminal w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_min_i32_aligned_seq_cst:
; CHECK:    ldsminal w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_min_i64_aligned_monotonic:
; CHECK:    ldsmin x1, x0, [x0]
    %r = atomicrmw min ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_min_i64_aligned_acquire:
; CHECK:    ldsmina x1, x0, [x0]
    %r = atomicrmw min ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_min_i64_aligned_release:
; CHECK:    ldsminl x1, x0, [x0]
    %r = atomicrmw min ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_min_i64_aligned_acq_rel:
; CHECK:    ldsminal x1, x0, [x0]
    %r = atomicrmw min ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_min_i64_aligned_seq_cst:
; CHECK:    ldsminal x1, x0, [x0]
    %r = atomicrmw min ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_monotonic:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, ge
; -O1:    csel x8, x4, x2, ge
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw min ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_acquire:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, ge
; -O1:    csel x8, x4, x2, ge
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw min ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_release:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, ge
; -O1:    csel x8, x4, x2, ge
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw min ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_acq_rel:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, ge
; -O1:    csel x8, x4, x2, ge
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw min ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_aligned_seq_cst:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_min_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, ge
; -O1:    csel x8, x4, x2, ge
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw min ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_unaligned_monotonic:
; CHECK:    ldsminb w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_unaligned_acquire:
; CHECK:    ldsminab w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_unaligned_release:
; CHECK:    ldsminlb w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_unaligned_acq_rel:
; CHECK:    ldsminalb w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_min_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_min_i8_unaligned_seq_cst:
; CHECK:    ldsminalb w1, w0, [x0]
    %r = atomicrmw min ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_monotonic:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_monotonic:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_acquire:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_acquire:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_release:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_release:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_acq_rel:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_acq_rel:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_min_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_min_i16_unaligned_seq_cst:
; -O0:    sxth w10, w9
; -O0:    subs w10, w10, w8, sxth
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i16_unaligned_seq_cst:
; -O1:    sxth w8, w0
; -O1:    cmp w8, w20, sxth
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_monotonic:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_monotonic:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_acquire:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_acquire:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_release:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_release:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_acq_rel:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_acq_rel:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_min_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_min_i32_unaligned_seq_cst:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i32_unaligned_seq_cst:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_monotonic:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_monotonic:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_acquire:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_acquire:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_release:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_release:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_acq_rel:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_acq_rel:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_min_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_min_i64_unaligned_seq_cst:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, le
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i64_unaligned_seq_cst:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, le
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_monotonic:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x21, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_acquire:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x21, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_release:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x21, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_acq_rel:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x21, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_min_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_min_i128_unaligned_seq_cst:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_min_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, ge
; -O1:    csel x9, x0, x21, ge
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw min ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_aligned_monotonic:
; CHECK:    ldumaxb w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_aligned_acquire:
; CHECK:    ldumaxab w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_aligned_release:
; CHECK:    ldumaxlb w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_aligned_acq_rel:
; CHECK:    ldumaxalb w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_aligned_seq_cst:
; CHECK:    ldumaxalb w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umax_i16_aligned_monotonic:
; CHECK:    ldumaxh w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umax_i16_aligned_acquire:
; CHECK:    ldumaxah w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umax_i16_aligned_release:
; CHECK:    ldumaxlh w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umax_i16_aligned_acq_rel:
; CHECK:    ldumaxalh w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umax_i16_aligned_seq_cst:
; CHECK:    ldumaxalh w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umax_i32_aligned_monotonic:
; CHECK:    ldumax w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umax_i32_aligned_acquire:
; CHECK:    ldumaxa w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umax_i32_aligned_release:
; CHECK:    ldumaxl w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umax_i32_aligned_acq_rel:
; CHECK:    ldumaxal w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umax_i32_aligned_seq_cst:
; CHECK:    ldumaxal w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umax_i64_aligned_monotonic:
; CHECK:    ldumax x1, x0, [x0]
    %r = atomicrmw umax ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umax_i64_aligned_acquire:
; CHECK:    ldumaxa x1, x0, [x0]
    %r = atomicrmw umax ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umax_i64_aligned_release:
; CHECK:    ldumaxl x1, x0, [x0]
    %r = atomicrmw umax ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umax_i64_aligned_acq_rel:
; CHECK:    ldumaxal x1, x0, [x0]
    %r = atomicrmw umax ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umax_i64_aligned_seq_cst:
; CHECK:    ldumaxal x1, x0, [x0]
    %r = atomicrmw umax ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_monotonic:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lo
; -O1:    csel x8, x4, x2, lo
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umax ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_acquire:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lo
; -O1:    csel x8, x4, x2, lo
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umax ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_release:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lo
; -O1:    csel x8, x4, x2, lo
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umax ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_acq_rel:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lo
; -O1:    csel x8, x4, x2, lo
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umax ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_aligned_seq_cst:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umax_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, lo
; -O1:    csel x8, x4, x2, lo
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umax ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_unaligned_monotonic:
; CHECK:    ldumaxb w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_unaligned_acquire:
; CHECK:    ldumaxab w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_unaligned_release:
; CHECK:    ldumaxlb w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_unaligned_acq_rel:
; CHECK:    ldumaxalb w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umax_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umax_i8_unaligned_seq_cst:
; CHECK:    ldumaxalb w1, w0, [x0]
    %r = atomicrmw umax ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_monotonic:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_monotonic:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_acquire:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_acquire:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_release:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_release:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_acq_rel:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_acq_rel:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umax_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umax_i16_unaligned_seq_cst:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i16_unaligned_seq_cst:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_monotonic:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_monotonic:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_acquire:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_acquire:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_release:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_release:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_acq_rel:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_acq_rel:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umax_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umax_i32_unaligned_seq_cst:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i32_unaligned_seq_cst:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_monotonic:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_monotonic:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_acquire:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_acquire:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_release:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_release:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_acq_rel:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_acq_rel:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umax_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umax_i64_unaligned_seq_cst:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, hi
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i64_unaligned_seq_cst:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, hi
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_monotonic:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x21, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_acquire:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x21, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_release:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x21, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_acq_rel:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x21, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umax_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umax_i128_unaligned_seq_cst:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umax_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, lo
; -O1:    csel x9, x0, x21, lo
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umax ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_aligned_monotonic:
; CHECK:    lduminb w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_aligned_acquire:
; CHECK:    lduminab w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_aligned_release:
; CHECK:    lduminlb w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_aligned_acq_rel:
; CHECK:    lduminalb w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_aligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_aligned_seq_cst:
; CHECK:    lduminalb w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_monotonic(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umin_i16_aligned_monotonic:
; CHECK:    lduminh w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value monotonic, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_acquire(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umin_i16_aligned_acquire:
; CHECK:    lduminah w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value acquire, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_release(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umin_i16_aligned_release:
; CHECK:    lduminlh w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value release, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_acq_rel(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umin_i16_aligned_acq_rel:
; CHECK:    lduminalh w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value acq_rel, align 2
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_aligned_seq_cst(ptr %ptr, i16 %value) {
; CHECK-LABEL: atomicrmw_umin_i16_aligned_seq_cst:
; CHECK:    lduminalh w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i16 %value seq_cst, align 2
    ret i16 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_monotonic(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umin_i32_aligned_monotonic:
; CHECK:    ldumin w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value monotonic, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_acquire(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umin_i32_aligned_acquire:
; CHECK:    ldumina w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value acquire, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_release(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umin_i32_aligned_release:
; CHECK:    lduminl w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value release, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_acq_rel(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umin_i32_aligned_acq_rel:
; CHECK:    lduminal w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value acq_rel, align 4
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_aligned_seq_cst(ptr %ptr, i32 %value) {
; CHECK-LABEL: atomicrmw_umin_i32_aligned_seq_cst:
; CHECK:    lduminal w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i32 %value seq_cst, align 4
    ret i32 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_monotonic(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umin_i64_aligned_monotonic:
; CHECK:    ldumin x1, x0, [x0]
    %r = atomicrmw umin ptr %ptr, i64 %value monotonic, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_acquire(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umin_i64_aligned_acquire:
; CHECK:    ldumina x1, x0, [x0]
    %r = atomicrmw umin ptr %ptr, i64 %value acquire, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_release(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umin_i64_aligned_release:
; CHECK:    lduminl x1, x0, [x0]
    %r = atomicrmw umin ptr %ptr, i64 %value release, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_acq_rel(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umin_i64_aligned_acq_rel:
; CHECK:    lduminal x1, x0, [x0]
    %r = atomicrmw umin ptr %ptr, i64 %value acq_rel, align 8
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_aligned_seq_cst(ptr %ptr, i64 %value) {
; CHECK-LABEL: atomicrmw_umin_i64_aligned_seq_cst:
; CHECK:    lduminal x1, x0, [x0]
    %r = atomicrmw umin ptr %ptr, i64 %value seq_cst, align 8
    ret i64 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_monotonic:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    casp x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_monotonic:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, hs
; -O1:    csel x8, x4, x2, hs
; -O1:    casp x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umin ptr %ptr, i128 %value monotonic, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_acquire:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspa x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_acquire:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, hs
; -O1:    csel x8, x4, x2, hs
; -O1:    caspa x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umin ptr %ptr, i128 %value acquire, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_release:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspl x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_release:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, hs
; -O1:    csel x8, x4, x2, hs
; -O1:    caspl x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umin ptr %ptr, i128 %value release, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_acq_rel:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_acq_rel:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, hs
; -O1:    csel x8, x4, x2, hs
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umin ptr %ptr, i128 %value acq_rel, align 16
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_aligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_aligned_seq_cst:
; -O0:    subs x9, x9, x12
; -O0:    subs x11, x11, x10
; -O0:    subs x13, x13, x10
; -O0:    csel w11, w9, w11, eq
; -O0:    ands w13, w11, #0x1
; -O0:    csel x2, x9, x12, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x9, x9, x10, ne
; -O0:    caspal x0, x1, x2, x3, [x8]
; -O0:    eor x8, x10, x8
; -O0:    eor x11, x9, x11
; -O0:    orr x8, x8, x11
; -O0:    subs x8, x8, #0
;
; -O1-LABEL: atomicrmw_umin_i128_aligned_seq_cst:
; -O1:    ldp x4, x5, [x0]
; -O1:    cmp x2, x4
; -O1:    csel x9, x7, x3, hs
; -O1:    csel x8, x4, x2, hs
; -O1:    caspal x4, x5, x8, x9, [x0]
; -O1:    cmp x5, x7
; -O1:    ccmp x4, x6, #0, eq
    %r = atomicrmw umin ptr %ptr, i128 %value seq_cst, align 16
    ret i128 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_monotonic(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_unaligned_monotonic:
; CHECK:    lduminb w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value monotonic, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_acquire(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_unaligned_acquire:
; CHECK:    lduminab w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value acquire, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_release(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_unaligned_release:
; CHECK:    lduminlb w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value release, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_acq_rel(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_unaligned_acq_rel:
; CHECK:    lduminalb w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value acq_rel, align 1
    ret i8 %r
}

define dso_local i8 @atomicrmw_umin_i8_unaligned_seq_cst(ptr %ptr, i8 %value) {
; CHECK-LABEL: atomicrmw_umin_i8_unaligned_seq_cst:
; CHECK:    lduminalb w1, w0, [x0]
    %r = atomicrmw umin ptr %ptr, i8 %value seq_cst, align 1
    ret i8 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_monotonic(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_monotonic:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_monotonic:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value monotonic, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_acquire(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_acquire:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_acquire:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value acquire, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_release(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_release:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_release:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value release, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_acq_rel(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_acq_rel:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_acq_rel:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value acq_rel, align 1
    ret i16 %r
}

define dso_local i16 @atomicrmw_umin_i16_unaligned_seq_cst(ptr %ptr, i16 %value) {
; -O0-LABEL: atomicrmw_umin_i16_unaligned_seq_cst:
; -O0:    subs w10, w10, w8, uxth
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i16_unaligned_seq_cst:
; -O1:    and w8, w0, #0xffff
; -O1:    cmp w8, w20, uxth
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i16 %value seq_cst, align 1
    ret i16 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_monotonic(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_monotonic:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_monotonic:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value monotonic, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_acquire(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_acquire:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_acquire:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value acquire, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_release(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_release:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_release:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value release, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_acq_rel(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_acq_rel:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_acq_rel:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value acq_rel, align 1
    ret i32 %r
}

define dso_local i32 @atomicrmw_umin_i32_unaligned_seq_cst(ptr %ptr, i32 %value) {
; -O0-LABEL: atomicrmw_umin_i32_unaligned_seq_cst:
; -O0:    subs w10, w9, w8
; -O0:    csel w8, w9, w8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i32_unaligned_seq_cst:
; -O1:    cmp w0, w20
; -O1:    csel w8, w0, w20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i32 %value seq_cst, align 1
    ret i32 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_monotonic(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_monotonic:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_monotonic:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value monotonic, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_acquire(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_acquire:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_acquire:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value acquire, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_release(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_release:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_release:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value release, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_acq_rel(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_acq_rel:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_acq_rel:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value acq_rel, align 1
    ret i64 %r
}

define dso_local i64 @atomicrmw_umin_i64_unaligned_seq_cst(ptr %ptr, i64 %value) {
; -O0-LABEL: atomicrmw_umin_i64_unaligned_seq_cst:
; -O0:    subs x10, x9, x8
; -O0:    csel x8, x9, x8, ls
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i64_unaligned_seq_cst:
; -O1:    cmp x0, x20
; -O1:    csel x8, x0, x20, ls
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i64 %value seq_cst, align 1
    ret i64 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_monotonic(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_monotonic:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_monotonic:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x21, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value monotonic, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_acquire(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_acquire:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_acquire:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x21, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value acquire, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_release(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_release:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_release:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x21, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value release, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_acq_rel(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_acq_rel:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_acq_rel:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x21, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value acq_rel, align 1
    ret i128 %r
}

define dso_local i128 @atomicrmw_umin_i128_unaligned_seq_cst(ptr %ptr, i128 %value) {
; -O0-LABEL: atomicrmw_umin_i128_unaligned_seq_cst:
; -O0:    subs x8, x8, x9
; -O0:    subs x11, x11, x10
; -O0:    subs x12, x12, x10
; -O0:    csel w11, w8, w11, eq
; -O0:    ands w12, w11, #0x1
; -O0:    csel x9, x8, x9, ne
; -O0:    ands w11, w11, #0x1
; -O0:    csel x8, x8, x10, ne
; -O0:    bl __atomic_compare_exchange
;
; -O1-LABEL: atomicrmw_umin_i128_unaligned_seq_cst:
; -O1:    ldp x0, x1, [x0]
; -O1:    cmp x21, x0
; -O1:    csel x8, x1, x19, hs
; -O1:    csel x9, x0, x21, hs
; -O1:    bl __atomic_compare_exchange
    %r = atomicrmw umin ptr %ptr, i128 %value seq_cst, align 1
    ret i128 %r
}
