; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32D
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64D
; RUN: llc -mtriple=riscv32 -mattr=+Xmipslsp -use-riscv-mips-load-store-pairs=1 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I_PAIR
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+d,+Xmipslsp -use-riscv-mips-load-store-pairs=1 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32D_PAIR
; RUN: llc -mtriple=riscv64 -mattr=+Xmipslsp -use-riscv-mips-load-store-pairs=1 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I_PAIR
; RUN: llc -mtriple=riscv64 -mcpu=mips-p8700 -mattr=+Xmipslsp -use-riscv-mips-load-store-pairs=1 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64P_8700
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+d,+Xmipslsp -use-riscv-mips-load-store-pairs=1 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64D_PAIR
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+d -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64D_NOPAIR

define void @testi(ptr %a) {
; RV32I-LABEL: testi:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:    addi sp, sp, -16
; RV32I-NEXT:    .cfi_def_cfa_offset 16
; RV32I-NEXT:    sw s2, 12(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s3, 8(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s4, 4(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s5, 0(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset s2, -4
; RV32I-NEXT:    .cfi_offset s3, -8
; RV32I-NEXT:    .cfi_offset s4, -12
; RV32I-NEXT:    .cfi_offset s5, -16
; RV32I-NEXT:    lw s3, 0(a0)
; RV32I-NEXT:    lw s2, 4(a0)
; RV32I-NEXT:    lw s5, 8(a0)
; RV32I-NEXT:    lw s4, 12(a0)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    lw s2, 12(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s3, 8(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s4, 4(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s5, 0(sp) # 4-byte Folded Reload
; RV32I-NEXT:    .cfi_restore s2
; RV32I-NEXT:    .cfi_restore s3
; RV32I-NEXT:    .cfi_restore s4
; RV32I-NEXT:    .cfi_restore s5
; RV32I-NEXT:    addi sp, sp, 16
; RV32I-NEXT:    .cfi_def_cfa_offset 0
; RV32I-NEXT:    ret
;
; RV32D-LABEL: testi:
; RV32D:       # %bb.0: # %entry
; RV32D-NEXT:    addi sp, sp, -16
; RV32D-NEXT:    .cfi_def_cfa_offset 16
; RV32D-NEXT:    sw s2, 12(sp) # 4-byte Folded Spill
; RV32D-NEXT:    sw s3, 8(sp) # 4-byte Folded Spill
; RV32D-NEXT:    sw s4, 4(sp) # 4-byte Folded Spill
; RV32D-NEXT:    sw s5, 0(sp) # 4-byte Folded Spill
; RV32D-NEXT:    .cfi_offset s2, -4
; RV32D-NEXT:    .cfi_offset s3, -8
; RV32D-NEXT:    .cfi_offset s4, -12
; RV32D-NEXT:    .cfi_offset s5, -16
; RV32D-NEXT:    lw s3, 0(a0)
; RV32D-NEXT:    lw s2, 4(a0)
; RV32D-NEXT:    lw s5, 8(a0)
; RV32D-NEXT:    lw s4, 12(a0)
; RV32D-NEXT:    #APP
; RV32D-NEXT:    #NO_APP
; RV32D-NEXT:    lw s2, 12(sp) # 4-byte Folded Reload
; RV32D-NEXT:    lw s3, 8(sp) # 4-byte Folded Reload
; RV32D-NEXT:    lw s4, 4(sp) # 4-byte Folded Reload
; RV32D-NEXT:    lw s5, 0(sp) # 4-byte Folded Reload
; RV32D-NEXT:    .cfi_restore s2
; RV32D-NEXT:    .cfi_restore s3
; RV32D-NEXT:    .cfi_restore s4
; RV32D-NEXT:    .cfi_restore s5
; RV32D-NEXT:    addi sp, sp, 16
; RV32D-NEXT:    .cfi_def_cfa_offset 0
; RV32D-NEXT:    ret
;
; RV64I-LABEL: testi:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:    addi sp, sp, -32
; RV64I-NEXT:    .cfi_def_cfa_offset 32
; RV64I-NEXT:    sd s2, 24(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s3, 16(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s5, 0(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset s2, -8
; RV64I-NEXT:    .cfi_offset s3, -16
; RV64I-NEXT:    .cfi_offset s4, -24
; RV64I-NEXT:    .cfi_offset s5, -32
; RV64I-NEXT:    ld s3, 0(a0)
; RV64I-NEXT:    ld s2, 8(a0)
; RV64I-NEXT:    ld s5, 16(a0)
; RV64I-NEXT:    ld s4, 24(a0)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ld s2, 24(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s3, 16(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s5, 0(sp) # 8-byte Folded Reload
; RV64I-NEXT:    .cfi_restore s2
; RV64I-NEXT:    .cfi_restore s3
; RV64I-NEXT:    .cfi_restore s4
; RV64I-NEXT:    .cfi_restore s5
; RV64I-NEXT:    addi sp, sp, 32
; RV64I-NEXT:    .cfi_def_cfa_offset 0
; RV64I-NEXT:    ret
;
; RV64D-LABEL: testi:
; RV64D:       # %bb.0: # %entry
; RV64D-NEXT:    addi sp, sp, -32
; RV64D-NEXT:    .cfi_def_cfa_offset 32
; RV64D-NEXT:    sd s2, 24(sp) # 8-byte Folded Spill
; RV64D-NEXT:    sd s3, 16(sp) # 8-byte Folded Spill
; RV64D-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64D-NEXT:    sd s5, 0(sp) # 8-byte Folded Spill
; RV64D-NEXT:    .cfi_offset s2, -8
; RV64D-NEXT:    .cfi_offset s3, -16
; RV64D-NEXT:    .cfi_offset s4, -24
; RV64D-NEXT:    .cfi_offset s5, -32
; RV64D-NEXT:    ld s3, 0(a0)
; RV64D-NEXT:    ld s2, 8(a0)
; RV64D-NEXT:    ld s5, 16(a0)
; RV64D-NEXT:    ld s4, 24(a0)
; RV64D-NEXT:    #APP
; RV64D-NEXT:    #NO_APP
; RV64D-NEXT:    ld s2, 24(sp) # 8-byte Folded Reload
; RV64D-NEXT:    ld s3, 16(sp) # 8-byte Folded Reload
; RV64D-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64D-NEXT:    ld s5, 0(sp) # 8-byte Folded Reload
; RV64D-NEXT:    .cfi_restore s2
; RV64D-NEXT:    .cfi_restore s3
; RV64D-NEXT:    .cfi_restore s4
; RV64D-NEXT:    .cfi_restore s5
; RV64D-NEXT:    addi sp, sp, 32
; RV64D-NEXT:    .cfi_def_cfa_offset 0
; RV64D-NEXT:    ret
;
; RV32I_PAIR-LABEL: testi:
; RV32I_PAIR:       # %bb.0: # %entry
; RV32I_PAIR-NEXT:    addi sp, sp, -16
; RV32I_PAIR-NEXT:    .cfi_def_cfa_offset 16
; RV32I_PAIR-NEXT:    sw s3, 8(sp) # 4-byte Folded Spill
; RV32I_PAIR-NEXT:    sw s2, 12(sp) # 4-byte Folded Spill
; RV32I_PAIR-NEXT:    sw s5, 0(sp) # 4-byte Folded Spill
; RV32I_PAIR-NEXT:    sw s4, 4(sp) # 4-byte Folded Spill
; RV32I_PAIR-NEXT:    .cfi_offset s2, -4
; RV32I_PAIR-NEXT:    .cfi_offset s3, -8
; RV32I_PAIR-NEXT:    .cfi_offset s4, -12
; RV32I_PAIR-NEXT:    .cfi_offset s5, -16
; RV32I_PAIR-NEXT:    mips.lwp s3, s2, 0(a0)
; RV32I_PAIR-NEXT:    mips.lwp s5, s4, 8(a0)
; RV32I_PAIR-NEXT:    #APP
; RV32I_PAIR-NEXT:    #NO_APP
; RV32I_PAIR-NEXT:    lw s3, 8(sp) # 4-byte Folded Reload
; RV32I_PAIR-NEXT:    lw s2, 12(sp) # 4-byte Folded Reload
; RV32I_PAIR-NEXT:    lw s5, 0(sp) # 4-byte Folded Reload
; RV32I_PAIR-NEXT:    lw s4, 4(sp) # 4-byte Folded Reload
; RV32I_PAIR-NEXT:    .cfi_restore s2
; RV32I_PAIR-NEXT:    .cfi_restore s3
; RV32I_PAIR-NEXT:    .cfi_restore s4
; RV32I_PAIR-NEXT:    .cfi_restore s5
; RV32I_PAIR-NEXT:    addi sp, sp, 16
; RV32I_PAIR-NEXT:    .cfi_def_cfa_offset 0
; RV32I_PAIR-NEXT:    ret
;
; RV32D_PAIR-LABEL: testi:
; RV32D_PAIR:       # %bb.0: # %entry
; RV32D_PAIR-NEXT:    addi sp, sp, -16
; RV32D_PAIR-NEXT:    .cfi_def_cfa_offset 16
; RV32D_PAIR-NEXT:    sw s3, 8(sp) # 4-byte Folded Spill
; RV32D_PAIR-NEXT:    sw s2, 12(sp) # 4-byte Folded Spill
; RV32D_PAIR-NEXT:    sw s5, 0(sp) # 4-byte Folded Spill
; RV32D_PAIR-NEXT:    sw s4, 4(sp) # 4-byte Folded Spill
; RV32D_PAIR-NEXT:    .cfi_offset s2, -4
; RV32D_PAIR-NEXT:    .cfi_offset s3, -8
; RV32D_PAIR-NEXT:    .cfi_offset s4, -12
; RV32D_PAIR-NEXT:    .cfi_offset s5, -16
; RV32D_PAIR-NEXT:    mips.lwp s3, s2, 0(a0)
; RV32D_PAIR-NEXT:    mips.lwp s5, s4, 8(a0)
; RV32D_PAIR-NEXT:    #APP
; RV32D_PAIR-NEXT:    #NO_APP
; RV32D_PAIR-NEXT:    lw s3, 8(sp) # 4-byte Folded Reload
; RV32D_PAIR-NEXT:    lw s2, 12(sp) # 4-byte Folded Reload
; RV32D_PAIR-NEXT:    lw s5, 0(sp) # 4-byte Folded Reload
; RV32D_PAIR-NEXT:    lw s4, 4(sp) # 4-byte Folded Reload
; RV32D_PAIR-NEXT:    .cfi_restore s2
; RV32D_PAIR-NEXT:    .cfi_restore s3
; RV32D_PAIR-NEXT:    .cfi_restore s4
; RV32D_PAIR-NEXT:    .cfi_restore s5
; RV32D_PAIR-NEXT:    addi sp, sp, 16
; RV32D_PAIR-NEXT:    .cfi_def_cfa_offset 0
; RV32D_PAIR-NEXT:    ret
;
; RV64I_PAIR-LABEL: testi:
; RV64I_PAIR:       # %bb.0: # %entry
; RV64I_PAIR-NEXT:    addi sp, sp, -32
; RV64I_PAIR-NEXT:    .cfi_def_cfa_offset 32
; RV64I_PAIR-NEXT:    sd s3, 16(sp) # 8-byte Folded Spill
; RV64I_PAIR-NEXT:    sd s2, 24(sp) # 8-byte Folded Spill
; RV64I_PAIR-NEXT:    sd s5, 0(sp) # 8-byte Folded Spill
; RV64I_PAIR-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64I_PAIR-NEXT:    .cfi_offset s2, -8
; RV64I_PAIR-NEXT:    .cfi_offset s3, -16
; RV64I_PAIR-NEXT:    .cfi_offset s4, -24
; RV64I_PAIR-NEXT:    .cfi_offset s5, -32
; RV64I_PAIR-NEXT:    mips.ldp s3, s2, 0(a0)
; RV64I_PAIR-NEXT:    ld s5, 16(a0)
; RV64I_PAIR-NEXT:    ld s4, 24(a0)
; RV64I_PAIR-NEXT:    #APP
; RV64I_PAIR-NEXT:    #NO_APP
; RV64I_PAIR-NEXT:    ld s3, 16(sp) # 8-byte Folded Reload
; RV64I_PAIR-NEXT:    ld s2, 24(sp) # 8-byte Folded Reload
; RV64I_PAIR-NEXT:    ld s5, 0(sp) # 8-byte Folded Reload
; RV64I_PAIR-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64I_PAIR-NEXT:    .cfi_restore s2
; RV64I_PAIR-NEXT:    .cfi_restore s3
; RV64I_PAIR-NEXT:    .cfi_restore s4
; RV64I_PAIR-NEXT:    .cfi_restore s5
; RV64I_PAIR-NEXT:    addi sp, sp, 32
; RV64I_PAIR-NEXT:    .cfi_def_cfa_offset 0
; RV64I_PAIR-NEXT:    ret
;
; RV64P_8700-LABEL: testi:
; RV64P_8700:       # %bb.0: # %entry
; RV64P_8700-NEXT:    addi sp, sp, -32
; RV64P_8700-NEXT:    .cfi_def_cfa_offset 32
; RV64P_8700-NEXT:    sd s3, 16(sp) # 8-byte Folded Spill
; RV64P_8700-NEXT:    sd s2, 24(sp) # 8-byte Folded Spill
; RV64P_8700-NEXT:    sd s5, 0(sp) # 8-byte Folded Spill
; RV64P_8700-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64P_8700-NEXT:    .cfi_offset s2, -8
; RV64P_8700-NEXT:    .cfi_offset s3, -16
; RV64P_8700-NEXT:    .cfi_offset s4, -24
; RV64P_8700-NEXT:    .cfi_offset s5, -32
; RV64P_8700-NEXT:    mips.ldp s3, s2, 0(a0)
; RV64P_8700-NEXT:    ld s5, 16(a0)
; RV64P_8700-NEXT:    ld s4, 24(a0)
; RV64P_8700-NEXT:    #APP
; RV64P_8700-NEXT:    #NO_APP
; RV64P_8700-NEXT:    ld s3, 16(sp) # 8-byte Folded Reload
; RV64P_8700-NEXT:    ld s2, 24(sp) # 8-byte Folded Reload
; RV64P_8700-NEXT:    ld s5, 0(sp) # 8-byte Folded Reload
; RV64P_8700-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64P_8700-NEXT:    .cfi_restore s2
; RV64P_8700-NEXT:    .cfi_restore s3
; RV64P_8700-NEXT:    .cfi_restore s4
; RV64P_8700-NEXT:    .cfi_restore s5
; RV64P_8700-NEXT:    addi sp, sp, 32
; RV64P_8700-NEXT:    .cfi_def_cfa_offset 0
; RV64P_8700-NEXT:    ret
;
; RV64D_PAIR-LABEL: testi:
; RV64D_PAIR:       # %bb.0: # %entry
; RV64D_PAIR-NEXT:    addi sp, sp, -32
; RV64D_PAIR-NEXT:    .cfi_def_cfa_offset 32
; RV64D_PAIR-NEXT:    sd s3, 16(sp) # 8-byte Folded Spill
; RV64D_PAIR-NEXT:    sd s2, 24(sp) # 8-byte Folded Spill
; RV64D_PAIR-NEXT:    sd s5, 0(sp) # 8-byte Folded Spill
; RV64D_PAIR-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64D_PAIR-NEXT:    .cfi_offset s2, -8
; RV64D_PAIR-NEXT:    .cfi_offset s3, -16
; RV64D_PAIR-NEXT:    .cfi_offset s4, -24
; RV64D_PAIR-NEXT:    .cfi_offset s5, -32
; RV64D_PAIR-NEXT:    mips.ldp s3, s2, 0(a0)
; RV64D_PAIR-NEXT:    ld s5, 16(a0)
; RV64D_PAIR-NEXT:    ld s4, 24(a0)
; RV64D_PAIR-NEXT:    #APP
; RV64D_PAIR-NEXT:    #NO_APP
; RV64D_PAIR-NEXT:    ld s3, 16(sp) # 8-byte Folded Reload
; RV64D_PAIR-NEXT:    ld s2, 24(sp) # 8-byte Folded Reload
; RV64D_PAIR-NEXT:    ld s5, 0(sp) # 8-byte Folded Reload
; RV64D_PAIR-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64D_PAIR-NEXT:    .cfi_restore s2
; RV64D_PAIR-NEXT:    .cfi_restore s3
; RV64D_PAIR-NEXT:    .cfi_restore s4
; RV64D_PAIR-NEXT:    .cfi_restore s5
; RV64D_PAIR-NEXT:    addi sp, sp, 32
; RV64D_PAIR-NEXT:    .cfi_def_cfa_offset 0
; RV64D_PAIR-NEXT:    ret
;
; RV64D_NOPAIR-LABEL: testi:
; RV64D_NOPAIR:       # %bb.0: # %entry
; RV64D_NOPAIR-NEXT:    addi sp, sp, -32
; RV64D_NOPAIR-NEXT:    .cfi_def_cfa_offset 32
; RV64D_NOPAIR-NEXT:    sd s2, 24(sp) # 8-byte Folded Spill
; RV64D_NOPAIR-NEXT:    sd s3, 16(sp) # 8-byte Folded Spill
; RV64D_NOPAIR-NEXT:    sd s4, 8(sp) # 8-byte Folded Spill
; RV64D_NOPAIR-NEXT:    sd s5, 0(sp) # 8-byte Folded Spill
; RV64D_NOPAIR-NEXT:    .cfi_offset s2, -8
; RV64D_NOPAIR-NEXT:    .cfi_offset s3, -16
; RV64D_NOPAIR-NEXT:    .cfi_offset s4, -24
; RV64D_NOPAIR-NEXT:    .cfi_offset s5, -32
; RV64D_NOPAIR-NEXT:    ld s3, 0(a0)
; RV64D_NOPAIR-NEXT:    ld s2, 8(a0)
; RV64D_NOPAIR-NEXT:    ld s5, 16(a0)
; RV64D_NOPAIR-NEXT:    ld s4, 24(a0)
; RV64D_NOPAIR-NEXT:    #APP
; RV64D_NOPAIR-NEXT:    #NO_APP
; RV64D_NOPAIR-NEXT:    ld s2, 24(sp) # 8-byte Folded Reload
; RV64D_NOPAIR-NEXT:    ld s3, 16(sp) # 8-byte Folded Reload
; RV64D_NOPAIR-NEXT:    ld s4, 8(sp) # 8-byte Folded Reload
; RV64D_NOPAIR-NEXT:    ld s5, 0(sp) # 8-byte Folded Reload
; RV64D_NOPAIR-NEXT:    .cfi_restore s2
; RV64D_NOPAIR-NEXT:    .cfi_restore s3
; RV64D_NOPAIR-NEXT:    .cfi_restore s4
; RV64D_NOPAIR-NEXT:    .cfi_restore s5
; RV64D_NOPAIR-NEXT:    addi sp, sp, 32
; RV64D_NOPAIR-NEXT:    .cfi_def_cfa_offset 0
; RV64D_NOPAIR-NEXT:    ret
entry:
  %arrayidx = getelementptr inbounds ptr, ptr %a, i64 1
  %0 = load ptr, ptr %arrayidx, align 16
  %1 = load ptr, ptr %a, align 16
  %arrayidx2 = getelementptr inbounds ptr, ptr %a, i64 3
  %2 = load ptr, ptr %arrayidx2, align 16
  %arrayidx3 = getelementptr inbounds ptr, ptr %a, i64 2
  %3 = load ptr, ptr %arrayidx3, align 8
  tail call void asm sideeffect "", "{x18},{x19},{x20},{x21}"(ptr %0, ptr %1, ptr %2, ptr %3)
  ret void
}
