; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -aarch64-sve-vector-bits-min=128  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_128
; RUN: llc -aarch64-sve-vector-bits-min=256  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_256
; RUN: llc -aarch64-sve-vector-bits-min=512  < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_512
; RUN: llc -aarch64-sve-vector-bits-min=2048 < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_512
; RUN: llc -aarch64-sve-vector-bits-min=128 -use-constant-int-for-fixed-length-splat < %s | FileCheck %s -check-prefixes=CHECK,VBITS_GE_128

target triple = "aarch64-unknown-linux-gnu"

define <4 x i32> @sdiv_v4i32_negative_pow2_divisor_packed(<4 x i32> %op1) vscale_range(1,0) #0 {
; CHECK-LABEL: sdiv_v4i32_negative_pow2_divisor_packed:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #3
; CHECK-NEXT:    subr z0.s, z0.s, #0 // =0x0
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <4 x i32> %op1, splat (i32 -8)
  ret <4 x i32> %res
}

define <2 x i32> @sdiv_v2i32_negative_pow2_divisor_unpacked(<2 x i32> %op1) vscale_range(1,0) #0 {
; CHECK-LABEL: sdiv_v2i32_negative_pow2_divisor_unpacked:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #3
; CHECK-NEXT:    subr z0.s, z0.s, #0 // =0x0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <2 x i32> %op1, splat (i32 -8)
  ret <2 x i32> %res
}

define <4 x i32> @sdiv_v4i32_positive_pow2_divisor_packed(<4 x i32> %op1) vscale_range(1,0) #0 {
; CHECK-LABEL: sdiv_v4i32_positive_pow2_divisor_packed:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #3
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <4 x i32> %op1, splat (i32 8)
  ret <4 x i32> %res
}

define <2 x i32> @sdiv_v2i32_positive_pow2_divisor_unpacked(<2 x i32> %op1) vscale_range(1,0) #0 {
; CHECK-LABEL: sdiv_v2i32_positive_pow2_divisor_unpacked:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #3
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <2 x i32> %op1, splat (i32 8)
  ret <2 x i32> %res
}

define <8 x i8> @sdiv_v8i8(<8 x i8> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #1
; CHECK-NEXT:    subr z0.b, z0.b, #0 // =0x0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <8 x i8> %op1, shufflevector (<8 x i8> insertelement (<8 x i8> poison, i8 -2, i32 0), <8 x i8> poison, <8 x i32> zeroinitializer)
  ret <8 x i8> %res
}

define <16 x i8> @sdiv_v16i8(<16 x i8> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #5
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <16 x i8> %op1, shufflevector (<16 x i8> insertelement (<16 x i8> poison, i8 32, i32 0), <16 x i8> poison, <16 x i32> zeroinitializer)
  ret <16 x i8> %res
}

define void @sdiv_v32i8(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl32
; CHECK-NEXT:    ld1b { z0.b }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #5
; CHECK-NEXT:    st1b { z0.b }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %res = sdiv <32 x i8> %op1, shufflevector (<32 x i8> insertelement (<32 x i8> poison, i8 32, i32 0), <32 x i8> poison, <32 x i32> zeroinitializer)
  store <32 x i8> %res, ptr %a
  ret void
}

define void @sdiv_v64i8(ptr %a) #0 {
; VBITS_GE_128-LABEL: sdiv_v64i8:
; VBITS_GE_128:       // %bb.0:
; VBITS_GE_128-NEXT:    ldp q0, q1, [x0, #32]
; VBITS_GE_128-NEXT:    ptrue p0.b, vl16
; VBITS_GE_128-NEXT:    ldp q2, q3, [x0]
; VBITS_GE_128-NEXT:    asrd z0.b, p0/m, z0.b, #5
; VBITS_GE_128-NEXT:    asrd z1.b, p0/m, z1.b, #5
; VBITS_GE_128-NEXT:    asrd z2.b, p0/m, z2.b, #5
; VBITS_GE_128-NEXT:    asrd z3.b, p0/m, z3.b, #5
; VBITS_GE_128-NEXT:    stp q0, q1, [x0, #32]
; VBITS_GE_128-NEXT:    stp q2, q3, [x0]
; VBITS_GE_128-NEXT:    ret
;
; VBITS_GE_256-LABEL: sdiv_v64i8:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.b, vl32
; VBITS_GE_256-NEXT:    mov w8, #32 // =0x20
; VBITS_GE_256-NEXT:    ld1b { z0.b }, p0/z, [x0, x8]
; VBITS_GE_256-NEXT:    ld1b { z1.b }, p0/z, [x0]
; VBITS_GE_256-NEXT:    asrd z0.b, p0/m, z0.b, #5
; VBITS_GE_256-NEXT:    asrd z1.b, p0/m, z1.b, #5
; VBITS_GE_256-NEXT:    st1b { z0.b }, p0, [x0, x8]
; VBITS_GE_256-NEXT:    st1b { z1.b }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: sdiv_v64i8:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.b, vl64
; VBITS_GE_512-NEXT:    ld1b { z0.b }, p0/z, [x0]
; VBITS_GE_512-NEXT:    asrd z0.b, p0/m, z0.b, #5
; VBITS_GE_512-NEXT:    st1b { z0.b }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <64 x i8>, ptr %a
  %res = sdiv <64 x i8> %op1, shufflevector (<64 x i8> insertelement (<64 x i8> poison, i8 32, i32 0), <64 x i8> poison, <64 x i32> zeroinitializer)
  store <64 x i8> %res, ptr %a
  ret void
}

define void @sdiv_v128i8(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: sdiv_v128i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl128
; CHECK-NEXT:    ld1b { z0.b }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #2
; CHECK-NEXT:    subr z0.b, z0.b, #0 // =0x0
; CHECK-NEXT:    st1b { z0.b }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <128 x i8>, ptr %a
  %res = sdiv <128 x i8> %op1, shufflevector (<128 x i8> insertelement (<128 x i8> poison, i8 -4, i32 0), <128 x i8> poison, <128 x i32> zeroinitializer)
  store <128 x i8> %res, ptr %a
  ret void
}

define void @sdiv_v256i8(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: sdiv_v256i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl256
; CHECK-NEXT:    ld1b { z0.b }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.b, p0/m, z0.b, #5
; CHECK-NEXT:    st1b { z0.b }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <256 x i8>, ptr %a
  %res = sdiv <256 x i8> %op1, shufflevector (<256 x i8> insertelement (<256 x i8> poison, i8 32, i32 0), <256 x i8> poison, <256 x i32> zeroinitializer)
  store <256 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @sdiv_v4i16(<4 x i16> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #5
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <4 x i16> %op1, shufflevector (<4 x i16> insertelement (<4 x i16> poison, i16 32, i32 0), <4 x i16> poison, <4 x i32> zeroinitializer)
  ret <4 x i16> %res
}

define <8 x i16> @sdiv_v8i16(<8 x i16> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #3
; CHECK-NEXT:    subr z0.h, z0.h, #0 // =0x0
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <8 x i16> %op1, shufflevector (<8 x i16> insertelement (<8 x i16> poison, i16 -8, i32 0), <8 x i16> poison, <8 x i32> zeroinitializer)
  ret <8 x i16> %res
}

define void @sdiv_v16i16(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl16
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #5
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %res = sdiv <16 x i16> %op1, shufflevector (<16 x i16> insertelement (<16 x i16> poison, i16 32, i32 0), <16 x i16> poison, <16 x i32> zeroinitializer)
  store <16 x i16> %res, ptr %a
  ret void
}

define void @sdiv_v32i16(ptr %a) #0 {
; VBITS_GE_128-LABEL: sdiv_v32i16:
; VBITS_GE_128:       // %bb.0:
; VBITS_GE_128-NEXT:    ldp q0, q1, [x0, #32]
; VBITS_GE_128-NEXT:    ptrue p0.h, vl8
; VBITS_GE_128-NEXT:    ldp q2, q3, [x0]
; VBITS_GE_128-NEXT:    asrd z0.h, p0/m, z0.h, #5
; VBITS_GE_128-NEXT:    asrd z1.h, p0/m, z1.h, #5
; VBITS_GE_128-NEXT:    asrd z2.h, p0/m, z2.h, #5
; VBITS_GE_128-NEXT:    asrd z3.h, p0/m, z3.h, #5
; VBITS_GE_128-NEXT:    stp q0, q1, [x0, #32]
; VBITS_GE_128-NEXT:    stp q2, q3, [x0]
; VBITS_GE_128-NEXT:    ret
;
; VBITS_GE_256-LABEL: sdiv_v32i16:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.h, vl16
; VBITS_GE_256-NEXT:    mov x8, #16 // =0x10
; VBITS_GE_256-NEXT:    ld1h { z0.h }, p0/z, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    ld1h { z1.h }, p0/z, [x0]
; VBITS_GE_256-NEXT:    asrd z0.h, p0/m, z0.h, #5
; VBITS_GE_256-NEXT:    asrd z1.h, p0/m, z1.h, #5
; VBITS_GE_256-NEXT:    st1h { z0.h }, p0, [x0, x8, lsl #1]
; VBITS_GE_256-NEXT:    st1h { z1.h }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: sdiv_v32i16:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.h, vl32
; VBITS_GE_512-NEXT:    ld1h { z0.h }, p0/z, [x0]
; VBITS_GE_512-NEXT:    asrd z0.h, p0/m, z0.h, #5
; VBITS_GE_512-NEXT:    st1h { z0.h }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <32 x i16>, ptr %a
  %res = sdiv <32 x i16> %op1, shufflevector (<32 x i16> insertelement (<32 x i16> poison, i16 32, i32 0), <32 x i16> poison, <32 x i32> zeroinitializer)
  store <32 x i16> %res, ptr %a
  ret void
}

define void @sdiv_v64i16(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: sdiv_v64i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl64
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #4
; CHECK-NEXT:    subr z0.h, z0.h, #0 // =0x0
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x i16>, ptr %a
  %res = sdiv <64 x i16> %op1, shufflevector (<64 x i16> insertelement (<64 x i16> poison, i16 -16, i32 0), <64 x i16> poison, <64 x i32> zeroinitializer)
  store <64 x i16> %res, ptr %a
  ret void
}

define void @sdiv_v128i16(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: sdiv_v128i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl128
; CHECK-NEXT:    ld1h { z0.h }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.h, p0/m, z0.h, #5
; CHECK-NEXT:    st1h { z0.h }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <128 x i16>, ptr %a
  %res = sdiv <128 x i16> %op1, shufflevector (<128 x i16> insertelement (<128 x i16> poison, i16 32, i32 0), <128 x i16> poison, <128 x i32> zeroinitializer)
  store <128 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @sdiv_v2i32(<2 x i32> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #5
; CHECK-NEXT:    subr z0.s, z0.s, #0 // =0x0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <2 x i32> %op1, shufflevector (<2 x i32> insertelement (<2 x i32> poison, i32 -32, i32 0), <2 x i32> poison, <2 x i32> zeroinitializer)
  ret <2 x i32> %res
}

define <4 x i32> @sdiv_v4i32(<4 x i32> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #5
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <4 x i32> %op1, shufflevector (<4 x i32> insertelement (<4 x i32> poison, i32 32, i32 0), <4 x i32> poison, <4 x i32> zeroinitializer)
  ret <4 x i32> %res
}

define void @sdiv_v8i32(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl8
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #6
; CHECK-NEXT:    subr z0.s, z0.s, #0 // =0x0
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %res = sdiv <8 x i32> %op1, shufflevector (<8 x i32> insertelement (<8 x i32> poison, i32 -64, i32 0), <8 x i32> poison, <8 x i32> zeroinitializer)
  store <8 x i32> %res, ptr %a
  ret void
}

define void @sdiv_v16i32(ptr %a) #0 {
; VBITS_GE_128-LABEL: sdiv_v16i32:
; VBITS_GE_128:       // %bb.0:
; VBITS_GE_128-NEXT:    ldp q0, q1, [x0, #32]
; VBITS_GE_128-NEXT:    ptrue p0.s, vl4
; VBITS_GE_128-NEXT:    ldp q2, q3, [x0]
; VBITS_GE_128-NEXT:    asrd z0.s, p0/m, z0.s, #5
; VBITS_GE_128-NEXT:    asrd z1.s, p0/m, z1.s, #5
; VBITS_GE_128-NEXT:    asrd z2.s, p0/m, z2.s, #5
; VBITS_GE_128-NEXT:    asrd z3.s, p0/m, z3.s, #5
; VBITS_GE_128-NEXT:    stp q0, q1, [x0, #32]
; VBITS_GE_128-NEXT:    stp q2, q3, [x0]
; VBITS_GE_128-NEXT:    ret
;
; VBITS_GE_256-LABEL: sdiv_v16i32:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.s, vl8
; VBITS_GE_256-NEXT:    mov x8, #8 // =0x8
; VBITS_GE_256-NEXT:    ld1w { z0.s }, p0/z, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    ld1w { z1.s }, p0/z, [x0]
; VBITS_GE_256-NEXT:    asrd z0.s, p0/m, z0.s, #5
; VBITS_GE_256-NEXT:    asrd z1.s, p0/m, z1.s, #5
; VBITS_GE_256-NEXT:    st1w { z0.s }, p0, [x0, x8, lsl #2]
; VBITS_GE_256-NEXT:    st1w { z1.s }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: sdiv_v16i32:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.s, vl16
; VBITS_GE_512-NEXT:    ld1w { z0.s }, p0/z, [x0]
; VBITS_GE_512-NEXT:    asrd z0.s, p0/m, z0.s, #5
; VBITS_GE_512-NEXT:    st1w { z0.s }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <16 x i32>, ptr %a
  %res = sdiv <16 x i32> %op1, shufflevector (<16 x i32> insertelement (<16 x i32> poison, i32 32, i32 0), <16 x i32> poison, <16 x i32> zeroinitializer)
  store <16 x i32> %res, ptr %a
  ret void
}

define void @sdiv_v32i32(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: sdiv_v32i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl32
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #5
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i32>, ptr %a
  %res = sdiv <32 x i32> %op1, shufflevector (<32 x i32> insertelement (<32 x i32> poison, i32 32, i32 0), <32 x i32> poison, <32 x i32> zeroinitializer)
  store <32 x i32> %res, ptr %a
  ret void
}

define void @sdiv_v64i32(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: sdiv_v64i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl64
; CHECK-NEXT:    ld1w { z0.s }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.s, p0/m, z0.s, #5
; CHECK-NEXT:    st1w { z0.s }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <64 x i32>, ptr %a
  %res = sdiv <64 x i32> %op1, shufflevector (<64 x i32> insertelement (<64 x i32> poison, i32 32, i32 0), <64 x i32> poison, <64 x i32> zeroinitializer)
  store <64 x i32> %res, ptr %a
  ret void
}

define <1 x i64> @sdiv_v1i64(<1 x i64> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #7
; CHECK-NEXT:    subr z0.d, z0.d, #0 // =0x0
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <1 x i64> %op1, shufflevector (<1 x i64> insertelement (<1 x i64> poison, i64 -128, i32 0), <1 x i64> poison, <1 x i32> zeroinitializer)
  ret <1 x i64> %res
}

; Vector i64 sdiv are not legal for NEON so use SVE when available.
define <2 x i64> @sdiv_v2i64(<2 x i64> %op1) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #5
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
  %res = sdiv <2 x i64> %op1, shufflevector (<2 x i64> insertelement (<2 x i64> poison, i64 32, i32 0), <2 x i64> poison, <2 x i32> zeroinitializer)
  ret <2 x i64> %res
}

define void @sdiv_v4i64(ptr %a) vscale_range(2,0) #0 {
; CHECK-LABEL: sdiv_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl4
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #8
; CHECK-NEXT:    subr z0.d, z0.d, #0 // =0x0
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %res = sdiv <4 x i64> %op1, shufflevector (<4 x i64> insertelement (<4 x i64> poison, i64 -256, i32 0), <4 x i64> poison, <4 x i32> zeroinitializer)
  store <4 x i64> %res, ptr %a
  ret void
}

define void @sdiv_v8i64(ptr %a) #0 {
; VBITS_GE_128-LABEL: sdiv_v8i64:
; VBITS_GE_128:       // %bb.0:
; VBITS_GE_128-NEXT:    ldp q0, q1, [x0, #32]
; VBITS_GE_128-NEXT:    ptrue p0.d, vl2
; VBITS_GE_128-NEXT:    ldp q2, q3, [x0]
; VBITS_GE_128-NEXT:    asrd z0.d, p0/m, z0.d, #5
; VBITS_GE_128-NEXT:    asrd z1.d, p0/m, z1.d, #5
; VBITS_GE_128-NEXT:    asrd z2.d, p0/m, z2.d, #5
; VBITS_GE_128-NEXT:    asrd z3.d, p0/m, z3.d, #5
; VBITS_GE_128-NEXT:    stp q0, q1, [x0, #32]
; VBITS_GE_128-NEXT:    stp q2, q3, [x0]
; VBITS_GE_128-NEXT:    ret
;
; VBITS_GE_256-LABEL: sdiv_v8i64:
; VBITS_GE_256:       // %bb.0:
; VBITS_GE_256-NEXT:    ptrue p0.d, vl4
; VBITS_GE_256-NEXT:    mov x8, #4 // =0x4
; VBITS_GE_256-NEXT:    ld1d { z0.d }, p0/z, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    ld1d { z1.d }, p0/z, [x0]
; VBITS_GE_256-NEXT:    asrd z0.d, p0/m, z0.d, #5
; VBITS_GE_256-NEXT:    asrd z1.d, p0/m, z1.d, #5
; VBITS_GE_256-NEXT:    st1d { z0.d }, p0, [x0, x8, lsl #3]
; VBITS_GE_256-NEXT:    st1d { z1.d }, p0, [x0]
; VBITS_GE_256-NEXT:    ret
;
; VBITS_GE_512-LABEL: sdiv_v8i64:
; VBITS_GE_512:       // %bb.0:
; VBITS_GE_512-NEXT:    ptrue p0.d, vl8
; VBITS_GE_512-NEXT:    ld1d { z0.d }, p0/z, [x0]
; VBITS_GE_512-NEXT:    asrd z0.d, p0/m, z0.d, #5
; VBITS_GE_512-NEXT:    st1d { z0.d }, p0, [x0]
; VBITS_GE_512-NEXT:    ret
  %op1 = load <8 x i64>, ptr %a
  %res = sdiv <8 x i64> %op1, shufflevector (<8 x i64> insertelement (<8 x i64> poison, i64 32, i32 0), <8 x i64> poison, <8 x i32> zeroinitializer)
  store <8 x i64> %res, ptr %a
  ret void
}

define void @sdiv_v16i64(ptr %a) vscale_range(8,0) #0 {
; CHECK-LABEL: sdiv_v16i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl16
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #5
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <16 x i64>, ptr %a
  %res = sdiv <16 x i64> %op1, shufflevector (<16 x i64> insertelement (<16 x i64> poison, i64 32, i32 0), <16 x i64> poison, <16 x i32> zeroinitializer)
  store <16 x i64> %res, ptr %a
  ret void
}

define void @sdiv_v32i64(ptr %a) vscale_range(16,0) #0 {
; CHECK-LABEL: sdiv_v32i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl32
; CHECK-NEXT:    ld1d { z0.d }, p0/z, [x0]
; CHECK-NEXT:    asrd z0.d, p0/m, z0.d, #9
; CHECK-NEXT:    subr z0.d, z0.d, #0 // =0x0
; CHECK-NEXT:    st1d { z0.d }, p0, [x0]
; CHECK-NEXT:    ret
  %op1 = load <32 x i64>, ptr %a
  %res = sdiv <32 x i64> %op1, shufflevector (<32 x i64> insertelement (<32 x i64> poison, i64 -512, i32 0), <32 x i64> poison, <32 x i32> zeroinitializer)
  store <32 x i64> %res, ptr %a
  ret void
}

attributes #0 = { "target-features"="+sve" }
