; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefixes=SSE,SSE2-SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+ssse3 | FileCheck %s --check-prefixes=SSE,SSE2-SSSE3
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefixes=SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefixes=AVX,AVX12,AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx2 | FileCheck %s --check-prefixes=AVX,AVX12,AVX2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f,+avx512vl,+avx512bw | FileCheck %s --check-prefixes=AVX,AVX512

;
; 128-bit vectors
;

define i1 @bitcast_v2i64_to_v2i1(<2 x i64> %a0) nounwind {
; SSE-LABEL: bitcast_v2i64_to_v2i1:
; SSE:       # %bb.0:
; SSE-NEXT:    movmskpd %xmm0, %ecx
; SSE-NEXT:    movl %ecx, %eax
; SSE-NEXT:    shrb %al
; SSE-NEXT:    xorb %cl, %al
; SSE-NEXT:    retq
;
; AVX12-LABEL: bitcast_v2i64_to_v2i1:
; AVX12:       # %bb.0:
; AVX12-NEXT:    vmovmskpd %xmm0, %ecx
; AVX12-NEXT:    movl %ecx, %eax
; AVX12-NEXT:    shrb %al
; AVX12-NEXT:    xorb %cl, %al
; AVX12-NEXT:    retq
;
; AVX512-LABEL: bitcast_v2i64_to_v2i1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpgtq %xmm0, %xmm1, %k0
; AVX512-NEXT:    kshiftrw $1, %k0, %k1
; AVX512-NEXT:    kmovd %k1, %ecx
; AVX512-NEXT:    kmovd %k0, %eax
; AVX512-NEXT:    xorb %cl, %al
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    retq
  %1 = icmp slt <2 x i64> %a0, zeroinitializer
  %2 = bitcast <2 x i1> %1 to <2 x i1>
  %3 = extractelement <2 x i1> %2, i32 0
  %4 = extractelement <2 x i1> %2, i32 1
  %5 = add i1 %3, %4
  ret i1 %5
}

define i1 @trunc_v2i64_cmp(<2 x i64> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v2i64_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    psllq $63, %xmm0
; SSE2-SSSE3-NEXT:    movmskpd %xmm0, %eax
; SSE2-SSSE3-NEXT:    testl %eax, %eax
; SSE2-SSSE3-NEXT:    sete %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v2i64_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX12-LABEL: trunc_v2i64_cmp:
; AVX12:       # %bb.0:
; AVX12-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX12-NEXT:    sete %al
; AVX12-NEXT:    retq
;
; AVX512-LABEL: trunc_v2i64_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [1,1]
; AVX512-NEXT:    vptest %xmm1, %xmm0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    retq
  %1 = trunc <2 x i64> %a0 to <2 x i1>
  %2 = bitcast <2 x i1> %1 to i2
  %3 = icmp eq i2 %2, 0
  ret i1 %3
}

define i2 @bitcast_v4i32_to_v2i2(<4 x i32> %a0) nounwind {
; SSE-LABEL: bitcast_v4i32_to_v2i2:
; SSE:       # %bb.0:
; SSE-NEXT:    movmskps %xmm0, %eax
; SSE-NEXT:    movl %eax, %ecx
; SSE-NEXT:    shrb $2, %cl
; SSE-NEXT:    andb $3, %al
; SSE-NEXT:    addb %cl, %al
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    retq
;
; AVX-LABEL: bitcast_v4i32_to_v2i2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovmskps %xmm0, %eax
; AVX-NEXT:    movl %eax, %ecx
; AVX-NEXT:    shrb $2, %cl
; AVX-NEXT:    andb $3, %al
; AVX-NEXT:    addb %cl, %al
; AVX-NEXT:    # kill: def $al killed $al killed $eax
; AVX-NEXT:    retq
  %1 = icmp slt <4 x i32> %a0, zeroinitializer
  %2 = bitcast <4 x i1> %1 to <2 x i2>
  %3 = extractelement <2 x i2> %2, i32 0
  %4 = extractelement <2 x i2> %2, i32 1
  %5 = add i2 %3, %4
  ret i2 %5
}

define i1 @trunc_v4i32_cmp(<4 x i32> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v4i32_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    pslld $31, %xmm0
; SSE2-SSSE3-NEXT:    movmskps %xmm0, %eax
; SSE2-SSSE3-NEXT:    xorl $15, %eax
; SSE2-SSSE3-NEXT:    sete %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v4i32_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX12-LABEL: trunc_v4i32_cmp:
; AVX12:       # %bb.0:
; AVX12-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX12-NEXT:    setb %al
; AVX12-NEXT:    retq
;
; AVX512-LABEL: trunc_v4i32_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [4294967297,4294967297]
; AVX512-NEXT:    vptest %xmm1, %xmm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    retq
  %1 = trunc <4 x i32> %a0 to <4 x i1>
  %2 = bitcast <4 x i1> %1 to i4
  %3 = icmp eq i4 %2, -1
  ret i1 %3
}

define i4 @bitcast_v8i16_to_v2i4(<8 x i16> %a0) nounwind {
; SSE-LABEL: bitcast_v8i16_to_v2i4:
; SSE:       # %bb.0:
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    movl %eax, %ecx
; SSE-NEXT:    shrb $4, %cl
; SSE-NEXT:    andb $15, %al
; SSE-NEXT:    addb %cl, %al
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    retq
;
; AVX12-LABEL: bitcast_v8i16_to_v2i4:
; AVX12:       # %bb.0:
; AVX12-NEXT:    vpacksswb %xmm0, %xmm0, %xmm0
; AVX12-NEXT:    vpmovmskb %xmm0, %eax
; AVX12-NEXT:    movl %eax, %ecx
; AVX12-NEXT:    shrb $4, %cl
; AVX12-NEXT:    andb $15, %al
; AVX12-NEXT:    addb %cl, %al
; AVX12-NEXT:    # kill: def $al killed $al killed $eax
; AVX12-NEXT:    retq
;
; AVX512-LABEL: bitcast_v8i16_to_v2i4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovw2m %xmm0, %k0
; AVX512-NEXT:    kmovd %k0, %eax
; AVX512-NEXT:    movl %eax, %ecx
; AVX512-NEXT:    shrb $4, %cl
; AVX512-NEXT:    andb $15, %al
; AVX512-NEXT:    addb %cl, %al
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    retq
  %1 = icmp slt <8 x i16> %a0, zeroinitializer
  %2 = bitcast <8 x i1> %1 to <2 x i4>
  %3 = extractelement <2 x i4> %2, i32 0
  %4 = extractelement <2 x i4> %2, i32 1
  %5 = add i4 %3, %4
  ret i4 %5
}

define i1 @trunc_v8i16_cmp(<8 x i16> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v8i16_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    psllw $7, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    testl $21845, %eax # imm = 0x5555
; SSE2-SSSE3-NEXT:    setne %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v8i16_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX12-LABEL: trunc_v8i16_cmp:
; AVX12:       # %bb.0:
; AVX12-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX12-NEXT:    setne %al
; AVX12-NEXT:    retq
;
; AVX512-LABEL: trunc_v8i16_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [281479271743489,281479271743489]
; AVX512-NEXT:    vptest %xmm1, %xmm0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    retq
  %1 = trunc <8 x i16> %a0 to <8 x i1>
  %2 = bitcast <8 x i1> %1 to i8
  %3 = icmp ne i8 %2, 0
  ret i1 %3
}

define i8 @bitcast_v16i8_to_v2i8(<16 x i8> %a0) nounwind {
; SSE-LABEL: bitcast_v16i8_to_v2i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pmovmskb %xmm0, %ecx
; SSE-NEXT:    movl %ecx, %eax
; SSE-NEXT:    shrl $8, %eax
; SSE-NEXT:    addb %cl, %al
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    retq
;
; AVX12-LABEL: bitcast_v16i8_to_v2i8:
; AVX12:       # %bb.0:
; AVX12-NEXT:    vpmovmskb %xmm0, %ecx
; AVX12-NEXT:    movl %ecx, %eax
; AVX12-NEXT:    shrl $8, %eax
; AVX12-NEXT:    addb %cl, %al
; AVX12-NEXT:    # kill: def $al killed $al killed $eax
; AVX12-NEXT:    retq
;
; AVX512-LABEL: bitcast_v16i8_to_v2i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovb2m %xmm0, %k0
; AVX512-NEXT:    kshiftrw $8, %k0, %k1
; AVX512-NEXT:    kmovd %k0, %ecx
; AVX512-NEXT:    kmovd %k1, %eax
; AVX512-NEXT:    addb %cl, %al
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    retq
  %1 = icmp slt <16 x i8> %a0, zeroinitializer
  %2 = bitcast <16 x i1> %1 to <2 x i8>
  %3 = extractelement <2 x i8> %2, i32 0
  %4 = extractelement <2 x i8> %2, i32 1
  %5 = add i8 %3, %4
  ret i8 %5
}

define i1 @trunc_v16i8_cmp(<16 x i8> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v16i8_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    psllw $7, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-SSSE3-NEXT:    setne %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v16i8_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setae %al
; SSE41-NEXT:    retq
;
; AVX12-LABEL: trunc_v16i8_cmp:
; AVX12:       # %bb.0:
; AVX12-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; AVX12-NEXT:    setae %al
; AVX12-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i8_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} xmm1 = [72340172838076673,72340172838076673]
; AVX512-NEXT:    vptest %xmm1, %xmm0
; AVX512-NEXT:    setae %al
; AVX512-NEXT:    retq
  %1 = trunc <16 x i8> %a0 to <16 x i1>
  %2 = bitcast <16 x i1> %1 to i16
  %3 = icmp ne i16 %2, -1
  ret i1 %3
}

;
; 256-bit vectors
;

define i2 @bitcast_v4i64_to_v2i2(<4 x i64> %a0) nounwind {
; SSE-LABEL: bitcast_v4i64_to_v2i2:
; SSE:       # %bb.0:
; SSE-NEXT:    shufps {{.*#+}} xmm0 = xmm0[1,3],xmm1[1,3]
; SSE-NEXT:    movmskps %xmm0, %eax
; SSE-NEXT:    movl %eax, %ecx
; SSE-NEXT:    shrb $2, %cl
; SSE-NEXT:    andb $3, %al
; SSE-NEXT:    addb %cl, %al
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    retq
;
; AVX-LABEL: bitcast_v4i64_to_v2i2:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovmskpd %ymm0, %eax
; AVX-NEXT:    movl %eax, %ecx
; AVX-NEXT:    shrb $2, %cl
; AVX-NEXT:    andb $3, %al
; AVX-NEXT:    addb %cl, %al
; AVX-NEXT:    # kill: def $al killed $al killed $eax
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %1 = icmp slt <4 x i64> %a0, zeroinitializer
  %2 = bitcast <4 x i1> %1 to <2 x i2>
  %3 = extractelement <2 x i2> %2, i32 0
  %4 = extractelement <2 x i2> %2, i32 1
  %5 = add i2 %3, %4
  ret i2 %5
}

define i1 @trunc_v4i64_cmp(<4 x i64> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v4i64_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE2-SSSE3-NEXT:    pslld $31, %xmm0
; SSE2-SSSE3-NEXT:    movmskps %xmm0, %eax
; SSE2-SSSE3-NEXT:    testl %eax, %eax
; SSE2-SSSE3-NEXT:    setne %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v4i64_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v4i64_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v4i64_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v4i64_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <4 x i64> %a0 to <4 x i1>
  %2 = bitcast <4 x i1> %1 to i4
  %3 = icmp ne i4 %2, 0
  ret i1 %3
}

define i4 @bitcast_v8i32_to_v2i4(<8 x i32> %a0) nounwind {
; SSE-LABEL: bitcast_v8i32_to_v2i4:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    movl %eax, %ecx
; SSE-NEXT:    shrb $4, %cl
; SSE-NEXT:    andb $15, %al
; SSE-NEXT:    addb %cl, %al
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    retq
;
; AVX-LABEL: bitcast_v8i32_to_v2i4:
; AVX:       # %bb.0:
; AVX-NEXT:    vmovmskps %ymm0, %eax
; AVX-NEXT:    movl %eax, %ecx
; AVX-NEXT:    shrb $4, %cl
; AVX-NEXT:    andb $15, %al
; AVX-NEXT:    addb %cl, %al
; AVX-NEXT:    # kill: def $al killed $al killed $eax
; AVX-NEXT:    vzeroupper
; AVX-NEXT:    retq
  %1 = icmp slt <8 x i32> %a0, zeroinitializer
  %2 = bitcast <8 x i1> %1 to <2 x i4>
  %3 = extractelement <2 x i4> %2, i32 0
  %4 = extractelement <2 x i4> %2, i32 1
  %5 = add i4 %3, %4
  ret i4 %5
}

define i1 @trunc_v8i132_cmp(<8 x i32> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v8i132_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pslld $31, %xmm0
; SSE2-SSSE3-NEXT:    movmskps %xmm0, %eax
; SSE2-SSSE3-NEXT:    xorl $15, %eax
; SSE2-SSSE3-NEXT:    setne %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v8i132_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setae %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v8i132_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setae %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v8i132_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setae %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v8i132_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setae %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <8 x i32> %a0 to <8 x i1>
  %2 = bitcast <8 x i1> %1 to i8
  %3 = icmp ne i8 %2, -1
  ret i1 %3
}

define i8 @bitcast_v16i16_to_v2i8(<16 x i16> %a0) nounwind {
; SSE-LABEL: bitcast_v16i16_to_v2i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %ecx
; SSE-NEXT:    movl %ecx, %eax
; SSE-NEXT:    shrl $8, %eax
; SSE-NEXT:    addb %cl, %al
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    retq
;
; AVX1-LABEL: bitcast_v16i16_to_v2i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %ecx
; AVX1-NEXT:    movl %ecx, %eax
; AVX1-NEXT:    shrl $8, %eax
; AVX1-NEXT:    addb %cl, %al
; AVX1-NEXT:    # kill: def $al killed $al killed $eax
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: bitcast_v16i16_to_v2i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpmovmskb %xmm0, %ecx
; AVX2-NEXT:    movl %ecx, %eax
; AVX2-NEXT:    shrl $8, %eax
; AVX2-NEXT:    addb %cl, %al
; AVX2-NEXT:    # kill: def $al killed $al killed $eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: bitcast_v16i16_to_v2i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovw2m %ymm0, %k0
; AVX512-NEXT:    kshiftrw $8, %k0, %k1
; AVX512-NEXT:    kmovd %k0, %ecx
; AVX512-NEXT:    kmovd %k1, %eax
; AVX512-NEXT:    addb %cl, %al
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = icmp slt <16 x i16> %a0, zeroinitializer
  %2 = bitcast <16 x i1> %1 to <2 x i8>
  %3 = extractelement <2 x i8> %2, i32 0
  %4 = extractelement <2 x i8> %2, i32 1
  %5 = add i8 %3, %4
  ret i8 %5
}

define i1 @trunc_v16i16_cmp(<16 x i16> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v16i16_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    psllw $7, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    testl $21845, %eax # imm = 0x5555
; SSE2-SSSE3-NEXT:    sete %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v16i16_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v16i16_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v16i16_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i16_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <16 x i16> %a0 to <16 x i1>
  %2 = bitcast <16 x i1> %1 to i16
  %3 = icmp eq i16 %2, 0
  ret i1 %3
}

define i16 @bitcast_v32i8_to_v2i16(<32 x i8> %a0) nounwind {
; SSE-LABEL: bitcast_v32i8_to_v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pmovmskb %xmm1, %ecx
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    addl %ecx, %eax
; SSE-NEXT:    # kill: def $ax killed $ax killed $eax
; SSE-NEXT:    retq
;
; AVX1-LABEL: bitcast_v32i8_to_v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpmovmskb %xmm1, %ecx
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    addl %ecx, %eax
; AVX1-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: bitcast_v32i8_to_v2i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovmskb %ymm0, %ecx
; AVX2-NEXT:    movl %ecx, %eax
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    addl %ecx, %eax
; AVX2-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: bitcast_v32i8_to_v2i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovb2m %ymm0, %k0
; AVX512-NEXT:    kshiftrd $16, %k0, %k1
; AVX512-NEXT:    kmovd %k0, %ecx
; AVX512-NEXT:    kmovd %k1, %eax
; AVX512-NEXT:    addl %ecx, %eax
; AVX512-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = icmp slt <32 x i8> %a0, zeroinitializer
  %2 = bitcast <32 x i1> %1 to <2 x i16>
  %3 = extractelement <2 x i16> %2, i32 0
  %4 = extractelement <2 x i16> %2, i32 1
  %5 = add i16 %3, %4
  ret i16 %5
}

define i1 @trunc_v32i8_cmp(<32 x i8> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v32i8_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    psllw $7, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    xorl $65535, %eax # imm = 0xFFFF
; SSE2-SSSE3-NEXT:    sete %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v32i8_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v32i8_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v32i8_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v32i8_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX512-NEXT:    vptest %ymm1, %ymm0
; AVX512-NEXT:    setb %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <32 x i8> %a0 to <32 x i1>
  %2 = bitcast <32 x i1> %1 to i32
  %3 = icmp eq i32 %2, -1
  ret i1 %3
}

;
; 512-bit vectors
;

define i4 @bitcast_v8i64_to_v2i4(<8 x i64> %a0) nounwind {
; SSE-LABEL: bitcast_v8i64_to_v2i4:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packssdw %xmm2, %xmm0
; SSE-NEXT:    packsswb %xmm0, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    movl %eax, %ecx
; SSE-NEXT:    shrb $4, %cl
; SSE-NEXT:    andb $15, %al
; SSE-NEXT:    addb %cl, %al
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    retq
;
; AVX1-LABEL: bitcast_v8i64_to_v2i4:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpgtq %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpgtq %xmm0, %xmm3, %xmm0
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    vmovmskps %ymm0, %eax
; AVX1-NEXT:    movl %eax, %ecx
; AVX1-NEXT:    shrb $4, %cl
; AVX1-NEXT:    andb $15, %al
; AVX1-NEXT:    addb %cl, %al
; AVX1-NEXT:    # kill: def $al killed $al killed $eax
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: bitcast_v8i64_to_v2i4:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vmovmskps %ymm0, %eax
; AVX2-NEXT:    movl %eax, %ecx
; AVX2-NEXT:    shrb $4, %cl
; AVX2-NEXT:    andb $15, %al
; AVX2-NEXT:    addb %cl, %al
; AVX2-NEXT:    # kill: def $al killed $al killed $eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: bitcast_v8i64_to_v2i4:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpgtq %zmm0, %zmm1, %k0
; AVX512-NEXT:    kmovd %k0, %eax
; AVX512-NEXT:    movl %eax, %ecx
; AVX512-NEXT:    shrb $4, %cl
; AVX512-NEXT:    andb $15, %al
; AVX512-NEXT:    addb %cl, %al
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = icmp slt <8 x i64> %a0, zeroinitializer
  %2 = bitcast <8 x i1> %1 to <2 x i4>
  %3 = extractelement <2 x i4> %2, i32 0
  %4 = extractelement <2 x i4> %2, i32 1
  %5 = add i4 %3, %4
  ret i4 %5
}

define i1 @trunc_v8i64_cmp(<8 x i64> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v8i64_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,2],xmm3[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm2
; SSE2-SSSE3-NEXT:    psrad $16, %xmm2
; SSE2-SSSE3-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,2],xmm1[0,2]
; SSE2-SSSE3-NEXT:    pslld $16, %xmm0
; SSE2-SSSE3-NEXT:    psrad $16, %xmm0
; SSE2-SSSE3-NEXT:    packssdw %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    psllw $15, %xmm0
; SSE2-SSSE3-NEXT:    packsswb %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    cmpb $-1, %al
; SSE2-SSSE3-NEXT:    sete %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v8i64_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setb %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v8i64_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setb %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v8i64_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [1,1,1,1]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setb %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v8i64_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastq {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1]
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <8 x i64> %a0 to <8 x i1>
  %2 = bitcast <8 x i1> %1 to i8
  %3 = icmp eq i8 %2, -1
  ret i1 %3
}

define i8 @bitcast_v16i32_to_v2i8(<16 x i32> %a0) nounwind {
; SSE-LABEL: bitcast_v16i32_to_v2i8:
; SSE:       # %bb.0:
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm2, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %ecx
; SSE-NEXT:    movl %ecx, %eax
; SSE-NEXT:    shrl $8, %eax
; SSE-NEXT:    addb %cl, %al
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    retq
;
; AVX1-LABEL: bitcast_v16i32_to_v2i8:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %ecx
; AVX1-NEXT:    movl %ecx, %eax
; AVX1-NEXT:    shrl $8, %eax
; AVX1-NEXT:    addb %cl, %al
; AVX1-NEXT:    # kill: def $al killed $al killed $eax
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: bitcast_v16i32_to_v2i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpgtd %ymm1, %ymm2, %ymm1
; AVX2-NEXT:    vpcmpgtd %ymm0, %ymm2, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpmovmskb %xmm0, %ecx
; AVX2-NEXT:    movl %ecx, %eax
; AVX2-NEXT:    shrl $8, %eax
; AVX2-NEXT:    addb %cl, %al
; AVX2-NEXT:    # kill: def $al killed $al killed $eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: bitcast_v16i32_to_v2i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpgtd %zmm0, %zmm1, %k0
; AVX512-NEXT:    kshiftrw $8, %k0, %k1
; AVX512-NEXT:    kmovd %k0, %ecx
; AVX512-NEXT:    kmovd %k1, %eax
; AVX512-NEXT:    addb %cl, %al
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = icmp slt <16 x i32> %a0, zeroinitializer
  %2 = bitcast <16 x i1> %1 to <2 x i8>
  %3 = extractelement <2 x i8> %2, i32 0
  %4 = extractelement <2 x i8> %2, i32 1
  %5 = add i8 %3, %4
  ret i8 %5
}

define i1 @trunc_v16i32_cmp(<16 x i32> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v16i32_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pslld $31, %xmm0
; SSE2-SSSE3-NEXT:    movmskps %xmm0, %eax
; SSE2-SSSE3-NEXT:    testl %eax, %eax
; SSE2-SSSE3-NEXT:    sete %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v16i32_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    sete %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v16i32_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    sete %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v16i32_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [4294967297,4294967297,4294967297,4294967297]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    sete %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v16i32_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    sete %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <16 x i32> %a0 to <16 x i1>
  %2 = bitcast <16 x i1> %1 to i16
  %3 = icmp eq i16 %2, 0
  ret i1 %3
}

define i16 @bitcast_v32i16_to_v2i16(<32 x i16> %a0) nounwind {
; SSE-LABEL: bitcast_v32i16_to_v2i16:
; SSE:       # %bb.0:
; SSE-NEXT:    packsswb %xmm3, %xmm2
; SSE-NEXT:    pmovmskb %xmm2, %ecx
; SSE-NEXT:    packsswb %xmm1, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    addl %ecx, %eax
; SSE-NEXT:    # kill: def $ax killed $ax killed $eax
; SSE-NEXT:    retq
;
; AVX1-LABEL: bitcast_v32i16_to_v2i16:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vpacksswb %xmm2, %xmm1, %xmm1
; AVX1-NEXT:    vpmovmskb %xmm1, %ecx
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    addl %ecx, %eax
; AVX1-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: bitcast_v32i16_to_v2i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpacksswb %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpermq {{.*#+}} ymm0 = ymm0[0,2,1,3]
; AVX2-NEXT:    vpmovmskb %ymm0, %ecx
; AVX2-NEXT:    movl %ecx, %eax
; AVX2-NEXT:    shrl $16, %eax
; AVX2-NEXT:    addl %ecx, %eax
; AVX2-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: bitcast_v32i16_to_v2i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovw2m %zmm0, %k0
; AVX512-NEXT:    kshiftrd $16, %k0, %k1
; AVX512-NEXT:    kmovd %k0, %ecx
; AVX512-NEXT:    kmovd %k1, %eax
; AVX512-NEXT:    addl %ecx, %eax
; AVX512-NEXT:    # kill: def $ax killed $ax killed $eax
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = icmp slt <32 x i16> %a0, zeroinitializer
  %2 = bitcast <32 x i1> %1 to <2 x i16>
  %3 = extractelement <2 x i16> %2, i32 0
  %4 = extractelement <2 x i16> %2, i32 1
  %5 = add i16 %3, %4
  ret i16 %5
}

define i1 @trunc_v32i16_cmp(<32 x i16> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v32i16_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    pand %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    pand %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    pand %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    psllw $7, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    notl %eax
; SSE2-SSSE3-NEXT:    testl $21845, %eax # imm = 0x5555
; SSE2-SSSE3-NEXT:    setne %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v32i16_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pand %xmm3, %xmm1
; SSE41-NEXT:    pand %xmm2, %xmm0
; SSE41-NEXT:    pand %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setae %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v32i16_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vandps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setae %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v32i16_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpand %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [281479271743489,281479271743489,281479271743489,281479271743489]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setae %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v32i16_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpbroadcastw {{.*#+}} zmm1 = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1]
; AVX512-NEXT:    vpandq %zmm1, %zmm0, %zmm0
; AVX512-NEXT:    vpcmpneqd %zmm1, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <32 x i16> %a0 to <32 x i1>
  %2 = bitcast <32 x i1> %1 to i32
  %3 = icmp ne i32 %2, -1
  ret i1 %3
}

define i32 @bitcast_v64i8_to_v2i32(<64 x i8> %a0) nounwind {
; SSE2-SSSE3-LABEL: bitcast_v64i8_to_v2i32:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    pmovmskb %xmm1, %ecx
; SSE2-SSSE3-NEXT:    shll $16, %ecx
; SSE2-SSSE3-NEXT:    orl %eax, %ecx
; SSE2-SSSE3-NEXT:    pmovmskb %xmm2, %eax
; SSE2-SSSE3-NEXT:    pmovmskb %xmm3, %edx
; SSE2-SSSE3-NEXT:    shll $16, %edx
; SSE2-SSSE3-NEXT:    orl %eax, %edx
; SSE2-SSSE3-NEXT:    shlq $32, %rdx
; SSE2-SSSE3-NEXT:    orq %rcx, %rdx
; SSE2-SSSE3-NEXT:    movq %rdx, %xmm0
; SSE2-SSSE3-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[1,1,1,1]
; SSE2-SSSE3-NEXT:    movd %xmm0, %eax
; SSE2-SSSE3-NEXT:    addl %ecx, %eax
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: bitcast_v64i8_to_v2i32:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovmskb %xmm2, %eax
; SSE41-NEXT:    pmovmskb %xmm3, %ecx
; SSE41-NEXT:    shll $16, %ecx
; SSE41-NEXT:    orl %eax, %ecx
; SSE41-NEXT:    pmovmskb %xmm0, %edx
; SSE41-NEXT:    pmovmskb %xmm1, %eax
; SSE41-NEXT:    shll $16, %eax
; SSE41-NEXT:    orl %edx, %eax
; SSE41-NEXT:    addl %ecx, %eax
; SSE41-NEXT:    retq
;
; AVX1-LABEL: bitcast_v64i8_to_v2i32:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovmskb %xmm1, %eax
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm1
; AVX1-NEXT:    vpmovmskb %xmm1, %ecx
; AVX1-NEXT:    shll $16, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    vpmovmskb %xmm0, %edx
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    orl %edx, %eax
; AVX1-NEXT:    addl %ecx, %eax
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: bitcast_v64i8_to_v2i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovmskb %ymm1, %ecx
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    addl %ecx, %eax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: bitcast_v64i8_to_v2i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovb2m %zmm0, %k0
; AVX512-NEXT:    kshiftrq $32, %k0, %k1
; AVX512-NEXT:    kmovd %k0, %ecx
; AVX512-NEXT:    kmovd %k1, %eax
; AVX512-NEXT:    addl %ecx, %eax
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = icmp slt <64 x i8> %a0, zeroinitializer
  %2 = bitcast <64 x i1> %1 to <2 x i32>
  %3 = extractelement <2 x i32> %2, i32 0
  %4 = extractelement <2 x i32> %2, i32 1
  %5 = add i32 %3, %4
  ret i32 %5
}

define i1 @trunc_v64i8_cmp(<64 x i8> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v64i8_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    por %xmm3, %xmm1
; SSE2-SSSE3-NEXT:    por %xmm2, %xmm0
; SSE2-SSSE3-NEXT:    por %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    psllw $7, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    testl %eax, %eax
; SSE2-SSSE3-NEXT:    setne %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v64i8_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    por %xmm3, %xmm1
; SSE41-NEXT:    por %xmm2, %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    ptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    setne %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v64i8_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vorps %ymm1, %ymm0, %ymm0
; AVX1-NEXT:    vptest {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v64i8_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpor %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vpbroadcastq {{.*#+}} ymm1 = [72340172838076673,72340172838076673,72340172838076673,72340172838076673]
; AVX2-NEXT:    vptest %ymm1, %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v64i8_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vptestmd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to16}, %zmm0, %k0
; AVX512-NEXT:    kortestw %k0, %k0
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <64 x i8> %a0 to <64 x i1>
  %2 = bitcast <64 x i1> %1 to i64
  %3 = icmp ne i64 %2, 0
  ret i1 %3
}

define i64 @bitcast_v128i8_to_v2i64(<128 x i8> %a0) nounwind {
; SSE-LABEL: bitcast_v128i8_to_v2i64:
; SSE:       # %bb.0:
; SSE-NEXT:    pmovmskb %xmm4, %eax
; SSE-NEXT:    pmovmskb %xmm5, %ecx
; SSE-NEXT:    shll $16, %ecx
; SSE-NEXT:    orl %eax, %ecx
; SSE-NEXT:    pmovmskb %xmm6, %eax
; SSE-NEXT:    pmovmskb %xmm7, %edx
; SSE-NEXT:    shll $16, %edx
; SSE-NEXT:    orl %eax, %edx
; SSE-NEXT:    shlq $32, %rdx
; SSE-NEXT:    orq %rcx, %rdx
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    pmovmskb %xmm1, %ecx
; SSE-NEXT:    shll $16, %ecx
; SSE-NEXT:    orl %eax, %ecx
; SSE-NEXT:    pmovmskb %xmm2, %esi
; SSE-NEXT:    pmovmskb %xmm3, %eax
; SSE-NEXT:    shll $16, %eax
; SSE-NEXT:    orl %esi, %eax
; SSE-NEXT:    shlq $32, %rax
; SSE-NEXT:    orq %rcx, %rax
; SSE-NEXT:    addq %rdx, %rax
; SSE-NEXT:    retq
;
; AVX1-LABEL: bitcast_v128i8_to_v2i64:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpmovmskb %xmm2, %eax
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm2
; AVX1-NEXT:    vpmovmskb %xmm2, %edx
; AVX1-NEXT:    shll $16, %edx
; AVX1-NEXT:    orl %eax, %edx
; AVX1-NEXT:    vpmovmskb %xmm3, %eax
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm2
; AVX1-NEXT:    vpmovmskb %xmm2, %ecx
; AVX1-NEXT:    shll $16, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    shlq $32, %rcx
; AVX1-NEXT:    orq %rdx, %rcx
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %edx
; AVX1-NEXT:    shll $16, %edx
; AVX1-NEXT:    orl %eax, %edx
; AVX1-NEXT:    vpmovmskb %xmm1, %esi
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    orl %esi, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %rdx, %rax
; AVX1-NEXT:    addq %rcx, %rax
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: bitcast_v128i8_to_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpmovmskb %ymm3, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    vpmovmskb %ymm2, %ecx
; AVX2-NEXT:    orq %rax, %rcx
; AVX2-NEXT:    vpmovmskb %ymm1, %edx
; AVX2-NEXT:    shlq $32, %rdx
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    orq %rdx, %rax
; AVX2-NEXT:    addq %rcx, %rax
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: bitcast_v128i8_to_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpmovb2m %zmm1, %k0
; AVX512-NEXT:    kmovq %k0, %rcx
; AVX512-NEXT:    vpmovb2m %zmm0, %k0
; AVX512-NEXT:    kmovq %k0, %rax
; AVX512-NEXT:    addq %rcx, %rax
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = icmp slt <128 x i8> %a0, zeroinitializer
  %2 = bitcast <128 x i1> %1 to <2 x i64>
  %3 = extractelement <2 x i64> %2, i32 0
  %4 = extractelement <2 x i64> %2, i32 1
  %5 = add i64 %3, %4
  ret i64 %5
}

define i1 @trunc_v128i8_cmp(<128 x i8> %a0) nounwind {
; SSE2-SSSE3-LABEL: trunc_v128i8_cmp:
; SSE2-SSSE3:       # %bb.0:
; SSE2-SSSE3-NEXT:    psllw $7, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    psllw $7, %xmm1
; SSE2-SSSE3-NEXT:    pmovmskb %xmm1, %ecx
; SSE2-SSSE3-NEXT:    shll $16, %ecx
; SSE2-SSSE3-NEXT:    orl %eax, %ecx
; SSE2-SSSE3-NEXT:    psllw $7, %xmm2
; SSE2-SSSE3-NEXT:    pmovmskb %xmm2, %edx
; SSE2-SSSE3-NEXT:    psllw $7, %xmm3
; SSE2-SSSE3-NEXT:    pmovmskb %xmm3, %eax
; SSE2-SSSE3-NEXT:    shll $16, %eax
; SSE2-SSSE3-NEXT:    orl %edx, %eax
; SSE2-SSSE3-NEXT:    shlq $32, %rax
; SSE2-SSSE3-NEXT:    orq %rcx, %rax
; SSE2-SSSE3-NEXT:    psllw $7, %xmm4
; SSE2-SSSE3-NEXT:    pmovmskb %xmm4, %ecx
; SSE2-SSSE3-NEXT:    psllw $7, %xmm5
; SSE2-SSSE3-NEXT:    pmovmskb %xmm5, %edx
; SSE2-SSSE3-NEXT:    shll $16, %edx
; SSE2-SSSE3-NEXT:    orl %ecx, %edx
; SSE2-SSSE3-NEXT:    psllw $7, %xmm6
; SSE2-SSSE3-NEXT:    pmovmskb %xmm6, %ecx
; SSE2-SSSE3-NEXT:    psllw $7, %xmm7
; SSE2-SSSE3-NEXT:    pmovmskb %xmm7, %esi
; SSE2-SSSE3-NEXT:    shll $16, %esi
; SSE2-SSSE3-NEXT:    orl %ecx, %esi
; SSE2-SSSE3-NEXT:    shlq $32, %rsi
; SSE2-SSSE3-NEXT:    orq %rdx, %rsi
; SSE2-SSSE3-NEXT:    movq %rsi, %xmm0
; SSE2-SSSE3-NEXT:    movq %rax, %xmm1
; SSE2-SSSE3-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE2-SSSE3-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE2-SSSE3-NEXT:    pcmpeqb %xmm1, %xmm0
; SSE2-SSSE3-NEXT:    pmovmskb %xmm0, %eax
; SSE2-SSSE3-NEXT:    cmpl $65535, %eax # imm = 0xFFFF
; SSE2-SSSE3-NEXT:    setne %al
; SSE2-SSSE3-NEXT:    retq
;
; SSE41-LABEL: trunc_v128i8_cmp:
; SSE41:       # %bb.0:
; SSE41-NEXT:    psllw $7, %xmm0
; SSE41-NEXT:    pmovmskb %xmm0, %eax
; SSE41-NEXT:    psllw $7, %xmm1
; SSE41-NEXT:    pmovmskb %xmm1, %ecx
; SSE41-NEXT:    shll $16, %ecx
; SSE41-NEXT:    orl %eax, %ecx
; SSE41-NEXT:    psllw $7, %xmm2
; SSE41-NEXT:    pmovmskb %xmm2, %edx
; SSE41-NEXT:    psllw $7, %xmm3
; SSE41-NEXT:    pmovmskb %xmm3, %eax
; SSE41-NEXT:    shll $16, %eax
; SSE41-NEXT:    orl %edx, %eax
; SSE41-NEXT:    shlq $32, %rax
; SSE41-NEXT:    orq %rcx, %rax
; SSE41-NEXT:    psllw $7, %xmm4
; SSE41-NEXT:    pmovmskb %xmm4, %ecx
; SSE41-NEXT:    psllw $7, %xmm5
; SSE41-NEXT:    pmovmskb %xmm5, %edx
; SSE41-NEXT:    shll $16, %edx
; SSE41-NEXT:    orl %ecx, %edx
; SSE41-NEXT:    psllw $7, %xmm6
; SSE41-NEXT:    pmovmskb %xmm6, %ecx
; SSE41-NEXT:    psllw $7, %xmm7
; SSE41-NEXT:    pmovmskb %xmm7, %esi
; SSE41-NEXT:    shll $16, %esi
; SSE41-NEXT:    orl %ecx, %esi
; SSE41-NEXT:    shlq $32, %rsi
; SSE41-NEXT:    orq %rdx, %rsi
; SSE41-NEXT:    movq %rsi, %xmm0
; SSE41-NEXT:    movq %rax, %xmm1
; SSE41-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE41-NEXT:    pcmpeqd %xmm0, %xmm0
; SSE41-NEXT:    ptest %xmm0, %xmm1
; SSE41-NEXT:    setae %al
; SSE41-NEXT:    retq
;
; AVX1-LABEL: trunc_v128i8_cmp:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm4
; AVX1-NEXT:    vpmovmskb %xmm4, %eax
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %ecx
; AVX1-NEXT:    shll $16, %ecx
; AVX1-NEXT:    orl %eax, %ecx
; AVX1-NEXT:    vpsllw $7, %xmm1, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %edx
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    shll $16, %eax
; AVX1-NEXT:    orl %edx, %eax
; AVX1-NEXT:    shlq $32, %rax
; AVX1-NEXT:    orq %rcx, %rax
; AVX1-NEXT:    vpsllw $7, %xmm2, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %ecx
; AVX1-NEXT:    vextractf128 $1, %ymm2, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %edx
; AVX1-NEXT:    shll $16, %edx
; AVX1-NEXT:    orl %ecx, %edx
; AVX1-NEXT:    vpsllw $7, %xmm3, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %ecx
; AVX1-NEXT:    vextractf128 $1, %ymm3, %xmm0
; AVX1-NEXT:    vpsllw $7, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %esi
; AVX1-NEXT:    shll $16, %esi
; AVX1-NEXT:    orl %ecx, %esi
; AVX1-NEXT:    shlq $32, %rsi
; AVX1-NEXT:    orq %rdx, %rsi
; AVX1-NEXT:    vmovq %rsi, %xmm0
; AVX1-NEXT:    vmovq %rax, %xmm1
; AVX1-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vptest %xmm1, %xmm0
; AVX1-NEXT:    setae %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: trunc_v128i8_cmp:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpsllw $7, %ymm1, %ymm1
; AVX2-NEXT:    vpmovmskb %ymm1, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    vpsllw $7, %ymm0, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %ecx
; AVX2-NEXT:    orq %rax, %rcx
; AVX2-NEXT:    vpsllw $7, %ymm3, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %eax
; AVX2-NEXT:    shlq $32, %rax
; AVX2-NEXT:    vpsllw $7, %ymm2, %ymm0
; AVX2-NEXT:    vpmovmskb %ymm0, %edx
; AVX2-NEXT:    orq %rax, %rdx
; AVX2-NEXT:    vmovq %rdx, %xmm0
; AVX2-NEXT:    vmovq %rcx, %xmm1
; AVX2-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vptest %xmm1, %xmm0
; AVX2-NEXT:    setae %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: trunc_v128i8_cmp:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpsllw $7, %zmm0, %zmm0
; AVX512-NEXT:    vpmovb2m %zmm0, %k0
; AVX512-NEXT:    kmovq %k0, %rax
; AVX512-NEXT:    vpsllw $7, %zmm1, %zmm0
; AVX512-NEXT:    vpmovb2m %zmm0, %k0
; AVX512-NEXT:    kmovq %k0, %rcx
; AVX512-NEXT:    vmovq %rcx, %xmm0
; AVX512-NEXT:    vmovq %rax, %xmm1
; AVX512-NEXT:    vpunpcklqdq {{.*#+}} xmm0 = xmm1[0],xmm0[0]
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vptest %xmm1, %xmm0
; AVX512-NEXT:    setae %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = trunc <128 x i8> %a0 to <128 x i1>
  %2 = bitcast <128 x i1> %1 to i128
  %3 = icmp ne i128 %2, -1
  ret i1 %3
}

define [2 x i8] @PR58546(<16 x float> %a0) {
; SSE-LABEL: PR58546:
; SSE:       # %bb.0:
; SSE-NEXT:    xorps %xmm4, %xmm4
; SSE-NEXT:    cmpunordps %xmm4, %xmm3
; SSE-NEXT:    cmpunordps %xmm4, %xmm2
; SSE-NEXT:    packssdw %xmm3, %xmm2
; SSE-NEXT:    cmpunordps %xmm4, %xmm1
; SSE-NEXT:    cmpunordps %xmm4, %xmm0
; SSE-NEXT:    packssdw %xmm1, %xmm0
; SSE-NEXT:    packsswb %xmm2, %xmm0
; SSE-NEXT:    pmovmskb %xmm0, %eax
; SSE-NEXT:    movl %eax, %edx
; SSE-NEXT:    shrl $8, %edx
; SSE-NEXT:    # kill: def $al killed $al killed $eax
; SSE-NEXT:    # kill: def $dl killed $dl killed $edx
; SSE-NEXT:    retq
;
; AVX1-LABEL: PR58546:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vcmpunordps %ymm2, %ymm1, %ymm1
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm3
; AVX1-NEXT:    vpackssdw %xmm3, %xmm1, %xmm1
; AVX1-NEXT:    vcmpunordps %ymm2, %ymm0, %ymm0
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpackssdw %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovmskb %xmm0, %eax
; AVX1-NEXT:    movl %eax, %edx
; AVX1-NEXT:    shrl $8, %edx
; AVX1-NEXT:    # kill: def $al killed $al killed $eax
; AVX1-NEXT:    # kill: def $dl killed $dl killed $edx
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: PR58546:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vxorps %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vcmpunordps %ymm2, %ymm1, %ymm1
; AVX2-NEXT:    vcmpunordps %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vpackssdw %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpacksswb %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[0,2,1,3]
; AVX2-NEXT:    vpmovmskb %xmm0, %eax
; AVX2-NEXT:    movl %eax, %edx
; AVX2-NEXT:    shrl $8, %edx
; AVX2-NEXT:    # kill: def $al killed $al killed $eax
; AVX2-NEXT:    # kill: def $dl killed $dl killed $edx
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: PR58546:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vxorps %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vcmpunordps %zmm1, %zmm0, %k0
; AVX512-NEXT:    kshiftrw $8, %k0, %k1
; AVX512-NEXT:    kmovd %k0, %eax
; AVX512-NEXT:    kmovd %k1, %edx
; AVX512-NEXT:    # kill: def $al killed $al killed $eax
; AVX512-NEXT:    # kill: def $dl killed $dl killed $edx
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %1 = fcmp uno <16 x float> %a0, zeroinitializer
  %2 = bitcast <16 x i1> %1 to <2 x i8>
  %3 = extractelement <2 x i8> %2, i64 0
  %4 = extractelement <2 x i8> %2, i64 1
  %5 = insertvalue [2 x i8] poison, i8 %3, 0
  %6 = insertvalue [2 x i8] %5, i8 %4, 1
  ret [2 x i8] %6
}

define i8 @PR59526(<8 x i32> %a, <8 x i32> %b, ptr %mask) {
; SSE-LABEL: PR59526:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE-NEXT:    pcmpeqd %xmm3, %xmm1
; SSE-NEXT:    movdqu (%rdi), %xmm2
; SSE-NEXT:    pand %xmm0, %xmm2
; SSE-NEXT:    movdqu 16(%rdi), %xmm0
; SSE-NEXT:    pand %xmm1, %xmm0
; SSE-NEXT:    packssdw %xmm0, %xmm2
; SSE-NEXT:    pmovmskb %xmm2, %eax
; SSE-NEXT:    testl $43690, %eax # imm = 0xAAAA
; SSE-NEXT:    setne %al
; SSE-NEXT:    retq
;
; AVX1-LABEL: PR59526:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm3, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vtestps (%rdi), %ymm0
; AVX1-NEXT:    setne %al
; AVX1-NEXT:    vzeroupper
; AVX1-NEXT:    retq
;
; AVX2-LABEL: PR59526:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %ymm1, %ymm0, %ymm0
; AVX2-NEXT:    vtestps (%rdi), %ymm0
; AVX2-NEXT:    setne %al
; AVX2-NEXT:    vzeroupper
; AVX2-NEXT:    retq
;
; AVX512-LABEL: PR59526:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %ymm1, %ymm0, %k1
; AVX512-NEXT:    vpxor %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    vpcmpgtd (%rdi), %ymm0, %k0 {%k1}
; AVX512-NEXT:    kmovd %k0, %eax
; AVX512-NEXT:    testb %al, %al
; AVX512-NEXT:    setne %al
; AVX512-NEXT:    vzeroupper
; AVX512-NEXT:    retq
  %cmp.eq = icmp eq <8 x i32> %a, %b
  %load = load <8 x i32>, ptr %mask, align 1
  %cmp.slt = icmp slt <8 x i32> %load, zeroinitializer
  %sel = select <8 x i1> %cmp.eq, <8 x i1> %cmp.slt, <8 x i1> zeroinitializer
  %bc = bitcast <8 x i1> %sel to i8
  %cmp = icmp ne i8 %bc, 0
  %conv = zext i1 %cmp to i8
  ret i8 %conv
}
