; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --filter-out-after "scalar.ph:" --version 2
; RUN: opt -passes=loop-vectorize -force-vector-interleave=1 -force-vector-width=2 %s -S | FileCheck --check-prefixes=VF2 %s
; RUN: opt -passes=loop-vectorize -force-vector-interleave=1 -force-vector-width=4 %s -S | FileCheck --check-prefixes=VF4 %s

; Tests for checking uniformity within a VF.

; for (iv = 0 ; ; iv += 1) B[iv] = A[iv>>0] + 42;
define void @ld_lshr0_step1_start0_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr0_step1_start0_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = lshr i64 [[INDEX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = add nsw <2 x i64> [[WIDE_LOAD]], splat (i64 42)
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[INDEX]]
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[TMP4]], i32 0
; VF2-NEXT:    store <2 x i64> [[TMP3]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF2-NEXT:    br i1 [[TMP6]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr0_step1_start0_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = lshr i64 [[INDEX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[TMP1]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP3:%.*]] = add nsw <4 x i64> [[WIDE_LOAD]], splat (i64 42)
; VF4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[INDEX]]
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[TMP4]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP3]], ptr [[TMP5]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF4-NEXT:    br i1 [[TMP6]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 0
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0 ; ; iv += 1) B[iv] = A[iv>>1] + 42;
; A[iv>>1] is uniform for VF=2 but not VF=4.
define void @ld_lshr1_step1_start0_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr1_step1_start0_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = lshr i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP2:%.*]] = load i64, ptr [[TMP1]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = add nsw i64 [[TMP2]], 42
; VF2-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <2 x i64> poison, i64 [[TMP3]], i64 0
; VF2-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <2 x i64> [[BROADCAST_SPLATINSERT]], <2 x i64> poison, <2 x i32> zeroinitializer
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[INDEX]]
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[TMP4]], i32 0
; VF2-NEXT:    store <2 x i64> [[BROADCAST_SPLAT]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF2-NEXT:    br i1 [[TMP6]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr1_step1_start0_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 1, i64 2, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = lshr <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP1:%.*]] = extractelement <4 x i64> [[TMP0]], i32 0
; VF4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP3:%.*]] = extractelement <4 x i64> [[TMP0]], i32 1
; VF4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP5:%.*]] = extractelement <4 x i64> [[TMP0]], i32 2
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP0]], i32 3
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP4]], align 8
; VF4-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = insertelement <4 x i64> poison, i64 [[TMP9]], i32 0
; VF4-NEXT:    [[TMP14:%.*]] = insertelement <4 x i64> [[TMP13]], i64 [[TMP10]], i32 1
; VF4-NEXT:    [[TMP15:%.*]] = insertelement <4 x i64> [[TMP14]], i64 [[TMP11]], i32 2
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> [[TMP15]], i64 [[TMP12]], i32 3
; VF4-NEXT:    [[TMP17:%.*]] = add nsw <4 x i64> [[TMP16]], splat (i64 42)
; VF4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[INDEX]]
; VF4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds i64, ptr [[TMP18]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP17]], ptr [[TMP19]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; VF4-NEXT:    [[TMP20:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF4-NEXT:    br i1 [[TMP20]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 1
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0 ; ; iv += 1) B[iv] = A[iv>>2] + 42;
; A[iv>>2] is uniform for VF=2 and VF=4.
define void @ld_lshr2_step1_start0_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr2_step1_start0_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = lshr i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP2:%.*]] = load i64, ptr [[TMP1]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = add nsw i64 [[TMP2]], 42
; VF2-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <2 x i64> poison, i64 [[TMP3]], i64 0
; VF2-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <2 x i64> [[BROADCAST_SPLATINSERT]], <2 x i64> poison, <2 x i32> zeroinitializer
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[INDEX]]
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[TMP4]], i32 0
; VF2-NEXT:    store <2 x i64> [[BROADCAST_SPLAT]], ptr [[TMP5]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF2-NEXT:    br i1 [[TMP6]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr2_step1_start0_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = lshr i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP1:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP2:%.*]] = load i64, ptr [[TMP1]], align 8
; VF4-NEXT:    [[TMP3:%.*]] = add nsw i64 [[TMP2]], 42
; VF4-NEXT:    [[BROADCAST_SPLATINSERT:%.*]] = insertelement <4 x i64> poison, i64 [[TMP3]], i64 0
; VF4-NEXT:    [[BROADCAST_SPLAT:%.*]] = shufflevector <4 x i64> [[BROADCAST_SPLATINSERT]], <4 x i64> poison, <4 x i32> zeroinitializer
; VF4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[INDEX]]
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[TMP4]], i32 0
; VF4-NEXT:    store <4 x i64> [[BROADCAST_SPLAT]], ptr [[TMP5]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[INDEX_NEXT]], 1000
; VF4-NEXT:    br i1 [[TMP6]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0 ; ; iv += 2) B[iv] = A[iv>>0] + 42;
define void @ld_lshr0_step2_start0_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr0_step2_start0_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 2>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP2:%.*]] = lshr <2 x i64> [[VEC_IND]], zeroinitializer
; VF2-NEXT:    [[TMP3:%.*]] = extractelement <2 x i64> [[TMP2]], i32 0
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP2]], i32 1
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP4]], align 8
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = insertelement <2 x i64> poison, i64 [[TMP7]], i32 0
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> [[TMP9]], i64 [[TMP8]], i32 1
; VF2-NEXT:    [[TMP11:%.*]] = add nsw <2 x i64> [[TMP10]], splat (i64 42)
; VF2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP14:%.*]] = extractelement <2 x i64> [[TMP11]], i32 0
; VF2-NEXT:    store i64 [[TMP14]], ptr [[TMP12]], align 8
; VF2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i64> [[TMP11]], i32 1
; VF2-NEXT:    store i64 [[TMP15]], ptr [[TMP13]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 4)
; VF2-NEXT:    [[TMP16:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF2-NEXT:    br i1 [[TMP16]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP8:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr0_step2_start0_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 2, i64 4, i64 6>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = lshr <4 x i64> [[VEC_IND]], zeroinitializer
; VF4-NEXT:    [[TMP5:%.*]] = extractelement <4 x i64> [[TMP4]], i32 0
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP4]], i32 1
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP4]], i32 2
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP4]], i32 3
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> poison, i64 [[TMP13]], i32 0
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 1
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 2
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 3
; VF4-NEXT:    [[TMP21:%.*]] = add nsw <4 x i64> [[TMP20]], splat (i64 42)
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP26:%.*]] = extractelement <4 x i64> [[TMP21]], i32 0
; VF4-NEXT:    store i64 [[TMP26]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[TMP27:%.*]] = extractelement <4 x i64> [[TMP21]], i32 1
; VF4-NEXT:    store i64 [[TMP27]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP21]], i32 2
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP21]], i32 3
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 8)
; VF4-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF4-NEXT:    br i1 [[TMP30]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP8:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 0
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0 ; ; iv += 2) B[iv] = A[iv>>1] + 42;
define void @ld_lshr1_step2_start0_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr1_step2_start0_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP0]], 1
; VF2-NEXT:    [[TMP3:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[TMP3]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP4]], align 8
; VF2-NEXT:    [[TMP5:%.*]] = add nsw <2 x i64> [[WIDE_LOAD]], splat (i64 42)
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP8:%.*]] = extractelement <2 x i64> [[TMP5]], i32 0
; VF2-NEXT:    store i64 [[TMP8]], ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = extractelement <2 x i64> [[TMP5]], i32 1
; VF2-NEXT:    store i64 [[TMP9]], ptr [[TMP7]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP10:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF2-NEXT:    br i1 [[TMP10]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP10:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr1_step2_start0_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = lshr i64 [[TMP0]], 1
; VF4-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[TMP5]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP7:%.*]] = add nsw <4 x i64> [[WIDE_LOAD]], splat (i64 42)
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP7]], i32 0
; VF4-NEXT:    store i64 [[TMP12]], ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP7]], i32 1
; VF4-NEXT:    store i64 [[TMP13]], ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP7]], i32 2
; VF4-NEXT:    store i64 [[TMP14]], ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = extractelement <4 x i64> [[TMP7]], i32 3
; VF4-NEXT:    store i64 [[TMP15]], ptr [[TMP11]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP16:%.*]] = icmp eq i64 [[INDEX_NEXT]], 500
; VF4-NEXT:    br i1 [[TMP16]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP10:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 true, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 1
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0 ; ; iv += 3) B[iv] = A[iv>>0] + 42;
define void @ld_lshr0_step3_start0_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr0_step3_start0_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP2:%.*]] = lshr <2 x i64> [[VEC_IND]], zeroinitializer
; VF2-NEXT:    [[TMP3:%.*]] = extractelement <2 x i64> [[TMP2]], i32 0
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP2]], i32 1
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP4]], align 8
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = insertelement <2 x i64> poison, i64 [[TMP7]], i32 0
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> [[TMP9]], i64 [[TMP8]], i32 1
; VF2-NEXT:    [[TMP11:%.*]] = add nsw <2 x i64> [[TMP10]], splat (i64 42)
; VF2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP14:%.*]] = extractelement <2 x i64> [[TMP11]], i32 0
; VF2-NEXT:    store i64 [[TMP14]], ptr [[TMP12]], align 8
; VF2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i64> [[TMP11]], i32 1
; VF2-NEXT:    store i64 [[TMP15]], ptr [[TMP13]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 6)
; VF2-NEXT:    [[TMP16:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP16]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP12:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr0_step3_start0_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 3, i64 6, i64 9>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP4:%.*]] = lshr <4 x i64> [[VEC_IND]], zeroinitializer
; VF4-NEXT:    [[TMP5:%.*]] = extractelement <4 x i64> [[TMP4]], i32 0
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP4]], i32 1
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP4]], i32 2
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP4]], i32 3
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> poison, i64 [[TMP13]], i32 0
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 1
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 2
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 3
; VF4-NEXT:    [[TMP21:%.*]] = add nsw <4 x i64> [[TMP20]], splat (i64 42)
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP26:%.*]] = extractelement <4 x i64> [[TMP21]], i32 0
; VF4-NEXT:    store i64 [[TMP26]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[TMP27:%.*]] = extractelement <4 x i64> [[TMP21]], i32 1
; VF4-NEXT:    store i64 [[TMP27]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP21]], i32 2
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP21]], i32 3
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 12)
; VF4-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP30]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP12:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 0
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 0 ; ; iv += 3) B[iv] = A[iv>>1] + 42;
define void @ld_lshr1_step3_start0_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr1_step3_start0_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 0, i64 3>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP2:%.*]] = lshr <2 x i64> [[VEC_IND]], splat (i64 1)
; VF2-NEXT:    [[TMP3:%.*]] = extractelement <2 x i64> [[TMP2]], i32 0
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = extractelement <2 x i64> [[TMP2]], i32 1
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF2-NEXT:    [[TMP7:%.*]] = load i64, ptr [[TMP4]], align 8
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = insertelement <2 x i64> poison, i64 [[TMP7]], i32 0
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> [[TMP9]], i64 [[TMP8]], i32 1
; VF2-NEXT:    [[TMP11:%.*]] = add nsw <2 x i64> [[TMP10]], splat (i64 42)
; VF2-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP14:%.*]] = extractelement <2 x i64> [[TMP11]], i32 0
; VF2-NEXT:    store i64 [[TMP14]], ptr [[TMP12]], align 8
; VF2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i64> [[TMP11]], i32 1
; VF2-NEXT:    store i64 [[TMP15]], ptr [[TMP13]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 6)
; VF2-NEXT:    [[TMP16:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP16]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP14:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr1_step3_start0_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 0, i64 3, i64 6, i64 9>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP4:%.*]] = lshr <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP5:%.*]] = extractelement <4 x i64> [[TMP4]], i32 0
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP4]], i32 1
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = extractelement <4 x i64> [[TMP4]], i32 2
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = extractelement <4 x i64> [[TMP4]], i32 3
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP11]]
; VF4-NEXT:    [[TMP13:%.*]] = load i64, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP12]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = insertelement <4 x i64> poison, i64 [[TMP13]], i32 0
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> [[TMP17]], i64 [[TMP14]], i32 1
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 2
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 3
; VF4-NEXT:    [[TMP21:%.*]] = add nsw <4 x i64> [[TMP20]], splat (i64 42)
; VF4-NEXT:    [[TMP22:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP0]]
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP26:%.*]] = extractelement <4 x i64> [[TMP21]], i32 0
; VF4-NEXT:    store i64 [[TMP26]], ptr [[TMP22]], align 8
; VF4-NEXT:    [[TMP27:%.*]] = extractelement <4 x i64> [[TMP21]], i32 1
; VF4-NEXT:    store i64 [[TMP27]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP21]], i32 2
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP21]], i32 3
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 12)
; VF4-NEXT:    [[TMP30:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP30]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP14:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 0, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 1
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1 ; ; iv += 1) B[iv] = A[iv>>1] + 42;
; A[iv>>1] not uniform for VF=2 due to alignment (iv starts at 1).
define void @ld_lshr1_step1_start1_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr1_step1_start1_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 2>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; VF2-NEXT:    [[TMP0:%.*]] = lshr <2 x i64> [[VEC_IND]], splat (i64 1)
; VF2-NEXT:    [[TMP1:%.*]] = extractelement <2 x i64> [[TMP0]], i32 0
; VF2-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP3:%.*]] = extractelement <2 x i64> [[TMP0]], i32 1
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = load i64, ptr [[TMP2]], align 8
; VF2-NEXT:    [[TMP6:%.*]] = load i64, ptr [[TMP4]], align 8
; VF2-NEXT:    [[TMP7:%.*]] = insertelement <2 x i64> poison, i64 [[TMP5]], i32 0
; VF2-NEXT:    [[TMP8:%.*]] = insertelement <2 x i64> [[TMP7]], i64 [[TMP6]], i32 1
; VF2-NEXT:    [[TMP9:%.*]] = add nsw <2 x i64> [[TMP8]], splat (i64 42)
; VF2-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[OFFSET_IDX]]
; VF2-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[TMP10]], i32 0
; VF2-NEXT:    store <2 x i64> [[TMP9]], ptr [[TMP11]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 2)
; VF2-NEXT:    [[TMP12:%.*]] = icmp eq i64 [[INDEX_NEXT]], 998
; VF2-NEXT:    br i1 [[TMP12]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP16:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr1_step1_start1_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 2, i64 3, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[INDEX]]
; VF4-NEXT:    [[TMP0:%.*]] = lshr <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP1:%.*]] = extractelement <4 x i64> [[TMP0]], i32 0
; VF4-NEXT:    [[TMP2:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP3:%.*]] = extractelement <4 x i64> [[TMP0]], i32 1
; VF4-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP5:%.*]] = extractelement <4 x i64> [[TMP0]], i32 2
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = extractelement <4 x i64> [[TMP0]], i32 3
; VF4-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP7]]
; VF4-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP2]], align 8
; VF4-NEXT:    [[TMP10:%.*]] = load i64, ptr [[TMP4]], align 8
; VF4-NEXT:    [[TMP11:%.*]] = load i64, ptr [[TMP6]], align 8
; VF4-NEXT:    [[TMP12:%.*]] = load i64, ptr [[TMP8]], align 8
; VF4-NEXT:    [[TMP13:%.*]] = insertelement <4 x i64> poison, i64 [[TMP9]], i32 0
; VF4-NEXT:    [[TMP14:%.*]] = insertelement <4 x i64> [[TMP13]], i64 [[TMP10]], i32 1
; VF4-NEXT:    [[TMP15:%.*]] = insertelement <4 x i64> [[TMP14]], i64 [[TMP11]], i32 2
; VF4-NEXT:    [[TMP16:%.*]] = insertelement <4 x i64> [[TMP15]], i64 [[TMP12]], i32 3
; VF4-NEXT:    [[TMP17:%.*]] = add nsw <4 x i64> [[TMP16]], splat (i64 42)
; VF4-NEXT:    [[TMP18:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[OFFSET_IDX]]
; VF4-NEXT:    [[TMP19:%.*]] = getelementptr inbounds i64, ptr [[TMP18]], i32 0
; VF4-NEXT:    store <4 x i64> [[TMP17]], ptr [[TMP19]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 4)
; VF4-NEXT:    [[TMP20:%.*]] = icmp eq i64 [[INDEX_NEXT]], 996
; VF4-NEXT:    br i1 [[TMP20]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP16:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 1
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 1
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1 ; ; iv += 2) B[iv] = A[iv>>1] + 42;
define void @ld_lshr1_step2_start1_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr1_step2_start1_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2-NEXT:    [[TMP3:%.*]] = lshr i64 [[TMP1]], 1
; VF2-NEXT:    [[TMP4:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP3]]
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[TMP4]], i32 0
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP6:%.*]] = add nsw <2 x i64> [[WIDE_LOAD]], splat (i64 42)
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP9:%.*]] = extractelement <2 x i64> [[TMP6]], i32 0
; VF2-NEXT:    store i64 [[TMP9]], ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = extractelement <2 x i64> [[TMP6]], i32 1
; VF2-NEXT:    store i64 [[TMP10]], ptr [[TMP8]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP11:%.*]] = icmp eq i64 [[INDEX_NEXT]], 498
; VF2-NEXT:    br i1 [[TMP11]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP18:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr1_step2_start1_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 4
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP5:%.*]] = lshr i64 [[TMP1]], 1
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP5]]
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[TMP6]], i32 0
; VF4-NEXT:    [[WIDE_LOAD:%.*]] = load <4 x i64>, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP8:%.*]] = add nsw <4 x i64> [[WIDE_LOAD]], splat (i64 42)
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP13:%.*]] = extractelement <4 x i64> [[TMP8]], i32 0
; VF4-NEXT:    store i64 [[TMP13]], ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP14:%.*]] = extractelement <4 x i64> [[TMP8]], i32 1
; VF4-NEXT:    store i64 [[TMP14]], ptr [[TMP10]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = extractelement <4 x i64> [[TMP8]], i32 2
; VF4-NEXT:    store i64 [[TMP15]], ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = extractelement <4 x i64> [[TMP8]], i32 3
; VF4-NEXT:    store i64 [[TMP16]], ptr [[TMP12]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP17:%.*]] = icmp eq i64 [[INDEX_NEXT]], 496
; VF4-NEXT:    br i1 [[TMP17]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP18:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 1
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 2
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1 ; ; iv += 3) B[iv] = A[iv>>1] + 42;
define void @ld_lshr1_step3_start1_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr1_step3_start1_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP3:%.*]] = lshr <2 x i64> [[VEC_IND]], splat (i64 1)
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = add nsw <2 x i64> [[TMP11]], splat (i64 42)
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i64> [[TMP12]], i32 0
; VF2-NEXT:    store i64 [[TMP15]], ptr [[TMP13]], align 8
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP12]], i32 1
; VF2-NEXT:    store i64 [[TMP16]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 6)
; VF2-NEXT:    [[TMP17:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP17]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP20:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr1_step3_start1_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 4, i64 7, i64 10>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP5:%.*]] = lshr <4 x i64> [[VEC_IND]], splat (i64 1)
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP5]], i32 0
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP5]], i32 1
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP5]], i32 2
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP5]], i32 3
; VF4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP12]]
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP13]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> poison, i64 [[TMP14]], i32 0
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 1
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 2
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 3
; VF4-NEXT:    [[TMP22:%.*]] = add nsw <4 x i64> [[TMP21]], splat (i64 42)
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP27:%.*]] = extractelement <4 x i64> [[TMP22]], i32 0
; VF4-NEXT:    store i64 [[TMP27]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP22]], i32 1
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP22]], i32 2
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP22]], i32 3
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 12)
; VF4-NEXT:    [[TMP31:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP31]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP20:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 1
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}

; for (iv = 1 ; ; iv += 3) B[iv] = A[iv>>2] + 42;
define void @ld_lshr2_step3_start1_ind1(ptr noalias %A, ptr noalias %B) {
; VF2-LABEL: define void @ld_lshr2_step3_start1_ind1
; VF2-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF2-NEXT:  entry:
; VF2-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF2:       vector.ph:
; VF2-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF2:       vector.body:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[VEC_IND:%.*]] = phi <2 x i64> [ <i64 1, i64 4>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF2-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF2-NEXT:    [[TMP3:%.*]] = lshr <2 x i64> [[VEC_IND]], splat (i64 2)
; VF2-NEXT:    [[TMP4:%.*]] = extractelement <2 x i64> [[TMP3]], i32 0
; VF2-NEXT:    [[TMP5:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP4]]
; VF2-NEXT:    [[TMP6:%.*]] = extractelement <2 x i64> [[TMP3]], i32 1
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF2-NEXT:    [[TMP8:%.*]] = load i64, ptr [[TMP5]], align 8
; VF2-NEXT:    [[TMP9:%.*]] = load i64, ptr [[TMP7]], align 8
; VF2-NEXT:    [[TMP10:%.*]] = insertelement <2 x i64> poison, i64 [[TMP8]], i32 0
; VF2-NEXT:    [[TMP11:%.*]] = insertelement <2 x i64> [[TMP10]], i64 [[TMP9]], i32 1
; VF2-NEXT:    [[TMP12:%.*]] = add nsw <2 x i64> [[TMP11]], splat (i64 42)
; VF2-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF2-NEXT:    [[TMP14:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF2-NEXT:    [[TMP15:%.*]] = extractelement <2 x i64> [[TMP12]], i32 0
; VF2-NEXT:    store i64 [[TMP15]], ptr [[TMP13]], align 8
; VF2-NEXT:    [[TMP16:%.*]] = extractelement <2 x i64> [[TMP12]], i32 1
; VF2-NEXT:    store i64 [[TMP16]], ptr [[TMP14]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2-NEXT:    [[VEC_IND_NEXT]] = add <2 x i64> [[VEC_IND]], splat (i64 6)
; VF2-NEXT:    [[TMP17:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF2-NEXT:    br i1 [[TMP17]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP22:![0-9]+]]
; VF2:       middle.block:
; VF2-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF2:       scalar.ph:
;
; VF4-LABEL: define void @ld_lshr2_step3_start1_ind1
; VF4-SAME: (ptr noalias [[A:%.*]], ptr noalias [[B:%.*]]) {
; VF4-NEXT:  entry:
; VF4-NEXT:    br i1 false, label [[SCALAR_PH:%.*]], label [[VECTOR_PH:%.*]]
; VF4:       vector.ph:
; VF4-NEXT:    br label [[VECTOR_BODY:%.*]]
; VF4:       vector.body:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, [[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[VEC_IND:%.*]] = phi <4 x i64> [ <i64 1, i64 4, i64 7, i64 10>, [[VECTOR_PH]] ], [ [[VEC_IND_NEXT:%.*]], [[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP0:%.*]] = mul i64 [[INDEX]], 3
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 1, [[TMP0]]
; VF4-NEXT:    [[TMP1:%.*]] = add i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP2:%.*]] = add i64 [[OFFSET_IDX]], 3
; VF4-NEXT:    [[TMP3:%.*]] = add i64 [[OFFSET_IDX]], 6
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[OFFSET_IDX]], 9
; VF4-NEXT:    [[TMP5:%.*]] = lshr <4 x i64> [[VEC_IND]], splat (i64 2)
; VF4-NEXT:    [[TMP6:%.*]] = extractelement <4 x i64> [[TMP5]], i32 0
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP6]]
; VF4-NEXT:    [[TMP8:%.*]] = extractelement <4 x i64> [[TMP5]], i32 1
; VF4-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[TMP10:%.*]] = extractelement <4 x i64> [[TMP5]], i32 2
; VF4-NEXT:    [[TMP11:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP10]]
; VF4-NEXT:    [[TMP12:%.*]] = extractelement <4 x i64> [[TMP5]], i32 3
; VF4-NEXT:    [[TMP13:%.*]] = getelementptr inbounds i64, ptr [[A]], i64 [[TMP12]]
; VF4-NEXT:    [[TMP14:%.*]] = load i64, ptr [[TMP7]], align 8
; VF4-NEXT:    [[TMP15:%.*]] = load i64, ptr [[TMP9]], align 8
; VF4-NEXT:    [[TMP16:%.*]] = load i64, ptr [[TMP11]], align 8
; VF4-NEXT:    [[TMP17:%.*]] = load i64, ptr [[TMP13]], align 8
; VF4-NEXT:    [[TMP18:%.*]] = insertelement <4 x i64> poison, i64 [[TMP14]], i32 0
; VF4-NEXT:    [[TMP19:%.*]] = insertelement <4 x i64> [[TMP18]], i64 [[TMP15]], i32 1
; VF4-NEXT:    [[TMP20:%.*]] = insertelement <4 x i64> [[TMP19]], i64 [[TMP16]], i32 2
; VF4-NEXT:    [[TMP21:%.*]] = insertelement <4 x i64> [[TMP20]], i64 [[TMP17]], i32 3
; VF4-NEXT:    [[TMP22:%.*]] = add nsw <4 x i64> [[TMP21]], splat (i64 42)
; VF4-NEXT:    [[TMP23:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP1]]
; VF4-NEXT:    [[TMP24:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP2]]
; VF4-NEXT:    [[TMP25:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP3]]
; VF4-NEXT:    [[TMP26:%.*]] = getelementptr inbounds i64, ptr [[B]], i64 [[TMP4]]
; VF4-NEXT:    [[TMP27:%.*]] = extractelement <4 x i64> [[TMP22]], i32 0
; VF4-NEXT:    store i64 [[TMP27]], ptr [[TMP23]], align 8
; VF4-NEXT:    [[TMP28:%.*]] = extractelement <4 x i64> [[TMP22]], i32 1
; VF4-NEXT:    store i64 [[TMP28]], ptr [[TMP24]], align 8
; VF4-NEXT:    [[TMP29:%.*]] = extractelement <4 x i64> [[TMP22]], i32 2
; VF4-NEXT:    store i64 [[TMP29]], ptr [[TMP25]], align 8
; VF4-NEXT:    [[TMP30:%.*]] = extractelement <4 x i64> [[TMP22]], i32 3
; VF4-NEXT:    store i64 [[TMP30]], ptr [[TMP26]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[VEC_IND_NEXT]] = add <4 x i64> [[VEC_IND]], splat (i64 12)
; VF4-NEXT:    [[TMP31:%.*]] = icmp eq i64 [[INDEX_NEXT]], 332
; VF4-NEXT:    br i1 [[TMP31]], label [[MIDDLE_BLOCK:%.*]], label [[VECTOR_BODY]], !llvm.loop [[LOOP22:![0-9]+]]
; VF4:       middle.block:
; VF4-NEXT:    br i1 false, label [[EXIT:%.*]], label [[SCALAR_PH]]
; VF4:       scalar.ph:
;
entry:
  br label %loop
loop:
  %iv = phi i64 [ 1, %entry ], [ %iv_next, %loop ]
  %lshr = lshr i64 %iv, 2
  %gep_ld = getelementptr inbounds i64, ptr %A, i64 %lshr
  %ld = load i64, ptr %gep_ld, align 8
  %calc = add nsw i64 %ld, 42
  %gep_st = getelementptr inbounds i64, ptr %B, i64 %iv
  store i64 %calc, ptr %gep_st, align 8
  %iv_next = add nsw i64 %iv, 3
  %cond = icmp eq i64 %iv_next, 1000
  br i1 %cond, label %exit, label %loop
exit:
  ret void
}
