; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes='print<access-info>' -disable-output %s 2>&1 | FileCheck %s

define void @all_exits_dominate_latch_countable_exits_at_most_500_iterations_known_deref(ptr dereferenceable(2000) %A, ptr dereferenceable(2000) %B) {
; CHECK-LABEL: 'all_exits_dominate_latch_countable_exits_at_most_500_iterations_known_deref'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: (2000 + %B)<nuw>)
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: (2000 + %A)<nuw>)
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  %iv.next = add nuw nsw i64 %iv, 1
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %cntable.c.2 = icmp eq i64 %iv.next, 500
  br i1 %cntable.c.2, label %cleanup4, label %latch

latch:
  br label %loop.header

cleanup4:
  ret void

e.1:
  ret void

e.2:
  ret void
}

define void @all_exits_dominate_latch_countable_exits_at_most_501_iterations_known_deref(ptr dereferenceable(2000) %A, ptr dereferenceable(2000) %B) {
; CHECK-LABEL: 'all_exits_dominate_latch_countable_exits_at_most_501_iterations_known_deref'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  %iv.next = add nuw nsw i64 %iv, 1
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %cntable.c.2 = icmp eq i64 %iv.next, 501
  br i1 %cntable.c.2, label %cleanup4, label %latch

latch:
  br label %loop.header

cleanup4:
  ret void

e.1:
  ret void

e.2:
  ret void
}


define void @all_exits_dominate_latch_countable_exits_at_most_500_iterations_not_known_deref(ptr %A, ptr %B) {
; CHECK-LABEL: 'all_exits_dominate_latch_countable_exits_at_most_500_iterations_not_known_deref'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  %iv.next = add nuw nsw i64 %iv, 1
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %cntable.c.2 = icmp eq i64 %iv.next, 500
  br i1 %cntable.c.2, label %cleanup4, label %latch

latch:
  br label %loop.header

cleanup4:
  ret void

e.1:
  ret void

e.2:
  ret void
}

define i32 @all_exits_dominate_latch_countable_exits_at_most_1000_iterations_known_deref(ptr dereferenceable(4000) %A, ptr dereferenceable(4000) %B) {
; CHECK-LABEL: 'all_exits_dominate_latch_countable_exits_at_most_1000_iterations_known_deref'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: (4000 + %B)<nuw>)
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: (4000 + %A)<nuw>)
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 999
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %iv.next = add nuw nsw i64 %iv, 1
  %cntable.c.2 = icmp eq i64 %iv.next, 2000
  br i1 %cntable.c.2, label %e.0, label %latch

latch:
  br label %loop.header

e.0:
  ret i32 0

e.1:
  ret i32 1

e.2:
  ret i32 2
}

define i32 @all_exits_dominate_latch_countable_exits_at_most_1001_iterations_known_deref(ptr dereferenceable(4000) %A, ptr dereferenceable(4000) %B) {
; CHECK-LABEL: 'all_exits_dominate_latch_countable_exits_at_most_1001_iterations_known_deref'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %iv.next = add nuw nsw i64 %iv, 1
  %cntable.c.2 = icmp eq i64 %iv.next, 2000
  br i1 %cntable.c.2, label %e.0, label %latch

latch:
  br label %loop.header

e.0:
  ret i32 0

e.1:
  ret i32 1

e.2:
  ret i32 2
}

define i32 @all_exits_dominate_latch_countable_exits_at_most_1000_iterations_not_known_deref(ptr %A, ptr %B) {
; CHECK-LABEL: 'all_exits_dominate_latch_countable_exits_at_most_1000_iterations_not_known_deref'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 999
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %iv.next = add nuw nsw i64 %iv, 1
  %cntable.c.2 = icmp eq i64 %iv.next, 2000
  br i1 %cntable.c.2, label %e.0, label %latch

latch:
  br label %loop.header

e.0:
  ret i32 0

e.1:
  ret i32 1

e.2:
  ret i32 2
}


define i32 @not_all_exits_dominate_latch(ptr %A, ptr %B) {
; CHECK-LABEL: 'not_all_exits_dominate_latch'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Report: could not determine number of loop iterations
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Grouped accesses:
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  %iv.next = add nuw nsw i64 %iv, 1
  br i1 %cntable.c.1, label %b2, label %latch

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %cntable.c.2 = icmp eq i64 %iv.next, 2000
  br i1 %cntable.c.2, label %e.0, label %latch

latch:
  br label %loop.header

e.0:
  ret i32 0

e.2:
  ret i32 1
}

define i32 @b3_does_not_dominate_latch_known_deref(ptr dereferenceable(4000) %A, ptr dereferenceable(4000) %B) {
; CHECK-LABEL: 'b3_does_not_dominate_latch_known_deref'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  %iv.next = add nuw nsw i64 %iv, 1
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %latch, label %b3

b3:
  %cntable.c.2 = icmp eq i64 %iv.next, 500
  br i1 %cntable.c.2, label %e.0, label %latch

latch:
  br label %loop.header

e.0:
  ret i32 0

e.1:
  ret i32 1
}

define i32 @b3_does_not_dominate_latch_not_known_deref(ptr %A, ptr %B) {
; CHECK-LABEL: 'b3_does_not_dominate_latch_not_known_deref'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  %iv.next = add nuw nsw i64 %iv, 1
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %latch, label %b3

b3:
  %cntable.c.2 = icmp eq i64 %iv.next, 500
  br i1 %cntable.c.2, label %e.0, label %latch

latch:
  br label %loop.header

e.0:
  ret i32 0

e.1:
  ret i32 1
}

define void @all_exits_dominate_latch_countable_exits_at_most_500_iterations_known_deref_via_assumption(ptr %A, ptr %B) {
; CHECK-LABEL: 'all_exits_dominate_latch_countable_exits_at_most_500_iterations_known_deref_via_assumption'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  call void @llvm.assume(i1 true) [ "dereferenceable"(ptr %A, i64 2000) ]
  call void @llvm.assume(i1 true) [ "dereferenceable"(ptr %B, i64 2000) ]
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  %iv.next = add nuw nsw i64 %iv, 1
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %cntable.c.2 = icmp eq i64 %iv.next, 500
  br i1 %cntable.c.2, label %cleanup4, label %latch

latch:
  br label %loop.header

cleanup4:
  ret void

e.1:
  ret void

e.2:
  ret void
}

define void @all_exits_dominate_latch_countable_exits_at_most_500_iterations_deref_via_assumption_too_small(ptr %A, ptr %B) {
; CHECK-LABEL: 'all_exits_dominate_latch_countable_exits_at_most_500_iterations_deref_via_assumption_too_small'
; CHECK-NEXT:    loop.header:
; CHECK-NEXT:      Memory dependences are safe with run-time checks
; CHECK-NEXT:      Dependences:
; CHECK-NEXT:      Run-time memory checks:
; CHECK-NEXT:      Check 0:
; CHECK-NEXT:        Comparing group GRP0:
; CHECK-NEXT:          %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
; CHECK-NEXT:        Against group GRP1:
; CHECK-NEXT:          %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
; CHECK-NEXT:      Grouped accesses:
; CHECK-NEXT:        Group GRP0:
; CHECK-NEXT:          (Low: %B High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%B,+,4}<nuw><%loop.header>
; CHECK-NEXT:        Group GRP1:
; CHECK-NEXT:          (Low: %A High: inttoptr (i64 -1 to ptr))
; CHECK-NEXT:            Member: {%A,+,4}<nuw><%loop.header>
; CHECK-EMPTY:
; CHECK-NEXT:      Non vectorizable stores to invariant address were not found in loop.
; CHECK-NEXT:      SCEV assumptions:
; CHECK-EMPTY:
; CHECK-NEXT:      Expressions re-written:
;
entry:
  call void @llvm.assume(i1 true) [ "dereferenceable"(ptr %A, i64 1999) ]
  call void @llvm.assume(i1 true) [ "dereferenceable"(ptr %B, i64 1999) ]
  br label %loop.header

loop.header:
  %iv = phi i64 [ 0, %entry ], [ %iv.next, %latch ]
  %gep.A = getelementptr inbounds i32, ptr %A, i64 %iv
  %gep.B = getelementptr inbounds i32, ptr %B, i64 %iv
  %l = load i32, ptr %gep.A, align 4
  store i32 0, ptr %gep.B, align 4
  %cntable.c.1 = icmp ult i64 %iv, 1000
  %iv.next = add nuw nsw i64 %iv, 1
  br i1 %cntable.c.1, label %b2, label %e.1

b2:
  %uncntable.c.0 = icmp eq i32 %l, 0
  br i1 %uncntable.c.0, label %e.2, label %b3

b3:
  %cntable.c.2 = icmp eq i64 %iv.next, 500
  br i1 %cntable.c.2, label %cleanup4, label %latch

latch:
  br label %loop.header

cleanup4:
  ret void

e.1:
  ret void

e.2:
  ret void
}
