; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV32I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=RV64I

define i32 @and_0xfff_shl_2(i32 %x) {
; RV32I-LABEL: and_0xfff_shl_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 20
; RV32I-NEXT:    srli a0, a0, 18
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_0xfff_shl_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 52
; RV64I-NEXT:    srli a0, a0, 50
; RV64I-NEXT:    ret
  %a = and i32 %x, 4095
  %s = shl i32 %a, 2
  ret i32 %s
}

define i32 @and_0x7ff_shl_2(i32 %x) {
; RV32I-LABEL: and_0x7ff_shl_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    andi a0, a0, 2047
; RV32I-NEXT:    slli a0, a0, 2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_0x7ff_shl_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    andi a0, a0, 2047
; RV64I-NEXT:    slli a0, a0, 2
; RV64I-NEXT:    ret
  %a = and i32 %x, 2047
  %s = shl i32 %a, 2
  ret i32 %s
}

define i64 @and_0xffffffff_shl_2(i64 %x) {
; RV32I-LABEL: and_0xffffffff_shl_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 2
; RV32I-NEXT:    srli a1, a0, 30
; RV32I-NEXT:    mv a0, a2
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_0xffffffff_shl_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 32
; RV64I-NEXT:    srli a0, a0, 30
; RV64I-NEXT:    ret
  %a = and i64 %x, 4294967295
  %s = shl i64 %a, 2
  ret i64 %s
}

define i32 @and_0xfff_shl_2_multi_use(i32 %x) {
; RV32I-LABEL: and_0xfff_shl_2_multi_use:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 20
; RV32I-NEXT:    srli a0, a0, 20
; RV32I-NEXT:    slli a1, a0, 2
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_0xfff_shl_2_multi_use:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 52
; RV64I-NEXT:    srli a0, a0, 52
; RV64I-NEXT:    slli a1, a0, 2
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    ret
  %a = and i32 %x, 4095
  %s = shl i32 %a, 2
  %r = add i32 %a, %s
  ret i32 %r
}

define i64 @and_0xfff_shl_33(i64 %x) {
; RV32I-LABEL: and_0xfff_shl_33:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 20
; RV32I-NEXT:    srli a1, a0, 19
; RV32I-NEXT:    li a0, 0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: and_0xfff_shl_33:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 52
; RV64I-NEXT:    srli a0, a0, 19
; RV64I-NEXT:    ret
  %a = and i64 %x, 4095
  %s = shl i64 %a, 33
  ret i64 %s
}
