; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s

define i8 @sdiv_neg_neg_high_bits(i8 %x, i8 %y) {
; CHECK-LABEL: sdiv_neg_neg_high_bits:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %num = or i8 %x, 128
  %denum = or i8 %y, 131
  %div = sdiv i8 %num, %denum
  %r = and i8 %div, 128
  ret i8 %r
}

define i8 @sdiv_exact_odd_odd(i8 %x, i8 %y) {
; CHECK-LABEL: sdiv_exact_odd_odd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    retq
  %num = or i8 %x, 1
  %denum = or i8 %y, 1
  %div = sdiv exact i8 %num, %denum
  %r = and i8 %div, 1
  ret i8 %r
}

define i8 @sdiv_exact_even_even_fail_unknown(i8 %x, i8 %y) {
; CHECK-LABEL: sdiv_exact_even_even_fail_unknown:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andb $-2, %dil
; CHECK-NEXT:    andb $-2, %sil
; CHECK-NEXT:    movsbl %dil, %eax
; CHECK-NEXT:    idivb %sil
; CHECK-NEXT:    andb $1, %al
; CHECK-NEXT:    retq
  %num = and i8 %x, -2
  %denum = and i8 %y, -2
  %div = sdiv exact i8 %num, %denum
  %r = and i8 %div, 1
  ret i8 %r
}

define i8 @udiv_exact_even_odd(i8 %x, i8 %y) {
; CHECK-LABEL: udiv_exact_even_odd:
; CHECK:       # %bb.0:
; CHECK-NEXT:    xorl %eax, %eax
; CHECK-NEXT:    retq
  %num = and i8 %x, -2
  %denum = or i8 %y, 1
  %div = udiv exact i8 %num, %denum
  %r = and i8 %div, 1
  ret i8 %r
}

define i8 @udiv_exact_even_even_fail_unknown(i8 %x, i8 %y) {
; CHECK-LABEL: udiv_exact_even_even_fail_unknown:
; CHECK:       # %bb.0:
; CHECK-NEXT:    andb $-2, %dil
; CHECK-NEXT:    andb $-2, %sil
; CHECK-NEXT:    movzbl %dil, %eax
; CHECK-NEXT:    divb %sil
; CHECK-NEXT:    andb $1, %al
; CHECK-NEXT:    retq
  %num = and i8 %x, -2
  %denum = and i8 %y, -2
  %div = udiv exact i8 %num, %denum
  %r = and i8 %div, 1
  ret i8 %r
}
