/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMessageEvent.h"

#include "DOMWindow.h"
#include "JSDOMWindow.h"
#include "KURL.h"
#include "MessageEvent.h"
#include "SerializedScriptValue.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMessageEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMessageEventTableValues[7] =
{
    { "data", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventData), (intptr_t)0 THUNK_GENERATOR(0) },
    { "origin", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventOrigin), (intptr_t)0 THUNK_GENERATOR(0) },
    { "lastEventId", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventLastEventId), (intptr_t)0 THUNK_GENERATOR(0) },
    { "source", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventSource), (intptr_t)0 THUNK_GENERATOR(0) },
    { "ports", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventPorts), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMessageEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMessageEventTable = { 16, 15, JSMessageEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMessageEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMessageEventConstructorTable = { 1, 0, JSMessageEventConstructorTableValues, 0 };
class JSMessageEventConstructor : public DOMConstructorObject {
public:
    JSMessageEventConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSMessageEventConstructor::s_info = { "MessageEventConstructor", &DOMConstructorObject::s_info, &JSMessageEventConstructorTable, 0 };

JSMessageEventConstructor::JSMessageEventConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMessageEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSMessageEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageEventConstructor, JSDOMWrapper>(exec, &JSMessageEventConstructorTable, this, propertyName, slot);
}

bool JSMessageEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageEventConstructor, JSDOMWrapper>(exec, &JSMessageEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMessageEventPrototypeTableValues[2] =
{
    { "initMessageEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsMessageEventPrototypeFunctionInitMessageEvent), (intptr_t)8 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMessageEventPrototypeTable = { 2, 1, JSMessageEventPrototypeTableValues, 0 };
static const HashTable* getJSMessageEventPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageEventPrototypeTable);
}

const ClassInfo JSMessageEventPrototype::s_info = { "MessageEventPrototype", &JSC::JSObjectWithGlobalObject::s_info, 0, getJSMessageEventPrototypeTable };

JSObject* JSMessageEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessageEvent>(exec, globalObject);
}

bool JSMessageEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSMessageEventPrototypeTable(exec), this, propertyName, slot);
}

bool JSMessageEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, getJSMessageEventPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSMessageEventTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessageEventTable);
}

const ClassInfo JSMessageEvent::s_info = { "MessageEvent", &JSEvent::s_info, 0, getJSMessageEventTable };

JSMessageEvent::JSMessageEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MessageEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
    for (unsigned i = Base::AnonymousSlotCount; i < AnonymousSlotCount; i++)
        putAnonymousValue(globalObject->globalData(), i, JSValue());
}

JSObject* JSMessageEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMessageEventPrototype(exec->globalData(), globalObject, JSMessageEventPrototype::createStructure(exec->globalData(), JSEventPrototype::self(exec, globalObject)));
}

bool JSMessageEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessageEvent, Base>(exec, getJSMessageEventTable(exec), this, propertyName, slot);
}

bool JSMessageEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMessageEvent, Base>(exec, getJSMessageEventTable(exec), this, propertyName, descriptor);
}

JSValue jsMessageEventData(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    if (JSValue cachedValue = castedThis->getAnonymousValue(JSMessageEvent::dataSlot))
        return cachedValue;
    MessageEvent* imp = static_cast<MessageEvent*>(castedThis->impl());
    JSValue result = imp->data() ? imp->data()->deserialize(exec, castedThis->globalObject()) : jsNull();
    castedThis->putAnonymousValue(exec->globalData(), JSMessageEvent::dataSlot, result);
    return result;
}


JSValue jsMessageEventOrigin(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageEvent* imp = static_cast<MessageEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->origin());
    return result;
}


JSValue jsMessageEventLastEventId(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageEvent* imp = static_cast<MessageEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->lastEventId());
    return result;
}


JSValue jsMessageEventSource(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MessageEvent* imp = static_cast<MessageEvent*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->source()));
    return result;
}


JSValue jsMessageEventPorts(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(slotBase));
    return castedThis->ports(exec);
}


JSValue jsMessageEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMessageEvent* domObject = static_cast<JSMessageEvent*>(asObject(slotBase));
    return JSMessageEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSMessageEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMessageEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsMessageEventPrototypeFunctionInitMessageEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSMessageEvent::s_info))
        return throwVMTypeError(exec);
    JSMessageEvent* castedThis = static_cast<JSMessageEvent*>(asObject(thisValue));
    return JSValue::encode(castedThis->initMessageEvent(exec));
}


}
