/*
    magick-aux.c - Part of psiconv, a PSION 5 file formats converter
    Copyright (c) 2000-2005  Frodo Looijaard <frodo@frodo.looijaard.name>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "config.h"

#if IMAGEMAGICK

#include "magick-aux.h"

#endif

#ifdef DMALLOC
#include "dmalloc.h"
#endif

#if IMAGEMAGICK

/* This used to be very ugly, but nowadays it is much better */

#if IMAGEMAGICK_API == 1 || IMAGEMAGICK_API == 2
const MagickInfo * GetMagickFileList(void)
{
  ExceptionInfo exc;
  GetExceptionInfo(&exc);
  OpenModules(&exc);
  return GetMagickInfo(NULL,&exc);
}

#elif IMAGEMAGICK_API == 3

const MagickInfo * GetMagickFileList(void)
{
  MagickInfo **mi;
  unsigned long nr;
  int i;
  ExceptionInfo exc;
  GetExceptionInfo(&exc);
  OpenModules(&exc);
  mi = GetMagickInfoList("*",&nr);
  for (i = 0; i < nr-1; i++) {
    mi[i]->next = mi[i+1];
  }
  return *mi;
}

#elif IMAGEMAGICK_API == 4

const MagickInfo * GetMagickFileList(void)
{
  MagickInfo **mi;
  unsigned long nr;
  int i;
  ExceptionInfo exc;
  GetExceptionInfo(&exc);
  mi = GetMagickInfoList("*",&nr,&exc);
  for (i = 0; i < nr-1; i++) {
    mi[i]->next = mi[i+1];
  }
  return *mi;
}
#endif

#endif /* IMAGEMAGICK */
