/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.spore;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.eclipse.elk.alg.common.TEdge;
import org.eclipse.elk.alg.common.spore.IOverlapHandler;
import org.eclipse.elk.alg.common.spore.InternalProperties;
import org.eclipse.elk.alg.common.spore.ScanlineOverlapCheck;
import org.eclipse.elk.alg.common.utils.SVGImage;
import org.eclipse.elk.alg.spore.ElkGraphImporter;
import org.eclipse.elk.alg.spore.SPOrEPhases;
import org.eclipse.elk.alg.spore.graph.Graph;
import org.eclipse.elk.alg.spore.options.OverlapRemovalStrategy;
import org.eclipse.elk.alg.spore.options.RootSelection;
import org.eclipse.elk.alg.spore.options.SpanningTreeCostFunction;
import org.eclipse.elk.alg.spore.options.SporeCompactionOptions;
import org.eclipse.elk.alg.spore.options.SporeOverlapRemovalOptions;
import org.eclipse.elk.alg.spore.options.StructureExtractionStrategy;
import org.eclipse.elk.alg.spore.options.TreeConstructionStrategy;
import org.eclipse.elk.core.AbstractLayoutProvider;
import org.eclipse.elk.core.alg.AlgorithmAssembler;
import org.eclipse.elk.core.alg.ILayoutPhaseFactory;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.data.LayoutAlgorithmData;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.graph.ElkNode;

public class OverlapRemovalLayoutProvider
extends AbstractLayoutProvider {
    private AlgorithmAssembler<SPOrEPhases, Graph> algorithmAssembler = AlgorithmAssembler.create(SPOrEPhases.class);
    private List<ILayoutProcessor<Graph>> algorithm;

    public void layout(ElkNode layoutGraph, IElkProgressMonitor progressMonitor) {
        if (layoutGraph.hasProperty(SporeCompactionOptions.UNDERLYING_LAYOUT_ALGORITHM)) {
            String requestedAlgorithm = (String)layoutGraph.getProperty(SporeOverlapRemovalOptions.UNDERLYING_LAYOUT_ALGORITHM);
            LayoutAlgorithmData lad = LayoutMetaDataService.getInstance().getAlgorithmDataBySuffix(requestedAlgorithm);
            if (lad != null) {
                AbstractLayoutProvider layoutProvider = (AbstractLayoutProvider)lad.getInstancePool().fetch();
                layoutProvider.layout(layoutGraph, progressMonitor.subTask(1.0f));
            }
        }
        layoutGraph.setProperty(SporeCompactionOptions.PROCESSING_ORDER_ROOT_SELECTION, (Object)RootSelection.CENTER_NODE);
        layoutGraph.setProperty(SporeCompactionOptions.PROCESSING_ORDER_SPANNING_TREE_COST_FUNCTION, (Object)SpanningTreeCostFunction.INVERTED_OVERLAP);
        layoutGraph.setProperty(SporeCompactionOptions.PROCESSING_ORDER_TREE_CONSTRUCTION, (Object)TreeConstructionStrategy.MINIMUM_SPANNING_TREE);
        int maxIterations = (Integer)layoutGraph.getProperty(SporeOverlapRemovalOptions.OVERLAP_REMOVAL_MAX_ITERATIONS);
        progressMonitor.begin("Overlap removal", 1.0f);
        String debugOutputFile = null;
        if (((Boolean)layoutGraph.getProperty(SporeOverlapRemovalOptions.DEBUG_MODE)).booleanValue()) {
            debugOutputFile = ElkUtil.debugFolderPath((String[])new String[]{"spore"}) + "45scanlineOverlaps";
        }
        SVGImage svg = new SVGImage(debugOutputFile);
        HashSet overlapEdges = Sets.newHashSet();
        IOverlapHandler overlapHandler = (n1, n2) -> {
            boolean bl = overlapEdges.add(new TEdge(n1.originalVertex, n2.originalVertex));
        };
        ElkGraphImporter graphImporter = new ElkGraphImporter();
        Graph graph = graphImporter.importGraph(layoutGraph);
        boolean overlapsExisted = true;
        int iteration = 0;
        while (iteration < maxIterations && overlapsExisted) {
            if (((Boolean)layoutGraph.getProperty(SporeOverlapRemovalOptions.OVERLAP_REMOVAL_RUN_SCANLINE)).booleanValue()) {
                overlapEdges.clear();
                new ScanlineOverlapCheck(overlapHandler, svg).sweep(graph.vertices);
                if (overlapEdges.isEmpty()) break;
                graph.tEdges = overlapEdges;
            }
            this.algorithmAssembler.reset();
            this.algorithmAssembler.setPhase((Enum)SPOrEPhases.P1_STRUCTURE, (ILayoutPhaseFactory)StructureExtractionStrategy.DELAUNAY_TRIANGULATION);
            this.algorithmAssembler.setPhase((Enum)SPOrEPhases.P2_PROCESSING_ORDER, (ILayoutPhaseFactory)graph.treeConstructionStrategy);
            this.algorithmAssembler.setPhase((Enum)SPOrEPhases.P3_EXECUTION, (ILayoutPhaseFactory)OverlapRemovalStrategy.GROW_TREE);
            this.algorithm = this.algorithmAssembler.build((Object)graph);
            for (ILayoutProcessor<Graph> processor : this.algorithm) {
                processor.process((Object)graph, progressMonitor.subTask(1.0f));
            }
            graphImporter.updateGraph(graph);
            overlapsExisted = (Boolean)graph.getProperty(InternalProperties.OVERLAPS_EXISTED);
            ++iteration;
        }
        graphImporter.applyPositions(graph);
        progressMonitor.done();
    }
}

