/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.delete;

import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.gef.commands.Command;

public class DeleteImportCommand
extends Command
implements ScopedCommand {
    private final CompilerInfo compilerInfo;
    private final Import importer;
    private int oldIndex;

    public DeleteImportCommand(CompilerInfo compilerInfo, Import importer) {
        this.compilerInfo = Objects.requireNonNull(compilerInfo);
        this.importer = Objects.requireNonNull(importer);
    }

    public void execute() {
        this.oldIndex = this.compilerInfo.getImports().indexOf((Object)this.importer);
        this.redo();
    }

    public void undo() {
        this.compilerInfo.getImports().add(this.oldIndex, (Object)this.importer);
    }

    public void redo() {
        this.compilerInfo.getImports().remove((Object)this.importer);
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(EcoreUtil.getRootContainer((EObject)this.compilerInfo));
    }
}

