/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.compiler;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoParserUtils;
import org.eclipse.acceleo.internal.parser.compiler.AcceleoProjectClasspathEntry;
import org.eclipse.acceleo.internal.parser.cst.utils.FileContent;
import org.eclipse.acceleo.internal.parser.cst.utils.Region;
import org.eclipse.acceleo.internal.parser.cst.utils.Sequence;
import org.eclipse.emf.common.util.URI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoProject {
    private File projectRoot;
    private Set<AcceleoProjectClasspathEntry> entries = new LinkedHashSet<AcceleoProjectClasspathEntry>();
    private Set<URI> dependencies = new LinkedHashSet<URI>();
    private Set<AcceleoProject> projectDependencies = new LinkedHashSet<AcceleoProject>();
    private Set<AcceleoProject> dependentProjects = new LinkedHashSet<AcceleoProject>();
    private Set<File> acceleoModulesCache = new LinkedHashSet<File>();

    public AcceleoProject(File projectRoot) {
        this(projectRoot, new LinkedHashSet<AcceleoProjectClasspathEntry>());
    }

    public AcceleoProject(File projectRoot, Set<AcceleoProjectClasspathEntry> entries) {
        Preconditions.checkState((boolean)projectRoot.isDirectory());
        this.projectRoot = projectRoot;
        this.entries.addAll(entries);
    }

    public Set<File> getFilesDependingOn(File file) {
        List<Sequence> sequencesToSearch = AcceleoParserUtils.getImportSequencesToSearch(this, file);
        return this.getFilesDependingOn(sequencesToSearch);
    }

    public Set<File> getFilesDependingOn(List<Sequence> sequences) {
        LinkedHashSet<File> filesToBuild = new LinkedHashSet<File>();
        Set<File> allAcceleoModules = this.getAllAcceleoModules();
        for (File acceleoModule : allAcceleoModules) {
            StringBuffer fileContent = FileContent.getFileContent(acceleoModule);
            for (Sequence sequence : sequences) {
                Region region = sequence.search(fileContent);
                if (region.b() <= -1) continue;
                filesToBuild.add(acceleoModule);
            }
        }
        return filesToBuild;
    }

    public File getFileDependency(String dependency) {
        File module = null;
        for (File acceleoModule : this.getAllAcceleoModules()) {
            if (!dependency.equals(this.getModuleQualifiedName(acceleoModule))) continue;
            module = acceleoModule;
            break;
        }
        for (File acceleoModule : this.getAllAcceleoModules()) {
            String name = acceleoModule.getName();
            if (name.endsWith(".mtl")) {
                name = name.substring(0, name.length() - ".mtl".length());
            }
            if (!dependency.equals(name)) continue;
            module = acceleoModule;
            break;
        }
        return module;
    }

    public URI getURIDependency(String dependency) {
        URI result = null;
        for (URI uri : this.dependencies) {
            Set<String> moduleQualifiedName;
            String[] segments;
            String uriStr;
            if (uri.isPlatformPlugin()) {
                uriStr = uri.toString();
                segments = uri.segments();
                if (!uriStr.startsWith("platform:/plugin/") || segments.length <= 1 || !"plugin".equals(segments[0]) || !(moduleQualifiedName = this.computeQualifiedNames(segments)).contains(dependency)) continue;
                result = uri;
                break;
            }
            if (uri.isPlatformResource()) {
                uriStr = uri.toString();
                segments = uri.segments();
                if (!uriStr.startsWith("platform:/resource/") || segments.length <= 1 || !"resource".equals(segments[0]) || !(moduleQualifiedName = this.computeQualifiedNames(segments)).contains(dependency)) continue;
                result = uri;
                break;
            }
            Set<URI> allModules = AcceleoParserUtils.getAllModules(uri);
            for (URI moduleURI : allModules) {
                String moduleName = AcceleoParserUtils.getModuleName(moduleURI);
                if (!dependency.equals(moduleName)) continue;
                return moduleURI;
            }
        }
        return result;
    }

    private Set<String> computeQualifiedNames(String[] segments) {
        LinkedHashSet<String> names = new LinkedHashSet<String>(2);
        names.add(this.qualifiedNameFromSegment(segments, true));
        names.add(this.qualifiedNameFromSegment(segments, false));
        return names;
    }

    private String qualifiedNameFromSegment(String[] segments, boolean trimBinOutputFolder) {
        String moduleQualifiedName = "";
        ArrayList qualifiedNameSegments = Lists.newArrayList();
        int cpt = 2;
        while (cpt < segments.length) {
            String segment = segments[cpt];
            if (!"bin".equals(segment) && !trimBinOutputFolder) {
                qualifiedNameSegments.add(segment);
            }
            ++cpt;
        }
        moduleQualifiedName = Joiner.on((String)"::").join((Iterable)qualifiedNameSegments);
        if (moduleQualifiedName.endsWith(".emtl")) {
            moduleQualifiedName = moduleQualifiedName.substring(0, moduleQualifiedName.lastIndexOf(46));
        }
        return moduleQualifiedName;
    }

    public void addClasspathEntries(Set<AcceleoProjectClasspathEntry> classpathEntries) {
        this.entries.addAll(classpathEntries);
    }

    public boolean addDependencies(Set<URI> newDependencies) {
        return this.dependencies.addAll(newDependencies);
    }

    public Set<URI> getDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public void clearDependencies() {
        this.dependencies.clear();
    }

    public Set<URI> getModulesDependencies() {
        return Collections.unmodifiableSet(this.dependencies);
    }

    public boolean addProjectDependencies(Set<AcceleoProject> newProjectDependencies) {
        boolean result = this.projectDependencies.addAll(newProjectDependencies);
        for (AcceleoProject projectDependency : newProjectDependencies) {
            if (projectDependency.getDependentProjects().contains(this)) continue;
            projectDependency.addDependentProjects(Sets.newHashSet((Object[])new AcceleoProject[]{this}));
        }
        return result;
    }

    public Set<AcceleoProject> getProjectDependencies() {
        return Collections.unmodifiableSet(this.projectDependencies);
    }

    public void clearProjectDependencies() {
        this.projectDependencies.clear();
    }

    public boolean addDependentProjects(Set<AcceleoProject> newDependentProjects) {
        boolean result = this.dependentProjects.addAll(newDependentProjects);
        for (AcceleoProject dependentProject : newDependentProjects) {
            if (dependentProject.getProjectDependencies().contains(this)) continue;
            dependentProject.addProjectDependencies(Sets.newHashSet((Object[])new AcceleoProject[]{this}));
        }
        return result;
    }

    public Set<AcceleoProject> getDependentProjects() {
        return Collections.unmodifiableSet(this.dependentProjects);
    }

    public void clearDependentProjects() {
        this.dependentProjects.clear();
    }

    public String getPackageName(File file) {
        for (AcceleoProjectClasspathEntry entry : this.entries) {
            String slash;
            File inputDirectory = entry.getInputDirectory();
            if (!file.getAbsolutePath().startsWith(inputDirectory.getAbsolutePath())) continue;
            String path = file.getAbsolutePath().substring(inputDirectory.getAbsolutePath().length());
            String packageName = path;
            if (packageName.endsWith(file.getName())) {
                packageName = packageName.substring(0, packageName.length() - file.getName().length());
            }
            if ((packageName = packageName.replace("\\", slash = "/")).startsWith(slash)) {
                packageName = packageName.substring(1);
            }
            if (packageName.endsWith(slash)) {
                packageName = packageName.substring(0, packageName.length() - 1);
            }
            return packageName;
        }
        return "";
    }

    public boolean isInProject(File file) {
        return this.getAllAcceleoModules().contains(file);
    }

    public File getOutputFile(File inputFile) {
        for (AcceleoProjectClasspathEntry entry : this.entries) {
            File inputDirectory = entry.getInputDirectory();
            if (!inputFile.getAbsolutePath().startsWith(inputDirectory.getAbsolutePath())) continue;
            String path = inputFile.getAbsolutePath().substring(inputDirectory.getAbsolutePath().length());
            File outputDirectory = entry.getOutputDirectory();
            if (path.endsWith("mtl")) {
                path = path.substring(0, path.length() - "mtl".length());
                path = String.valueOf(path) + "emtl";
            }
            File outputFile = new File(outputDirectory, path);
            return outputFile;
        }
        return null;
    }

    public File getInputFile(File outputFile) {
        for (AcceleoProjectClasspathEntry entry : this.entries) {
            File outputDirectory = entry.getOutputDirectory();
            if (!outputFile.getAbsolutePath().startsWith(outputDirectory.getAbsolutePath())) continue;
            String path = outputFile.getAbsolutePath().substring(outputDirectory.getAbsolutePath().length());
            File inputDirectory = entry.getInputDirectory();
            if (path.endsWith("emtl")) {
                path = path.substring(0, path.length() - "emtl".length());
                path = String.valueOf(path) + "mtl";
            }
            File inputFile = new File(inputDirectory, path);
            return inputFile;
        }
        return null;
    }

    public Set<File> getAllAcceleoModules() {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        boolean shouldUpdate = this.acceleoModulesCache.isEmpty();
        if (shouldUpdate) {
            for (AcceleoProjectClasspathEntry entry : this.entries) {
                File inputDirectory = entry.getInputDirectory();
                result.addAll(AcceleoProject.getChildren(inputDirectory, "mtl"));
            }
            this.acceleoModulesCache.clear();
            this.acceleoModulesCache.addAll(result);
        } else {
            result.addAll(this.acceleoModulesCache);
        }
        return result;
    }

    public Set<File> getAllCompiledAcceleoModules() {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        for (AcceleoProjectClasspathEntry entry : this.entries) {
            File outputDirectory = entry.getOutputDirectory();
            result.addAll(AcceleoProject.getChildren(outputDirectory, "emtl"));
        }
        return result;
    }

    public static Set<File> getChildren(File directory, String extension) {
        LinkedHashSet<File> result = new LinkedHashSet<File>();
        File[] files = directory.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File subfile = fileArray[n2];
                if (subfile.isFile() && subfile.getName().endsWith("." + extension)) {
                    result.add(subfile);
                } else if (subfile.isDirectory()) {
                    result.addAll(AcceleoProject.getChildren(subfile, extension));
                }
                ++n2;
            }
        }
        return result;
    }

    public File getFileFromModuleName(String moduleName) {
        File file = null;
        for (AcceleoProjectClasspathEntry entry : this.entries) {
            File inputDirectory = entry.getInputDirectory();
            Set<File> children = AcceleoProject.getChildren(inputDirectory, "mtl");
            for (File child : children) {
                if (!moduleName.equals(this.getModuleQualifiedName(child))) continue;
                file = child;
                return file;
            }
        }
        return file;
    }

    public String getModuleQualifiedName(File file) {
        String packageName = this.getPackageName(file);
        packageName = packageName.replace("/", "::");
        String fileName = file.getName();
        if (fileName.endsWith(".mtl")) {
            fileName = fileName.substring(0, fileName.length() - ".mtl".length());
        }
        packageName = String.valueOf(packageName) + "::" + fileName;
        return packageName;
    }

    public Set<File> getFileNotCompiled() {
        LinkedHashSet<File> notCompiled = new LinkedHashSet<File>();
        Set<File> allAcceleoModules = this.getAllAcceleoModules();
        Set<File> allCompiledAcceleoModules = this.getAllCompiledAcceleoModules();
        for (File file : allAcceleoModules) {
            File outputFile = this.getOutputFile(file);
            if (allCompiledAcceleoModules.contains(outputFile)) continue;
            notCompiled.add(file);
        }
        return notCompiled;
    }

    public void clean() {
        Set<File> allCompiledAcceleoModules = this.getAllCompiledAcceleoModules();
        for (File compiledModules : allCompiledAcceleoModules) {
            compiledModules.delete();
        }
    }

    public File getProjectRoot() {
        return this.projectRoot;
    }

    Set<AcceleoProjectClasspathEntry> getEntries() {
        return Collections.unmodifiableSet(this.entries);
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof AcceleoProject) {
            AcceleoProject project = (AcceleoProject)arg0;
            return project.getProjectRoot().equals(this.projectRoot);
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return this.projectRoot.hashCode();
    }

    public String toString() {
        return "AP/" + this.projectRoot.getName();
    }
}

