/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.ui.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.AcceleoPackage;
import org.eclipse.acceleo.aql.ide.ui.Activator;
import org.eclipse.acceleo.aql.ide.ui.message.AcceleoUIMessages;
import org.eclipse.acceleo.aql.ide.ui.wizard.ModuleConfiguration;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ide.ui.dialog.AQLTypeSelectionDialog;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.presentation.EcoreActionBarContributor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;

public class ModulePage
extends WizardPage {
    public static final String MODULE_NAME = "generate";
    public static final String MODULE_ELEMENT_NAME = "generateElement";
    private Text moduleContainer;
    private Button moduleContainerBrowseButton;
    private Text moduleName;
    private Table metamodelTable;
    private Button addButton;
    private Button removeButton;
    private Text metamodelType;
    private Button metamodelTypeSelectButton;
    private Label moduleElementNameLabel;
    private Text moduleElementName;
    private Button templateModuleElementKind;
    private Button queryModuleElementKind;
    private Button generateDocumentation;
    private Button generateFile;
    private Button isMain;
    private Button initializeContent;
    private Label initializeContentFileLabel;
    private Text initializeContentFile;
    private Button initializeContentBrowseButton;
    private String initialContainer;
    private final ModuleConfiguration moduleConfiguration = new ModuleConfiguration();

    protected ModulePage(String initialContainer) {
        super("New Acceleo Module File");
        this.initialContainer = initialContainer;
    }

    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void createControl(Composite parent) {
        Composite pageGroup = new Composite(parent, 0);
        GridLayout pageGroupLayout = new GridLayout();
        pageGroupLayout.numColumns = 4;
        pageGroup.setLayout((Layout)pageGroupLayout);
        pageGroup.setLayoutData((Object)new GridData(1808));
        this.createModuleGroup(pageGroup);
        this.createSeparator(pageGroup);
        this.createModuleElementGroup(pageGroup);
        this.createSeparator(pageGroup);
        this.createInitializeGroup(pageGroup);
        this.setControl((Control)pageGroup);
        this.updateModuleContiguration();
    }

    private void createSeparator(Composite pageGroup) {
        Label label = new Label(pageGroup, 258);
        GridData gd = new GridData(768);
        int eight = 8;
        gd.minimumHeight = 8;
        gd.heightHint = 8;
        gd.horizontalSpan = 4;
        label.setLayoutData((Object)gd);
    }

    private void createModuleGroup(Composite pageGroup) {
        Label label = new Label(pageGroup, 0);
        label.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleContainer") + ":");
        this.moduleContainer = new Text(pageGroup, 2052);
        if (this.initialContainer != null && !"".equals(this.initialContainer)) {
            this.moduleContainer.setText(this.initialContainer);
        }
        GridData gd = new GridData(768);
        this.moduleContainer.setLayoutData((Object)gd);
        this.moduleContainer.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.moduleContainerBrowseButton = new Button(pageGroup, 8);
        this.moduleContainerBrowseButton.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.Browse"));
        this.moduleContainerBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.handleBrowseWorkspace();
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleContainerHelp"));
        GridData gridData = new GridData(768);
        Label moduleNameLabel = new Label(pageGroup, 0);
        moduleNameLabel.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleName") + ":");
        this.moduleName = new Text(pageGroup, 2052);
        this.moduleName.setText(MODULE_NAME);
        gridData = new GridData(768);
        int widthHint = 270;
        gridData.widthHint = 270;
        gridData.horizontalSpan = 2;
        this.moduleName.setLayoutData((Object)gridData);
        this.moduleName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleNameHelp"));
        Label metamodelLabel = new Label(pageGroup, 0);
        metamodelLabel.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.MetamodelURIs") + ":");
        gridData = new GridData(2);
        gridData.horizontalSpan = 1;
        metamodelLabel.setLayoutData((Object)gridData);
        this.metamodelTable = new Table(pageGroup, 2048);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 100;
        gridData.minimumHeight = 100;
        this.metamodelTable.setLayoutData((Object)gridData);
        Composite tableButtonComposite = new Composite(pageGroup, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        tableButtonComposite.setLayoutData((Object)new GridData(1040));
        tableButtonComposite.setLayout((Layout)layout);
        this.addButton = new Button(tableButtonComposite, 8);
        Image addImage = Activator.getDefault().getImageRegistry().get("add");
        this.addButton.setImage(addImage);
        this.addButton.setToolTipText(AcceleoUIMessages.getString("AcceleoModuleComposite.AddButton"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.handleSelectMetamodelURI();
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.removeButton = new Button(tableButtonComposite, 8);
        Image removeImage = Activator.getDefault().getImageRegistry().get("delete");
        this.removeButton.setImage(removeImage);
        this.removeButton.setToolTipText(AcceleoUIMessages.getString("AcceleoModuleComposite.RemoveButton"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] selectionIndices;
                int[] nArray = selectionIndices = ModulePage.this.metamodelTable.getSelectionIndices();
                int n = selectionIndices.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    ModulePage.this.metamodelTable.remove(i);
                    ++n2;
                }
                ModulePage.this.metamodelTypeSelectButton.setEnabled(ModulePage.this.metamodelTable.getItemCount() != 0);
                ArrayList<String> metamodelURIs = new ArrayList<String>();
                TableItem[] tableItemArray = ModulePage.this.metamodelTable.getItems();
                int n3 = tableItemArray.length;
                n = 0;
                while (n < n3) {
                    TableItem tableItem = tableItemArray[n];
                    metamodelURIs.add(tableItem.getText());
                    ++n;
                }
                if (!AQLUtils.computeAvailableTypes(metamodelURIs, (boolean)true, (boolean)true, (boolean)true).contains(ModulePage.this.metamodelType.getText())) {
                    ModulePage.this.metamodelType.setText("");
                }
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.createHelpButton(tableButtonComposite, AcceleoUIMessages.getString("AcceleoModuleComposite.MetamodelURIsHelp"));
    }

    private void createModuleElementGroup(Composite pageGroup) {
        GridData gridData = new GridData(768);
        this.moduleElementNameLabel = new Label(pageGroup, 0);
        this.moduleElementNameLabel.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementNameTemplate") + ":");
        this.moduleElementName = new Text(pageGroup, 2052);
        this.moduleElementName.setText(MODULE_ELEMENT_NAME);
        gridData = new GridData(768);
        int widthHint = 270;
        gridData.widthHint = 270;
        gridData.horizontalSpan = 2;
        this.moduleElementName.setLayoutData((Object)gridData);
        this.moduleElementName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementNameHelp"));
        Label typeLabel = new Label(pageGroup, 0);
        typeLabel.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementType") + ":");
        this.metamodelType = new Text(pageGroup, 8);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        this.metamodelType.setLayoutData((Object)gridData);
        this.metamodelTable.setToolTipText(AcceleoUIMessages.getString("AcceleoModuleComposite.Type"));
        this.metamodelTypeSelectButton = new Button(pageGroup, 8);
        this.metamodelTypeSelectButton.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.Select"));
        this.metamodelTypeSelectButton.setEnabled(this.metamodelTable.getItemCount() != 0);
        this.metamodelTypeSelectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ArrayList<String> metamodelURIs = new ArrayList<String>();
                TableItem[] tableItemArray = ModulePage.this.metamodelTable.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    metamodelURIs.add(tableItem.getText());
                    ++n2;
                }
                AQLTypeSelectionDialog dialog = new AQLTypeSelectionDialog(ModulePage.this.getShell(), "parameter", ModulePage.this.metamodelType.getText(), metamodelURIs, true, true, true);
                int dialogResult = dialog.open();
                if (dialogResult == 0) {
                    ModulePage.this.metamodelType.setText(dialog.getSelectedType());
                    ModulePage.this.updateModuleContiguration();
                }
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementTypeHelp"));
        this.templateModuleElementKind = new Button(pageGroup, 16);
        this.templateModuleElementKind.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementKindTemplate"));
        this.templateModuleElementKind.setSelection(true);
        this.templateModuleElementKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.switchModuleElementKind();
                ModulePage.this.updateModuleContiguration();
                ModulePage.this.updateModuleContainer();
            }
        });
        this.queryModuleElementKind = new Button(pageGroup, 16);
        this.queryModuleElementKind.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementKindQuery"));
        this.queryModuleElementKind.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.switchModuleElementKind();
                ModulePage.this.updateModuleContiguration();
                ModulePage.this.updateModuleContainer();
            }
        });
        new Label(pageGroup, 0);
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementKindHelp"));
        this.generateDocumentation = new Button(pageGroup, 32);
        this.generateDocumentation.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleGenerateDocumentation"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.generateDocumentation.setLayoutData((Object)gridData);
        this.generateDocumentation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleGenerateDocumentationHelp"));
        this.generateFile = new Button(pageGroup, 32);
        this.generateFile.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.TemplateGenerateFile"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.generateFile.setLayoutData((Object)gridData);
        this.generateFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.updateModuleContiguration();
                ModulePage.this.updateModuleContainer();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.TemplateGenerateFileHelp"));
        this.isMain = new Button(pageGroup, 32);
        this.isMain.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.TemplateMain"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.isMain.setLayoutData((Object)gridData);
        this.isMain.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.updateModuleContiguration();
                ModulePage.this.updateModuleContainer();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.TemplateMainHelp"));
    }

    private void createInitializeGroup(Composite pageGroup) {
        this.initializeContent = new Button(pageGroup, 32);
        this.initializeContent.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeContent"));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        this.initializeContent.setLayoutData((Object)gridData);
        this.initializeContent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.switchInitializeContent();
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeContentHelp"));
        this.initializeContentFileLabel = new Label(pageGroup, 0);
        gridData = new GridData(128);
        this.initializeContentFileLabel.setLayoutData((Object)gridData);
        this.initializeContentFileLabel.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeFile"));
        this.initializeContentFileLabel.setEnabled(false);
        this.initializeContentFile = new Text(pageGroup, 2048);
        gridData = new GridData(768);
        this.initializeContentFile.setLayoutData((Object)gridData);
        this.initializeContentFile.setEnabled(false);
        this.initializeContentFile.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.initializeContentFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModulePage.this.updateModuleContiguration();
            }
        });
        this.initializeContentBrowseButton = new Button(pageGroup, 8);
        this.initializeContentBrowseButton.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.Browse"));
        this.initializeContentBrowseButton.setEnabled(false);
        this.initializeContentBrowseButton.addSelectionListener((SelectionListener)new ExampleBrowseSelectionAdapter());
        this.createHelpButton(pageGroup, AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementInitializeFileHelp"));
    }

    private void handleBrowseWorkspace() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, AcceleoUIMessages.getString("AcceleoModuleComposite.ContainerSelection"));
        IResource current = null;
        Path path = new Path(this.moduleContainer.getText());
        while (current == null && path.segmentCount() > 0) {
            current = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (current != null) continue;
            path = path.removeLastSegments(1);
        }
        if (current != null) {
            dialog.setInitialSelections(new Object[]{current});
        }
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.moduleContainer.setText(((Path)result[0]).toString());
        }
    }

    private void createHelpButton(Composite parent, String helpMessage) {
        Image image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_LCL_LINKTO_HELP");
        ToolBar result = new ToolBar(parent, 0x880000);
        result.setLayoutData((Object)new GridData(64));
        ToolItem item = new ToolItem(result, 0);
        item.setImage(image);
        if (helpMessage != null && !"".equals(helpMessage)) {
            item.setToolTipText(helpMessage);
        }
    }

    private void updateModuleContiguration() {
        this.moduleConfiguration.setModuleName(this.moduleName.getText());
        Path path = new Path(this.moduleContainer.getText());
        String projectName = path.segment(0);
        this.moduleConfiguration.setProjectName(projectName);
        this.moduleConfiguration.setParentFolder(this.moduleContainer.getText());
        Set<String> metamodelURIs = this.moduleConfiguration.getNsURIs();
        metamodelURIs.clear();
        TableItem[] tableItemArray = this.metamodelTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem tableItem = tableItemArray[n2];
            metamodelURIs.add(tableItem.getText());
            ++n2;
        }
        this.moduleConfiguration.setModuleElementName(this.moduleElementName.getText());
        this.moduleConfiguration.setModuleElementParameterType(this.metamodelType.getText());
        boolean isTemplate = this.templateModuleElementKind.getSelection();
        boolean isQuery = this.queryModuleElementKind.getSelection();
        if (isTemplate && !isQuery) {
            this.moduleConfiguration.setModuleElementEClass(AcceleoPackage.eINSTANCE.getTemplate());
        } else if (isQuery && !isTemplate) {
            this.moduleConfiguration.setModuleElementEClass(AcceleoPackage.eINSTANCE.getQuery());
            this.moduleConfiguration.setMainTemplate(false);
            this.moduleConfiguration.setGenerateFile(false);
        }
        if (isTemplate) {
            boolean hasMain = this.isMain.getSelection();
            this.moduleConfiguration.setMainTemplate(hasMain);
            boolean generatesFile = this.generateFile.getSelection();
            this.moduleConfiguration.setGenerateFile(generatesFile);
        }
        boolean hasDocumentation = this.generateDocumentation.getSelection();
        this.moduleConfiguration.setGenerateDocumentation(hasDocumentation);
        boolean isInitialized = this.initializeContent.getSelection();
        this.moduleConfiguration.setIsInitialized(isInitialized);
        this.moduleConfiguration.setInitializationPath(this.initializeContentFile.getText());
        this.checkErrors();
    }

    private void checkErrors() {
        Status status = new Status(0, "org.eclipse.acceleo.aql.ide.ui", null);
        if (this.moduleConfiguration.getModuleName() == null || "".equals(this.moduleConfiguration.getModuleName())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidName");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.moduleConfiguration.getParentFolder() == null || "".equals(this.moduleConfiguration.getParentFolder())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidParentFolder");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.moduleConfiguration.getNsURIs() == null || this.moduleConfiguration.getNsURIs().size() == 0) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.EmptyMetamodelURIs");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.moduleConfiguration.getModuleElementName() == null || "".equals(this.moduleConfiguration.getModuleElementName())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidModuleElementName");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.moduleConfiguration.getModuleElementParameterType() == null || "".equals(this.moduleConfiguration.getModuleElementParameterType())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidModuleElementParameterType");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.templateModuleElementKind.getSelection() && this.moduleConfiguration.isIsInitialized() && (this.moduleConfiguration.getInitializationPath() == null || "".equals(this.moduleConfiguration.getInitializationPath()))) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.EmptyModuleElementInitializationPath");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.templateModuleElementKind.getSelection() && this.moduleConfiguration.isIsInitialized() && !this.fileExists(this.moduleConfiguration.getInitializationPath())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.InvalidModuleElementInitializationPath");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        } else if (this.moduleExists(this.moduleConfiguration.getProjectName(), this.moduleConfiguration.getParentFolder(), this.moduleConfiguration.getModuleName())) {
            String message = AcceleoUIMessages.getString("AcceleoModuleCompositeMessage.FileAlreadyExists");
            status = new Status(4, "org.eclipse.acceleo.aql.ide.ui", message);
        }
        this.setMessage(MODULE_ELEMENT_NAME, 3);
        this.applyToStatusLine((IStatus)status);
    }

    public void applyToStatusLine(IStatus status) {
        String message = status.getMessage();
        if (message != null && message.length() == 0) {
            message = null;
        }
        switch (status.getSeverity()) {
            case 0: {
                this.setMessage(message, 0);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            case 2: {
                this.setMessage(message, 2);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            case 1: {
                this.setMessage(message, 1);
                this.setErrorMessage(null);
                this.setPageComplete(true);
                break;
            }
            default: {
                this.setMessage(null);
                this.setErrorMessage(message);
                this.setPageComplete(false);
            }
        }
    }

    private void switchInitializeContent() {
        if (this.initializeContent.getSelection()) {
            this.initializeContentFileLabel.setEnabled(true);
            this.initializeContentFile.setEnabled(true);
            this.initializeContentBrowseButton.setEnabled(true);
        } else {
            this.initializeContentFileLabel.setEnabled(false);
            this.initializeContentFile.setEnabled(false);
            this.initializeContentBrowseButton.setEnabled(false);
        }
    }

    private void updateModuleContainer() {
        String common = "/common";
        String main = "/main";
        String files = "/files";
        String requests = "/requests";
        String basicContainer = this.initialContainer;
        if (basicContainer != null && basicContainer.endsWith("/common")) {
            basicContainer = basicContainer.substring(0, basicContainer.length() - "/common".length());
        } else if (basicContainer != null && basicContainer.endsWith("/main")) {
            basicContainer = basicContainer.substring(0, basicContainer.length() - "/main".length());
        } else if (basicContainer != null && basicContainer.endsWith("/files")) {
            basicContainer = basicContainer.substring(0, basicContainer.length() - "/files".length());
        } else if (basicContainer != null && basicContainer.endsWith("/requests")) {
            basicContainer = basicContainer.substring(0, basicContainer.length() - "/requests".length());
        }
        boolean canUpdate = false;
        if (basicContainer != null && this.moduleContainer.getText() != null) {
            String currentContainer = this.moduleContainer.getText();
            canUpdate = canUpdate || currentContainer.equals(basicContainer + "/common");
            canUpdate = canUpdate || currentContainer.equals(basicContainer + "/main");
            canUpdate = canUpdate || currentContainer.equals(basicContainer + "/files");
            boolean bl = canUpdate = canUpdate || currentContainer.equals(basicContainer + "/requests");
        }
        if (canUpdate) {
            boolean isTemplate = this.templateModuleElementKind.getSelection();
            boolean isQuery = this.queryModuleElementKind.getSelection();
            if (isTemplate && !isQuery) {
                boolean hasMain = this.isMain.getSelection();
                boolean generatesFile = this.generateFile.getSelection();
                if (generatesFile && !hasMain) {
                    this.moduleContainer.setText(basicContainer + "/files");
                } else if (hasMain) {
                    this.moduleContainer.setText(basicContainer + "/main");
                } else {
                    this.moduleContainer.setText(basicContainer + "/common");
                }
            } else if (isQuery && !isTemplate && this.moduleContainer.getText() != null && !this.moduleContainer.getText().endsWith("/common") && !this.moduleContainer.getText().endsWith("/requests")) {
                this.moduleContainer.setText(basicContainer + "/requests");
            }
        }
    }

    private void switchModuleElementKind() {
        if (this.templateModuleElementKind.getSelection()) {
            this.generateFile.setEnabled(true);
            this.isMain.setEnabled(true);
            this.initializeContent.setEnabled(true);
            this.initializeContentFile.setEnabled(true);
            this.initializeContentBrowseButton.setEnabled(true);
            this.moduleElementNameLabel.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementNameTemplate") + ":");
        } else {
            this.generateFile.setEnabled(false);
            this.isMain.setEnabled(false);
            this.initializeContent.setEnabled(false);
            this.initializeContentFile.setEnabled(false);
            this.initializeContentBrowseButton.setEnabled(false);
            this.moduleElementNameLabel.setText(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementNameQuery") + ":");
        }
    }

    private void handleSelectMetamodelURI() {
        EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog registeredPackageDialog = new EcoreActionBarContributor.ExtendedLoadResourceAction.RegisteredPackageDialog(this.getShell());
        registeredPackageDialog.open();
        Object[] result = registeredPackageDialog.getResult();
        if (result != null) {
            List<Object> nsURIs = Arrays.asList(result);
            LinkedHashSet<String> uriSet = new LinkedHashSet<String>();
            if (registeredPackageDialog.isDevelopmentTimeVersion()) {
                StringBuffer uris = new StringBuffer();
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.setPackageRegistry(EPackage.Registry.INSTANCE);
                    resourceSet.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)true));
                    Map ePackageNsURItoGenModelLocationMap = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
                    int i = 0;
                    while (i < result.length) {
                        Iterator location = (URI)ePackageNsURItoGenModelLocationMap.get(result[i]);
                        Resource resource = resourceSet.getResource((URI)location, true);
                        EcoreUtil.resolveAll((Resource)resource);
                        ++i;
                    }
                    block3: for (Resource resource : resourceSet.getResources()) {
                        for (EPackage ePackage : this.getAllPackages(resource)) {
                            if (!nsURIs.contains(ePackage.getNsURI())) continue;
                            uriSet.add(ePackage.getNsURI());
                            uris.append(ePackage.getNsURI());
                            uris.append(',');
                            continue block3;
                        }
                    }
                }
                catch (WrappedException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(3, ((Object)((Object)this)).getClass(), e.getMessage(), (Throwable)e));
                }
            } else {
                int i = 0;
                while (i < result.length) {
                    uriSet.add(result[i].toString());
                    ++i;
                }
            }
            for (String uri : uriSet) {
                TableItem[] items;
                boolean exists = false;
                TableItem[] tableItemArray = items = this.metamodelTable.getItems();
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem tableItem = tableItemArray[n2];
                    if (tableItem.getText().equals(uri)) {
                        exists = true;
                    }
                    ++n2;
                }
                if (exists) continue;
                TableItem item = new TableItem(this.metamodelTable, 0);
                item.setText(uri);
            }
        }
        this.metamodelTypeSelectButton.setEnabled(this.metamodelTable.getItemCount() != 0);
    }

    private Collection<EPackage> getAllPackages(Resource resource) {
        ArrayList<EPackage> result = new ArrayList<EPackage>();
        EcoreUtil.ContentTreeIterator<Object> iterator = new EcoreUtil.ContentTreeIterator<Object>((Collection)resource.getContents()){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends EObject> getEObjectChildren(EObject eObject) {
                if (eObject instanceof EPackage) {
                    return ((EPackage)eObject).getESubpackages().iterator();
                }
                return Collections.emptyList().iterator();
            }
        };
        while (iterator.hasNext()) {
            Object content = iterator.next();
            if (!(content instanceof EPackage)) continue;
            result.add((EPackage)content);
        }
        return result;
    }

    private boolean fileExists(String path) {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        return file != null && file.exists() && file.isAccessible();
    }

    private boolean moduleExists(String projectName, String outputPath, String module) {
        Path path;
        Object container;
        boolean result = false;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project.exists() && project.isAccessible() && (container = (path = new Path(outputPath)).segmentCount() > 1 ? project.getFolder(path.removeFirstSegments(1)) : project).exists() && container.isAccessible()) {
            IFile file = container.getFile((IPath)new Path(module + ".mtl"));
            result = file.exists() && file.isAccessible();
        }
        return result;
    }

    private class ExampleBrowseSelectionAdapter
    extends SelectionAdapter {
        private ExampleBrowseSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(ModulePage.this.getShell(), false, (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
            dialog.setTitle(AcceleoUIMessages.getString("AcceleoModuleComposite.ModuleElementExample"));
            String path = ModulePage.this.initializeContentFile.getText();
            if (path != null && path.length() > 0 && new Path(path).lastSegment().length() > 0) {
                dialog.setInitialPattern("*." + new Path(path).getFileExtension());
            } else {
                dialog.setInitialPattern("*.java");
            }
            dialog.open();
            if (dialog.getResult() != null && dialog.getResult().length > 0 && dialog.getResult()[0] instanceof IFile) {
                ModulePage.this.initializeContentFile.setText(((IFile)dialog.getResult()[0]).getFullPath().toString());
            }
            ModulePage.this.updateModuleContiguration();
        }
    }
}

