/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.runtime.ICompletionProposal;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EFeatureCompletionProposal
implements ICompletionProposal {
    private final EStructuralFeature feature;

    public EFeatureCompletionProposal(EStructuralFeature feature) {
        this.feature = feature;
    }

    @Override
    public String getProposal() {
        return AstBuilder.protectWithUnderscore(this.feature.getName());
    }

    @Override
    public int getCursorOffset() {
        return this.getProposal().length();
    }

    public EStructuralFeature getObject() {
        return this.feature;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.feature.getName());
        buffer.append(": ");
        EClassifier eType = this.feature.getEType();
        buffer.append(eType.getEPackage().getName());
        buffer.append("::");
        buffer.append(this.feature.getEType().getName());
        buffer.append(" [");
        buffer.append(this.getBoundString(this.feature.getLowerBound()));
        buffer.append("..");
        buffer.append(this.getBoundString(this.feature.getUpperBound()));
        buffer.append("]");
        return buffer.toString();
    }

    private String getBoundString(int bound) {
        if (-1 == bound) {
            return "*";
        }
        return String.valueOf(bound);
    }

    @Override
    public String getDescription() {
        StringBuffer result = new StringBuffer();
        result.append(this.feature.eClass().getName());
        result.append(" named ");
        result.append(this.feature.getName());
        result.append(" in ");
        result.append(this.feature.getEContainingClass().getName());
        result.append('(');
        result.append(this.feature.getEContainingClass().getEPackage().getNsURI());
        result.append(')');
        String doc = EcoreUtil.getDocumentation((EModelElement)this.feature);
        if (doc != null) {
            result.append('\n');
            result.append(doc);
        }
        return result.toString();
    }
}

