/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.migration.converters.utils;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.query.ast.AstFactory;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.util.Bag;

public final class TypeUtils {
    private TypeUtils() {
    }

    public static boolean containsOclAny(EClassifier type) {
        boolean res = type instanceof AnyType ? true : (type instanceof CollectionType ? TypeUtils.containsOclAny((EClassifier)((CollectionType)type).getElementType()) : false);
        return res;
    }

    public static TypeLiteral createTypeLiteral(EClassifier inputType) {
        CollectionTypeLiteral typeLiteral = null;
        if (inputType instanceof CollectionType) {
            typeLiteral = AstFactory.eINSTANCE.createCollectionTypeLiteral();
            Class instanceClass = ((CollectionType)inputType).getInstanceClass();
            if (instanceClass.equals(LinkedHashSet.class)) {
                instanceClass = Set.class;
            } else if (instanceClass.equals(Collection.class)) {
                instanceClass = List.class;
            } else if (instanceClass.equals(Bag.class)) {
                instanceClass = List.class;
            }
            typeLiteral.setValue(instanceClass);
            typeLiteral.setElementType(TypeUtils.createTypeLiteral((EClassifier)((CollectionType)inputType).getElementType()));
        } else if (inputType instanceof PrimitiveType) {
            typeLiteral = AstFactory.eINSTANCE.createClassTypeLiteral();
            ((ClassTypeLiteral)typeLiteral).setValue(inputType.getInstanceClass());
        } else if (inputType instanceof AnyType) {
            typeLiteral = AstFactory.eINSTANCE.createEClassifierTypeLiteral();
            ((EClassifierTypeLiteral)typeLiteral).setEPackageName("ecore");
            ((EClassifierTypeLiteral)typeLiteral).setEClassifierName(EcorePackage.eINSTANCE.getEObject().getName());
        } else {
            typeLiteral = AstFactory.eINSTANCE.createEClassifierTypeLiteral();
            ((EClassifierTypeLiteral)typeLiteral).setEPackageName(inputType.getEPackage().getName());
            ((EClassifierTypeLiteral)typeLiteral).setEClassifierName(inputType.getName());
        }
        return typeLiteral;
    }
}

