/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.theme;

import org.eclipse.jdt.annotation.Nullable;

public class RGB {
    public final int red;
    public final int green;
    public final int blue;

    public static @Nullable RGB fromHex(@Nullable String hex) {
        if (hex == null || hex.isBlank()) {
            return null;
        }
        int offset = hex.startsWith("#") ? 1 : 0;
        int r = Integer.parseInt(hex.substring(offset + 0, offset + 2), 16);
        int g = Integer.parseInt(hex.substring(offset + 2, offset + 4), 16);
        int b = Integer.parseInt(hex.substring(offset + 4, offset + 6), 16);
        return new RGB(r, g, b);
    }

    public RGB(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
    }

    public String toString() {
        return "RGB(" + this.red + "," + this.green + "," + this.blue + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blue;
        result = 31 * result + this.green;
        result = 31 * result + this.red;
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGB other = (RGB)obj;
        if (this.blue != other.blue) {
            return false;
        }
        if (this.green != other.green) {
            return false;
        }
        return this.red == other.red;
    }
}

