/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.List;
import org.ascape.model.space.Array2D;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.Geometry;
import org.ascape.model.space.Node;

public class Array2DEuclidian
extends Array2D {
    private static final long serialVersionUID = 1L;

    public Array2DEuclidian() {
        this.setGeometry(new Geometry(2, false, -2));
    }

    public Array2DEuclidian(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    @Override
    public List calculateNeighbors(Node cell) {
        return this.findWithinMoore(cell.getCoordinate(), false, 1.0);
    }

    @Override
    public List findWithinImpl(Coordinate origin, boolean includeSelf, double distance) {
        return this.findWithinEuclidian(origin, includeSelf, distance);
    }

    @Override
    public double calculateDistance(Coordinate origin, Coordinate target) {
        return (int)Math.round(Math.sqrt(Math.pow(this.getXSpan(origin, target), 2.0) + Math.pow(this.getYSpan(origin, target), 2.0)));
    }
}

