/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.tests;

import java.io.File;
import junit.framework.TestCase;
import org.metaabm.xsd.MetaABMPersist;

public class PathFixTest
extends TestCase {
    protected static String p = File.pathSeparator;
    protected static String s = File.separator;

    public PathFixTest(String name) {
        super(name);
    }

    public void testPathPlatform() {
        String r = System.getProperty("user.dir");
        String os = System.getProperty("os.name");
        String prefix = "";
        if (os.contains("Windows") || os.contains("windows")) {
            prefix = "C:";
        }
        this.checkPathPlatform("\\Users\\test", String.valueOf(prefix) + s + "Users" + s + "test");
        this.checkPathPlatform("/Users/test", String.valueOf(prefix) + s + "Users" + s + "test");
        this.checkPathPlatform("/Users/../Users/test", String.valueOf(prefix) + s + "Users" + s + "test");
        this.checkPathPlatform("\\Users\\test;\\Users\\test2", String.valueOf(prefix) + s + "Users" + s + "test" + p + prefix + s + "Users" + s + "test2");
        this.checkPathPlatform("/Users/test;/Users/test2", String.valueOf(prefix) + s + "Users" + s + "test" + p + prefix + s + "Users" + s + "test2");
        this.checkPathPlatform("Users\\test", String.valueOf(r) + s + "Users" + s + "test");
        this.checkPathPlatform("Users/test", String.valueOf(r) + s + "Users" + s + "test");
        this.checkPathPlatform("Users/../Users/test", String.valueOf(r) + s + "Users" + s + "test");
        this.checkPathPlatform("Users\\test;\\Users\\test2", String.valueOf(r) + s + "Users" + s + "test" + p + prefix + s + "Users" + s + "test2");
        this.checkPathPlatform("Users/test;Users/test2", String.valueOf(r) + s + "Users" + s + "test" + p + r + s + "Users" + s + "test2");
    }

    protected void checkPathPlatform(String input, String expected) {
        String result = MetaABMPersist.platformPath((String)input);
        PathFixTest.assertEquals((String)expected, (String)result);
    }
}

