/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.ascape.view;

import java.util.TooManyListenersException;
import org.ascape.model.event.DefaultScapeListener;
import org.ascape.model.event.ScapeEvent;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.ide.AXFWorkbenchPlugin;
import org.eclipse.amp.axf.view.ModelInput;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class ModelScapeView
extends DefaultScapeListener
implements IAdaptable {
    private static final long serialVersionUID = -2831280332433751678L;
    private String name;
    private String primaryID;
    private String secondaryID;
    private IModel model;

    public ModelScapeView(String primaryID, String secondaryID, String name) {
        this.primaryID = primaryID;
        this.secondaryID = secondaryID;
        this.name = name;
        if (name == null) {
            this.name = String.valueOf(primaryID) + (secondaryID != null ? ":" + secondaryID : "");
        }
    }

    public ModelScapeView(String primaryID) {
        this(primaryID, null, null);
    }

    public Object getAdapter(Class key) {
        if (key == IModel.class) {
            IObservationProvider model = (IObservationProvider)AXFWorkbenchPlugin.getDefault().getManager().getAdapter((Object)this.getScape().getRoot(), IModel.class);
            return model;
        }
        return null;
    }

    public ModelInput createInput() {
        return new ModelInput(this.getModel(), (ISelection)new StructuredSelection((Object)this.getScape()));
    }

    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        super.scapeAdded(scapeEvent);
        this.model = (IModel)AXFWorkbenchPlugin.getDefault().getManager().getAdapter((Object)this.getScape().getRoot(), IModel.class);
        AXFWorkbenchPlugin.getDefault().getManager().createViewPart(this.primaryID, this.createInput(), this.name);
    }

    public IModel getModel() {
        return this.model;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return String.valueOf(this.getName()) + " View";
    }
}

