/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.camera;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.camera.ICameraListener;

public abstract class AbstractCamera
implements ICamera {
    private final List<ICameraListener> m_listeners = new LinkedList<ICameraListener>();

    public void addCameraListener(ICameraListener i_listener) {
        if (!this.m_listeners.contains(i_listener)) {
            this.m_listeners.add(i_listener);
        }
    }

    protected void fireCameraChanged() {
        for (ICameraListener listener : this.m_listeners) {
            listener.cameraChanged();
        }
    }

    public void removeCameraListener(ICameraListener i_listener) {
        if (this.m_listeners.contains(i_listener)) {
            this.m_listeners.remove(i_listener);
        }
    }

    public void transferListeners(ICamera i_newCamera) {
        Iterator<ICameraListener> i = this.m_listeners.iterator();
        while (i.hasNext()) {
            ICameraListener listener = i.next();
            i.remove();
            i_newCamera.addCameraListener(listener);
        }
    }
}

