/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.internal.datafeed;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.chart.datafeed.IResultSetDataSet;
import org.eclipse.birt.chart.internal.datafeed.ResultSetWrapper;

public class ResultSetDataSet
implements IResultSetDataSet {
    protected final int[] iaColumnIndexes;
    protected final long lStartRow;
    protected final long lEndRow;
    protected final Iterator it;
    protected long lRow = 0L;
    protected final ResultSetWrapper rsw;
    protected final Object[] oaTuple;
    protected final int iColumnCount;
    protected final boolean listMode;
    protected final int listDataType;

    public ResultSetDataSet(ResultSetWrapper rsw, int[] iaColumnIndexes, long lStartRow, long lEndRow) {
        this.rsw = rsw;
        this.iColumnCount = iaColumnIndexes.length;
        this.iaColumnIndexes = iaColumnIndexes;
        this.lStartRow = lStartRow;
        this.lEndRow = lEndRow;
        this.oaTuple = new Object[iaColumnIndexes.length];
        this.listMode = false;
        this.listDataType = 0;
        this.it = rsw.iterator();
        if (this.lRow < lStartRow) {
            while (this.lRow < lStartRow) {
                ++this.lRow;
                this.it.next();
            }
        }
    }

    public ResultSetDataSet(List lst, int dataType) {
        this.rsw = null;
        this.iColumnCount = 1;
        this.iaColumnIndexes = new int[1];
        this.lStartRow = 0L;
        this.lEndRow = lst.size();
        this.oaTuple = new Object[this.iColumnCount];
        this.listMode = true;
        this.listDataType = dataType;
        this.it = lst.iterator();
    }

    public boolean hasNext() {
        return this.lRow < this.lEndRow;
    }

    public Object[] next() {
        ++this.lRow;
        if (this.lRow > this.lEndRow) {
            return null;
        }
        if (this.listMode) {
            this.oaTuple[0] = this.it.next();
        } else {
            Object[] oaResultSet = (Object[])this.it.next();
            int i = 0;
            while (i < this.iColumnCount) {
                if (this.iaColumnIndexes[i] != -1) {
                    this.oaTuple[i] = oaResultSet[this.iaColumnIndexes[i]];
                }
                ++i;
            }
        }
        return this.oaTuple;
    }

    public int getDataType() {
        if (this.listMode) {
            return this.listDataType;
        }
        if (this.iaColumnIndexes.length >= 1) {
            return this.rsw.getColumnDataType(this.iaColumnIndexes[0]);
        }
        return 0;
    }

    public int getDataType(int columnIndex) {
        if (this.listMode) {
            return this.listDataType;
        }
        if (columnIndex < this.iaColumnIndexes.length) {
            return this.rsw.getColumnDataType(this.iaColumnIndexes[columnIndex]);
        }
        return 0;
    }

    public int getColumnCount() {
        return this.iColumnCount;
    }

    public long getSize() {
        return this.lEndRow - this.lStartRow;
    }
}

