/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationInputFile {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationInputFile.class);
    private String modelVersion = "";
    private boolean selectedFile;
    private File file;
    private File originalFile;
    private String projectRelativePath;
    private Document document;
    private boolean zipFile;
    private boolean isVersionDifferent;

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
    }

    public boolean isSelectedFile() {
        return this.selectedFile;
    }

    public void setSelectedFile(boolean isSelectedFile) {
        this.selectedFile = isSelectedFile;
    }

    public File getFile() {
        if (this.file == null && MigrationHelper.isZipFile(this.originalFile)) {
            try {
                this.file = MigrationHelper.temporaryUnzip(this.originalFile);
            }
            catch (IOException e) {
                LOGGER.error("Failed to unzip model file {}", (Object)this.originalFile.getAbsolutePath(), (Object)e);
            }
        }
        return this.file;
    }

    public void setFile(File file, File project) {
        if (MigrationHelper.isZipFile(file)) {
            this.zipFile = true;
        } else {
            this.zipFile = false;
            this.file = file;
        }
        this.originalFile = file;
        this.projectRelativePath = project.toURI().relativize(file.toURI()).getPath();
    }

    public String getProjectRelativePath() {
        return this.projectRelativePath;
    }

    public Document getDocument() {
        if (this.document == null) {
            try {
                this.document = HelperUtil.loadFile(this.getFile().getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.error("Failed to load model file {}", (Object)this.getFile().getAbsolutePath(), (Object)e);
            }
        }
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public boolean isVersionDifferent() {
        return this.isVersionDifferent;
    }

    public void setVersionDifferent(boolean isVersionDifferent) {
        this.isVersionDifferent = isVersionDifferent;
    }

    public boolean isZipFile() {
        return this.zipFile;
    }

    public File getOriginalFile() {
        return this.originalFile;
    }

    public void dispose() {
        if (this.zipFile && this.file != null && this.file.exists()) {
            try {
                Files.delete(Paths.get(this.file.getAbsolutePath(), new String[0]));
            }
            catch (IOException e) {
                LOGGER.error("Failed to delete temporary unzipped file {}", (Object)this.file.getAbsolutePath(), (Object)e);
            }
        }
    }
}

