/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.xpath.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class XpathFragment {
    private String value;
    private List<Element> xmlElements = new ArrayList<Element>();
    private XpathFragment parentFragment;
    private boolean isVisited;

    public boolean isVisited() {
        return this.isVisited;
    }

    public void setVisited(boolean isVisited) {
        this.isVisited = isVisited;
    }

    public XpathFragment getParent() {
        return this.parentFragment;
    }

    public void setParent(XpathFragment parent) {
        this.parentFragment = parent;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public List<Element> getXmlElements() {
        return this.xmlElements;
    }

    public void addXmlElements(Element element) {
        if (this.xmlElements == null) {
            this.xmlElements = new ArrayList<Element>();
        }
        this.xmlElements.add(element);
    }

    public void addAllXmlElements(List<Element> elements) {
        if (this.xmlElements == null) {
            this.xmlElements = new ArrayList<Element>();
        }
        this.xmlElements.addAll(elements);
    }

    public void visit(Element rootElement) {
        if (!this.isVisited) {
            List<Object> parentElements = new ArrayList<Element>();
            if (this.parentFragment == null) {
                parentElements.add(rootElement);
            } else {
                if (!this.parentFragment.isVisited()) {
                    this.parentFragment.visit(rootElement);
                }
                if ((parentElements = this.parentFragment.getXmlElements()) == null || parentElements.isEmpty()) {
                    this.isVisited = true;
                    return;
                }
            }
            for (Element element : parentElements) {
                List<Element> elements = HelperUtil.getXpathResult(element, this.value, Element.class, new Namespace[0]);
                this.addAllXmlElements(elements);
            }
            this.isVisited = true;
        }
    }
}

