/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.headless.app;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.app4mc.amalthea.converters.headless.app.ModelMigrationCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMigrationStarter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMigrationStarter.class);
    protected ModelMigrationCommand command;

    protected void activate(String[] args, boolean isInteractive, boolean showConsoleLog) {
        if (args != null && args.length > 0) {
            String migrationVersion = "latest";
            boolean recursive = false;
            boolean noBackup = false;
            ArrayList<String> filenameList = new ArrayList<String>();
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.startsWith("-v") || arg.startsWith("--version")) {
                    migrationVersion = args[++i];
                } else if (arg.startsWith("-r") || arg.startsWith("--recursive")) {
                    recursive = true;
                } else if (arg.startsWith("-nb") || arg.startsWith("--nobackup")) {
                    noBackup = true;
                } else if (arg.startsWith("/?") || arg.startsWith("-h") || arg.startsWith("--help")) {
                    System.out.println();
                    System.out.println("[-v, --version <model_version>] [-r, --recursive] [-nb, --nobackup] <filename>");
                    System.out.println();
                    System.out.println("Options:");
                    System.out.println("\t-v, --version  \tThe model version to which the model should be migrated to [optional].");
                    System.out.println("\t\t\tIf not provided the latest supported version will be used.");
                    System.out.println();
                    System.out.println("\t-r, --recursive\tIf folders should be traversed recursively [optional].");
                    System.out.println("\t\t\tIf not provided only the files in the given folder will be migrated.");
                    System.out.println();
                    System.out.println("\t-nb, --nobackup\tIf backup files should be created before the migration process [optional].");
                    System.out.println("\t\t\tIf not provided a backup file will be created for every model file.");
                    System.out.println();
                    System.out.println("\t-h, --help, /?\tShow this help.");
                    System.out.println();
                    System.out.println("Parameter:");
                    System.out.println("\tfilename\tThe filename of the model file or the folder that contains model files to migrate");
                    System.exit(0);
                } else if (!arg.startsWith("-") && arg.trim().length() > 0) {
                    filenameList.add(arg);
                }
                ++i;
            }
            for (String file : filenameList) {
                this.command.convert(migrationVersion, recursive, noBackup, file);
            }
            if (showConsoleLog) {
                System.out.println();
                System.out.println("***** Press Enter to exit *****");
                try {
                    Throwable file = null;
                    Iterator iterator = null;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));){
                        reader.readLine();
                    }
                    catch (Throwable throwable) {
                        if (file == null) {
                            file = throwable;
                        } else if (file != throwable) {
                            file.addSuppressed(throwable);
                        }
                        throw file;
                    }
                }
                catch (IOException e) {
                    LOGGER.error("Error on waiting for user input", (Throwable)e);
                }
            }
        }
        if (!isInteractive) {
            System.exit(0);
        }
    }
}

