/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.views.attributes.providers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.ui.dialogs.MapRuleBuilder;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;

public class MapHandleProvider {
    private static final MapRuleHandle[] EMPTY = new MapRuleHandle[0];
    public static final int EXPRESSION_TYPE_ROW = 0;
    public static final int EXPRESSION_TYPE_DATA = 1;
    protected DesignElementHandle elementHandle;
    private int expressionType;

    public MapHandleProvider() {
        this.expressionType = 0;
    }

    public MapHandleProvider(int expressionType) {
        this.expressionType = expressionType;
    }

    public int getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(int expressionType) {
        this.expressionType = expressionType;
    }

    public DesignElementHandle getDesignElementHandle() {
        return this.elementHandle;
    }

    public String getColumnText(Object element, int columnIndex) {
        MapRuleHandle handle = (MapRuleHandle)element;
        switch (columnIndex) {
            case 0: {
                String pv = handle.getDisplay();
                return pv == null ? "" : pv;
            }
            case 1: {
                String exp = String.valueOf(this.resolveNull(handle.getTestExpression())) + " " + MapRuleBuilder.getNameForOperator(handle.getOperator());
                int vv = MapRuleBuilder.determineValueVisible(handle.getOperator());
                if (vv == 1) {
                    exp = String.valueOf(exp) + " " + this.resolveNull(handle.getValue1());
                } else if (vv == 2) {
                    exp = String.valueOf(exp) + " " + this.resolveNull(handle.getValue1()) + " , " + this.resolveNull(handle.getValue2());
                } else if (vv == 3) {
                    exp = String.valueOf(exp) + " ";
                    int count = handle.getValue1List().size();
                    int i = 0;
                    while (i < count) {
                        exp = i == 0 ? String.valueOf(exp) + handle.getValue1List().get(i).toString() : String.valueOf(exp) + "; " + handle.getValue1List().get(i).toString();
                        ++i;
                    }
                }
                return exp;
            }
        }
        return "";
    }

    private String resolveNull(String src) {
        if (src == null) {
            return "";
        }
        return src;
    }

    public boolean doSwapItem(int pos, int direction) throws PropertyValueException {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        if (direction < 0) {
            phandle.moveItem(pos, pos - 1);
        } else {
            phandle.moveItem(pos, pos + 1);
        }
        return true;
    }

    public boolean doDeleteItem(int pos) throws PropertyValueException {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        phandle.removeItem(pos);
        try {
            if (phandle.getListValue() == null || phandle.getListValue().size() == 0) {
                this.elementHandle.setProperty("mapRules", null);
            }
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        return true;
    }

    public MapRuleHandle doAddItem(MapRule rule, int pos) {
        PropertyHandle phandle = this.elementHandle.getPropertyHandle("mapRules");
        try {
            phandle.addItem((IStructure)rule);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
        StructureHandle handle = rule.getHandle((SimpleValueHandle)phandle, pos);
        return (MapRuleHandle)handle;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            inputElement = ((List)inputElement).size() > 0 ? ((List)inputElement).get(0) : null;
        }
        if (inputElement instanceof DesignElementHandle) {
            this.elementHandle = (DesignElementHandle)inputElement;
            PropertyHandle mapRules = this.elementHandle.getPropertyHandle("mapRules");
            ArrayList list = new ArrayList();
            for (Object o : mapRules) {
                list.add(o);
            }
            return list.toArray(new MapRuleHandle[0]);
        }
        return EMPTY;
    }
}

