/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pptx;

public class TreeVisitor<T> {
    public ITreeNode<T> forEach(ITreeNode<T> node, IFilter<T> filter) {
        ITreeNode<T> ret = this.visitChild(node, filter);
        if (ret != null) {
            return ret;
        }
        do {
            ITreeNode<T> next = node.getNext();
            while (next != null) {
                ret = this.visitChild(next, filter);
                if (ret != null) {
                    return ret;
                }
                next = next.getNext();
            }
        } while ((node = node.getParent()) != null);
        return null;
    }

    private ITreeNode<T> visitChild(ITreeNode<T> node, IFilter<T> filter) {
        if (node == null) {
            return null;
        }
        if (filter.matches(node.getValue())) {
            return node;
        }
        ITreeNode<T> child = node.getChild();
        while (child != null) {
            ITreeNode<T> ret = this.visitChild(child, filter);
            if (ret != null) {
                return ret;
            }
            child = child.getNext();
        }
        return null;
    }

    public static interface IFilter<T> {
        public boolean matches(T var1);

        public int getRowCount();
    }

    public static interface ITreeNode<T> {
        public T getValue();

        public ITreeNode<T> getParent();

        public ITreeNode<T> getChild();

        public ITreeNode<T> getNext();
    }
}

