/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultRow;
import org.eclipse.birt.data.engine.olap.data.api.IAggregationResultSet;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.sort.ITargetSort;
import org.eclipse.birt.data.engine.olap.data.util.CompareUtil;

class AggrResultRowComparator
implements Comparator {
    private int[] valueIndexs;
    private boolean[] sortDirections;

    public AggrResultRowComparator(IAggregationResultSet base, ITargetSort[] targetSorts) {
        int length = base.getLevelCount() + targetSorts.length;
        this.valueIndexs = new int[length];
        this.sortDirections = new boolean[length];
        List[] indicesForSort = new List[base.getLevelCount()];
        int i = 0;
        while (i < targetSorts.length) {
            DimLevel targetLevel = targetSorts[i].getTargetLevel();
            int levelIndex = base.getLevelIndex(targetLevel);
            if (indicesForSort[levelIndex] == null) {
                indicesForSort[levelIndex] = new ArrayList();
            }
            indicesForSort[levelIndex].add(~i);
            ++i;
        }
        int index = 0;
        int i2 = 0;
        while (i2 < indicesForSort.length) {
            if (indicesForSort[i2] != null) {
                for (Integer aggrIndex : indicesForSort[i2]) {
                    this.valueIndexs[index] = aggrIndex;
                    ITargetSort targetSort = targetSorts[~this.valueIndexs[index]];
                    this.sortDirections[index] = this.toSortDirection(targetSort.getSortDirection());
                    ++index;
                }
            }
            this.valueIndexs[index] = i2;
            this.sortDirections[index] = this.toSortDirection(base.getSortType(i2));
            ++index;
            ++i2;
        }
    }

    public int compare(Object arg0, Object arg1) {
        IAggregationResultRow row1 = (IAggregationResultRow)arg0;
        IAggregationResultRow row2 = (IAggregationResultRow)arg1;
        Object[] keyValues1 = new Object[this.valueIndexs.length];
        Object[] keyValues2 = new Object[this.valueIndexs.length];
        int i = 0;
        while (i < this.valueIndexs.length) {
            int index = this.valueIndexs[i];
            if (index >= 0) {
                keyValues1[i] = row1.getLevelMembers()[index].getKeyValues()[0];
                keyValues2[i] = row2.getLevelMembers()[index].getKeyValues()[0];
            } else {
                keyValues1[i] = row1.getAggregationValues()[~index];
                keyValues2[i] = row2.getAggregationValues()[~index];
            }
            ++i;
        }
        return CompareUtil.compare(keyValues1, keyValues2, this.sortDirections);
    }

    private boolean toSortDirection(int sortType) {
        return sortType != 1;
    }
}

