/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.text.edits.TextEditGroup;

public class TypeAnnotationRewrite {
    public static void removePureTypeAnnotations(ASTNode node, ChildListPropertyDescriptor childListProperty, ASTRewrite rewrite, TextEditGroup editGroup) {
        CompilationUnit root = (CompilationUnit)node.getRoot();
        if (!JavaModelUtil.is1d8OrHigher(root.getJavaElement().getJavaProject())) {
            return;
        }
        ListRewrite listRewrite = rewrite.getListRewrite(node, childListProperty);
        List children = (List)node.getStructuralProperty((StructuralPropertyDescriptor)childListProperty);
        for (ASTNode child : children) {
            Annotation annotation;
            if (!(child instanceof Annotation) || !TypeAnnotationRewrite.isPureTypeAnnotation(annotation = (Annotation)child)) continue;
            listRewrite.remove(child, editGroup);
        }
    }

    private static boolean isPureTypeAnnotation(Annotation annotation) {
        IAnnotationBinding binding = annotation.resolveAnnotationBinding();
        if (binding == null) {
            return false;
        }
        IAnnotationBinding targetAnnotationBinding = TypeAnnotationRewrite.findTargetAnnotation(binding.getAnnotationType().getAnnotations());
        if (targetAnnotationBinding == null) {
            return false;
        }
        return TypeAnnotationRewrite.isTypeUseOnly(targetAnnotationBinding);
    }

    private static IAnnotationBinding findTargetAnnotation(IAnnotationBinding[] metaAnnotations) {
        IAnnotationBinding[] iAnnotationBindingArray = metaAnnotations;
        int n = metaAnnotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding binding = iAnnotationBindingArray[n2];
            ITypeBinding annotationType = binding.getAnnotationType();
            if (annotationType != null && annotationType.getQualifiedName().equals(Target.class.getName())) {
                return binding;
            }
            ++n2;
        }
        return null;
    }

    private static boolean isTypeUseOnly(IAnnotationBinding binding) {
        boolean typeUseSeen = false;
        boolean otherSeen = false;
        IMemberValuePairBinding[] iMemberValuePairBindingArray = binding.getAllMemberValuePairs();
        int n = iMemberValuePairBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemberValuePairBinding pair = iMemberValuePairBindingArray[n2];
            if (pair.getKey() == null || "value".equals(pair.getKey())) {
                Object value = pair.getValue();
                if (value instanceof Object[]) {
                    Object[] objectArray = (Object[])value;
                    int n3 = objectArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object v = objectArray[n4];
                        if (v instanceof IVariableBinding) {
                            String name = ((IVariableBinding)v).getName();
                            if (name.equals(ElementType.TYPE_USE.name())) {
                                typeUseSeen = true;
                            } else if (!name.equals(ElementType.TYPE_PARAMETER.name())) {
                                otherSeen = true;
                            }
                        }
                        ++n4;
                    }
                } else if (value instanceof IVariableBinding) {
                    String name = ((IVariableBinding)value).getName();
                    if (name.equals(ElementType.TYPE_USE.name())) {
                        typeUseSeen = true;
                    } else if (!name.equals(ElementType.TYPE_PARAMETER.name())) {
                        otherSeen = true;
                    }
                }
            }
            ++n2;
        }
        return typeUseSeen && !otherSeen;
    }

    private TypeAnnotationRewrite() {
    }
}

