/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.logging.Logger;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.MemorySegmentIndexInput;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Unwrappable;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class MemorySegmentIndexInputProvider
implements MMapDirectory.MMapIndexInputProvider {
    public MemorySegmentIndexInputProvider() {
        Logger log = Logger.getLogger(this.getClass().getName());
        log.info("Using MemorySegmentIndexInput with Java 20; to disable start with -Dorg.apache.lucene.store.MMapDirectory.enableMemorySegments=false");
    }

    @Override
    public IndexInput openInput(Path path, IOContext context, int chunkSizePower, boolean preload) throws IOException {
        String resourceDescription = "MemorySegmentIndexInput(path=\"" + path.toString() + "\")";
        path = Unwrappable.unwrapAll(path);
        boolean success = false;
        Arena arena = Arena.openShared();
        try {
            MemorySegmentIndexInput memorySegmentIndexInput;
            block10: {
                FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);
                try {
                    long fileSize = fc.size();
                    MemorySegmentIndexInput in = MemorySegmentIndexInput.newInstance(resourceDescription, arena, this.map(arena, resourceDescription, fc, chunkSizePower, preload, fileSize), fileSize, chunkSizePower);
                    success = true;
                    memorySegmentIndexInput = in;
                    if (fc == null) break block10;
                }
                catch (Throwable throwable) {
                    if (fc != null) {
                        try {
                            fc.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fc.close();
            }
            return memorySegmentIndexInput;
        }
        finally {
            if (!success) {
                arena.close();
            }
        }
    }

    @Override
    public long getDefaultMaxChunkSize() {
        return Constants.JRE_IS_64BIT ? 0x400000000L : 0x10000000L;
    }

    @Override
    public boolean isUnmapSupported() {
        return true;
    }

    @Override
    public String getUnmapNotSupportedReason() {
        return null;
    }

    private final MemorySegment[] map(Arena arena, String resourceDescription, FileChannel fc, int chunkSizePower, boolean preload, long length) throws IOException {
        if (length >>> chunkSizePower >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big for chunk size: " + resourceDescription);
        }
        long chunkSize = 1L << chunkSizePower;
        int nrSegments = (int)(length >>> chunkSizePower) + 1;
        MemorySegment[] segments = new MemorySegment[nrSegments];
        long startOffset = 0L;
        for (int segNr = 0; segNr < nrSegments; ++segNr) {
            MemorySegment segment;
            long segSize = length > startOffset + chunkSize ? chunkSize : length - startOffset;
            try {
                segment = fc.map(FileChannel.MapMode.READ_ONLY, startOffset, segSize, arena.scope());
            }
            catch (IOException ioe) {
                throw this.convertMapFailedIOException(ioe, resourceDescription, segSize);
            }
            if (preload) {
                segment.load();
            }
            segments[segNr] = segment;
            startOffset += segSize;
        }
        return segments;
    }
}

