/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl.rank;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.RunningAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.aggregation.impl.rank.RankAggregationUtil;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

abstract class BaseTotalRank
extends AggrFunction {
    BaseTotalRank() {
    }

    public int getType() {
        return 1;
    }

    public int getDataType() {
        return 2;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("ascending", Messages.getString("TotalRank.param.ascending"), true, false, SupportedDataTypes.ANY, "")};
    }

    @Override
    public int getNumberOfPasses() {
        return 2;
    }

    static class RankObjComparator
    implements Comparator<Object> {
        public static RankObjComparator INSTANCE = new RankObjComparator();

        private RankObjComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Comparable) {
                if (o2 instanceof Comparable) {
                    Comparable obj1 = (Comparable)o1;
                    Comparable obj2 = (Comparable)o2;
                    return obj1.compareTo(obj2);
                }
                return 1;
            }
            if (o2 instanceof Comparable) {
                return -1;
            }
            return 0;
        }
    }

    static class TotalRankAccumulator
    extends RunningAccumulator {
        private Integer sum;
        private List<Object> cachedValues;
        private Map<Object, Integer> rankMap;
        private boolean asc;
        private boolean denseRank;
        private boolean hasInitialized;
        private int passCount = 0;
        private Comparator<Object> comparator;

        public TotalRankAccumulator(boolean denseRank) {
            this.denseRank = denseRank;
        }

        public void start() {
            if (this.passCount == 0) {
                this.cachedValues = new ArrayList<Object>();
                this.rankMap = new HashMap<Object, Integer>();
                this.sum = 0;
                this.asc = true;
                this.comparator = RankObjComparator.INSTANCE;
                this.hasInitialized = false;
            }
            ++this.passCount;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 0);
            if (this.passCount == 1) {
                if (args[0] != null) {
                    this.cachedValues.add(args[0]);
                } else {
                    this.cachedValues.add(RankAggregationUtil.getNullObject());
                }
                if (!this.hasInitialized && args[1] != null) {
                    this.hasInitialized = true;
                    this.asc = args[1].toString().equals("false") ? false : !(args[1] instanceof Double) || !((Double)args[1]).equals(0.0);
                    if (!this.asc) {
                        this.comparator = RankObjComparator.INSTANCE.reversed();
                    }
                }
            } else {
                Object compareValue = args[0] != null ? args[0] : RankAggregationUtil.getNullObject();
                Integer calculatedRank = this.rankMap.get(compareValue);
                this.sum = calculatedRank != null ? calculatedRank : -1;
            }
        }

        public void finish() throws DataException {
            if (this.passCount == 1) {
                Collections.sort(this.cachedValues, this.comparator);
                this.calculateRank(this.cachedValues, this.denseRank);
            }
        }

        private void calculateRank(List<Object> sortedList, boolean useDenseRank) {
            int currentRank = 1;
            int currentDenseRank = 1;
            Object currentValue = sortedList.get(0);
            int i = 0;
            while (i < sortedList.size()) {
                Object integer = sortedList.get(i);
                if (!Objects.equals(integer, currentValue)) {
                    this.rankMap.put(currentValue, useDenseRank ? currentDenseRank : currentRank);
                    currentValue = integer;
                    ++currentDenseRank;
                    currentRank = i + 1;
                }
                ++i;
            }
            this.rankMap.put(currentValue, useDenseRank ? currentDenseRank : currentRank);
        }

        public Object getValue() throws DataException {
            return this.sum;
        }
    }
}

