/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.rulers;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportColorConstants;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuideEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuideFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorGuidePlaceHolder;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.rulers.EditorRulerProvider;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.swt.graphics.Font;

public class EditorDragGuidePolicy
extends GraphicalEditPolicy {
    private static final String PIXELS_LABEL = Messages.getString((String)"EditorDragGuidePolicy.pixels.label");
    private static final DecimalFormat FORMAT = new DecimalFormat("#0.000");
    private static final int DEFAULT_VALUE = 10;
    private static final int DISTANCE = 40;
    private static final Insets INSETS = new Insets(2, 4, 2, 4);
    private List attachedEditParts = null;
    private IFigure dummyGuideFigure;
    private IFigure dummyLineFigure;
    private Label infoLabel;
    private IChoiceSet choiceSet = ChoiceSetFactory.getElementChoiceSet("ReportDesign", "units");
    private int maxWidth = -1;

    protected IFigure createDummyLineFigure() {
        return new Figure(){

            protected void paintFigure(Graphics graphics) {
                graphics.setLineStyle(3);
                graphics.setXORMode(true);
                graphics.setForegroundColor(ColorConstants.darkGray);
                if (this.bounds.width > this.bounds.height) {
                    graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.right(), this.bounds.y);
                    graphics.drawLine(this.bounds.x + 2, this.bounds.y, this.bounds.right(), this.bounds.y);
                } else {
                    graphics.drawLine(this.bounds.x, this.bounds.y, this.bounds.x, this.bounds.bottom());
                    graphics.drawLine(this.bounds.x, this.bounds.y + 2, this.bounds.x, this.bounds.bottom());
                }
            }
        };
    }

    protected Label createInfoLabel() {
        Label labelFigure = new Label();
        labelFigure.setBorder((Border)new MarginBorder(new Insets(0, 3, 0, 0)){

            public void paint(IFigure figure, Graphics graphics, Insets insets) {
                tempRect.setBounds(2.getPaintRectangle((IFigure)figure, (Insets)insets));
                if (this.getWidth() % 2 != 0) {
                    --2.tempRect.width;
                    --2.tempRect.height;
                }
                tempRect.shrink(this.getWidth() / 2, this.getWidth() / 2);
                graphics.setLineWidth(this.getWidth());
                graphics.drawRectangle(tempRect);
            }

            private int getWidth() {
                return 1;
            }
        });
        labelFigure.setLabelAlignment(1);
        labelFigure.setOpaque(true);
        labelFigure.setBackgroundColor(ReportColorConstants.TableGuideFillColor);
        return labelFigure;
    }

    protected EditorGuideFigure createDummyGuideFigure() {
        return new EditorGuidePlaceHolder(this.getGuideEditPart().isHorizontal());
    }

    public void deactivate() {
        this.removeFeedback();
        super.deactivate();
    }

    private void eraseAttachedPartsFeedback(Request request) {
        if (this.attachedEditParts != null) {
            ChangeBoundsRequest req = new ChangeBoundsRequest(request.getType());
            req.setEditParts(this.attachedEditParts);
            Iterator i = this.attachedEditParts.iterator();
            while (i.hasNext()) {
                ((EditPart)i.next()).eraseSourceFeedback((Request)req);
            }
            this.attachedEditParts = null;
        }
    }

    public void eraseSourceFeedback(Request request) {
        this.getGuideEditPart().updateLocationOfFigures(this.getGuideEditPart().getZoomedPosition());
        this.getHostFigure().setVisible(true);
        this.getGuideEditPart().getGuideLineFigure().setVisible(true);
        this.removeFeedback();
        this.getGuideEditPart().setCurrentCursor(null);
        this.eraseAttachedPartsFeedback(request);
        this.maxWidth = -1;
    }

    private List getAttachedEditParts() {
        if (this.attachedEditParts == null) {
            this.attachedEditParts = this.getGuideEditPart().getRulerProvider().getAttachedEditParts(this.getHost().getModel(), ((EditorRulerEditPart)this.getHost().getParent()).getDiagramViewer());
        }
        return this.attachedEditParts;
    }

    public Command getCommand(Request request) {
        Command cmd;
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        if (this.isDeleteRequest(req)) {
            cmd = this.getGuideEditPart().getRulerProvider().getDeleteGuideCommand(this.getHost().getModel());
        } else {
            int pDelta = this.getGuideEditPart().isHorizontal() ? req.getMoveDelta().y : req.getMoveDelta().x;
            if (this.isMoveValid(this.getGuideEditPart().getZoomedPosition() + pDelta)) {
                ZoomManager zoomManager = this.getGuideEditPart().getZoomManager();
                if (zoomManager != null) {
                    pDelta = (int)Math.round((double)pDelta / zoomManager.getZoom());
                }
                cmd = this.getGuideEditPart().getRulerProvider().getMoveGuideCommand(this.getHost().getModel(), pDelta);
            } else {
                cmd = UnexecutableCommand.INSTANCE;
            }
        }
        return cmd;
    }

    protected IFigure getDummyGuideFigure() {
        if (this.dummyGuideFigure == null) {
            this.dummyGuideFigure = this.createDummyGuideFigure();
        }
        return this.dummyGuideFigure;
    }

    protected IFigure getDummyLineFigure() {
        if (this.dummyLineFigure == null) {
            this.dummyLineFigure = this.createDummyLineFigure();
        }
        return this.dummyLineFigure;
    }

    protected IFigure getInfoLabel() {
        if (this.infoLabel == null) {
            this.infoLabel = this.createInfoLabel();
        }
        return this.infoLabel;
    }

    protected EditorGuideEditPart getGuideEditPart() {
        return (EditorGuideEditPart)this.getHost();
    }

    protected boolean isDeleteRequest(ChangeBoundsRequest req) {
        return false;
    }

    protected boolean isMoveValid(int zoomedPosition) {
        return true;
    }

    private void removeFeedback() {
        if (this.getDummyGuideFigure().getParent() != null) {
            this.getDummyGuideFigure().getParent().remove(this.getDummyGuideFigure());
        }
        if (this.getDummyLineFigure().getParent() != null) {
            this.getDummyLineFigure().getParent().remove(this.getDummyLineFigure());
        }
        if (this.getInfoLabel().getParent() != null) {
            this.getInfoLabel().getParent().remove(this.getInfoLabel());
        }
    }

    private void showAttachedPartsFeedback(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest(request.getType());
        req.setEditParts(this.getAttachedEditParts());
        if (this.getGuideEditPart().isHorizontal()) {
            req.setMoveDelta(new Point(0, request.getMoveDelta().y));
        } else {
            req.setMoveDelta(new Point(request.getMoveDelta().x, 0));
        }
        Iterator i = this.getAttachedEditParts().iterator();
        while (i.hasNext()) {
            ((EditPart)i.next()).showSourceFeedback((Request)req);
        }
    }

    public void showSourceFeedback(Request request) {
        ChangeBoundsRequest req = (ChangeBoundsRequest)request;
        this.getHostFigure().getParent().add(this.getDummyGuideFigure(), 0);
        ((GraphicalEditPart)this.getHost().getParent()).setLayoutConstraint(this.getHost(), this.getDummyGuideFigure(), (Object)this.getGuideEditPart().getZoomedPosition());
        this.getDummyGuideFigure().setBounds(this.getHostFigure().getBounds());
        this.getGuideEditPart().getGuideLayer().add(this.getDummyLineFigure(), 0);
        this.getGuideEditPart().getGuideLayer().setConstraint(this.getDummyLineFigure(), (Object)this.getGuideEditPart().isHorizontal());
        this.getDummyLineFigure().setBounds(this.getDummyLineFigureBounds(req));
        this.getGuideEditPart().getGuideLayer().add(this.getInfoLabel(), 0);
        this.updateInfomation(this.getShowLable(req));
        List children = this.getHostFigure().getParent().getChildren();
        children.remove(this.getHostFigure());
        children.add(this.getHostFigure());
        if (this.isDeleteRequest(req)) {
            this.getHostFigure().setVisible(false);
            this.getGuideEditPart().getGuideLineFigure().setVisible(false);
            this.getGuideEditPart().setCurrentCursor(SharedCursors.ARROW);
            this.eraseAttachedPartsFeedback(request);
        } else {
            int newPosition = this.getGuideEditPart().isHorizontal() ? this.getGuideEditPart().getZoomedPosition() + req.getMoveDelta().y : this.getGuideEditPart().getZoomedPosition() + req.getMoveDelta().x;
            this.getHostFigure().setVisible(true);
            this.getGuideEditPart().getGuideLineFigure().setVisible(true);
            if (this.isMoveValid(newPosition)) {
                this.getGuideEditPart().setCurrentCursor(null);
                this.getGuideEditPart().updateLocationOfFigures(newPosition);
                this.showAttachedPartsFeedback(req);
            } else {
                this.getGuideEditPart().setCurrentCursor(SharedCursors.NO);
                this.getGuideEditPart().updateLocationOfFigures(this.getGuideEditPart().getZoomedPosition());
                this.eraseAttachedPartsFeedback(request);
            }
        }
    }

    private EditorRulerEditPart getRulerEditPart() {
        return (EditorRulerEditPart)this.getHost().getParent();
    }

    private Rectangle getDummyLineFigureBounds(ChangeBoundsRequest request) {
        Rectangle bounds = new Rectangle();
        EditorRulerEditPart source = this.getRulerEditPart();
        if (source.isHorizontal()) {
            bounds.x = this.getCurrentPositionZoomed(request);
            bounds.y = source.getGuideLayer().getBounds().y;
            bounds.width = 1;
            bounds.height = source.getGuideLayer().getBounds().height;
        } else {
            bounds.x = source.getGuideLayer().getBounds().x;
            bounds.y = this.getCurrentPositionZoomed(request);
            bounds.width = source.getGuideLayer().getBounds().width;
            bounds.height = 1;
        }
        return bounds;
    }

    private int getCurrentPositionZoomed(ChangeBoundsRequest request) {
        int newPosition = this.getGuideEditPart().isHorizontal() ? this.getGuideEditPart().getZoomedPosition() + request.getMoveDelta().y : this.getGuideEditPart().getZoomedPosition() + request.getMoveDelta().x;
        return newPosition;
    }

    public boolean understandsRequest(Request req) {
        return req.getType().equals("move");
    }

    private String getShowLable(ChangeBoundsRequest req) {
        double value;
        int pDelta = this.getGuideEditPart().isHorizontal() ? req.getMoveDelta().y : req.getMoveDelta().x;
        ZoomManager zoomManager = this.getGuideEditPart().getZoomManager();
        if (zoomManager != null) {
            pDelta = (int)Math.round((double)pDelta / zoomManager.getZoom());
        }
        int marginValue = ((EditorRulerProvider)this.getGuideEditPart().getRulerProvider()).getMarginValue(this.getHost().getModel(), pDelta);
        ModuleHandle handle = SessionHandleAdapter.getInstance().getReportDesignHandle();
        String unit = handle.getDefaultUnits();
        if (unit == null) {
            unit = "in";
        }
        if ((value = MetricUtility.pixelToPixelInch((int)marginValue)) < 0.0) {
            value = 0.0;
        }
        DimensionValue dim = DimensionUtil.convertTo((double)value, (String)"in", (String)unit);
        double showValue = dim.getMeasure();
        String prefix = ((EditorRulerProvider)this.getGuideEditPart().getRulerProvider()).getPrefixLabel(this.getHost().getModel());
        return prefix + " " + this.getShowValue(showValue) + " " + this.getUnitDisplayName(unit) + " (" + marginValue + " " + PIXELS_LABEL + ")";
    }

    private String getShowValue(double value) {
        return FORMAT.format(value);
    }

    protected String getUnitDisplayName(String unit) {
        IChoice choice = this.choiceSet.findChoice(unit);
        return choice.getDisplayName();
    }

    private Dimension getDistance() {
        Point p = this.getStartLocation();
        FigureCanvas canvas = ((DeferredGraphicalViewer)((Object)this.getGuideEditPart().getViewer().getProperty(GraphicalViewer.class.toString()))).getFigureCanvas();
        org.eclipse.swt.graphics.Rectangle rect = canvas.getBounds();
        Dimension retValue = new Dimension(rect.width - p.x, p.y);
        if (canvas.getVerticalBar().isVisible()) {
            retValue.width -= canvas.getVerticalBar().getSize().x;
        }
        return retValue;
    }

    private void adjustLocation() {
        if (this.infoLabel == null) {
            return;
        }
        Rectangle rect = this.infoLabel.getBounds().getCopy();
        Dimension dim = this.getDistance();
        Point p = this.infoLabel.getLocation().getCopy();
        if (dim.width < rect.width) {
            p.x -= rect.width - dim.width;
        }
        if (dim.height < rect.height + 40) {
            p.y += rect.height + 40 - dim.height;
        }
        this.infoLabel.setLocation(p);
    }

    private void setLabelLocation() {
        if (this.infoLabel == null) {
            return;
        }
        Point p = this.getStartLocation();
        Point location = p.getCopy();
        this.infoLabel.translateToRelative((Translatable)p);
        if (this.getGuideEditPart().isHorizontal()) {
            p.y = location.y;
        } else {
            p.x = location.x;
        }
        this.infoLabel.setLocation(new Point(p.x, p.y - 40));
    }

    private Point getStartLocation() {
        if (this.getGuideEditPart().isHorizontal()) {
            return new Point(30, this.getGuideEditPart().getZoomedPosition() + 40);
        }
        return new Point(this.getGuideEditPart().getZoomedPosition(), 10);
    }

    protected void updateInfomation(String label) {
        if (this.infoLabel == null) {
            return;
        }
        this.infoLabel.setText(label);
        Dimension size = FigureUtilities.getTextExtents((String)label, (Font)this.infoLabel.getFont());
        Insets insets = INSETS;
        Dimension newSize = size.getCopy().expand(insets.getWidth(), insets.getHeight());
        if (size.width > this.maxWidth) {
            this.maxWidth = size.width;
        } else {
            newSize = new Dimension(this.maxWidth, size.height).expand(insets.getWidth(), insets.getHeight());
        }
        this.infoLabel.setSize(newSize);
        this.setLabelLocation();
        this.adjustLocation();
    }
}

