/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util;

import java.util.Hashtable;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.ServerKindsConfig;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.util.WrapperConfigFile;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.LUWDatabase;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.LUWDatabaseImpl;

public class WrapperConfigManager {
    private ServerKindsConfig skc = new ServerKindsConfig();
    private Hashtable wrapperConfigHT;
    private WrapperConfigFile wcf;
    private static LUWDatabase database;
    private static WrapperConfigManager instance;

    static {
        instance = null;
    }

    public WrapperConfigManager(LUWDatabaseImpl _database) throws Exception {
        this.skc.init(_database);
        this.wrapperConfigHT = new Hashtable();
    }

    public static synchronized WrapperConfigManager getInstance(LUWDatabaseImpl _database) throws Exception {
        try {
            if (instance == null) {
                database = _database;
                instance = new WrapperConfigManager(_database);
            } else if (!database.getName().equals(_database.getName())) {
                database = _database;
                instance = new WrapperConfigManager(_database);
            }
        }
        catch (Exception e) {
            database = null;
            throw e;
        }
        return instance;
    }

    public WrapperConfigFile getWrapperConfigFile(String libName) throws Exception {
        if (!this.wrapperConfigHT.containsKey(libName)) {
            String id = this.skc.getWrapperID(libName);
            this.wcf = new WrapperConfigFile();
            this.wcf.initFile(id, database);
            this.wrapperConfigHT.put(libName, this.wcf);
            return this.wcf;
        }
        return (WrapperConfigFile)this.wrapperConfigHT.get(libName);
    }

    public ServerKindsConfig getServerKindsConfig() {
        return this.skc;
    }
}

