/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.nls.changes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.manipulation.util.BasicElementLabels;
import org.eclipse.jdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public class CreateFileChange
extends ResourceChange {
    private String fChangeName;
    private IPath fPath;
    private String fSource;
    private String fEncoding;
    private boolean fExplicitEncoding;
    private long fStampToRestore;

    public CreateFileChange(IPath path, String source, String encoding) {
        this(path, source, encoding, -1L);
    }

    public CreateFileChange(IPath path, String source, String encoding, long stampToRestore) {
        Assert.isNotNull((Object)path, (String)"path");
        Assert.isNotNull((Object)source, (String)"source");
        this.fPath = path;
        this.fSource = source;
        this.fEncoding = encoding;
        this.fExplicitEncoding = this.fEncoding != null;
        this.fStampToRestore = stampToRestore;
    }

    protected void setEncoding(String encoding, boolean explicit) {
        Assert.isNotNull((Object)encoding, (String)"encoding");
        this.fEncoding = encoding;
        this.fExplicitEncoding = explicit;
    }

    public String getName() {
        if (this.fChangeName == null) {
            return Messages.format(NLSChangesMessages.createFile_Create_file, BasicElementLabels.getPathLabel(this.fPath, false));
        }
        return this.fChangeName;
    }

    public void setName(String name) {
        this.fChangeName = name;
    }

    protected void setSource(String source) {
        this.fSource = source;
    }

    protected String getSource() {
        return this.fSource;
    }

    protected void setPath(IPath path) {
        this.fPath = path;
    }

    public IPath getPath() {
        return this.fPath;
    }

    protected IResource getModifiedResource() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
        URI location = file.getLocationURI();
        if (location == null) {
            result.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_unknownLocation, BasicElementLabels.getPathLabel(file.getFullPath(), false)));
            return result;
        }
        IFileInfo jFile = EFS.getStore((URI)location).fetchInfo();
        if (jFile.exists()) {
            result.addFatalError(Messages.format(NLSChangesMessages.CreateFileChange_error_exists, BasicElementLabels.getPathLabel(file.getFullPath(), false)));
            return result;
        }
        return result;
    }

    public Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            DeleteResourceChange deleteResourceChange;
            block21: {
                pm.beginTask(NLSChangesMessages.createFile_creating_resource, 3);
                this.initializeEncoding();
                IFile file = this.getOldFile((IProgressMonitor)new SubProgressMonitor(pm, 1));
                Throwable throwable = null;
                Object var4_7 = null;
                ByteArrayInputStream is = new ByteArrayInputStream(this.fSource.getBytes(this.fEncoding));
                try {
                    file.create((InputStream)is, false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (this.fStampToRestore != -1L) {
                        file.revertModificationStamp(this.fStampToRestore);
                    }
                    if (this.fExplicitEncoding) {
                        file.setCharset(this.fEncoding, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    } else {
                        pm.worked(1);
                    }
                    deleteResourceChange = new DeleteResourceChange(file.getFullPath(), true);
                    if (is == null) break block21;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            try {
                                if (is != null) {
                                    ((InputStream)is).close();
                                }
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (throwable == null) {
                                    throwable = throwable3;
                                } else if (throwable != throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                throw throwable;
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new JavaModelException((Throwable)e, 985);
                        }
                    }
                    catch (IOException ioe) {
                        throw new JavaModelException((Throwable)ioe, 985);
                    }
                }
                ((InputStream)is).close();
            }
            return deleteResourceChange;
        }
        finally {
            pm.done();
        }
    }

    protected IFile getOldFile(IProgressMonitor pm) throws OperationCanceledException {
        pm.beginTask("", 1);
        try {
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            return iFile;
        }
        finally {
            pm.done();
        }
    }

    private void initializeEncoding() {
        if (this.fEncoding == null) {
            this.fExplicitEncoding = false;
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            if (file != null) {
                try {
                    if (file.exists()) {
                        this.fEncoding = file.getCharset(false);
                        if (this.fEncoding == null) {
                            this.fEncoding = file.getCharset(true);
                        } else {
                            this.fExplicitEncoding = true;
                        }
                    } else {
                        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                        if (contentType != null) {
                            this.fEncoding = contentType.getDefaultCharset();
                        }
                        if (this.fEncoding == null) {
                            this.fEncoding = file.getCharset(true);
                        }
                    }
                }
                catch (CoreException coreException) {
                    this.fEncoding = ResourcesPlugin.getEncoding();
                    this.fExplicitEncoding = true;
                }
            } else {
                this.fEncoding = ResourcesPlugin.getEncoding();
                this.fExplicitEncoding = true;
            }
        }
        Assert.isNotNull((Object)this.fEncoding);
    }
}

