/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IModuleAwareNameEnvironment;
import org.eclipse.jdt.internal.compiler.env.IModulePathEntry;
import org.eclipse.jdt.internal.compiler.env.IMultiModuleEntry;
import org.eclipse.jdt.internal.compiler.env.IUpdatableModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.AbstractModule;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CompilationGroup;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.ModuleUpdater;
import org.eclipse.jdt.internal.core.builder.AbortIncrementalBuildException;
import org.eclipse.jdt.internal.core.builder.BuildNotifier;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;
import org.eclipse.jdt.internal.core.builder.ModuleEntryProcessor;
import org.eclipse.jdt.internal.core.builder.ModulePathEntry;
import org.eclipse.jdt.internal.core.builder.SourceFile;

public class NameEnvironment
implements IModuleAwareNameEnvironment,
SuffixConstants {
    boolean isIncrementalBuild;
    ClasspathMultiDirectory[] sourceLocations;
    ClasspathLocation[] binaryLocations;
    Map<String, IModulePathEntry> modulePathEntries;
    BuildNotifier notifier;
    SimpleSet initialTypeNames;
    SimpleLookupTable additionalUnits;
    private final CompilationGroup compilationGroup;
    ModuleUpdater moduleUpdater;

    NameEnvironment(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject, BuildNotifier notifier, CompilationGroup compilationGroup) throws CoreException {
        this.compilationGroup = compilationGroup;
        this.isIncrementalBuild = false;
        this.notifier = notifier;
        this.computeClasspathLocations(root, javaProject, binaryLocationsPerProject);
        this.setNames(null, null);
    }

    public NameEnvironment(IJavaProject javaProject, CompilationGroup compilationGroup) {
        this.isIncrementalBuild = false;
        this.compilationGroup = compilationGroup;
        try {
            this.computeClasspathLocations(javaProject.getProject().getWorkspace().getRoot(), (JavaProject)javaProject, null);
        }
        catch (CoreException coreException) {
            this.sourceLocations = new ClasspathMultiDirectory[0];
            this.binaryLocations = new ClasspathLocation[0];
        }
        this.setNames(null, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void computeClasspathLocations(IWorkspaceRoot root, JavaProject javaProject, SimpleLookupTable binaryLocationsPerProject) throws CoreException {
        block62: {
            cycleMarker = javaProject.getCycleMarker();
            if (cycleMarker != null) {
                v0 = severity = "error".equals(javaProject.getOption("org.eclipse.jdt.core.circularClasspath", true)) != false ? 2 : 1;
                if (severity != cycleMarker.getAttribute("severity", severity)) {
                    cycleMarker.setAttribute("severity", severity);
                }
            }
            classpathEntries = javaProject.getExpandedClasspath(this.compilationGroup == CompilationGroup.MAIN);
            sLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
            bLocations = new ArrayList<ClasspathLocation>(classpathEntries.length);
            sLocationsForTest = new ArrayList<ClasspathLocation>(classpathEntries.length);
            moduleEntries = null;
            compliance = javaProject.getOption("org.eclipse.jdt.core.compiler.compliance", true);
            if (CompilerOptions.versionToJdkLevel((String)compliance) >= 0x350000L) {
                moduleEntries = new LinkedHashMap<String, IModulePathEntry>(classpathEntries.length);
                this.moduleUpdater = new ModuleUpdater(javaProject);
                if (this.compilationGroup == CompilationGroup.TEST) {
                    this.moduleUpdater.addReadUnnamedForNonEmptyClasspath(javaProject, classpathEntries);
                }
            }
            projectModule = javaProject.getModuleDescription();
            patchedModuleName = ModuleEntryProcessor.pushPatchToFront(classpathEntries, javaProject);
            patchedModule = null;
            i = 0;
            l = classpathEntries.length;
            while (i < l) {
                if (i == 1 && patchedModuleName != null) {
                    patchedModuleName = null;
                }
                entry = (ClasspathEntry)classpathEntries[i];
                path = entry.getPath();
                target = JavaModel.getTarget(path, true);
                externalAnnotationPath = entry.getExternalAnnotationPath(javaProject.getProject(), true);
                if (target != null) {
                    isOnModulePath = this.isOnModulePath((ClasspathEntry)entry);
                    limitModules = ModuleEntryProcessor.computeLimitModules(entry);
                    if (patchedModuleName != null && limitModules != null && !limitModules.contains(patchedModuleName)) {
                        patchedModuleName = null;
                    }
                    if (!(this.moduleUpdater == null || this.compilationGroup != CompilationGroup.TEST && entry.isTest())) {
                        this.moduleUpdater.computeModuleUpdates((IClasspathEntry)entry);
                    }
                    switch (entry.getEntryKind()) {
                        case 3: {
                            if (!(target instanceof IContainer)) break;
                            v1 = outputPath = entry.getOutputLocation() != null ? entry.getOutputLocation() : javaProject.getOutputLocation();
                            if (outputPath.segmentCount() == 1) {
                                outputFolder = javaProject.getProject();
                            } else {
                                outputFolder = root.getFolder(outputPath);
                                if (!outputFolder.exists()) {
                                    this.createOutputFolder((IContainer)outputFolder);
                                }
                            }
                            if (this.compilationGroup == CompilationGroup.TEST && !entry.isTest()) {
                                bLocation = ClasspathLocation.forBinaryFolder((IContainer)outputFolder, true, entry.getAccessRuleSet(), externalAnnotationPath, isOnModulePath);
                                bLocations.add(bLocation);
                                sLocationsForTest.add(bLocation);
                                if (patchedModule != null) {
                                    ModuleEntryProcessor.combinePatchIntoModuleEntry(bLocation, patchedModule, moduleEntries);
                                }
                                bLocation.patchModuleName = patchedModuleName;
                                break;
                            }
                            sourceLocation = ClasspathLocation.forSourceFolder((IContainer)target, (IContainer)outputFolder, entry.fullInclusionPatternChars(), entry.fullExclusionPatternChars(), entry.ignoreOptionalProblems(), externalAnnotationPath);
                            if (patchedModule != null) {
                                ModuleEntryProcessor.combinePatchIntoModuleEntry(sourceLocation, patchedModule, moduleEntries);
                            }
                            sLocations.add(sourceLocation);
                            sourceLocation.patchModuleName = patchedModuleName;
                            break;
                        }
                        case 2: {
                            if (!(target instanceof IProject) || !JavaProject.hasJavaNature(prereqProject = (IProject)target)) break;
                            prereqJavaProject = (JavaProject)JavaCore.create(prereqProject);
                            prereqClasspathEntries = prereqJavaProject.getRawClasspath();
                            seen = new ArrayList<IProject>();
                            projectLocations = new ArrayList<ClasspathLocation>();
                            j = 0;
                            m = prereqClasspathEntries.length;
                            while (j < m) {
                                prereqEntry = prereqClasspathEntries[j];
                                if (prereqEntry.getEntryKind() == 3 && (this.compilationGroup != CompilationGroup.MAIN && !entry.isWithoutTestCode() || !prereqEntry.isTest())) {
                                    srcExtAnnotPath = externalAnnotationPath != null ? externalAnnotationPath : prereqEntry.getExternalAnnotationPath(javaProject.getProject(), true);
                                    prereqTarget = JavaModel.getTarget(prereqEntry.getPath(), true);
                                    if (prereqTarget instanceof IContainer) {
                                        if (srcExtAnnotPath == null) {
                                            outputLoc = prereqEntry.getOutputLocation();
                                            k = j + 1;
                                            while (k < m) {
                                                other = prereqClasspathEntries[k];
                                                if (other.getEntryKind() == 3) {
                                                    otherOutput = other.getOutputLocation();
                                                    if ((outputLoc == null ? otherOutput == null : outputLoc.equals((Object)otherOutput) != false) && (srcExtAnnotPath = other.getExternalAnnotationPath(javaProject.getProject(), true)) != null) break;
                                                }
                                                ++k;
                                            }
                                        }
                                        prereqOutputPath = prereqEntry.getOutputLocation() != null ? prereqEntry.getOutputLocation() : prereqJavaProject.getOutputLocation();
                                        v2 /* !! */  = binaryFolder = prereqOutputPath.segmentCount() == 1 ? prereqProject : root.getFolder(prereqOutputPath);
                                        if (binaryFolder.exists() && !seen.contains(binaryFolder)) {
                                            seen.add(binaryFolder);
                                            bLocation = ClasspathLocation.forBinaryFolder((IContainer)binaryFolder, true, entry.getAccessRuleSet(), srcExtAnnotPath, isOnModulePath);
                                            bLocations.add(bLocation);
                                            projectLocations.add(bLocation);
                                            if (binaryLocationsPerProject != null) {
                                                existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get((Object)prereqProject);
                                                if (existingLocations == null) {
                                                    existingLocations = new ClasspathLocation[]{bLocation};
                                                } else {
                                                    size = existingLocations.length;
                                                    v3 = existingLocations;
                                                    existingLocations = new ClasspathLocation[size + 1];
                                                    System.arraycopy(v3, 0, existingLocations, 0, size);
                                                    existingLocations[size] = bLocation;
                                                }
                                                binaryLocationsPerProject.put((Object)prereqProject, (Object)existingLocations);
                                            }
                                        }
                                    }
                                }
                                ++j;
                            }
                            if (moduleEntries == null || !isOnModulePath || projectLocations.size() <= 0) break;
                            info = null;
                            try {
                                mod = prereqJavaProject.getModuleDescription();
                                if (mod != null) {
                                    aModule = (AbstractModule)mod;
                                    info = aModule.getModuleInfo();
                                }
                            }
                            catch (JavaModelException v4) {}
                            if (info == null) {
                                info = IModule.createAutomatic((String)prereqJavaProject.getElementName(), (boolean)false, (Manifest)prereqJavaProject.getManifest());
                            }
                            projectEntry = new ModulePathEntry(prereqJavaProject.getPath(), info, projectLocations.toArray(new ClasspathLocation[projectLocations.size()]));
                            moduleName = String.valueOf(info.name());
                            updates = this.moduleUpdater.getUpdates(moduleName);
                            for (ClasspathLocation loc : projectLocations) {
                                loc.limitModuleNames = limitModules;
                                loc.updates = updates;
                                loc.patchModuleName = patchedModuleName;
                            }
                            if (limitModules != null && !limitModules.contains(moduleName)) break;
                            moduleEntries.put(moduleName, projectEntry);
                            if (!moduleName.equals(patchedModuleName)) break;
                            patchedModule = info;
                            break;
                        }
                        case 1: {
                            if (target instanceof IResource) {
                                resource = (IResource)target;
                                bLocation = null;
                                if (resource instanceof IFile) {
                                    accessRuleSet = "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) != false && "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) != false ? null : entry.getAccessRuleSet();
                                    bLocation = ClasspathLocation.forLibrary((IFile)resource, accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
                                } else if (resource instanceof IContainer) {
                                    accessRuleSet = "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) != false && "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) != false ? null : entry.getAccessRuleSet();
                                    bLocation = ClasspathLocation.forBinaryFolder((IContainer)target, false, accessRuleSet, externalAnnotationPath, isOnModulePath);
                                }
                                bLocations.add(bLocation);
                                if (moduleEntries != null) {
                                    patchedModule = this.collectModuleEntries(bLocation, path, isOnModulePath, limitModules, patchedModuleName, patchedModule, moduleEntries);
                                }
                                if (binaryLocationsPerProject == null) break;
                                p = resource.getProject();
                                existingLocations = (ClasspathLocation[])binaryLocationsPerProject.get((Object)p);
                                if (existingLocations == null) {
                                    existingLocations = new ClasspathLocation[]{bLocation};
                                } else {
                                    size = existingLocations.length;
                                    v5 = existingLocations;
                                    existingLocations = new ClasspathLocation[size + 1];
                                    System.arraycopy(v5, 0, existingLocations, 0, size);
                                    existingLocations[size] = bLocation;
                                }
                                binaryLocationsPerProject.put((Object)p, (Object)existingLocations);
                                break;
                            }
                            if (!(target instanceof File)) break;
                            accessRuleSet = "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.forbiddenReference", true)) != false && "ignore".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.problem.discouragedReference", true)) != false ? null : entry.getAccessRuleSet();
                            release = "enabled".equals(javaProject.getOption("org.eclipse.jdt.core.compiler.release", false)) != false ? compliance : null;
                            bLocation /* !! */  = null;
                            libPath = path.toOSString();
                            bLocation /* !! */  = Util.isJrt((String)libPath) != false ? ClasspathLocation.forJrtSystem(path.toOSString(), accessRuleSet, externalAnnotationPath, release) : ClasspathLocation.forLibrary(path.toOSString(), accessRuleSet, externalAnnotationPath, isOnModulePath, compliance);
                            bLocations.add(bLocation /* !! */ );
                            if (moduleEntries == null) break;
                            libraryLimitModules = limitModules == null && projectModule != null ? ClasspathJrt.NO_LIMIT_MODULES : limitModules;
                            patchedModule = this.collectModuleEntries(bLocation /* !! */ , path, isOnModulePath, libraryLimitModules, patchedModuleName, patchedModule, moduleEntries);
                        }
                    }
                }
                ++i;
            }
            if ("enabled".equals(javaProject.getOption("org.eclipse.jdt.core.builder.annotationPath.allLocations", true))) {
                allLocationsForEEA = new ArrayList<ClasspathLocation>();
                for (ClasspathLocation loc : bLocations) {
                    loc.connectAllLocationsForEEA(allLocationsForEEA, true);
                }
                for (ClasspathLocation loc : sLocations) {
                    loc.connectAllLocationsForEEA(allLocationsForEEA, true);
                }
            }
            outputFolders = new ArrayList<ClasspathDirectory>(1);
            this.sourceLocations = new ClasspathMultiDirectory[sLocations.size()];
            if (sLocations.isEmpty()) break block62;
            sLocations.toArray(this.sourceLocations);
            if (moduleEntries != null && projectModule != null) {
                try {
                    sourceModule = (AbstractModule)projectModule;
                    info = (IModule)sourceModule.getElementInfo();
                    if (sLocationsForTest.size() == 0) {
                        sourceLocations2 = this.sourceLocations;
                    } else {
                        sourceLocationsForModulePathEntry = new ArrayList<ClasspathLocation>(sLocations.size() + sLocationsForTest.size());
                        sourceLocationsForModulePathEntry.addAll(sLocations);
                        sourceLocationsForModulePathEntry.addAll(sLocationsForTest);
                        sourceLocations2 = sourceLocationsForModulePathEntry.toArray(new ClasspathLocation[sourceLocationsForModulePathEntry.size()]);
                    }
                    projectEntry = new ModulePathEntry(javaProject.getPath(), info, sourceLocations2);
                    if (!moduleEntries.containsKey(sourceModule.getElementName())) {
                        moduleEntries.put(sourceModule.getElementName(), projectEntry);
                    }
                }
                catch (JavaModelException v6) {}
            }
            i = 0;
            l = this.sourceLocations.length;
            while (i < l) {
                block61: {
                    md = this.sourceLocations[i];
                    outputPath = md.binaryFolder.getFullPath();
                    eeaPath = md.externalAnnotationPath;
                    j = 0;
                    while (j < i) {
                        block63: {
                            previousMd = this.sourceLocations[j];
                            if (!outputPath.equals((Object)previousMd.binaryFolder.getFullPath())) break block63;
                            if (eeaPath == null == (previousMd.externalAnnotationPath == null) || md.isOnModulePath != previousMd.isOnModulePath || md.accessRuleSet != previousMd.accessRuleSet) ** GOTO lbl-1000
                            if (eeaPath == null) {
                                eeaPath = previousMd.externalAnnotationPath;
                            }
                            if ((prev = outputFolders.indexOf(previousMd)) != -1) {
                                outputFolders.set(prev, new ClasspathDirectory(md.binaryFolder, true, md.accessRuleSet, (IPath)new Path(eeaPath), md.isOnModulePath));
                            } else lbl-1000:
                            // 2 sources

                            {
                                md.hasIndependentOutputFolder = previousMd.hasIndependentOutputFolder;
                            }
                            break block61;
                        }
                        ++j;
                    }
                    outputFolders.add(md);
                    j = 0;
                    m = this.sourceLocations.length;
                    while (j < m) {
                        if (!outputPath.equals((Object)this.sourceLocations[j].sourceFolder.getFullPath())) {
                            ++j;
                            continue;
                        }
                        break block61;
                    }
                    md.hasIndependentOutputFolder = true;
                }
                ++i;
            }
        }
        this.binaryLocations = new ClasspathLocation[outputFolders.size() + bLocations.size()];
        index = 0;
        i = 0;
        l = outputFolders.size();
        while (i < l) {
            this.binaryLocations[index++] = (ClasspathLocation)outputFolders.get(i);
            ++i;
        }
        i = 0;
        l = bLocations.size();
        while (i < l) {
            this.binaryLocations[index++] = (ClasspathLocation)bLocations.get(i);
            ++i;
        }
        if (moduleEntries != null && !moduleEntries.isEmpty()) {
            this.modulePathEntries = moduleEntries;
        }
    }

    IModule collectModuleEntries(ClasspathLocation bLocation, IPath path, boolean isOnModulePath, Set<String> limitModules, String patchedModuleName, IModule patchedModule, Map<String, IModulePathEntry> moduleEntries) {
        ModulePathEntry binaryModulePathEntry;
        IModule module;
        if (bLocation instanceof IMultiModuleEntry) {
            IModule module2;
            IMultiModuleEntry binaryModulePathEntry2 = (IMultiModuleEntry)bLocation;
            bLocation.limitModuleNames = limitModules;
            bLocation.patchModuleName = patchedModuleName;
            IUpdatableModule.UpdatesByKind updates = null;
            IUpdatableModule.UpdatesByKind finalUpdates = new IUpdatableModule.UpdatesByKind();
            List packageUpdates = null;
            List moduleUpdates = null;
            for (String moduleName : binaryModulePathEntry2.getModuleNames(limitModules)) {
                List mu;
                moduleEntries.put(moduleName, (IModulePathEntry)binaryModulePathEntry2);
                updates = this.moduleUpdater.getUpdates(moduleName);
                if (updates == null) continue;
                List pu = updates.getList(IUpdatableModule.UpdateKind.PACKAGE, false);
                if (pu != null) {
                    packageUpdates = finalUpdates.getList(IUpdatableModule.UpdateKind.PACKAGE, true);
                    packageUpdates.addAll(pu);
                }
                if ((mu = updates.getList(IUpdatableModule.UpdateKind.MODULE, false)) == null) continue;
                moduleUpdates = finalUpdates.getList(IUpdatableModule.UpdateKind.MODULE, true);
                moduleUpdates.addAll(mu);
            }
            if (packageUpdates != null || moduleUpdates != null) {
                bLocation.updates = finalUpdates;
            }
            if (patchedModuleName != null && (module2 = binaryModulePathEntry2.getModule(patchedModuleName.toCharArray())) != null) {
                return module2;
            }
        } else if (isOnModulePath && (module = (binaryModulePathEntry = new ModulePathEntry(path, bLocation)).getModule()) != null) {
            String moduleName = String.valueOf(module.name());
            bLocation.updates = this.moduleUpdater.getUpdates(moduleName);
            bLocation.limitModuleNames = limitModules;
            bLocation.patchModuleName = patchedModuleName;
            if (limitModules == null || limitModules == ClasspathJrt.NO_LIMIT_MODULES || limitModules.contains(moduleName)) {
                moduleEntries.put(moduleName, binaryModulePathEntry);
                if (patchedModuleName != null && moduleName.equals(patchedModuleName)) {
                    return module;
                }
            }
        }
        return patchedModule;
    }

    protected boolean isOnModulePath(ClasspathEntry entry) {
        return entry.isModular();
    }

    public void cleanup() {
        this.initialTypeNames = null;
        this.additionalUnits = null;
        int i = 0;
        int l = this.sourceLocations.length;
        while (i < l) {
            this.sourceLocations[i].cleanup();
            ++i;
        }
        i = 0;
        l = this.binaryLocations.length;
        while (i < l) {
            this.binaryLocations[i].cleanup();
            ++i;
        }
    }

    private void createOutputFolder(IContainer outputFolder) throws CoreException {
        this.createParentFolder(outputFolder.getParent());
        ((IFolder)outputFolder).create(1025, true, null);
    }

    private void createParentFolder(IContainer parent) throws CoreException {
        if (!parent.exists()) {
            this.createParentFolder(parent.getParent());
            ((IFolder)parent).create(true, true, null);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private NameEnvironmentAnswer findClass(String qualifiedTypeName, char[] typeName, IModuleAwareNameEnvironment.LookupStrategy strategy, String moduleName) {
        ClasspathLocation[] relevantLocations;
        char[] binaryFileName;
        String qPackageName;
        String qBinaryFileName;
        block17: {
            String moduleQualifiedName;
            if (this.notifier != null) {
                this.notifier.checkCancelWithinCompiler();
            }
            String string = moduleQualifiedName = moduleName != null ? moduleName + ":" + qualifiedTypeName : qualifiedTypeName;
            if (this.initialTypeNames != null && this.initialTypeNames.includes((Object)moduleQualifiedName)) {
                if (this.isIncrementalBuild) {
                    throw new AbortCompilation(true, (RuntimeException)new AbortIncrementalBuildException(qualifiedTypeName));
                }
                return null;
            }
            if (this.additionalUnits != null && this.sourceLocations.length > 0) {
                String enclosingTypeName;
                SourceFile unit = (SourceFile)this.additionalUnits.get((Object)qualifiedTypeName);
                if (unit != null) {
                    return new NameEnvironmentAnswer((ICompilationUnit)unit, null);
                }
                int index = qualifiedTypeName.indexOf(36);
                if (index > 0 && (unit = (SourceFile)this.additionalUnits.get((Object)(enclosingTypeName = qualifiedTypeName.substring(0, index)))) != null) {
                    return new NameEnvironmentAnswer((ICompilationUnit)unit, null);
                }
            }
            qBinaryFileName = qualifiedTypeName + ".class";
            qPackageName = qualifiedTypeName.length() == typeName.length ? Util.EMPTY_STRING : qBinaryFileName.substring(0, qBinaryFileName.length() - typeName.length - 7);
            binaryFileName = CharOperation.concat((char[])typeName, (char[])SUFFIX_class);
            if (moduleName != null && this.modulePathEntries != null) {
                IModulePathEntry modulePathEntry = this.modulePathEntries.get(moduleName);
                if (modulePathEntry instanceof ModulePathEntry) {
                    relevantLocations = ((ModulePathEntry)modulePathEntry).getClasspathLocations();
                    break block17;
                } else {
                    if (modulePathEntry instanceof ClasspathLocation) {
                        return ((ClasspathLocation)modulePathEntry).findClass(typeName, qPackageName, moduleName, qBinaryFileName, false, null);
                    }
                    return null;
                }
            }
            relevantLocations = this.binaryLocations;
        }
        NameEnvironmentAnswer suggestedAnswer = null;
        ClasspathLocation[] classpathLocationArray = relevantLocations;
        int n = relevantLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ClasspathLocation classpathLocation = classpathLocationArray[n2];
            if (strategy.matches((Object)classpathLocation, ClasspathLocation::hasModule)) {
                char[] answerMod;
                NameEnvironmentAnswer answer = classpathLocation.findClass(binaryFileName, qPackageName, moduleName, qBinaryFileName, false, this.modulePathEntries != null ? this.modulePathEntries::containsKey : null);
                if (answer != null && ((answerMod = answer.moduleName()) == null || this.modulePathEntries == null || this.modulePathEntries.containsKey(String.valueOf(answerMod)))) {
                    if (!answer.ignoreIfBetter()) {
                        if (answer.isBetter(suggestedAnswer)) {
                            return answer;
                        }
                    } else if (answer.isBetter(suggestedAnswer)) {
                        suggestedAnswer = answer;
                    }
                }
            }
            ++n2;
        }
        return suggestedAnswer;
    }

    public NameEnvironmentAnswer findType(char[][] compoundName, char[] moduleName) {
        if (compoundName != null) {
            return this.findClass(String.valueOf(CharOperation.concatWith((char[][])compoundName, (char)'/')), compoundName[compoundName.length - 1], IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName((char[])moduleName));
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, char[] moduleName) {
        return this.findClass(String.valueOf(CharOperation.concatWith((char[][])packageName, (char[])typeName, (char)'/')), typeName, IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName), IModuleAwareNameEnvironment.LookupStrategy.getStringName((char[])moduleName));
    }

    public char[][] getModulesDeclaringPackage(char[][] packageName, char[] moduleName) {
        String pkgName = new String(CharOperation.concatWith((char[][])packageName, (char)'/'));
        String modName = new String(moduleName);
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
        switch (strategy) {
            case Any: 
            case Unnamed: {
                char[][] declaringModules;
                ClasspathLocation location;
                char[][] names = CharOperation.NO_CHAR_CHAR;
                ClasspathLocation[] classpathLocationArray = this.binaryLocations;
                int n = this.binaryLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    location = classpathLocationArray[n2];
                    if (strategy.matches((Object)location, ClasspathLocation::hasModule) && (declaringModules = location.getModulesDeclaringPackage(pkgName, null)) != null) {
                        names = CharOperation.arrayConcat((char[][])names, (char[][])declaringModules);
                    }
                    ++n2;
                }
                classpathLocationArray = this.sourceLocations;
                n = this.sourceLocations.length;
                n2 = 0;
                while (n2 < n) {
                    location = classpathLocationArray[n2];
                    if (strategy.matches((Object)location, ClasspathLocation::hasModule) && (declaringModules = location.getModulesDeclaringPackage(pkgName, null)) != null) {
                        names = CharOperation.arrayConcat((char[][])names, (char[][])declaringModules);
                    }
                    ++n2;
                }
                return names == CharOperation.NO_CHAR_CHAR ? null : names;
            }
            case AnyNamed: {
                modName = null;
            }
        }
        if (this.modulePathEntries != null) {
            char[][] names = CharOperation.NO_CHAR_CHAR;
            HashSet<IModulePathEntry> entries = new HashSet<IModulePathEntry>(this.modulePathEntries.values());
            for (IModulePathEntry modulePathEntry : entries) {
                char[][] declaringModules = modulePathEntry.getModulesDeclaringPackage(pkgName, modName);
                if (declaringModules == null) continue;
                names = CharOperation.arrayConcat((char[][])names, (char[][])declaringModules);
            }
            return names == CharOperation.NO_CHAR_CHAR ? null : names;
        }
        return null;
    }

    public boolean hasCompilationUnit(char[][] qualifiedPackageName, char[] moduleName, boolean checkCUs) {
        String pkgName = String.valueOf(CharOperation.concatWith((char[][])qualifiedPackageName, (char)'/'));
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
        String modName = IModuleAwareNameEnvironment.LookupStrategy.getStringName((char[])moduleName);
        switch (strategy) {
            case Any: 
            case Unnamed: {
                ClasspathLocation location;
                ClasspathLocation[] classpathLocationArray = this.binaryLocations;
                int n = this.binaryLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    location = classpathLocationArray[n2];
                    if (strategy.matches((Object)location, ClasspathLocation::hasModule) && location.hasCompilationUnit(pkgName, null)) {
                        return true;
                    }
                    ++n2;
                }
                classpathLocationArray = this.sourceLocations;
                n = this.sourceLocations.length;
                n2 = 0;
                while (n2 < n) {
                    location = classpathLocationArray[n2];
                    if (strategy.matches((Object)location, ClasspathLocation::hasModule) && location.hasCompilationUnit(pkgName, null)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            case Named: {
                if (this.modulePathEntries != null) {
                    IModulePathEntry modulePathEntry = this.modulePathEntries.get(modName);
                    return modulePathEntry != null && modulePathEntry.hasCompilationUnit(pkgName, modName);
                }
                return false;
            }
            case AnyNamed: {
                if (this.modulePathEntries != null) {
                    for (IModulePathEntry modulePathEntry : this.modulePathEntries.values()) {
                        if (!modulePathEntry.hasCompilationUnit(pkgName, modName)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        throw new IllegalArgumentException("Unexpected LookupStrategy " + String.valueOf(strategy));
    }

    public boolean isPackage(String qualifiedPackageName, char[] moduleName) {
        String stringModuleName = null;
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
        Collection<IModulePathEntry> entries = null;
        switch (strategy) {
            case Any: 
            case Unnamed: {
                int i = 0;
                int l = this.binaryLocations.length;
                while (i < l) {
                    if (strategy.matches((Object)this.binaryLocations[i], ClasspathLocation::hasModule) && this.binaryLocations[i].isPackage(qualifiedPackageName, null)) {
                        return true;
                    }
                    ++i;
                }
                i = 0;
                l = this.sourceLocations.length;
                while (i < l) {
                    if (strategy.matches((Object)this.sourceLocations[i], ClasspathLocation::hasModule) && this.sourceLocations[i].isPackage(qualifiedPackageName, null)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            case AnyNamed: {
                entries = this.modulePathEntries.values();
                break;
            }
            default: {
                stringModuleName = String.valueOf(moduleName);
                IModulePathEntry entry = this.modulePathEntries.get(stringModuleName);
                if (entry == null) {
                    return false;
                }
                entries = Collections.singletonList(entry);
            }
        }
        for (IModulePathEntry modulePathEntry : entries) {
            if (modulePathEntry instanceof ModulePathEntry) {
                ClasspathLocation[] classpathLocationArray = ((ModulePathEntry)modulePathEntry).getClasspathLocations();
                int n = classpathLocationArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ClasspathLocation classpathLocation = classpathLocationArray[n2];
                    if (classpathLocation.isPackage(qualifiedPackageName, stringModuleName)) {
                        return true;
                    }
                    ++n2;
                }
                continue;
            }
            if (!(modulePathEntry instanceof ClasspathLocation)) continue;
            return ((ClasspathLocation)modulePathEntry).isPackage(qualifiedPackageName, stringModuleName);
        }
        return false;
    }

    public char[][] listPackages(char[] moduleName) {
        IModuleAwareNameEnvironment.LookupStrategy strategy = IModuleAwareNameEnvironment.LookupStrategy.get((char[])moduleName);
        switch (strategy) {
            case Named: {
                IModulePathEntry entry = this.modulePathEntries.get(String.valueOf(moduleName));
                if (entry == null) {
                    return CharOperation.NO_CHAR_CHAR;
                }
                return entry.listPackages();
            }
        }
        throw new UnsupportedOperationException("can list packages only of a named module");
    }

    void setNames(String[] typeNames, SourceFile[] additionalFiles) {
        int l;
        int i;
        if (typeNames == null) {
            this.initialTypeNames = null;
        } else {
            this.initialTypeNames = new SimpleSet(typeNames.length);
            i = 0;
            l = typeNames.length;
            while (i < l) {
                this.initialTypeNames.add((Object)typeNames[i]);
                ++i;
            }
        }
        if (additionalFiles == null) {
            this.additionalUnits = null;
        } else {
            this.additionalUnits = new SimpleLookupTable(additionalFiles.length);
            i = 0;
            l = additionalFiles.length;
            while (i < l) {
                SourceFile additionalUnit = additionalFiles[i];
                if (additionalUnit != null) {
                    this.additionalUnits.put((Object)additionalUnit.initialTypeName, (Object)additionalFiles[i]);
                }
                ++i;
            }
        }
        i = 0;
        l = this.sourceLocations.length;
        while (i < l) {
            this.sourceLocations[i].reset();
            ++i;
        }
        i = 0;
        l = this.binaryLocations.length;
        while (i < l) {
            this.binaryLocations[i].reset();
            ++i;
        }
    }

    public IModule getModule(char[] name) {
        if (this.modulePathEntries != null) {
            IModulePathEntry modulePathEntry = this.modulePathEntries.get(String.valueOf(name));
            if (modulePathEntry instanceof IMultiModuleEntry) {
                return modulePathEntry.getModule(name);
            }
            if (modulePathEntry != null) {
                return modulePathEntry.getModule();
            }
        }
        return null;
    }

    public char[][] getAllAutomaticModules() {
        if (this.modulePathEntries == null) {
            return CharOperation.NO_CHAR_CHAR;
        }
        Set set = this.modulePathEntries.values().stream().filter(m -> m.isAutomaticModule()).map(e -> e.getModule().name()).collect(Collectors.toSet());
        return (char[][])set.toArray((T[])new char[set.size()][]);
    }

    public void applyModuleUpdates(IUpdatableModule compilerModule, IUpdatableModule.UpdateKind kind) {
        if (this.moduleUpdater != null) {
            this.moduleUpdater.applyModuleUpdates(compilerModule, kind);
        }
    }
}

