/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import com.sun.jdi.connect.Connector;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdi.internal.connect.ConnectMessages;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AbstractJavaMainTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.MainMethodSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class JavaConnectTab
extends AbstractJavaMainTab
implements IPropertyChangeListener {
    private Button fAllowTerminateButton;
    private Map<String, Connector.Argument> fArgumentMap;
    private final Map<String, FieldEditor> fFieldEditorMap = new HashMap<String, FieldEditor>();
    private Composite fArgumentComposite;
    private Combo fConnectorCombo;
    private IVMConnector fConnector;
    private final IVMConnector[] fConnectors = JavaRuntime.getVMConnectors();

    public void createControl(Composite parent) {
        Composite cgroup;
        Font font = parent.getFont();
        Composite comp = SWTFactory.createComposite((Composite)parent, (Font)font, (int)1, (int)1, (int)1808);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        Group group = SWTFactory.createGroup((Composite)comp, (String)LauncherMessages.JavaConnectTab_Connect_ion_Type__7, (int)1, (int)1, (int)768);
        String[] names = new String[this.fConnectors.length];
        int i = 0;
        while (i < this.fConnectors.length) {
            names[i] = this.fConnectors[i].getName();
            ++i;
        }
        this.fConnectorCombo = SWTFactory.createCombo((Composite)group, (int)8, (int)1, (int)768, (String[])names);
        this.fConnectorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaConnectTab.this.handleConnectorComboModified();
            }
        });
        this.createVerticalSpacer(comp, 1);
        group = SWTFactory.createGroup((Composite)comp, (String)LauncherMessages.JavaConnectTab_Connection_Properties_1, (int)2, (int)1, (int)768);
        this.fArgumentComposite = cgroup = SWTFactory.createComposite((Composite)group, (Font)font, (int)2, (int)1, (int)768);
        this.createVerticalSpacer(comp, 2);
        this.fAllowTerminateButton = this.createCheckButton(comp, LauncherMessages.JavaConnectTab__Allow_termination_of_remote_VM_6);
        this.fAllowTerminateButton.addSelectionListener((SelectionListener)this.getDefaultListener());
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CONNECT_TAB);
    }

    /*
     * WARNING - void declaration
     */
    private void handleConnectorComboModified() {
        int index = this.fConnectorCombo.getSelectionIndex();
        if (index < 0 || index >= this.fConnectors.length) {
            return;
        }
        IVMConnector vm = this.fConnectors[index];
        if (vm.equals(this.fConnector)) {
            return;
        }
        this.fConnector = vm;
        try {
            this.fArgumentMap = vm.getDefaultArguments();
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.statusDialog(LauncherMessages.JavaConnectTab_Unable_to_display_connection_arguments__2, e.getStatus());
            return;
        }
        Control[] children = this.fArgumentComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.fFieldEditorMap.clear();
        PreferenceStore store = new PreferenceStore();
        for (String key : vm.getArgumentOrder()) {
            Connector.Argument arg = this.fArgumentMap.get(key);
            IntegerFieldEditor field = null;
            Connector.Argument argument = arg;
            if (argument instanceof Connector.IntegerArgument) {
                void integerArg;
                Connector.IntegerArgument cfr_ignored_0 = (Connector.IntegerArgument)argument;
                Connector.IntegerArgument cfr_ignored_1 = (Connector.IntegerArgument)argument;
                store.setDefault(arg.name(), integerArg.intValue());
                field = new IntegerFieldEditor(arg.name(), arg.label(), this.fArgumentComposite);
            } else {
                Connector.Argument argument2 = arg;
                if (argument2 instanceof Connector.SelectedArgument) {
                    void selectedArg;
                    Connector.SelectedArgument cfr_ignored_2 = (Connector.SelectedArgument)argument2;
                    Connector.SelectedArgument cfr_ignored_3 = (Connector.SelectedArgument)argument2;
                    List<String> choices = selectedArg.choices();
                    String[][] namesAndValues = new String[choices.size()][2];
                    Iterator iter = choices.iterator();
                    int count = 0;
                    while (iter.hasNext()) {
                        String choice;
                        namesAndValues[count][0] = choice = (String)iter.next();
                        namesAndValues[count][1] = choice;
                        ++count;
                    }
                    store.setDefault(arg.name(), arg.value());
                    field = new ComboFieldEditor(arg.name(), arg.label(), namesAndValues, this.fArgumentComposite);
                } else if (arg instanceof Connector.StringArgument) {
                    store.setDefault(arg.name(), arg.value());
                    field = new StringFieldEditor(arg.name(), arg.label(), this.fArgumentComposite);
                } else {
                    Connector.Argument argument3 = arg;
                    if (argument3 instanceof Connector.BooleanArgument) {
                        void bool;
                        Connector.BooleanArgument cfr_ignored_4 = (Connector.BooleanArgument)argument3;
                        Connector.BooleanArgument cfr_ignored_5 = (Connector.BooleanArgument)argument3;
                        store.setDefault(arg.name(), bool.booleanValue());
                        field = new BooleanFieldEditor(arg.name(), arg.label(), this.fArgumentComposite);
                    }
                }
            }
            if (field == null) continue;
            field.setPreferenceStore((IPreferenceStore)store);
            field.loadDefault();
            field.setPropertyChangeListener((IPropertyChangeListener)this);
            this.fFieldEditorMap.put(key, (FieldEditor)field);
        }
        this.fArgumentComposite.getParent().getParent().layout();
        this.fArgumentComposite.layout(true);
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateAllowTerminateFromConfig(config);
        this.updateConnectionFromConfig(config);
    }

    private void updateAllowTerminateFromConfig(ILaunchConfiguration config) {
        boolean allowTerminate = false;
        try {
            allowTerminate = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fAllowTerminateButton.setSelection(allowTerminate);
    }

    private void updateConnectionFromConfig(ILaunchConfiguration config) {
        String id = null;
        try {
            id = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
            this.fConnectorCombo.setText(JavaRuntime.getVMConnector((String)id).getName());
            this.handleConnectorComboModified();
            Map attrMap = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
            if (attrMap == null) {
                return;
            }
            for (String key : attrMap.keySet()) {
                Connector.Argument arg = this.fArgumentMap.get(key);
                FieldEditor editor = this.fFieldEditorMap.get(key);
                if (arg == null || editor == null) continue;
                String value = (String)attrMap.get(key);
                if (arg instanceof Connector.StringArgument || arg instanceof Connector.SelectedArgument) {
                    editor.getPreferenceStore().setValue(key, value);
                } else if (arg instanceof Connector.BooleanArgument) {
                    editor.getPreferenceStore().setValue(key, Boolean.parseBoolean(value));
                } else if (arg instanceof Connector.IntegerArgument) {
                    editor.getPreferenceStore().setValue(key, Integer.parseInt(value));
                }
                editor.load();
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, this.fAllowTerminateButton.getSelection());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, this.getSelectedConnector().getIdentifier());
        this.mapResources(config);
        HashMap<String, String> attrMap = new HashMap<String, String>(this.fFieldEditorMap.size());
        for (String key : this.fFieldEditorMap.keySet()) {
            FieldEditor editor = this.fFieldEditorMap.get(key);
            if (!editor.isValid()) {
                return;
            }
            Connector.Argument arg = this.fArgumentMap.get(key);
            editor.store();
            if (arg instanceof Connector.StringArgument || arg instanceof Connector.SelectedArgument) {
                attrMap.put(key, editor.getPreferenceStore().getString(key));
                continue;
            }
            if (arg instanceof Connector.BooleanArgument) {
                attrMap.put(key, Boolean.toString(editor.getPreferenceStore().getBoolean(key)));
                continue;
            }
            if (!(arg instanceof Connector.IntegerArgument)) continue;
            attrMap.put(key, Integer.toString(editor.getPreferenceStore().getInt(key)));
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, attrMap);
    }

    private void initializeDefaults(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        this.initializeJavaProject(javaElement, config);
        this.initializeName(javaElement, config);
        this.initializeHardCodedDefaults(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement == null) {
            this.initializeHardCodedDefaults(config);
        } else {
            this.initializeDefaults(javaElement, config);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initializeName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = "";
        IJavaElement iJavaElement = javaElement;
        if (iJavaElement instanceof IMember) {
            void member;
            IMember iMember = (IMember)iJavaElement;
            IMember cfr_ignored_0 = (IMember)iJavaElement;
            javaElement = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (javaElement instanceof ICompilationUnit || javaElement instanceof IClassFile) {
            try {
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{javaElement}, (boolean)false);
                MainMethodSearchEngine engine = new MainMethodSearchEngine();
                IType[] types = engine.searchMainMethods((IRunnableContext)this.getLaunchConfigurationDialog(), scope, false);
                if (types != null && types.length > 0) {
                    name = types[0].getFullyQualifiedName('.');
                }
            }
            catch (InterruptedException | InvocationTargetException ie) {
                JDIDebugUIPlugin.log(ie);
            }
            if (name.isEmpty()) {
                name = javaElement.getElementName();
            }
        }
        if (name.length() > 0) {
            int index;
            IPreferenceStore preferenceStore = PreferenceConstants.getPreferenceStore();
            boolean useQualification = preferenceStore.getBoolean("launch_name_fully_qualified_for_application");
            if (!useQualification && (index = name.lastIndexOf(46)) > 0) {
                name = name.substring(index + 1);
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
            config.rename(name);
        }
    }

    private void initializeHardCodedDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
    }

    /*
     * WARNING - void declaration
     */
    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LauncherMessages.JavaConnectTab_Project_does_not_exist_14);
            return false;
        }
        for (String key : this.fFieldEditorMap.keySet()) {
            void stringEditor;
            Connector.Argument arg = this.fArgumentMap.get(key);
            FieldEditor editor = this.fFieldEditorMap.get(key);
            FieldEditor fieldEditor = editor;
            if (!(fieldEditor instanceof StringFieldEditor)) continue;
            StringFieldEditor cfr_ignored_0 = (StringFieldEditor)fieldEditor;
            StringFieldEditor cfr_ignored_1 = (StringFieldEditor)fieldEditor;
            String value = stringEditor.getStringValue();
            if (arg.isValid(value)) continue;
            StringBuilder label = new StringBuilder(LegacyActionTools.removeMnemonics((String)arg.label()));
            if (label.lastIndexOf(ConnectMessages.SocketConnectionLabelSeparator) == label.length() - 1) {
                label = label.deleteCharAt(label.length() - 1);
            }
            this.setErrorMessage(label.toString() + LauncherMessages.JavaConnectTab__is_invalid__5);
            return false;
        }
        return true;
    }

    public String getName() {
        return LauncherMessages.JavaConnectTab_Conn_ect_20;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    public String getId() {
        return "org.eclipse.jdt.debug.ui.javaConnectTab";
    }

    private IVMConnector getSelectedConnector() {
        return this.fConnector;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateLaunchConfigurationDialog();
    }
}

