/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.core.target;

import org.eclipse.core.runtime.Assert;

public class NameVersionDescriptor {
    public static final String TYPE_PLUGIN = "plugin";
    public static final String TYPE_FEATURE = "feature";
    public static final String TYPE_PACKAGE = "package";
    private final String fId;
    private final String fVersion;
    private final String fType;

    public NameVersionDescriptor(String id, String version) {
        Assert.isNotNull((Object)id);
        this.fId = id;
        this.fVersion = version == null || version.equals("0.0.0") ? null : version;
        this.fType = TYPE_PLUGIN;
    }

    public NameVersionDescriptor(String id, String version, String type) {
        this.fId = id;
        this.fVersion = version == null || version.equals("0.0.0") ? null : version;
        this.fType = type;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof NameVersionDescriptor) {
            void iud;
            NameVersionDescriptor nameVersionDescriptor = (NameVersionDescriptor)object;
            NameVersionDescriptor cfr_ignored_0 = (NameVersionDescriptor)object;
            if (this.fId.equals(iud.fId)) {
                return this.fVersion != null && this.fVersion.equals(iud.fVersion) || this.fVersion == null && iud.fVersion == null;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.fId.hashCode() + (this.fVersion != null ? this.fVersion.hashCode() : 0);
    }

    public String getId() {
        return this.fId;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public String getType() {
        return this.fType;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fId);
        if (this.fVersion != null) {
            buf.append(' ');
            buf.append('(');
            buf.append(this.fVersion);
            buf.append(')');
        }
        buf.append(' ');
        buf.append('[');
        buf.append(this.fType);
        buf.append(']');
        return buf.toString();
    }

    public static NameVersionDescriptor fromPortableString(String portable) {
        int index = portable.indexOf(64);
        if (index > 0) {
            String name = portable.substring(0, index);
            String ver = null;
            if (++index < portable.length()) {
                ver = portable.substring(index);
            }
            return new NameVersionDescriptor(name, ver);
        }
        return new NameVersionDescriptor(portable, null);
    }

    public String toPortableString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.fId);
        buf.append('@');
        buf.append(this.fVersion);
        return buf.toString();
    }
}

