/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureManifestParser;
import org.eclipse.equinox.internal.p2.publisher.eclipse.FeatureParser;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.Feature;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.framework.util.CaseInsensitiveDictionaryMap;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.xml.sax.SAXException;

public class InstallableUnitGenerator {
    public static Stream<IInstallableUnit> generateInstallableUnits(TargetBundle[] bundles, TargetFeature[] features) {
        return Stream.concat(InstallableUnitGenerator.generateInstallableUnits(bundles), InstallableUnitGenerator.generateInstallableUnits(features));
    }

    public static Stream<IInstallableUnit> generateInstallableUnits(TargetBundle[] bundles) {
        if (bundles == null || bundles.length == 0) {
            return Stream.empty();
        }
        return Arrays.stream(bundles).flatMap(InstallableUnitGenerator::generateInstallableUnits);
    }

    public static Stream<IInstallableUnit> generateInstallableUnits(TargetBundle targetBundle) {
        String manifest;
        BundleInfo bundleInfo = targetBundle.getBundleInfo();
        if (bundleInfo != null && (manifest = bundleInfo.getManifest()) != null) {
            try {
                Manifest parsed = new Manifest(new ByteArrayInputStream(manifest.getBytes(StandardCharsets.UTF_8)));
                Attributes mainAttributes = parsed.getMainAttributes();
                CaseInsensitiveDictionaryMap headers = new CaseInsensitiveDictionaryMap(mainAttributes.size());
                Set<Map.Entry<Object, Object>> entrySet = mainAttributes.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    headers.put((Object)entry.getKey().toString(), (Object)entry.getValue().toString());
                }
                PublisherInfo publisherInfo = new PublisherInfo();
                publisherInfo.setArtifactOptions(1);
                BundleDescription bundleDescription = BundlesAction.createBundleDescription((Dictionary)headers, null);
                IInstallableUnit iu = BundlesAction.createBundleIU((BundleDescription)bundleDescription, (IArtifactKey)BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString()), (IPublisherInfo)publisherInfo);
                return Stream.of(iu);
            }
            catch (IOException iOException) {}
        }
        return Stream.empty();
    }

    public static Stream<IInstallableUnit> generateInstallableUnits(TargetFeature[] features) {
        if (features == null || features.length == 0) {
            return Stream.empty();
        }
        return Arrays.stream(features).flatMap(InstallableUnitGenerator::generateInstallableUnits);
    }

    /*
     * WARNING - void declaration
     */
    public static Stream<IInstallableUnit> generateInstallableUnits(TargetFeature targetFeature) {
        Feature feature;
        String location = targetFeature.getLocation();
        if (location != null && (feature = new FeatureParser().parse(new File(location))) != null) {
            feature.setLocation(location);
            return InstallableUnitGenerator.generateInstallableUnits(feature);
        }
        IModel model = targetFeature.getFeatureModel();
        IModel iModel = model;
        if (iModel instanceof IFeatureModel) {
            void featureModel;
            IFeatureModel iFeatureModel = (IFeatureModel)iModel;
            IFeatureModel cfr_ignored_0 = (IFeatureModel)iModel;
            IFeature feature2 = featureModel.getFeature();
            if (feature2 != null) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                feature2.write("", printWriter);
                printWriter.flush();
                try {
                    InstallableUnitGenerator.generateInstallableUnits(new FeatureManifestParser().parse((InputStream)new ByteArrayInputStream(stringWriter.toString().getBytes(StandardCharsets.UTF_8)), new URL("file:/dummy")));
                }
                catch (IOException | SAXException exception) {}
            }
        }
        return Stream.empty();
    }

    private static Stream<IInstallableUnit> generateInstallableUnits(Feature feature) {
        PublisherInfo publisherInfo = new PublisherInfo();
        publisherInfo.setArtifactOptions(1);
        FeaturesAction action = new FeaturesAction(new Feature[]{feature}){

            protected void publishFeatureArtifacts(Feature feature, IInstallableUnit featureIU, IPublisherInfo publisherInfo) {
            }
        };
        PublisherResult results = new PublisherResult();
        action.perform((IPublisherInfo)publisherInfo, (IPublisherResult)results, null);
        return results.query(QueryUtil.ALL_UNITS, null).stream();
    }
}

