/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.category;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.isite.ISiteBundle;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.category.CategoryLabelProvider;
import org.eclipse.pde.internal.ui.editor.category.SiteBundleAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteCategoryDefinitionAdapter;
import org.eclipse.pde.internal.ui.editor.category.SiteFeatureAdapter;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class CategorySection
extends TreeSection
implements IFeatureModelListener {
    private static final int BUTTON_ADD_CATEGORY = 0;
    private static final int BUTTON_ADD_FEATURE = 1;
    private static final int BUTTON_ADD_BUNDLE = 2;
    private static final int BUTTON_REMOVE = 3;
    private static int fCounter;
    private ISiteModel fModel;
    private TreePart fCategoryTreePart;
    private TreeViewer fCategoryViewer;
    private LabelProvider fSiteLabelProvider;

    public CategorySection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, new String[]{PDEUIMessages.CategoryDefinitionCategorySection_new, PDEUIMessages.CategorySection_add, PDEUIMessages.CategorySection_addBundle, PDEUIMessages.CategorySection_remove});
        this.getSection().setText(PDEUIMessages.CategoryDefinitionCategorySection_title);
        this.getSection().setDescription(PDEUIMessages.CategoryDefinitionCategorySection_desc);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        this.fModel = (ISiteModel)this.getPage().getModel();
        this.fModel.addModelChangedListener((IModelChangedListener)this);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        this.fCategoryTreePart = this.getTreePart();
        this.fCategoryViewer = this.fCategoryTreePart.getTreeViewer();
        this.fCategoryViewer.setContentProvider((IContentProvider)new CategoryContentProvider());
        this.fSiteLabelProvider = new CategoryLabelProvider();
        this.fCategoryViewer.setLabelProvider((IBaseLabelProvider)this.fSiteLabelProvider);
        this.fCategoryViewer.setInput((Object)this.fModel.getSite());
        int ops = 19;
        Transfer[] transfers = new Transfer[]{ModelDataTransfer.getInstance()};
        if (this.isEditable()) {
            this.fCategoryViewer.addDropSupport(ops, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.fCategoryViewer){

                public void dragEnter(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragEnter(event);
                }

                public void dragOperationChanged(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragOperationChanged(event);
                }

                public void dragOver(DropTargetEvent event) {
                    Object target = this.determineTarget(event);
                    if (target == null && event.detail == 1) {
                        event.detail = 2;
                    }
                    super.dragOver(event);
                }

                /*
                 * WARNING - void declaration
                 */
                protected int determineLocation(DropTargetEvent event) {
                    Rectangle bounds;
                    void item;
                    Widget widget = event.item;
                    if (!(widget instanceof Item)) {
                        return 4;
                    }
                    Item item2 = (Item)widget;
                    Item cfr_ignored_0 = (Item)widget;
                    Point coordinates = new Point(event.x, event.y);
                    coordinates = this.getViewer().getControl().toControl(coordinates);
                    if (item != null && (bounds = this.getBounds((Item)item)) == null) {
                        return 4;
                    }
                    return 3;
                }

                /*
                 * WARNING - void declaration
                 */
                public boolean performDrop(Object data) {
                    Object object;
                    if (!(data instanceof Object[])) {
                        return false;
                    }
                    Object target = this.getCurrentTarget();
                    int op = this.getCurrentOperation();
                    Object[] objects = (Object[])data;
                    if (objects.length > 0 && objects[0] instanceof SiteFeatureAdapter) {
                        if (op == 1 && target != null) {
                            CategorySection.this.copyFeature((SiteFeatureAdapter)objects[0], target);
                        } else {
                            CategorySection.this.moveFeature((SiteFeatureAdapter)objects[0], target);
                        }
                        return true;
                    }
                    if (objects.length > 0 && objects[0] instanceof SiteBundleAdapter) {
                        if (op == 1 && target != null) {
                            CategorySection.this.copyBundle((SiteBundleAdapter)objects[0], target);
                        } else {
                            CategorySection.this.moveBundle((SiteBundleAdapter)objects[0], target);
                        }
                        return true;
                    }
                    if (objects.length > 0 && (object = objects[0]) instanceof SiteCategoryDefinitionAdapter) {
                        void adapter;
                        SiteCategoryDefinitionAdapter siteCategoryDefinitionAdapter = (SiteCategoryDefinitionAdapter)object;
                        SiteCategoryDefinitionAdapter cfr_ignored_0 = (SiteCategoryDefinitionAdapter)object;
                        if (op == 1 && target != null) {
                            CategorySection.this.copyCategory((SiteCategoryDefinitionAdapter)adapter, target);
                        } else {
                            CategorySection.this.moveCategory((SiteCategoryDefinitionAdapter)adapter, target);
                        }
                        CategorySection.this.expandCategory(adapter.category.getName());
                        return true;
                    }
                    return false;
                }

                public boolean validateDrop(Object target, int operation, TransferData transferType) {
                    return target instanceof SiteCategoryDefinitionAdapter || target == null;
                }
            });
        }
        this.fCategoryViewer.addDragSupport(3, transfers, new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                ITreeSelection ssel = CategorySection.this.fCategoryViewer.getStructuredSelection();
                if (ssel == null || ssel.isEmpty() || !(ssel.getFirstElement() instanceof SiteFeatureAdapter) && !(ssel.getFirstElement() instanceof SiteBundleAdapter) && !(ssel.getFirstElement() instanceof SiteCategoryDefinitionAdapter)) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                ITreeSelection ssel = CategorySection.this.fCategoryViewer.getStructuredSelection();
                event.data = ssel.toArray();
            }

            public void dragFinished(DragSourceEvent event) {
            }
        });
        this.fCategoryTreePart.setButtonEnabled(0, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(1, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(2, this.isEditable());
        this.fCategoryTreePart.setButtonEnabled(3, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private boolean categoryExists(String name) {
        ISiteCategoryDefinition[] defs;
        ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = defs = this.fModel.getSite().getCategoryDefinitions();
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategoryDefinition def = iSiteCategoryDefinitionArray[n2];
            String dname = def.getName();
            if (dname != null && dname.equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void copyFeature(SiteFeatureAdapter adapter, Object target) {
        ISiteFeature feature = this.findRealFeature(adapter);
        if (feature == null) {
            return;
        }
        if (target != null && target instanceof SiteCategoryDefinitionAdapter) {
            this.addCategory(feature, ((SiteCategoryDefinitionAdapter)target).category.getName());
        }
    }

    private void copyBundle(SiteBundleAdapter adapter, Object target) {
        ISiteBundle bundle = this.findRealBundle(adapter);
        if (bundle == null) {
            return;
        }
        if (target != null && target instanceof SiteCategoryDefinitionAdapter) {
            this.addCategory(bundle, ((SiteCategoryDefinitionAdapter)target).category.getName());
        }
    }

    private void copyCategory(SiteCategoryDefinitionAdapter categoryAdapter, Object target) {
        ISiteCategoryDefinition categoryDef = categoryAdapter.category;
        if (categoryDef != null) {
            return;
        }
        if (target != null && target instanceof SiteCategoryDefinitionAdapter) {
            this.addCategory(categoryDef, ((SiteCategoryDefinitionAdapter)target).category.getName());
        }
    }

    private void addCategory(ISiteBundle aBundle, String catName) {
        try {
            ISiteCategory cat;
            ISiteCategory[] cats;
            if (aBundle == null) {
                return;
            }
            ISiteCategory[] iSiteCategoryArray = cats = aBundle.getCategories();
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                cat = iSiteCategoryArray[n2];
                if (cat.getName().equals(catName)) {
                    return;
                }
                ++n2;
            }
            cat = this.fModel.getFactory().createCategory(aBundle);
            cat.setName(catName);
            this.expandCategory(catName);
            aBundle.addCategories(new ISiteCategory[]{cat});
        }
        catch (CoreException coreException) {}
    }

    private void addCategory(ISiteFeature aFeature, String catName) {
        try {
            ISiteCategory cat;
            ISiteCategory[] cats;
            if (aFeature == null) {
                return;
            }
            ISiteCategory[] iSiteCategoryArray = cats = aFeature.getCategories();
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                cat = iSiteCategoryArray[n2];
                if (cat.getName().equals(catName)) {
                    return;
                }
                ++n2;
            }
            cat = this.fModel.getFactory().createCategory(aFeature);
            cat.setName(catName);
            this.expandCategory(catName);
            aFeature.addCategories(new ISiteCategory[]{cat});
        }
        catch (CoreException coreException) {}
    }

    private void addCategory(ISiteCategoryDefinition definition, String parentCategoryName) {
        try {
            ISiteCategory[] cats;
            if (definition == null) {
                return;
            }
            ISiteCategory[] iSiteCategoryArray = cats = definition.getCategories();
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategory cat = iSiteCategoryArray[n2];
                if (cat.getName().equals(parentCategoryName)) {
                    return;
                }
                ++n2;
            }
            ISiteCategory parentCategoryRef = this.fModel.getFactory().createCategory(definition);
            parentCategoryRef.setName(parentCategoryName);
            definition.addCategories(new ISiteCategory[]{parentCategoryRef});
            if (!definition.isInTheModel()) {
                this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{definition});
            }
            this.expandCategory(parentCategoryName);
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)new SiteCategoryDefinitionAdapter(parentCategoryName, definition)), true);
        }
        catch (CoreException coreException) {}
    }

    private void moveFeature(SiteFeatureAdapter adapter, Object target) {
        ISiteFeature feature = this.findRealFeature(adapter);
        if (feature == null) {
            return;
        }
        if (adapter.category != null) {
            this.removeCategory(feature, adapter.category);
        }
        if (target != null && target instanceof SiteCategoryDefinitionAdapter) {
            this.addCategory(feature, ((SiteCategoryDefinitionAdapter)target).category.getName());
        }
    }

    private void moveBundle(SiteBundleAdapter adapter, Object target) {
        ISiteBundle bundle = this.findRealBundle(adapter);
        if (bundle == null) {
            return;
        }
        if (adapter.category != null) {
            this.removeCategory(bundle, adapter.category);
        }
        if (target != null && target instanceof SiteCategoryDefinitionAdapter) {
            this.addCategory(bundle, ((SiteCategoryDefinitionAdapter)target).category.getName());
        }
    }

    private void moveCategory(SiteCategoryDefinitionAdapter categoryAdapter, Object target) {
        ISiteCategoryDefinition categoryDef = this.findRealCategoryDefinition(categoryAdapter);
        if (categoryDef == null) {
            return;
        }
        if (categoryAdapter.parentCategory != null) {
            this.removeCategory(categoryDef, categoryAdapter.parentCategory);
        }
        if (target != null && target instanceof SiteCategoryDefinitionAdapter) {
            this.addCategory(categoryDef, ((SiteCategoryDefinitionAdapter)target).category.getName());
        }
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleAddCategoryDefinition();
                break;
            }
            case 1: {
                this.handleNewFeature();
                break;
            }
            case 2: {
                this.handleNewBundle();
                break;
            }
            case 3: {
                this.handleRemove();
                break;
            }
        }
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection ssel) {
        super.handleDoubleClick(ssel);
        Object selected = ssel.getFirstElement();
        if (selected instanceof SiteFeatureAdapter) {
            IFeature feature = this.findFeature(((SiteFeatureAdapter)selected).feature);
            FeatureEditor.openFeatureEditor(feature);
        } else if (selected instanceof SiteBundleAdapter) {
            ManifestEditor.openPluginEditor(((SiteBundleAdapter)selected).bundle.getId());
        }
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
    }

    /*
     * WARNING - void declaration
     */
    private void handleAddCategoryDefinition() {
        String name = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryName, (Object)Integer.toString(++fCounter));
        while (this.categoryExists(name)) {
            name = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryName, (Object)Integer.toString(++fCounter));
        }
        String label = NLS.bind((String)PDEUIMessages.CategorySection_newCategoryLabel, (Object)Integer.toString(fCounter));
        ISiteCategoryDefinition categoryDef = this.fModel.getFactory().createCategoryDefinition();
        try {
            Object firstElement;
            String catDefReference = null;
            categoryDef.setName(name);
            categoryDef.setLabel(label);
            Object object = firstElement = this.fCategoryViewer.getStructuredSelection().getFirstElement();
            if (object instanceof SiteCategoryDefinitionAdapter) {
                void adapter;
                SiteCategoryDefinitionAdapter siteCategoryDefinitionAdapter = (SiteCategoryDefinitionAdapter)object;
                SiteCategoryDefinitionAdapter cfr_ignored_0 = (SiteCategoryDefinitionAdapter)object;
                catDefReference = adapter.category.getName();
                this.addCategory(categoryDef, catDefReference);
            } else {
                this.fModel.getSite().addCategoryDefinitions(new ISiteCategoryDefinition[]{categoryDef});
                this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)new SiteCategoryDefinitionAdapter(null, categoryDef)), true);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean handleRemove() {
        ITreeSelection ssel = this.fCategoryViewer.getStructuredSelection();
        Iterator iterator = ssel.iterator();
        boolean success = true;
        HashSet removedCategories = new HashSet();
        while (iterator.hasNext()) {
            void ba;
            Object object = iterator.next();
            if (object == null) continue;
            if (object instanceof SiteCategoryDefinitionAdapter) {
                if (this.handleRemoveCategoryDefinition((SiteCategoryDefinitionAdapter)object)) continue;
                success = false;
                continue;
            }
            Object e = object;
            if (e instanceof SiteFeatureAdapter) {
                void fa;
                SiteFeatureAdapter cfr_ignored_0 = (SiteFeatureAdapter)e;
                SiteFeatureAdapter cfr_ignored_1 = (SiteFeatureAdapter)e;
                if (removedCategories.contains(fa.category) || this.handleRemoveSiteFeatureAdapter((SiteFeatureAdapter)fa)) continue;
                success = false;
                continue;
            }
            Object e2 = object;
            if (!(e2 instanceof SiteBundleAdapter)) continue;
            SiteBundleAdapter cfr_ignored_2 = (SiteBundleAdapter)e2;
            SiteBundleAdapter cfr_ignored_3 = (SiteBundleAdapter)e2;
            if (removedCategories.contains(ba.category) || this.handleRemoveSiteBundleAdapter((SiteBundleAdapter)ba)) continue;
            success = false;
        }
        return success;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private boolean handleRemoveCategoryDefinition(SiteCategoryDefinitionAdapter catDef) {
        try {
            Object[] children;
            Object[] objectArray = children = ((CategoryContentProvider)this.fCategoryViewer.getContentProvider()).getChildren(catDef);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                Object object = element;
                if (object instanceof SiteCategoryDefinitionAdapter) {
                    void adapter;
                    SiteCategoryDefinitionAdapter cfr_ignored_0 = (SiteCategoryDefinitionAdapter)object;
                    SiteCategoryDefinitionAdapter cfr_ignored_1 = (SiteCategoryDefinitionAdapter)object;
                    this.removeCategory(adapter.category, catDef.category.getName());
                    this.handleRemoveCategoryDefinition((SiteCategoryDefinitionAdapter)adapter);
                } else {
                    Object object2 = element;
                    if (object2 instanceof SiteFeatureAdapter) {
                        void adapter;
                        ISiteCategory[] cats;
                        SiteFeatureAdapter cfr_ignored_2 = (SiteFeatureAdapter)object2;
                        SiteFeatureAdapter cfr_ignored_3 = (SiteFeatureAdapter)object2;
                        ISiteCategory[] iSiteCategoryArray = cats = adapter.feature.getCategories();
                        int n3 = cats.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ISiteCategory cat = iSiteCategoryArray[n4];
                            if (adapter.category.equals(cat.getName())) {
                                adapter.feature.removeCategories(new ISiteCategory[]{cat});
                            }
                            ++n4;
                        }
                        if (adapter.feature.getCategories().length == 0) {
                            this.fModel.getSite().removeFeatures(new ISiteFeature[]{adapter.feature});
                        }
                    } else {
                        Object object3 = element;
                        if (object3 instanceof SiteBundleAdapter) {
                            void adapter;
                            ISiteCategory[] cats;
                            ISiteCategory[] cfr_ignored_4 = (ISiteCategory[])object3;
                            SiteBundleAdapter cfr_ignored_5 = (SiteBundleAdapter)object3;
                            ISiteCategory[] iSiteCategoryArray = cats = adapter.bundle.getCategories();
                            int n5 = cats.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ISiteCategory cat = iSiteCategoryArray[n6];
                                if (adapter.category.equals(cat.getName())) {
                                    adapter.bundle.removeCategories(new ISiteCategory[]{cat});
                                }
                                ++n6;
                            }
                            if (adapter.bundle.getCategories().length == 0) {
                                this.fModel.getSite().removeBundles(new ISiteBundle[]{adapter.bundle});
                            }
                        } else {
                            return false;
                        }
                    }
                }
                ++n2;
            }
            this.fModel.getSite().removeCategoryDefinitions(new ISiteCategoryDefinition[]{catDef.category});
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean handleRemoveSiteFeatureAdapter(SiteFeatureAdapter adapter) {
        try {
            ISiteFeature feature = adapter.feature;
            if (adapter.category == null) {
                this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
            } else {
                this.removeCategory(feature, adapter.category);
                if (feature.getCategories().length == 0) {
                    this.fModel.getSite().removeFeatures(new ISiteFeature[]{feature});
                }
            }
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private boolean handleRemoveSiteBundleAdapter(SiteBundleAdapter adapter) {
        try {
            ISiteBundle bundle = adapter.bundle;
            if (adapter.category == null) {
                this.fModel.getSite().removeBundles(new ISiteBundle[]{bundle});
            } else {
                this.removeCategory(bundle, adapter.category);
                if (bundle.getCategories().length == 0) {
                    this.fModel.getSite().removeBundles(new ISiteBundle[]{bundle});
                }
            }
            return true;
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    private void removeCategory(ISiteFeature aFeature, String catName) {
        try {
            ISiteCategory[] cats;
            if (aFeature == null) {
                return;
            }
            ISiteCategory[] iSiteCategoryArray = cats = aFeature.getCategories();
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategory cat = iSiteCategoryArray[n2];
                if (catName.equals(cat.getName())) {
                    aFeature.removeCategories(new ISiteCategory[]{cat});
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private void removeCategory(ISiteBundle aBundle, String catName) {
        try {
            ISiteCategory[] cats;
            if (aBundle == null) {
                return;
            }
            ISiteCategory[] iSiteCategoryArray = cats = aBundle.getCategories();
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategory cat = iSiteCategoryArray[n2];
                if (catName.equals(cat.getName())) {
                    aBundle.removeCategories(new ISiteCategory[]{cat});
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private void removeCategory(ISiteCategoryDefinition category, String catName) {
        try {
            ISiteCategory[] cats;
            if (category == null) {
                return;
            }
            ISiteCategory[] iSiteCategoryArray = cats = category.getCategories();
            int n = cats.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategory cat = iSiteCategoryArray[n2];
                if (catName.equals(cat.getName())) {
                    category.removeCategories(new ISiteCategory[]{cat});
                }
                ++n2;
            }
        }
        catch (CoreException coreException) {}
    }

    private ISiteFeature findRealFeature(SiteFeatureAdapter adapter) {
        ISiteFeature[] features;
        ISiteFeature featureCopy = adapter.feature;
        ISiteFeature[] iSiteFeatureArray = features = this.fModel.getSite().getFeatures();
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature feature = iSiteFeatureArray[n2];
            if (Objects.equals(feature.getId(), featureCopy.getId()) && Objects.equals(feature.getVersion(), featureCopy.getVersion())) {
                return feature;
            }
            ++n2;
        }
        return null;
    }

    private ISiteBundle findRealBundle(SiteBundleAdapter adapter) {
        ISiteBundle[] bundles;
        ISiteBundle featureCopy = adapter.bundle;
        ISiteBundle[] iSiteBundleArray = bundles = this.fModel.getSite().getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteBundle bundle = iSiteBundleArray[n2];
            if (bundle.getId().equals(featureCopy.getId()) && bundle.getVersion().equals(featureCopy.getVersion())) {
                return bundle;
            }
            ++n2;
        }
        return null;
    }

    private ISiteCategoryDefinition findRealCategoryDefinition(SiteCategoryDefinitionAdapter adapter) {
        ISiteCategoryDefinition[] categoryDefinitions;
        ISiteCategoryDefinition categoryDefCopy = adapter.category;
        ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = categoryDefinitions = this.fModel.getSite().getCategoryDefinitions();
        int n = categoryDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteCategoryDefinition categoryDefinition = iSiteCategoryDefinitionArray[n2];
            if (categoryDefinition.getName().equals(categoryDefCopy.getName())) {
                return categoryDefinition;
            }
            ++n2;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.removeFeatureModelListener((IFeatureModelListener)this);
        this.fModel.removeModelChangedListener((IModelChangedListener)this);
        if (this.fSiteLabelProvider != null) {
            this.fSiteLabelProvider.dispose();
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        Action removeAction = new Action(PDEUIMessages.CategorySection_remove){

            public void run() {
                CategorySection.this.doGlobalAction(ActionFactory.DELETE.getId());
            }
        };
        removeAction.setEnabled(this.isEditable());
        manager.add((IAction)removeAction);
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleRemove();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            return this.handleRemove();
        }
        return super.doGlobalAction(actionId);
    }

    public void refresh() {
        this.fCategoryViewer.refresh();
        super.refresh();
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.fCategoryViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
        this.markStale();
    }

    public void initialize() {
        this.refresh();
        FeatureModelManager mng = PDECore.getDefault().getFeatureModelManager();
        mng.addFeatureModelListener((IFeatureModelListener)this);
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof SiteFeatureAdapter) {
                this.copyFeature((SiteFeatureAdapter)object, target);
            } else if (object instanceof SiteBundleAdapter) {
                this.copyBundle((SiteBundleAdapter)object, target);
            } else if (object instanceof ISiteCategoryDefinition) {
                this.copyCategory((SiteCategoryDefinitionAdapter)object, target);
            }
            ++n2;
        }
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        if (target == null || target instanceof ISiteCategoryDefinition) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof SiteFeatureAdapter) {
                    return true;
                }
                if (object instanceof SiteBundleAdapter) {
                    return true;
                }
                if (object instanceof ISiteCategoryDefinition) {
                    ISiteCategoryDefinition[] defs;
                    String name = ((ISiteCategoryDefinition)object).getName();
                    ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = defs = this.fModel.getSite().getCategoryDefinitions();
                    int n3 = defs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ISiteCategoryDefinition def = iSiteCategoryDefinitionArray[n4];
                        String dname = def.getName();
                        if (dname != null && dname.equals(name)) {
                            return false;
                        }
                        ++n4;
                    }
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private IFeature findFeature(ISiteFeature siteFeature) {
        IFeatureModel model = PDECore.getDefault().getFeatureModelManager().findFeatureModelRelaxed(siteFeature.getId(), siteFeature.getVersion());
        if (model != null) {
            return model.getFeature();
        }
        return null;
    }

    private void handleNewFeature() {
        Control control = this.fCategoryViewer.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), () -> {
            IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
            ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
            IFeatureModel[] iFeatureModelArray = allModels;
            int n = allModels.length;
            int n2 = 0;
            while (n2 < n) {
                IFeatureModel allModel = iFeatureModelArray[n2];
                if (this.canAdd(allModel)) {
                    newModels.add(allModel);
                }
                ++n2;
            }
            IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
            FeatureSelectionDialog dialog = new FeatureSelectionDialog(this.fCategoryViewer.getTree().getShell(), candidateModels, true);
            if (dialog.open() == 0) {
                Object[] models = dialog.getResult();
                try {
                    this.doAdd(models);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        });
    }

    private void handleNewBundle() {
        Control control = this.fCategoryViewer.getControl();
        BusyIndicator.showWhile((Display)control.getDisplay(), () -> {
            IPluginModelBase[] allModels = PluginRegistry.getAllModels();
            ArrayList<IPluginModelBase> newModels = new ArrayList<IPluginModelBase>();
            IPluginModelBase[] iPluginModelBaseArray = allModels;
            int n = allModels.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginModelBase allModel = iPluginModelBaseArray[n2];
                if (this.canAdd(allModel)) {
                    newModels.add(allModel);
                }
                ++n2;
            }
            IPluginModelBase[] candidateModels = newModels.toArray(new IPluginModelBase[newModels.size()]);
            PluginSelectionDialog dialog = new PluginSelectionDialog(this.fCategoryViewer.getTree().getShell(), candidateModels, true);
            if (dialog.open() == 0) {
                Object[] models = dialog.getResult();
                try {
                    this.doAddBundles(models);
                }
                catch (CoreException e) {
                    PDEPlugin.log(e);
                }
            }
        });
    }

    private boolean canAdd(IFeatureModel candidate) {
        ISiteFeature[] features = this.fModel.getSite().getFeatures();
        IFeature cfeature = candidate.getFeature();
        String id = cfeature.getId();
        String version = cfeature.getVersion();
        ISiteFeature[] iSiteFeatureArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteFeature bfeature = iSiteFeatureArray[n2];
            boolean idEquals = Objects.equals(bfeature.getId(), id);
            if (idEquals && (bfeature.getVersion() == null || Objects.equals(bfeature.getVersion(), version))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean canAdd(IPluginModelBase candidate) {
        ISiteBundle[] currentBundles = this.fModel.getSite().getBundles();
        IPluginBase candidateBundle = candidate.getPluginBase();
        String candidateId = candidateBundle.getId();
        String candidateVersion = candidateBundle.getVersion();
        ISiteBundle[] iSiteBundleArray = currentBundles;
        int n = currentBundles.length;
        int n2 = 0;
        while (n2 < n) {
            ISiteBundle currentBundle = iSiteBundleArray[n2];
            if (currentBundle.getId().equals(candidateId) && (currentBundle.getVersion() == null || currentBundle.getVersion().equals(candidateVersion))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static ISiteFeature createSiteFeature(ISiteModel model, IFeatureModel featureModel) throws CoreException {
        IFeature feature = featureModel.getFeature();
        ISiteFeature sfeature = model.getFactory().createFeature();
        sfeature.setId(feature.getId());
        sfeature.setOS(feature.getOS());
        sfeature.setWS(feature.getWS());
        sfeature.setArch(feature.getArch());
        sfeature.setNL(feature.getNL());
        sfeature.setIsPatch(CategorySection.isFeaturePatch(feature));
        return sfeature;
    }

    private ISiteBundle createSiteBundle(ISiteModel model, IPluginModelBase candidate) throws CoreException {
        ISiteBundle newBundle = model.getFactory().createBundle();
        newBundle.setId(candidate.getPluginBase().getId());
        return newBundle;
    }

    private static boolean isFeaturePatch(IFeature feature) {
        IFeatureImport[] imports;
        IFeatureImport[] iFeatureImportArray = imports = feature.getImports();
        int n = imports.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureImport import1 = iFeatureImportArray[n2];
            if (import1.isPatch()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public ISiteModel getModel() {
        return this.fModel;
    }

    public void doAdd(Object[] candidates) throws CoreException {
        String categoryName = this.getCategoryName();
        ISiteFeature[] added = new ISiteFeature[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            ISiteFeature child = CategorySection.createSiteFeature(this.fModel, candidate);
            if (categoryName != null) {
                this.addCategory(child, categoryName);
            }
            added[i] = child;
            ++i;
        }
        this.fModel.getSite().addFeatures(added);
        if (added.length > 0) {
            if (categoryName != null) {
                this.expandCategory(categoryName);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)new SiteFeatureAdapter(categoryName, added[added.length - 1])), true);
        }
    }

    private String getCategoryName() {
        String categoryName = null;
        Object element = this.fCategoryViewer.getStructuredSelection().getFirstElement();
        if (element instanceof SiteCategoryDefinitionAdapter) {
            categoryName = ((SiteCategoryDefinitionAdapter)element).category.getName();
        } else if (element instanceof SiteFeatureAdapter) {
            categoryName = ((SiteFeatureAdapter)element).category;
        } else if (element instanceof SiteBundleAdapter) {
            categoryName = ((SiteBundleAdapter)element).category;
        }
        return categoryName;
    }

    public void doAddBundles(Object[] candidates) throws CoreException {
        String categoryName = this.getCategoryName();
        ISiteBundle[] added = new ISiteBundle[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IPluginModelBase candidate = (IPluginModelBase)candidates[i];
            ISiteBundle child = this.createSiteBundle(this.fModel, candidate);
            if (categoryName != null) {
                this.addCategory(child, categoryName);
            }
            added[i] = child;
            ++i;
        }
        this.fModel.getSite().addBundles(added);
        if (added.length > 0) {
            if (categoryName != null) {
                this.expandCategory(categoryName);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection((Object)new SiteBundleAdapter(categoryName, added[added.length - 1])), true);
        }
    }

    void fireSelection() {
        this.fCategoryViewer.setSelection(this.fCategoryViewer.getSelection());
    }

    public boolean setFormInput(Object input) {
        if (input instanceof ISiteCategoryDefinition) {
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        if (input instanceof SiteFeatureAdapter) {
            String category = ((SiteFeatureAdapter)input).category;
            if (category != null) {
                this.expandCategory(category);
            }
            this.fCategoryViewer.setSelection((ISelection)new StructuredSelection(input), true);
            return true;
        }
        return super.setFormInput(input);
    }

    private void expandCategory(String category) {
        if (category != null) {
            ISiteCategoryDefinition[] catDefs;
            ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = catDefs = this.fModel.getSite().getCategoryDefinitions();
            int n = catDefs.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategoryDefinition definition = iSiteCategoryDefinitionArray[n2];
                if (category.equals(definition.getName())) {
                    String parentCategoryName = definition.getCategories().length == 0 ? null : definition.getCategories()[0].getName();
                    SiteCategoryDefinitionAdapter adapter = new SiteCategoryDefinitionAdapter(parentCategoryName, definition);
                    this.fCategoryViewer.expandToLevel((Object)adapter, 1);
                    break;
                }
                ++n2;
            }
        }
    }

    public void modelsChanged(IFeatureModelDelta delta) {
        this.markStale();
    }

    class CategoryContentProvider
    implements ITreeContentProvider {
        CategoryContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            ISiteBundle[] bundles;
            ISiteFeature[] features;
            ISiteCategoryDefinition[] catDefs;
            ArrayList<Serializable> result = new ArrayList<Serializable>();
            ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = catDefs = CategorySection.this.fModel.getSite().getCategoryDefinitions();
            int n = catDefs.length;
            int n2 = 0;
            while (n2 < n) {
                ISiteCategoryDefinition catDef = iSiteCategoryDefinitionArray[n2];
                if (catDef.getCategories().length == 0) {
                    result.add(new SiteCategoryDefinitionAdapter(null, catDef));
                }
                ++n2;
            }
            ISiteFeature[] iSiteFeatureArray = features = CategorySection.this.fModel.getSite().getFeatures();
            int n3 = features.length;
            n = 0;
            while (n < n3) {
                ISiteFeature feature = iSiteFeatureArray[n];
                if (feature.getCategories().length == 0) {
                    result.add(new SiteFeatureAdapter(null, feature));
                }
                ++n;
            }
            ISiteBundle[] iSiteBundleArray = bundles = CategorySection.this.fModel.getSite().getBundles();
            int n4 = bundles.length;
            n3 = 0;
            while (n3 < n4) {
                ISiteBundle bundle = iSiteBundleArray[n3];
                if (bundle.getCategories().length == 0) {
                    result.add(new SiteBundleAdapter(null, bundle));
                }
                ++n3;
            }
            return result.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof SiteCategoryDefinitionAdapter) {
                ISiteBundle[] bundles;
                ISiteFeature[] features;
                int n;
                ISiteCategoryDefinition[] categories;
                ISiteCategoryDefinition catDef = ((SiteCategoryDefinitionAdapter)parent).category;
                HashSet<Serializable> result = new HashSet<Serializable>();
                ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = categories = CategorySection.this.fModel.getSite().getCategoryDefinitions();
                int n2 = categories.length;
                int n3 = 0;
                while (n3 < n2) {
                    ISiteCategory[] cats;
                    ISiteCategoryDefinition categorie = iSiteCategoryDefinitionArray[n3];
                    ISiteCategory[] iSiteCategoryArray = cats = categorie.getCategories();
                    n = cats.length;
                    int n4 = 0;
                    while (n4 < n) {
                        ISiteCategory cat = iSiteCategoryArray[n4];
                        if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                            result.add(new SiteCategoryDefinitionAdapter(cat.getName(), categorie));
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ISiteFeature[] iSiteFeatureArray = features = CategorySection.this.fModel.getSite().getFeatures();
                int n5 = features.length;
                n2 = 0;
                while (n2 < n5) {
                    ISiteCategory[] cats;
                    ISiteFeature feature = iSiteFeatureArray[n2];
                    ISiteCategory[] iSiteCategoryArray = cats = feature.getCategories();
                    int n6 = cats.length;
                    n = 0;
                    while (n < n6) {
                        ISiteCategory cat = iSiteCategoryArray[n];
                        if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                            result.add(new SiteFeatureAdapter(cat.getName(), feature));
                        }
                        ++n;
                    }
                    ++n2;
                }
                ISiteBundle[] iSiteBundleArray = bundles = CategorySection.this.fModel.getSite().getBundles();
                int n7 = bundles.length;
                n5 = 0;
                while (n5 < n7) {
                    ISiteCategory[] cats;
                    ISiteBundle bundle = iSiteBundleArray[n5];
                    ISiteCategory[] iSiteCategoryArray = cats = bundle.getCategories();
                    int n8 = cats.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        ISiteCategory cat = iSiteCategoryArray[n9];
                        if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                            result.add(new SiteBundleAdapter(cat.getName(), bundle));
                        }
                        ++n9;
                    }
                    ++n5;
                }
                return result.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof SiteCategoryDefinitionAdapter) {
                ISiteCategoryDefinition[] categories;
                ISiteBundle[] bundles;
                int n;
                ISiteFeature[] features;
                ISiteCategoryDefinition catDef = ((SiteCategoryDefinitionAdapter)element).category;
                ISiteFeature[] iSiteFeatureArray = features = CategorySection.this.fModel.getSite().getFeatures();
                int n2 = features.length;
                int n3 = 0;
                while (n3 < n2) {
                    ISiteCategory[] cats;
                    ISiteFeature feature = iSiteFeatureArray[n3];
                    ISiteCategory[] iSiteCategoryArray = cats = feature.getCategories();
                    n = cats.length;
                    int n4 = 0;
                    while (n4 < n) {
                        ISiteCategory cat = iSiteCategoryArray[n4];
                        if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                            return true;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ISiteBundle[] iSiteBundleArray = bundles = CategorySection.this.fModel.getSite().getBundles();
                int n5 = bundles.length;
                n2 = 0;
                while (n2 < n5) {
                    ISiteCategory[] cats;
                    ISiteBundle bundle = iSiteBundleArray[n2];
                    ISiteCategory[] iSiteCategoryArray = cats = bundle.getCategories();
                    int n6 = cats.length;
                    n = 0;
                    while (n < n6) {
                        ISiteCategory cat = iSiteCategoryArray[n];
                        if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                            return true;
                        }
                        ++n;
                    }
                    ++n2;
                }
                ISiteCategoryDefinition[] iSiteCategoryDefinitionArray = categories = CategorySection.this.fModel.getSite().getCategoryDefinitions();
                int n7 = categories.length;
                n5 = 0;
                while (n5 < n7) {
                    ISiteCategory[] cats;
                    ISiteCategoryDefinition categorie = iSiteCategoryDefinitionArray[n5];
                    ISiteCategory[] iSiteCategoryArray = cats = categorie.getCategories();
                    int n8 = cats.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        ISiteCategory cat = iSiteCategoryArray[n9];
                        if (cat.getDefinition() != null && cat.getDefinition().equals(catDef)) {
                            return true;
                        }
                        ++n9;
                    }
                    ++n5;
                }
            }
            return false;
        }
    }
}

